/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;

class Connectivity {
    public static final int Network_UNKNOWN = -1;
    public static final int Network_DISCONNECTED = 0;
    public static final int Network_LAN = 1;
    public static final int Network_WIFI = 2;
    public static final int Network_2G = 3;
    public static final int Network_3G = 4;
    public static final int Network_4G = 5;
    public static final int Network_5G = 6;
    public static final int Network_SubType_WIFI_2P4G = 100;
    public static final int Network_SubType_WIFI_5G = 101;

    Connectivity() {
    }

    public static NetworkInfo getNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return cm.getActiveNetworkInfo();
    }

    public static boolean isConnected(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return info != null && info.isConnected();
    }

    public static boolean isConnectedWifi(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return info != null && info.isConnected() && info.getType() == 1;
    }

    public static boolean isConnectedMobile(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return info != null && info.isConnected() && info.getType() == 0;
    }

    public static boolean isConnectedFast(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return info != null && info.isConnected() && Connectivity.isConnectionFast(info.getType(), info.getSubtype());
    }

    public static boolean isConnectionFast(int type, int subType) {
        if (type == 1) {
            return true;
        }
        if (type == 0) {
            switch (subType) {
                case 7: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 8: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 11: {
                    return false;
                }
                case 13: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static int getNetworkType(NetworkInfo info) {
        if (info == null) {
            return 0;
        }
        if (!info.isConnected()) {
            return 0;
        }
        int type = info.getType();
        if (type == 1) {
            return 2;
        }
        if (type != 0) {
            return -1;
        }
        switch (info.getSubtype()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 3;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 4;
            }
            case 13: {
                return 5;
            }
        }
        return -1;
    }

    public static int getNetworkType(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return Connectivity.getNetworkType(info);
    }

    public static ArrayList<String> getDnsList() {
        try {
            Class<?> SystemProperties = Class.forName("android.os.SystemProperties");
            Method method = SystemProperties.getMethod("get", String.class);
            ArrayList<String> servers = new ArrayList<String>();
            for (String name : new String[]{"net.dns1", "net.dns2", "net.dns3", "net.dns4"}) {
                String value = (String)method.invoke(null, name);
                if (value == null || "".equals(value) || servers.contains(value)) continue;
                servers.add(value);
            }
            return servers;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ArrayList<String> getDnsFromConnectionManager(Context context) {
        ArrayList<String> dnsServers = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 21 && context != null) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                return dnsServers;
            }
            NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            if (activeNetworkInfo == null) {
                return dnsServers;
            }
            for (Network network : connectivityManager.getAllNetworks()) {
                NetworkInfo networkInfo = connectivityManager.getNetworkInfo(network);
                if (networkInfo == null || networkInfo.getType() != activeNetworkInfo.getType()) continue;
                LinkProperties lp = connectivityManager.getLinkProperties(network);
                if (lp == null) {
                    return dnsServers;
                }
                for (InetAddress addr : lp.getDnsServers()) {
                    dnsServers.add(addr.getHostAddress());
                }
            }
        }
        return dnsServers;
    }
}

