/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.realtime;

import io.ably.lib.realtime.Channel;
import io.ably.lib.realtime.Connection;
import io.ably.lib.realtime.ConnectionEvent;
import io.ably.lib.realtime.ConnectionStateListener;
import io.ably.lib.rest.AblyRest;
import io.ably.lib.transport.ConnectionManager;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.types.ReadOnlyMap;
import io.ably.lib.util.InternalMap;
import io.ably.lib.util.Log;
import java.util.Map;

public class AblyRealtime
extends AblyRest
implements AutoCloseable {
    public final Connection connection;
    public final Channels channels;
    private static final String TAG = AblyRealtime.class.getName();

    public AblyRealtime(String key) throws AblyException {
        this(new ClientOptions(key));
    }

    public AblyRealtime(ClientOptions options) throws AblyException {
        super(options);
        final InternalChannels channels = new InternalChannels();
        this.channels = channels;
        this.connection = new Connection(this, channels, this.platformAgentProvider);
        this.connection.on(ConnectionEvent.closed, new ConnectionStateListener(){

            @Override
            public void onConnectionStateChanged(ConnectionStateListener.ConnectionStateChange state) {
                channels.clear();
            }
        });
        if (options.autoConnect) {
            this.connection.connect();
        }
    }

    public void connect() {
        this.connection.connect();
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    protected void onAuthUpdated(String token, boolean waitForResponse) throws AblyException {
        this.connection.connectionManager.onAuthUpdated(token, waitForResponse);
    }

    @Override
    protected void onAuthError(ErrorInfo errorInfo) {
        this.connection.connectionManager.onAuthError(errorInfo);
    }

    private class InternalChannels
    extends InternalMap<String, Channel>
    implements Channels,
    ConnectionManager.Channels {
        private InternalChannels() {
        }

        @Override
        public Channel get(String channelName) {
            try {
                return this.get(channelName, null);
            }
            catch (AblyException e) {
                return null;
            }
        }

        @Override
        public Channel get(String channelName, ChannelOptions channelOptions) throws AblyException {
            Channel newChannel = new Channel(AblyRealtime.this, channelName, channelOptions);
            Channel existingChannel = this.map.putIfAbsent(channelName, newChannel);
            if (existingChannel != null) {
                if (channelOptions != null) {
                    if (existingChannel.shouldReattachToSetOptions(channelOptions)) {
                        throw AblyException.fromErrorInfo(new ErrorInfo("Channels.get() cannot be used to set channel options that would cause the channel to reattach. Please, use Channel.setOptions() instead.", 40000, 400));
                    }
                    existingChannel.setOptions(channelOptions);
                }
                return existingChannel;
            }
            return newChannel;
        }

        @Override
        public void release(String channelName) {
            Channel channel = (Channel)this.map.remove(channelName);
            if (channel != null) {
                try {
                    channel.detach();
                }
                catch (AblyException e) {
                    Log.e(TAG, "Unexpected exception detaching channel; channelName = " + channelName, e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(ProtocolMessage msg) {
            Channel channel;
            String channelName = msg.channel;
            InternalChannels internalChannels = this;
            synchronized (internalChannels) {
                channel = AblyRealtime.this.channels.get(channelName);
            }
            if (channel == null) {
                Log.e(TAG, "Received channel message for non-existent channel");
                return;
            }
            channel.onChannelMessage(msg);
        }

        @Override
        public void suspendAll(ErrorInfo error, boolean notifyStateChange) {
            for (Map.Entry entry : this.map.entrySet()) {
                ((Channel)entry.getValue()).setSuspended(error, notifyStateChange);
            }
        }

        private void clear() {
            this.map.clear();
        }
    }

    public static interface Channels
    extends ReadOnlyMap<String, Channel> {
        public Channel get(String var1);

        public Channel get(String var1, ChannelOptions var2) throws AblyException;

        public void release(String var1);
    }
}

