/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.BasePaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BasePaginatedQuery<T>
implements HttpCore.ResponseHandler<BasePaginatedResult<T>> {
    protected static Pattern linkPattern = Pattern.compile("\\s*<(.*)>;\\s*rel=\"(.*)\"");
    protected static Pattern urlPattern = Pattern.compile("\\./(.*)\\?(.*)");
    private final Http http;
    private final String path;
    private final Param[] requestHeaders;
    private final Param[] requestParams;
    private final HttpCore.RequestBody requestBody;
    private final HttpCore.BodyHandler<T> bodyHandler;

    public BasePaginatedQuery(Http http, String path, Param[] headers, Param[] params, HttpCore.BodyHandler<T> bodyHandler) {
        this(http, path, headers, params, null, bodyHandler);
    }

    public BasePaginatedQuery(Http http, String path, Param[] headers, Param[] params, HttpCore.RequestBody requestBody, HttpCore.BodyHandler<T> bodyHandler) {
        this.http = http;
        this.path = path;
        this.requestHeaders = headers;
        this.requestParams = params;
        this.requestBody = requestBody;
        this.bodyHandler = bodyHandler;
    }

    public ResultRequest<T> get() {
        return new ResultRequest(this.exec("GET"));
    }

    public Http.Request<BasePaginatedResult<T>> exec(final String method) {
        final BasePaginatedQuery responseHandler = this;
        return this.http.request(new Http.Execute<BasePaginatedResult<T>>(){

            @Override
            public void execute(HttpScheduler http, Callback<BasePaginatedResult<T>> callback) throws AblyException {
                http.exec(BasePaginatedQuery.this.path, method, BasePaginatedQuery.this.requestHeaders, BasePaginatedQuery.this.requestParams, BasePaginatedQuery.this.requestBody, responseHandler, true, callback);
            }
        });
    }

    @Override
    public BasePaginatedResult<T> handleResponse(HttpCore.Response response, ErrorInfo error) throws AblyException {
        if (error != null) {
            throw AblyException.fromErrorInfo(error);
        }
        Object[] responseContents = this.bodyHandler.handleResponseBody(response.contentType, response.body);
        return new ResultPage(responseContents, response.getHeaderFields("Link"));
    }

    protected static HashMap<String, String> parseLinks(Collection<String> linkHeaders) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String link : linkHeaders) {
            Matcher linkMatch = linkPattern.matcher(link);
            if (!linkMatch.matches()) continue;
            String linkUrl = linkMatch.group(1);
            for (String linkRel : linkMatch.group(2).toLowerCase(Locale.ENGLISH).split("\\s")) {
                result.put(linkRel, linkUrl);
            }
        }
        return result;
    }

    private static class CallbackBridge<T>
    implements Callback<BasePaginatedResult<T>> {
        private final Callback<AsyncPaginatedResult<T>> callback;

        CallbackBridge(Callback<AsyncPaginatedResult<T>> callback) {
            this.callback = callback;
        }

        @Override
        public void onSuccess(BasePaginatedResult<T> result) {
            this.callback.onSuccess(new AsyncResultPage<T>(result));
        }

        @Override
        public void onError(ErrorInfo reason) {
            this.callback.onError(reason);
        }
    }

    private static class AsyncResultPage<T>
    extends ResultPageWrapper<T>
    implements AsyncPaginatedResult<T> {
        AsyncResultPage(BasePaginatedResult<T> resultBase) {
            super(resultBase);
        }

        @Override
        public void first(Callback<AsyncPaginatedResult<T>> callback) {
            this.resultBase.first().async(new CallbackBridge<T>(callback));
        }

        @Override
        public void current(Callback<AsyncPaginatedResult<T>> callback) {
            this.resultBase.current().async(new CallbackBridge<T>(callback));
        }

        @Override
        public void next(Callback<AsyncPaginatedResult<T>> callback) {
            this.resultBase.next().async(new CallbackBridge<T>(callback));
        }
    }

    private static class SyncResultPage<T>
    extends ResultPageWrapper<T>
    implements PaginatedResult<T> {
        SyncResultPage(BasePaginatedResult<T> resultBase) {
            super(resultBase);
        }

        @Override
        public PaginatedResult<T> first() throws AblyException {
            return new SyncResultPage(this.resultBase.first().sync());
        }

        @Override
        public PaginatedResult<T> current() throws AblyException {
            return new SyncResultPage(this.resultBase.current().sync());
        }

        @Override
        public PaginatedResult<T> next() throws AblyException {
            return new SyncResultPage(this.resultBase.next().sync());
        }
    }

    private static abstract class ResultPageWrapper<T> {
        protected final BasePaginatedResult<T> resultBase;

        protected ResultPageWrapper(BasePaginatedResult<T> resultBase) {
            this.resultBase = resultBase;
        }

        public T[] items() {
            return this.resultBase.items();
        }

        public boolean hasFirst() {
            return this.resultBase.hasFirst();
        }

        public boolean hasCurrent() {
            return this.resultBase.hasCurrent();
        }

        public boolean hasNext() {
            return this.resultBase.hasNext();
        }

        public boolean isLast() {
            return this.resultBase.isLast();
        }
    }

    public static class ResultRequest<T> {
        private final Http.Request<BasePaginatedResult<T>> wrappedRequest;

        private ResultRequest(Http.Request<BasePaginatedResult<T>> wrappedRequest) {
            this.wrappedRequest = wrappedRequest;
        }

        public PaginatedResult<T> sync() throws AblyException {
            return new SyncResultPage<T>(this.wrappedRequest.sync());
        }

        public void async(final Callback<AsyncPaginatedResult<T>> callback) {
            this.wrappedRequest.async(new Callback<BasePaginatedResult<T>>(){

                @Override
                public void onSuccess(BasePaginatedResult<T> result) {
                    callback.onSuccess(new AsyncResultPage(result));
                }

                @Override
                public void onError(ErrorInfo reason) {
                    callback.onError(reason);
                }
            });
        }

        public static class Failed<T>
        extends ResultRequest<T> {
            private final AblyException reason;

            public Failed(AblyException reason) {
                super(null);
                this.reason = reason;
            }

            @Override
            public PaginatedResult<T> sync() throws AblyException {
                throw this.reason;
            }

            @Override
            public void async(Callback<AsyncPaginatedResult<T>> callback) {
                callback.onError(this.reason.errorInfo);
            }
        }
    }

    private class ResultPage
    implements BasePaginatedResult<T> {
        private T[] contents;
        private String relFirst;
        private String relCurrent;
        private String relNext;

        private ResultPage(T[] contents, Collection<String> linkHeaders) throws AblyException {
            this.contents = contents;
            if (linkHeaders != null) {
                HashMap<String, String> links = BasePaginatedQuery.parseLinks(linkHeaders);
                this.relFirst = links.get("first");
                this.relCurrent = links.get("current");
                this.relNext = links.get("next");
            }
        }

        @Override
        public T[] items() {
            return this.contents;
        }

        @Override
        public Http.Request<BasePaginatedResult<T>> first() {
            return this.getRel(this.relFirst);
        }

        @Override
        public Http.Request<BasePaginatedResult<T>> current() {
            return this.getRel(this.relCurrent);
        }

        @Override
        public Http.Request<BasePaginatedResult<T>> next() {
            return this.getRel(this.relNext);
        }

        private Http.Request<BasePaginatedResult<T>> getRel(final String linkUrl) {
            return BasePaginatedQuery.this.http.request(new Http.Execute<BasePaginatedResult<T>>(){

                @Override
                public void execute(HttpScheduler http, Callback<BasePaginatedResult<T>> callback) throws AblyException {
                    if (linkUrl == null) {
                        callback.onSuccess(null);
                        return;
                    }
                    Matcher urlMatch = urlPattern.matcher(linkUrl);
                    if (!urlMatch.matches()) {
                        throw AblyException.fromErrorInfo(new ErrorInfo("Unexpected link URL format", 500, 50000));
                    }
                    String[] paramSpecs = urlMatch.group(2).split("&");
                    Param[] params = new Param[paramSpecs.length];
                    try {
                        for (int i = 0; i < paramSpecs.length; ++i) {
                            String[] split = paramSpecs[i].split("=");
                            params[i] = new Param(split[0], URLDecoder.decode(split[1], "UTF-8"));
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    http.get(BasePaginatedQuery.this.path, BasePaginatedQuery.this.requestHeaders, params, BasePaginatedQuery.this, true, callback);
                }
            });
        }

        @Override
        public boolean hasFirst() {
            return this.relFirst != null;
        }

        @Override
        public boolean hasCurrent() {
            return this.relCurrent != null;
        }

        @Override
        public boolean hasNext() {
            return this.relNext != null;
        }

        @Override
        public boolean isLast() {
            return this.relNext == null;
        }
    }
}

