/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.davidehrmann.vcdiff.VCDiffDecoder;
import com.davidehrmann.vcdiff.VCDiffDecoderBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.DecodingContext;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.util.Base64Coder;
import io.ably.lib.util.Crypto;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class BaseMessage
implements Cloneable {
    public String id;
    public long timestamp;
    public String clientId;
    public String connectionId;
    public String encoding;
    public Object data;
    private static final String TIMESTAMP = "timestamp";
    private static final String ID = "id";
    private static final String CLIENT_ID = "clientId";
    private static final String CONNECTION_ID = "connectionId";
    private static final String ENCODING = "encoding";
    private static final String DATA = "data";
    private static final VCDiffDecoder vcdiffDecoder = VCDiffDecoderBuilder.builder().buildSimple();
    private static Pattern xformPattern = Pattern.compile("([\\-\\w]+)(\\+([\\-\\w]+))?");
    private static final String TAG = BaseMessage.class.getName();

    public void getDetails(StringBuilder builder) {
        if (this.clientId != null) {
            builder.append(" clientId=").append(this.clientId);
        }
        if (this.connectionId != null) {
            builder.append(" connectionId=").append(this.connectionId);
        }
        if (this.data != null) {
            builder.append(" data=").append(this.data);
        }
        if (this.encoding != null) {
            builder.append(" encoding=").append(this.encoding);
        }
        if (this.id != null) {
            builder.append(" id=").append(this.id);
        }
    }

    public void decode(ChannelOptions opts) throws MessageDecodeException {
        this.decode(opts, new DecodingContext());
    }

    private static byte[] vcdiffApply(byte[] delta, byte[] base) throws MessageDecodeException {
        try {
            ByteArrayOutputStream decoded = new ByteArrayOutputStream();
            vcdiffDecoder.decode(base, delta, (OutputStream)decoded);
            return decoded.toByteArray();
        }
        catch (Throwable t) {
            throw MessageDecodeException.fromThrowableAndErrorInfo(t, new ErrorInfo("VCDIFF delta decode failed", 400, 40018));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ChannelOptions opts, DecodingContext context) throws MessageDecodeException {
        Object lastPayload = this.data;
        if (this.encoding != null) {
            String[] xforms = this.encoding.split("\\/");
            int lastProcessedEncodingIndex = 0;
            int encodingsToProcess = xforms.length;
            try {
                Matcher match;
                block24: while ((lastProcessedEncodingIndex = encodingsToProcess--) > 0 && (match = xformPattern.matcher(xforms[encodingsToProcess])).matches()) {
                    switch (match.group(1)) {
                        case "base64": {
                            try {
                                this.data = Base64Coder.decode((String)this.data);
                            }
                            catch (IllegalArgumentException e) {
                                throw MessageDecodeException.fromDescription("Invalid base64 data received");
                            }
                            if (lastProcessedEncodingIndex != xforms.length) continue block24;
                            lastPayload = this.data;
                            continue block24;
                        }
                        case "utf-8": {
                            try {
                                this.data = new String((byte[])this.data, "UTF-8");
                            }
                            catch (UnsupportedEncodingException | ClassCastException e) {}
                            continue block24;
                        }
                        case "json": {
                            try {
                                String jsonText = ((String)this.data).trim();
                                this.data = Serialisation.gsonParser.parse(jsonText);
                                continue block24;
                            }
                            catch (JsonParseException e) {
                                throw MessageDecodeException.fromDescription("Invalid JSON data received");
                            }
                        }
                        case "cipher": {
                            if (opts != null && opts.encrypted) {
                                try {
                                    Crypto.DecryptingChannelCipher cipher = Crypto.createChannelDecipher(opts.getCipherParamsOrDefault());
                                    this.data = cipher.decrypt((byte[])this.data);
                                    continue block24;
                                }
                                catch (AblyException e) {
                                    throw MessageDecodeException.fromDescription(e.errorInfo.message);
                                }
                            }
                            throw MessageDecodeException.fromDescription("Encrypted message received but encryption is not set up");
                        }
                        case "vcdiff": {
                            lastPayload = this.data = (Object)BaseMessage.vcdiffApply((byte[])this.data, context.getLastMessageData());
                            continue block24;
                        }
                    }
                }
                this.encoding = lastProcessedEncodingIndex <= 0 ? null : this.join(xforms, '/', 0, lastProcessedEncodingIndex);
            }
            catch (Throwable throwable) {
                this.encoding = lastProcessedEncodingIndex <= 0 ? null : this.join(xforms, '/', 0, lastProcessedEncodingIndex);
                throw throwable;
            }
        }
        if (lastPayload instanceof String) {
            context.setLastMessageData((String)lastPayload);
        } else if (lastPayload instanceof byte[]) {
            context.setLastMessageData((byte[])lastPayload);
        } else {
            throw MessageDecodeException.fromDescription("Message data neither String nor byte[]. Unsupported message data type.");
        }
    }

    public void encode(ChannelOptions opts) throws AblyException {
        if (this.data != null) {
            if (this.data instanceof JsonElement) {
                this.data = Serialisation.gson.toJson((JsonElement)this.data);
                this.encoding = (this.encoding == null ? "" : this.encoding + "/") + "json";
            }
            if (this.data instanceof String) {
                if (opts != null && opts.encrypted) {
                    try {
                        this.data = ((String)this.data).getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    this.encoding = (this.encoding == null ? "" : this.encoding + "/") + "utf-8";
                }
            } else if (!(this.data instanceof byte[])) {
                Log.d(TAG, "Message data must be either `byte[]`, `String` or `JSONElement`; implicit coercion of other types to String is deprecated");
                throw AblyException.fromErrorInfo(new ErrorInfo("Invalid message data or encoding", 400, 40013));
            }
        }
        if (opts != null && opts.encrypted) {
            Crypto.EncryptingChannelCipher cipher = Crypto.createChannelEncipher(opts.getCipherParamsOrDefault());
            this.data = cipher.encrypt((byte[])this.data);
            this.encoding = (this.encoding == null ? "" : this.encoding + "/") + "cipher+" + cipher.getAlgorithm();
        }
    }

    private String join(String[] elements, char separator, int start, int end) {
        StringBuilder result = new StringBuilder(elements[start++]);
        for (int i = start; i < end; ++i) {
            result.append(separator).append(elements[i]);
        }
        return result.toString();
    }

    public static JsonObject toJsonObject(BaseMessage message) {
        JsonObject json = new JsonObject();
        Object data = message.data;
        String encoding = message.encoding;
        if (data != null) {
            if (data instanceof byte[]) {
                byte[] dataBytes = (byte[])data;
                json.addProperty(DATA, new String(Base64Coder.encode(dataBytes)));
                encoding = encoding == null ? "base64" : encoding + "/base64";
            } else {
                json.addProperty(DATA, data.toString());
            }
            if (encoding != null) {
                json.addProperty(ENCODING, encoding);
            }
        }
        if (message.id != null) {
            json.addProperty(ID, message.id);
        }
        if (message.clientId != null) {
            json.addProperty(CLIENT_ID, message.clientId);
        }
        if (message.connectionId != null) {
            json.addProperty(CONNECTION_ID, message.connectionId);
        }
        return json;
    }

    protected void read(JsonObject map) throws MessageDecodeException {
        Long optionalTimestamp = this.readLong(map, TIMESTAMP);
        if (null != optionalTimestamp) {
            this.timestamp = optionalTimestamp;
        }
        this.id = this.readString(map, ID);
        this.clientId = this.readString(map, CLIENT_ID);
        this.connectionId = this.readString(map, CONNECTION_ID);
        this.encoding = this.readString(map, ENCODING);
        this.data = this.readString(map, DATA);
    }

    protected String readString(JsonObject map, String key) {
        JsonElement element = map.get(key);
        if (null == element || element instanceof JsonNull) {
            return null;
        }
        return element.getAsString();
    }

    protected Long readLong(JsonObject map, String key) {
        JsonElement element = map.get(key);
        if (null == element || element instanceof JsonNull) {
            return null;
        }
        return element.getAsLong();
    }

    protected Integer readInt(JsonObject map, String key) {
        JsonElement element = map.get(key);
        if (null == element || element instanceof JsonNull) {
            return null;
        }
        return element.getAsInt();
    }

    boolean readField(MessageUnpacker unpacker, String fieldName, MessageFormat fieldType) throws IOException {
        boolean result = true;
        switch (fieldName) {
            case "timestamp": {
                this.timestamp = unpacker.unpackLong();
                break;
            }
            case "id": {
                this.id = unpacker.unpackString();
                break;
            }
            case "clientId": {
                this.clientId = unpacker.unpackString();
                break;
            }
            case "connectionId": {
                this.connectionId = unpacker.unpackString();
                break;
            }
            case "encoding": {
                this.encoding = unpacker.unpackString();
                break;
            }
            case "data": {
                if (fieldType.getValueType().isBinaryType()) {
                    byte[] byteData = new byte[unpacker.unpackBinaryHeader()];
                    unpacker.readPayload(byteData);
                    this.data = byteData;
                    break;
                }
                this.data = unpacker.unpackString();
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    protected int countFields() {
        int fieldCount = 0;
        if (this.timestamp > 0L) {
            ++fieldCount;
        }
        if (this.id != null) {
            ++fieldCount;
        }
        if (this.clientId != null) {
            ++fieldCount;
        }
        if (this.connectionId != null) {
            ++fieldCount;
        }
        if (this.encoding != null) {
            ++fieldCount;
        }
        if (this.data != null) {
            ++fieldCount;
        }
        return fieldCount;
    }

    void writeFields(MessagePacker packer) throws IOException {
        if (this.timestamp > 0L) {
            packer.packString(TIMESTAMP);
            packer.packLong(this.timestamp);
        }
        if (this.id != null) {
            packer.packString(ID);
            packer.packString(this.id);
        }
        if (this.clientId != null) {
            packer.packString(CLIENT_ID);
            packer.packString(this.clientId);
        }
        if (this.connectionId != null) {
            packer.packString(CONNECTION_ID);
            packer.packString(this.connectionId);
        }
        if (this.encoding != null) {
            packer.packString(ENCODING);
            packer.packString(this.encoding);
        }
        if (this.data != null) {
            packer.packString(DATA);
            if (this.data instanceof byte[]) {
                byte[] byteData = (byte[])this.data;
                packer.packBinaryHeader(byteData.length);
                packer.writePayload(byteData);
            } else {
                packer.packString(this.data.toString());
            }
        }
    }
}

