/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects;

import io.ably.lib.objects.Adapter;
import io.ably.lib.objects.LiveObjectSerializer;
import io.ably.lib.objects.LiveObjectsAdapter;
import io.ably.lib.objects.LiveObjectsPlugin;
import io.ably.lib.realtime.AblyRealtime;
import io.ably.lib.util.Log;
import java.lang.reflect.InvocationTargetException;

public class LiveObjectsHelper {
    private static final String TAG = LiveObjectsHelper.class.getName();
    private static volatile LiveObjectSerializer liveObjectSerializer;

    public static LiveObjectsPlugin tryInitializeLiveObjectsPlugin(AblyRealtime ablyRealtime) {
        try {
            Class<?> liveObjectsImplementation = Class.forName("io.ably.lib.objects.DefaultLiveObjectsPlugin");
            Adapter adapter = new Adapter(ablyRealtime);
            return (LiveObjectsPlugin)liveObjectsImplementation.getDeclaredConstructor(LiveObjectsAdapter.class).newInstance(adapter);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.i(TAG, "LiveObjects plugin not found in classpath. LiveObjects functionality will not be available.", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LiveObjectSerializer getLiveObjectSerializer() {
        if (liveObjectSerializer != null) return liveObjectSerializer;
        Class<LiveObjectsHelper> clazz = LiveObjectsHelper.class;
        synchronized (LiveObjectsHelper.class) {
            if (liveObjectSerializer != null) return liveObjectSerializer;
            try {
                Class<?> serializerClass = Class.forName("io.ably.lib.objects.serialization.DefaultLiveObjectSerializer");
                liveObjectSerializer = (LiveObjectSerializer)serializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Log.w(TAG, "Failed to init LiveObjectSerializer, LiveObjects plugin not included in the classpath", e);
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            return liveObjectSerializer;
        }
    }
}

