/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ably.lib.http.HttpCore;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.util.JsonUtils;
import io.ably.lib.util.Serialisation;

public class DeviceDetails {
    public String id;
    public String platform;
    public String formFactor;
    public String clientId;
    public JsonObject metadata;
    public Push push;
    private static Serialisation.FromJsonElement<DeviceDetails> fromJsonElement = new Serialisation.FromJsonElement<DeviceDetails>(){

        @Override
        public DeviceDetails fromJsonElement(JsonElement e) {
            return DeviceDetails.fromJsonObject((JsonObject)e);
        }
    };
    public static HttpCore.ResponseHandler<DeviceDetails> httpResponseHandler = new Serialisation.HttpResponseHandler<DeviceDetails>(DeviceDetails.class, fromJsonElement);
    public static HttpCore.BodyHandler<DeviceDetails> httpBodyHandler = new Serialisation.HttpBodyHandler<DeviceDetails>(DeviceDetails[].class, fromJsonElement);

    public JsonObject toJsonObject() {
        JsonObject o = new JsonObject();
        o.addProperty("id", this.id);
        o.addProperty("platform", this.platform);
        o.addProperty("formFactor", this.formFactor);
        o.addProperty("clientId", this.clientId);
        if (this.metadata != null) {
            o.add("metadata", (JsonElement)this.metadata);
        }
        if (this.push != null) {
            o.add("push", (JsonElement)this.push.toJsonObject());
        }
        return o;
    }

    public JsonObject pushRecipientJsonObject() {
        return JsonUtils.object().add("push", JsonUtils.object().add("recipient", this.push.recipient)).toJson();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeviceDetails)) {
            return false;
        }
        DeviceDetails other = (DeviceDetails)o;
        JsonObject thisJson = this.toJsonObject();
        JsonObject otherJson = other.toJsonObject();
        thisJson.remove("deviceSecret");
        otherJson.remove("deviceSecret");
        DeviceDetails.normalizeRecipientField(thisJson);
        DeviceDetails.normalizeRecipientField(otherJson);
        if ((this.metadata == null || this.metadata.entrySet().isEmpty()) && (other.metadata == null || other.metadata.entrySet().isEmpty())) {
            thisJson.remove("metadata");
            otherJson.remove("metadata");
        }
        return thisJson.equals((Object)otherJson);
    }

    public String toString() {
        return this.toJsonObject().toString();
    }

    public static DeviceDetails fromJsonObject(JsonObject o) {
        return (DeviceDetails)Serialisation.gson.fromJson((JsonElement)o, DeviceDetails.class);
    }

    private static void normalizeRecipientField(JsonObject deviceDetailsJson) {
        JsonElement push = deviceDetailsJson.get("push");
        if (push == null) {
            return;
        }
        JsonElement recipient = push.getAsJsonObject().get("recipient");
        if (recipient == null) {
            return;
        }
        JsonObject normalizedRecipient = JsonUtils.object().add("transportType", recipient.getAsJsonObject().get("transportType")).add("deviceToken", recipient.getAsJsonObject().get("deviceToken")).add("registrationToken", recipient.getAsJsonObject().get("registrationToken")).toJson();
        push.getAsJsonObject().add("recipient", (JsonElement)normalizedRecipient);
    }

    public static class Push {
        public JsonObject recipient;
        public State state;
        public ErrorInfo errorReason;

        public JsonObject toJsonObject() {
            JsonObject o = new JsonObject();
            o.add("recipient", (JsonElement)this.recipient);
            return o;
        }

        public static enum State {
            ACTIVE("ACTIVE"),
            FAILING("FAILING"),
            FAILED("FAILED");

            public String code;

            private State(String code) {
                this.code = code;
            }

            public int toInt() {
                State[] values = State.values();
                for (int i = 0; i < values.length; ++i) {
                    if (this != values[i]) continue;
                    return i;
                }
                return -1;
            }

            public static State fromInt(int i) {
                State[] values = State.values();
                if (i < 0 || i >= values.length) {
                    return null;
                }
                return values[i];
            }

            public static State fromCode(String code) {
                State[] values;
                for (State t : values = State.values()) {
                    if (!t.code.equals(code)) continue;
                    return t;
                }
                return null;
            }
        }
    }
}

