/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import io.ably.lib.http.AsyncHttpScheduler;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.http.SyncHttpScheduler;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;

public class Http
implements AutoCloseable {
    private final AsyncHttpScheduler asyncHttp;
    private final SyncHttpScheduler syncHttp;

    public Http(AsyncHttpScheduler asyncHttp, SyncHttpScheduler syncHttp) {
        this.asyncHttp = asyncHttp;
        this.syncHttp = syncHttp;
    }

    @Override
    public void close() throws Exception {
        this.asyncHttp.close();
    }

    public <Result> Request<Result> request(Execute<Result> execute) {
        return new Request<Result>(execute);
    }

    public <Result> Request<Result> failedRequest(final AblyException e) {
        return new Request(new Execute<Result>(){

            @Override
            public void execute(HttpScheduler http, final Callback<Result> callback) throws AblyException {
                http.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(e.errorInfo);
                    }
                });
            }
        });
    }

    public class Request<Result> {
        private final Execute<Result> execute;

        Request(Execute<Result> execute) {
            this.execute = execute;
        }

        public Result sync() throws AblyException {
            final SyncExecuteResult result = new SyncExecuteResult();
            this.execute.execute(Http.this.syncHttp, new Callback<Result>(){

                @Override
                public void onSuccess(Result r) {
                    result.ok = r;
                }

                @Override
                public void onError(ErrorInfo e) {
                    result.error = e;
                }
            });
            if (result.error != null) {
                throw AblyException.fromErrorInfo(result.error);
            }
            return result.ok;
        }

        public void async(Callback<Result> callback) {
            try {
                this.execute.execute(Http.this.asyncHttp, callback);
            }
            catch (AblyException e) {
                callback.onError(e.errorInfo);
            }
        }
    }

    public static interface Execute<Result> {
        public void execute(HttpScheduler var1, Callback<Result> var2) throws AblyException;
    }

    private static class SyncExecuteResult<Result> {
        public Result ok = null;
        public ErrorInfo error = null;

        private SyncExecuteResult() {
        }
    }
}

