/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.types.ProtocolMessage;
import java.util.HashSet;
import java.util.Set;

public enum ChannelMode {
    presence(ProtocolMessage.Flag.presence),
    publish(ProtocolMessage.Flag.publish),
    subscribe(ProtocolMessage.Flag.subscribe),
    presence_subscribe(ProtocolMessage.Flag.presence_subscribe);

    private final int mask;

    private ChannelMode(ProtocolMessage.Flag flag) {
        this.mask = flag.getMask();
    }

    public int getMask() {
        return this.mask;
    }

    public static Set<ChannelMode> toSet(int flags) {
        HashSet<ChannelMode> set = new HashSet<ChannelMode>();
        for (ChannelMode mode : ChannelMode.values()) {
            int mask = mode.getMask();
            if ((flags & mask) != mask) continue;
            set.add(mode);
        }
        return set;
    }
}

