/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import io.ably.lib.http.BasePaginatedQuery;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.rest.AblyBase;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.PresenceMessage;
import io.ably.lib.types.PresenceSerializer;
import io.ably.lib.util.Crypto;

public class ChannelBase {
    public final String name;
    public final Presence presence;
    private final AblyBase ably;
    private final String basePath;
    ChannelOptions options;

    public void publish(String name, Object data) throws AblyException {
        this.publishImpl(name, data).sync();
    }

    public void publishAsync(String name, Object data, CompletionListener listener) {
        this.publishImpl(name, data).async(new CompletionListener.ToCallback(listener));
    }

    private Http.Request<Void> publishImpl(String name, Object data) {
        return this.publishImpl(new Message[]{new Message(name, data)});
    }

    public void publish(Message[] messages) throws AblyException {
        this.publishImpl(messages).sync();
    }

    public void publishAsync(Message[] messages, CompletionListener listener) {
        this.publishImpl(messages).async(new CompletionListener.ToCallback(listener));
    }

    private Http.Request<Void> publishImpl(final Message[] messages) {
        return this.ably.http.request(new Http.Execute<Void>(){

            @Override
            public void execute(HttpScheduler http, Callback<Void> callback) throws AblyException {
                boolean hasClientSuppliedId = false;
                for (Message message : messages) {
                    hasClientSuppliedId |= message.id != null;
                    ((ChannelBase)ChannelBase.this).ably.auth.checkClientId(message, true, false);
                    message.encode(ChannelBase.this.options);
                }
                if (!hasClientSuppliedId && ((ChannelBase)ChannelBase.this).ably.options.idempotentRestPublishing) {
                    String messageId = Crypto.getRandomMessageId();
                    for (int i = 0; i < messages.length; ++i) {
                        messages[i].id = messageId + ':' + i;
                    }
                }
                HttpCore.RequestBody requestBody = ((ChannelBase)ChannelBase.this).ably.options.useBinaryProtocol ? MessageSerializer.asMsgpackRequest(messages) : MessageSerializer.asJsonRequest(messages);
                http.post(ChannelBase.this.basePath + "/messages", HttpUtils.defaultAcceptHeaders(((ChannelBase)ChannelBase.this).ably.options.useBinaryProtocol), null, requestBody, null, true, callback);
            }
        });
    }

    public PaginatedResult<Message> history(Param[] params) throws AblyException {
        return this.historyImpl(params).sync();
    }

    public void historyAsync(Param[] params, Callback<AsyncPaginatedResult<Message>> callback) {
        this.historyImpl(params).async(callback);
    }

    private BasePaginatedQuery.ResultRequest<Message> historyImpl(Param[] params) {
        HttpCore.BodyHandler<Message> bodyHandler = MessageSerializer.getMessageResponseHandler(this.options);
        return new BasePaginatedQuery<Message>(this.ably.http, this.basePath + "/messages", HttpUtils.defaultAcceptHeaders(this.ably.options.useBinaryProtocol), params, bodyHandler).get();
    }

    ChannelBase(AblyBase ably, String name, ChannelOptions options) throws AblyException {
        this.ably = ably;
        this.name = name;
        this.options = options;
        this.basePath = "/channels/" + HttpUtils.encodeURIComponent(name);
        this.presence = new Presence();
    }

    public class Presence {
        public PaginatedResult<PresenceMessage> get(Param[] params) throws AblyException {
            return this.getImpl(params).sync();
        }

        public void getAsync(Param[] params, Callback<AsyncPaginatedResult<PresenceMessage>> callback) {
            this.getImpl(params).async(callback);
        }

        private BasePaginatedQuery.ResultRequest<PresenceMessage> getImpl(Param[] params) {
            HttpCore.BodyHandler<PresenceMessage> bodyHandler = PresenceSerializer.getPresenceResponseHandler(ChannelBase.this.options);
            return new BasePaginatedQuery<PresenceMessage>(((ChannelBase)ChannelBase.this).ably.http, ChannelBase.this.basePath + "/presence", HttpUtils.defaultAcceptHeaders(((ChannelBase)ChannelBase.this).ably.options.useBinaryProtocol), params, bodyHandler).get();
        }

        public PaginatedResult<PresenceMessage> history(Param[] params) throws AblyException {
            return this.historyImpl(params).sync();
        }

        public void historyAsync(Param[] params, Callback<AsyncPaginatedResult<PresenceMessage>> callback) {
            this.historyImpl(params).async(callback);
        }

        private BasePaginatedQuery.ResultRequest<PresenceMessage> historyImpl(Param[] params) {
            HttpCore.BodyHandler<PresenceMessage> bodyHandler = PresenceSerializer.getPresenceResponseHandler(ChannelBase.this.options);
            return new BasePaginatedQuery<PresenceMessage>(((ChannelBase)ChannelBase.this).ably.http, ChannelBase.this.basePath + "/presence/history", HttpUtils.defaultAcceptHeaders(((ChannelBase)ChannelBase.this).ably.options.useBinaryProtocol), params, bodyHandler).get();
        }
    }
}

