/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.mojo.flexmojo.compiler;

import flex2.tools.oem.Library;
import flex2.tools.oem.Logger;
import info.rvin.flexmojos.utilities.MavenUtils;
import info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo;
import info.rvin.mojo.flexmojo.compiler.CompileLogger;
import info.rvin.mojo.flexmojo.compiler.MavenArtifact;
import info.rvin.mojo.flexmojo.compiler.Stylesheet;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryMojo
extends AbstractFlexCompilerMojo<Library> {
    private boolean computeDigest;
    private String[] includeClasses;
    private File[] includeFiles;
    private String[] includeNamespaces;
    private String[] includeResourceBundles;
    private MavenArtifact[] includeResourceBundlesArtifact;
    private File[] includeSources;
    private File directory;
    private boolean includeLookupOnly;
    private Stylesheet[] includeStylesheet;

    @Override
    public void setUp() throws MojoExecutionException, MojoFailureException {
        this.builder = new Library();
        if (this.directory != null) {
            ((Library)this.builder).setDirectory(this.directory);
        }
        super.setUp();
        ((Library)this.builder).setOutput(this.outputFile);
        if (this.checkNullOrEmpty(this.includeClasses) && this.checkNullOrEmpty(this.includeFiles) && this.checkNullOrEmpty(this.includeNamespaces) && this.checkNullOrEmpty(this.includeResourceBundles) && this.checkNullOrEmpty(this.includeResourceBundlesArtifact) && this.checkNullOrEmpty(this.includeSources) && this.checkNullOrEmpty(this.includeStylesheet)) {
            this.getLog().warn((CharSequence)"Nothing expecified to include.  Assuming source folders.");
            this.includeSources = (File[])this.sourcePaths.clone();
        }
        if (!this.checkNullOrEmpty(this.includeClasses)) {
            for (String string : this.includeClasses) {
                ((Library)this.builder).addComponent(string);
            }
        }
        if (!this.checkNullOrEmpty(this.includeFiles)) {
            for (File file : this.includeFiles) {
                if (file == null) {
                    throw new MojoFailureException("Cannot include a null file");
                }
                if (!file.exists()) {
                    throw new MojoFailureException("File " + file.getName() + " not found");
                }
                ((Library)this.builder).addArchiveFile(file.getName(), file);
            }
        }
        if (!this.checkNullOrEmpty(this.includeNamespaces)) {
            for (String string : this.includeNamespaces) {
                try {
                    ((Library)this.builder).addComponent(new URI(string));
                }
                catch (URISyntaxException e) {
                    throw new MojoExecutionException("Invalid URI " + (String)string, (Exception)e);
                }
            }
        }
        if (!this.checkNullOrEmpty(this.includeResourceBundles)) {
            for (String string : this.includeResourceBundles) {
                ((Library)this.builder).addResourceBundle(string);
            }
        }
        if (!this.checkNullOrEmpty(this.includeResourceBundlesArtifact)) {
            for (MavenArtifact mavenArtifact : this.includeResourceBundlesArtifact) {
                String[] bundles;
                String bundleFile;
                Artifact artifact = this.artifactFactory.createArtifactWithClassifier(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion(), "properties", "resource-bundle");
                MavenUtils.resolveArtifact((Artifact)artifact, (ArtifactResolver)this.resolver, (ArtifactRepository)this.localRepository, (List)this.remoteRepositories);
                try {
                    bundleFile = FileUtils.readFileToString((File)artifact.getFile());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Ocorreu um erro ao ler o artefato " + artifact, (Exception)e);
                }
                for (String bundle : bundles = bundleFile.split(" ")) {
                    ((Library)this.builder).addResourceBundle(bundle);
                }
            }
        }
        if (!this.checkNullOrEmpty(this.includeSources)) {
            for (File file : this.includeSources) {
                if (file == null) {
                    throw new MojoFailureException("Cannot include a null file");
                }
                if (!file.exists()) {
                    throw new MojoFailureException("File " + file.getName() + " not found");
                }
                ((Library)this.builder).addComponent(file);
            }
        }
        if (!this.checkNullOrEmpty(this.includeStylesheet)) {
            for (Stylesheet stylesheet : this.includeStylesheet) {
                if (!stylesheet.getPath().exists()) {
                    throw new MojoExecutionException("Stylesheet not found: " + stylesheet.getPath());
                }
                ((Library)this.builder).addStyleSheet(stylesheet.getName(), stylesheet.getPath());
            }
        }
        this.configuration.enableDigestComputation(this.computeDigest);
        ((Library)this.builder).addArchiveFile("maven/" + this.project.getGroupId() + "/" + this.project.getArtifactId() + "/pom.xml", new File(this.project.getBasedir(), "pom.xml"));
    }

    private boolean checkNullOrEmpty(Object[] array) {
        if (array == null) {
            return true;
        }
        if (array.length == 0) {
            return false;
        }
        return false;
    }

    @Override
    protected void writeResourceBundle(String[] bundles, String locale, File localePath) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Generating resource-bundle for " + locale));
        Library localized = new Library();
        localized.setConfiguration(this.configuration);
        localized.setLogger((Logger)new CompileLogger(this.getLog()));
        this.configuration.addLibraryPath(new File[]{this.outputFile});
        this.configuration.setLocale(new String[]{locale});
        this.configuration.setSourcePath(new File[]{localePath});
        for (String bundle : bundles) {
            localized.addResourceBundle(bundle);
        }
        this.configuration.addLibraryPath(this.getResourcesBundles());
        File output = new File(this.build.getDirectory(), this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + locale + ".swc");
        localized.setOutput(output);
        this.build(localized);
        this.projectHelper.attachArtifact(this.project, "resource-bundle", locale, output);
    }
}

