/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.mojo.flexmojo.compiler;

import flex2.tools.oem.Builder;
import flex2.tools.oem.Configuration;
import flex2.tools.oem.Logger;
import flex2.tools.oem.Report;
import info.rvin.flexmojos.utilities.MavenUtils;
import info.rvin.mojo.flexmojo.AbstractIrvinMojo;
import info.rvin.mojo.flexmojo.compiler.CompileLogger;
import info.rvin.mojo.flexmojo.compiler.Font;
import info.rvin.mojo.flexmojo.compiler.FrameLabel;
import info.rvin.mojo.flexmojo.compiler.MavenArtifact;
import info.rvin.mojo.flexmojo.compiler.Metadata;
import info.rvin.mojo.flexmojo.compiler.Namespace;
import info.rvin.mojo.flexmojo.compiler.Warning;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Build;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlexCompilerMojo<E extends Builder>
extends AbstractIrvinMojo {
    private static final String COMPATIBILITY_2_0_0 = "2.0.0";
    private static final String COMPATIBILITY_2_0_1 = "2.0.1";
    private static final String COMPATIBILITY_3_0_0 = "3.0.0";
    private static final File[] licensePropertiesLocations = new File[]{new File("C:/Documents and Settings/All Users/Application Data/Adobe/Flex/license.properties"), new File("C:/ProgramData/Adobe/Flex/license.properties"), new File("/Library/Application Support/Adobe/Flex/license.properties"), new File("~/.adobe/Flex/license.properties")};
    private boolean accessible;
    protected String[] locales;
    protected File[] sourcePaths;
    private boolean allowSourcePathOverlap;
    private boolean showWarnings;
    private Warning warnigs;
    private boolean debug;
    private String debugPassword;
    private boolean keepGeneratedActionscript;
    private Namespace[] namespaces;
    private boolean optimize;
    private boolean incremental;
    private String[] keepAs3Metadatas;
    private boolean strict;
    private boolean as3;
    private boolean es;
    private boolean verboseStacktraces;
    private Font fonts;
    private boolean useNetwork;
    private Map<String, String> licenses;
    private Map<String, String> defines;
    private String contextRoot;
    protected boolean linkReport;
    private boolean configurationReport;
    private MavenArtifact[] loadExterns;
    protected File configFile;
    private String output;
    private String targetPlayer;
    private String rawMetadata;
    private Metadata metadata;
    private String[] rslUrls;
    private String[] policyFileUrls;
    private File services;
    private Boolean mergeResourceBundle;
    protected String resourceBundlePath;
    private String compatibilityVersion;
    private String encoding;
    private File defaultsCss;
    private String defaultBackgroundColor;
    private int defaultFrameRate;
    private int scriptMaxRecursionDepth;
    private int scriptMaxExecutionTime;
    private int defaultSizeWidth;
    private int defaultSizeHeight;
    private String dumpConfig;
    private String[] externs;
    private FrameLabel[] frames;
    private String[] includes;
    private boolean headlessServer;
    private boolean keepAllTypeSelectors;
    private boolean useResourceBundleMetadata;
    private String resourceBundleList;
    private boolean staticLinkRuntimeSharedLibraries;
    private boolean verifyDigests;
    private File compilationData;
    protected E builder;
    protected File outputFile;
    protected Configuration configuration;
    protected boolean isSetProjectFile = true;
    protected File linkReportFile;

    @Override
    public void setUp() throws MojoExecutionException, MojoFailureException {
        Iterator i$;
        List resources;
        if (this.sourcePaths == null) {
            this.sourcePaths = MavenUtils.getSourcePaths((Build)this.build);
            if (this.mergeResourceBundle != null && this.mergeResourceBundle.booleanValue()) {
                ArrayList<File> paths = new ArrayList<File>(Arrays.asList(this.sourcePaths));
                for (String locale : this.locales) {
                    File localeResourcePath = MavenUtils.getLocaleResourcePath((String)this.resourceBundlePath, (String)locale);
                    paths.add(localeResourcePath);
                }
                this.sourcePaths = paths.toArray(new File[paths.size()]);
            }
        }
        if (this.outputFile == null) {
            this.outputFile = this.output == null ? new File(this.build.getDirectory(), this.build.getFinalName() + "." + this.project.getPackaging()) : new File(this.build.getDirectory(), this.output);
        }
        if (this.configFile == null) {
            resources = this.build.getResources();
            i$ = resources.iterator();
            while (i$.hasNext()) {
                Resource resource = (Resource)i$.next();
                File cfg = new File(resource.getDirectory(), "config.xml");
                if (!cfg.exists()) continue;
                this.configFile = cfg;
                break;
            }
        }
        if (this.configFile == null) {
            this.getLog().debug((CharSequence)"No config found, generating one!");
            this.configFile = MavenUtils.getConfigFile((Build)this.build);
        }
        if (!this.configFile.exists()) {
            throw new MojoExecutionException("Unable to find " + this.configFile);
        }
        this.getLog().info((CharSequence)("Using configuration file " + this.configFile));
        if (this.services == null) {
            resources = this.build.getResources();
            i$ = resources.iterator();
            while (i$.hasNext()) {
                Resource resource = (Resource)i$.next();
                File cfg = new File(resource.getDirectory(), "services-config.xml");
                if (!cfg.exists()) continue;
                this.services = cfg;
                break;
            }
        }
        if (this.rslUrls == null) {
            this.rslUrls = new String[]{"/{contextRoot}/rsl/{artifactId}-{version}.{extension}"};
        }
        if (this.policyFileUrls == null) {
            this.policyFileUrls = new String[]{""};
        }
        if (this.metadata == null) {
            List contributors;
            List developers;
            this.metadata = new Metadata();
            if (this.project.getDevelopers() != null && !this.project.getDevelopers().isEmpty() && (i$ = (developers = this.project.getDevelopers()).iterator()).hasNext()) {
                Developer d = (Developer)i$.next();
                this.metadata.setCreator(d.getName());
            }
            if (this.project.getContributors() != null && !this.project.getContributors().isEmpty() && (i$ = (contributors = this.project.getContributors()).iterator()).hasNext()) {
                Contributor c = (Contributor)i$.next();
                this.metadata.setContributor(c.getName());
            }
            this.metadata.setDate(DateFormat.getDateInstance().format(new Date()));
            if (this.locales != null) {
                this.metadata.setLanguage(this.locales[0]);
                this.metadata.addDescription(this.locales[0], this.project.getDescription());
                this.metadata.addTitle(this.locales[0], this.project.getName());
            }
        }
        if (this.licenses == null) {
            this.licenses = this.getLicenses();
        }
        this.configuration = this.builder.getDefaultConfiguration();
        this.configure();
        this.compilationData = new File(this.build.getDirectory(), this.project.getArtifactId() + "-" + this.project.getVersion() + ".incr");
    }

    private Map<String, String> getLicenses() throws MojoExecutionException {
        File licensePropertyFile = null;
        for (File lpl : licensePropertiesLocations) {
            if (!lpl.exists()) continue;
            licensePropertyFile = lpl;
            break;
        }
        if (licensePropertyFile == null) {
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(licensePropertyFile));
        }
        catch (FileNotFoundException e) {
            this.getLog().warn((CharSequence)("Unable to read license files " + licensePropertyFile.getAbsolutePath()), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to read license files " + licensePropertyFile.getAbsolutePath()), (Throwable)e);
            return null;
        }
        HashMap<String, String> licenses = new HashMap<String, String>();
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = props.getProperty(name);
            licenses.put(name, value);
        }
        return licenses;
    }

    @Override
    public void run() throws MojoExecutionException, MojoFailureException {
        this.builder.setLogger((Logger)new CompileLogger(this.getLog()));
        this.builder.setConfiguration(this.configuration);
        this.getLog().info((CharSequence)("Flex compiler configurations:" + this.configuration.toString().replace("--", "\n-")));
        this.build(this.builder);
    }

    private OutputStream saveCompilationData() throws MojoExecutionException {
        try {
            return new BufferedOutputStream(new FileOutputStream(this.compilationData));
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Can't save compilation data.");
        }
    }

    private InputStream loadCompilationData() throws MojoExecutionException {
        try {
            return new BufferedInputStream(new FileInputStream(this.compilationData));
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Previows compilation data not found.");
        }
    }

    protected void configure() throws MojoExecutionException {
        File fontsSnapshot;
        this.configuration.setExternalLibraryPath(this.getDependenciesPath("external"));
        this.configuration.includeLibraries(this.getDependenciesPath("internal"));
        this.configuration.setLibraryPath(this.getDependenciesPath("compile"));
        this.configuration.addLibraryPath(this.getDependenciesPath("merged"));
        if (this.mergeResourceBundle == null || this.mergeResourceBundle.booleanValue()) {
            this.configuration.addLibraryPath(this.getResourcesBundles());
        }
        this.resolveRuntimeLibraries();
        this.configuration.setTheme(this.getDependenciesPath("theme"));
        this.configuration.enableAccessibility(this.accessible);
        this.configuration.allowSourcePathOverlap(this.allowSourcePathOverlap);
        this.configuration.useActionScript3(this.as3);
        this.configuration.enableDebugging(this.debug, this.debugPassword);
        this.configuration.useECMAScript(this.es);
        if (this.fonts != null) {
            this.configuration.enableAdvancedAntiAliasing(this.fonts.isAdvancedAntiAliasing());
            this.configuration.enableFlashType(this.fonts.isFlashType());
            this.configuration.setFontManagers(this.fonts.getManagers());
            this.configuration.setMaximumCachedFonts(this.fonts.getMaxCachedFonts());
            this.configuration.setMaximumGlyphsPerFace(this.fonts.getMaxGlyphsPerFace());
            if (this.fonts.getLanguages() != null && !this.fonts.getLanguages().isEmpty()) {
                for (String language : this.fonts.getLanguages().keySet()) {
                    this.configuration.setFontLanguageRange(language, this.fonts.getLanguages().get(language));
                }
            }
        }
        if ((fontsSnapshot = this.getFontsSnapshot()) == null || !fontsSnapshot.exists()) {
            throw new MojoExecutionException("LocalFontSnapshot not found " + fontsSnapshot);
        }
        this.configuration.setLocalFontSnapshot(fontsSnapshot);
        this.configuration.setActionScriptMetadata(this.keepAs3Metadatas);
        this.configuration.keepCompilerGeneratedActionScript(this.keepGeneratedActionscript);
        if (this.licenses != null) {
            for (String licenseName : this.licenses.keySet()) {
                String key = this.licenses.get(licenseName);
                this.configuration.setLicense(licenseName, key);
            }
        }
        if (this.defines != null) {
            for (String defineName : this.defines.keySet()) {
                String value = this.defines.get(defineName);
                this.getLog().info((CharSequence)("define " + defineName + " = " + value));
                this.configuration.addDefineDirective(defineName, value);
            }
        }
        if (this.mergeResourceBundle == null || this.mergeResourceBundle.booleanValue()) {
            this.configuration.setLocale(this.locales);
        } else {
            this.configuration.setLocale(new String[0]);
        }
        if (this.namespaces != null) {
            for (Namespace namespace : this.namespaces) {
                this.configuration.setComponentManifest(namespace.getUri(), namespace.getManifest());
            }
        }
        this.configuration.optimize(this.optimize);
        if (this.warnigs != null) {
            this.configureWarnings(this.configuration);
        }
        this.configuration.setSourcePath(this.sourcePaths);
        this.configuration.enableStrictChecking(this.strict);
        this.configuration.useNetwork(this.useNetwork);
        this.configuration.enableVerboseStacktraces(this.verboseStacktraces);
        if (this.contextRoot != null) {
            this.configuration.setContextRoot(this.contextRoot);
        }
        this.configuration.keepLinkReport(this.linkReport);
        this.configuration.keepConfigurationReport(this.configurationReport);
        this.configuration.setConfiguration(this.configFile);
        this.configuration.setServiceConfiguration(this.services);
        if (this.loadExterns != null) {
            ArrayList<File> externsFiles = new ArrayList<File>();
            for (MavenArtifact mvnArtifact : this.loadExterns) {
                Artifact artifact = this.artifactFactory.createArtifactWithClassifier(mvnArtifact.getGroupId(), mvnArtifact.getArtifactId(), mvnArtifact.getVersion(), "xml", "link-report");
                MavenUtils.resolveArtifact((Artifact)artifact, (ArtifactResolver)this.resolver, (ArtifactRepository)this.localRepository, (List)this.remoteRepositories);
                externsFiles.add(artifact.getFile());
            }
            this.configuration.setExterns(externsFiles.toArray(new File[externsFiles.size()]));
        }
        if (this.rawMetadata != null) {
            this.configuration.setSWFMetaData(this.rawMetadata);
        }
        if (this.metadata != null) {
            if (this.metadata.getContributor() != null) {
                this.configuration.setSWFMetaData(1, (Object)this.metadata.getContributor());
            }
            if (this.metadata.getCreator() != null) {
                this.configuration.setSWFMetaData(2, (Object)this.metadata.getCreator());
            }
            if (this.metadata.getDate() != null) {
                this.configuration.setSWFMetaData(4, (Object)this.metadata.getDate());
            }
            if (this.metadata.getDescriptions() != null) {
                this.configuration.setSWFMetaData(8, this.metadata.getDescriptions());
            }
            if (this.metadata.getTitles() != null) {
                this.configuration.setSWFMetaData(16, this.metadata.getTitles());
            }
            if (this.metadata.getLanguage() != null) {
                this.configuration.setSWFMetaData(32, (Object)this.metadata.getLanguage());
            }
        }
        if (this.compatibilityVersion != null) {
            if (!(COMPATIBILITY_2_0_0.equals(this.compatibilityVersion) || COMPATIBILITY_2_0_1.equals(this.compatibilityVersion) || COMPATIBILITY_3_0_0.equals(this.compatibilityVersion))) {
                throw new MojoExecutionException("Invalid compatibility version " + this.compatibilityVersion);
            }
            if (COMPATIBILITY_2_0_0.equals(this.compatibilityVersion)) {
                this.configuration.setCompatibilityVersion(2, 0, 0);
            } else if (COMPATIBILITY_2_0_1.equals(this.compatibilityVersion)) {
                this.configuration.setCompatibilityVersion(2, 0, 1);
            } else if (COMPATIBILITY_3_0_0.equals(this.compatibilityVersion)) {
                this.configuration.setCompatibilityVersion(3, 0, 0);
            } else {
                throw new IllegalStateException("Should never reach this");
            }
        }
        this.configuration.setActionScriptFileEncoding(this.encoding);
        if (this.targetPlayer != null) {
            String[] nodes = this.targetPlayer.split("\\.");
            if (nodes.length != 3) {
                throw new MojoExecutionException("Invalid player version " + this.targetPlayer);
            }
            int[] versions = new int[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                try {
                    versions[i] = Integer.parseInt(nodes[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new MojoExecutionException("Invalid player version " + this.targetPlayer);
                }
            }
            if (versions[0] < 9) {
                throw new MojoExecutionException("Invalid player version " + this.targetPlayer);
            }
            this.configuration.setTargetPlayer(versions[0], versions[1], versions[2]);
        }
        if (this.defaultsCss != null) {
            this.configuration.setDefaultCSS(this.defaultsCss);
        }
        this.configuration.setDefaultBackgroundColor(Integer.parseInt(this.defaultBackgroundColor, 16));
        this.configuration.setDefaultFrameRate(this.defaultFrameRate);
        this.configuration.setDefaultScriptLimits(this.scriptMaxRecursionDepth, this.scriptMaxExecutionTime);
        this.configuration.setDefaultSize(this.defaultSizeWidth, this.defaultSizeHeight);
        if (this.externs != null && this.externs.length > 0) {
            this.configuration.setExterns(this.externs);
        }
        if (this.frames != null && this.frames.length > 0) {
            for (FrameLabel frame : this.frames) {
                this.configuration.setFrameLabel(frame.getLabel(), frame.getClassNames());
            }
        }
        if (this.includes != null && this.includes.length > 0) {
            this.configuration.setIncludes(this.includes);
        }
        this.configuration.useHeadlessServer(this.headlessServer);
        this.configuration.keepAllTypeSelectors(this.keepAllTypeSelectors);
        this.configuration.useResourceBundleMetaData(this.useResourceBundleMetadata);
        this.configuration.enableDigestVerification(this.verifyDigests);
    }

    private void resolveRuntimeLibraries() throws MojoExecutionException {
        List<Artifact> rsls = this.getDependencyArtifacts("rsl", "caching");
        this.rslsSort(rsls);
        for (Artifact artifact : rsls) {
            String scope = artifact.getScope();
            File artifactFile = MavenUtils.getArtifactFile((Artifact)artifact, (String)scope, (Build)this.build);
            String artifactPath = artifactFile.getAbsolutePath();
            String extension = "caching".equals(scope) ? "swz" : "swf";
            String[] rslUrls = this.getRslUrls(artifact, extension);
            String[] rslPolicyFileUrls = this.getRslPolicyFileUrls(artifact);
            this.configuration.addRuntimeSharedLibraryPath(artifactPath, rslUrls, rslPolicyFileUrls);
        }
    }

    public void rslsSort(List<Artifact> rslArtifacts) throws MojoExecutionException {
        Map<Artifact, List<Artifact>> dependencies = this.getDependencies(rslArtifacts);
        ArrayList<Artifact> ordered = new ArrayList<Artifact>();
        for (Artifact a : rslArtifacts) {
            if (dependencies.get(a) != null && !dependencies.get(a).isEmpty()) continue;
            ordered.add(a);
        }
        rslArtifacts.removeAll(ordered);
        while (!rslArtifacts.isEmpty()) {
            int original = rslArtifacts.size();
            for (Artifact a : rslArtifacts) {
                List<Artifact> deps = dependencies.get(a);
                if (!ordered.containsAll(deps)) continue;
                ordered.add(a);
            }
            rslArtifacts.removeAll(ordered);
            if (original != rslArtifacts.size()) continue;
            throw new MojoExecutionException("Unable to resolve " + rslArtifacts);
        }
        rslArtifacts.addAll(ordered);
    }

    private Map<Artifact, List<Artifact>> getDependencies(List<Artifact> rslArtifacts) throws MojoExecutionException {
        HashMap<Artifact, List<Artifact>> dependencies = new HashMap<Artifact, List<Artifact>>();
        for (Artifact pomArtifact : rslArtifacts) {
            try {
                MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(pomArtifact, this.remoteRepositories, this.localRepository);
                Set pomArtifacts = pomProject.createArtifacts(this.artifactFactory, null, null);
                ArtifactResolutionResult arr = this.resolver.resolveTransitively(pomArtifacts, pomArtifact, this.remoteRepositories, this.localRepository, this.artifactMetadataSource);
                List<Artifact> artifactDependencies = new ArrayList<Artifact>(arr.getArtifacts());
                artifactDependencies = this.removeNonRSLDependencies(rslArtifacts, artifactDependencies);
                dependencies.put(pomArtifact, artifactDependencies);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        return dependencies;
    }

    private List<Artifact> removeNonRSLDependencies(List<Artifact> rslArtifacts, List<Artifact> artifactDependencies) {
        ArrayList<Artifact> cleanArtifacts = new ArrayList<Artifact>();
        block0: for (Artifact artifact : artifactDependencies) {
            for (Artifact rslArtifact : rslArtifacts) {
                if (!artifact.getGroupId().equals(rslArtifact.getGroupId()) || !artifact.getArtifactId().equals(rslArtifact.getArtifactId()) || !artifact.getType().equals(rslArtifact.getType())) continue;
                cleanArtifacts.add(rslArtifact);
                continue block0;
            }
        }
        return cleanArtifacts;
    }

    private String[] getRslPolicyFileUrls(Artifact artifact) {
        String[] domains = new String[this.policyFileUrls.length];
        for (int i = 0; i < this.policyFileUrls.length; ++i) {
            String domain = this.policyFileUrls[i];
            if (this.contextRoot != null) {
                domain = domain.replace("{contextRoot}", this.contextRoot);
            }
            domain = domain.replace("{groupId}", artifact.getGroupId());
            domain = domain.replace("{artifactId}", artifact.getArtifactId());
            domains[i] = domain = domain.replace("{version}", artifact.getVersion());
        }
        return domains;
    }

    private String[] getRslUrls(Artifact artifact, String extension) {
        String[] rsls = new String[this.rslUrls.length];
        for (int i = 0; i < this.rslUrls.length; ++i) {
            String rsl = this.rslUrls[i];
            if (this.contextRoot != null) {
                rsl = rsl.replace("{contextRoot}", this.contextRoot);
            }
            rsl = rsl.replace("{groupId}", artifact.getGroupId());
            rsl = rsl.replace("{artifactId}", artifact.getArtifactId());
            rsl = rsl.replace("{version}", artifact.getVersion());
            rsls[i] = rsl = rsl.replace("{extension}", extension);
        }
        return rsls;
    }

    protected File getFontsSnapshot() throws MojoExecutionException {
        if (this.fonts != null && this.fonts.getLocalFontsSnapshot() != null) {
            return this.fonts.getLocalFontsSnapshot();
        }
        this.getLog().debug((CharSequence)"No fonts snapshot found, generating one!");
        return MavenUtils.getFontsFile((Build)this.build);
    }

    protected File[] getResourcesBundles() throws MojoExecutionException {
        ArrayList<File> resouceBundles = new ArrayList<File>();
        for (Artifact artifact : this.getDependencyArtifacts()) {
            if (!"resource-bundle".equals(artifact.getType())) continue;
            resouceBundles.add(artifact.getFile());
        }
        return resouceBundles.toArray(new File[resouceBundles.size()]);
    }

    protected File[] getDependenciesPath(String scope) throws MojoExecutionException {
        if (scope == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (Artifact a : this.getDependencyArtifacts(scope)) {
            files.add(MavenUtils.getArtifactFile((Artifact)a, (String)scope, (Build)this.build));
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    protected void tearDown() throws MojoExecutionException, MojoFailureException {
        if (this.isSetProjectFile) {
            this.project.getArtifact().setFile(this.outputFile);
        }
        Report report = this.builder.getReport();
        if (this.linkReport) {
            this.writeLinkReport(report);
        }
        if (this.configurationReport) {
            this.writeConfigurationReport(report);
        }
        if (this.mergeResourceBundle != null && !this.mergeResourceBundle.booleanValue()) {
            this.writeResourceBundle(report);
        }
    }

    private void writeResourceBundle(Report report) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Compiling resources bundles!");
        if (this.locales == null || this.locales.length == 0) {
            this.getLog().warn((CharSequence)"Resource-bundle generation fail: No locale defined.");
            return;
        }
        String[] bundles = report.getResourceBundleNames();
        if (bundles == null || bundles.length == 0) {
            this.getLog().warn((CharSequence)"Resource-bundle generation fail: No resource-bundle found.");
            return;
        }
        for (String locale : this.locales) {
            this.getLog().info((CharSequence)("Generating resource-bundle for " + locale));
            File localePath = MavenUtils.getLocaleResourcePath((String)this.resourceBundlePath, (String)locale);
            if (!localePath.exists()) {
                this.getLog().error((CharSequence)("Unable to find locales path: " + localePath.getAbsolutePath()));
                continue;
            }
            this.writeResourceBundle(bundles, locale, localePath);
        }
    }

    protected abstract void writeResourceBundle(String[] var1, String var2, File var3) throws MojoExecutionException;

    private void configureWarnings(Configuration cfg) {
        cfg.showActionScriptWarnings(this.showWarnings);
        cfg.showBindingWarnings(this.warnigs.getBinding());
        cfg.showDeprecationWarnings(this.warnigs.getDeprecation());
        cfg.showShadowedDeviceFontWarnings(this.warnigs.getShadowedDeviceFont());
        cfg.showUnusedTypeSelectorWarnings(this.warnigs.getUnusedTypeSelector());
        cfg.checkActionScriptWarning(1044, this.warnigs.getArrayTostringChanges());
        cfg.checkActionScriptWarning(1100, this.warnigs.getAssignmentWithinConditional());
        cfg.checkActionScriptWarning(1112, this.warnigs.getBadArrayCast());
        cfg.checkActionScriptWarning(3590, this.warnigs.getBadBooleanAssignment());
        cfg.checkActionScriptWarning(3575, this.warnigs.getBadDateCast());
        cfg.checkActionScriptWarning(3594, this.warnigs.getBadEs3TypeMethod());
        cfg.checkActionScriptWarning(3592, this.warnigs.getBadEs3TypeProp());
        cfg.checkActionScriptWarning(1098, this.warnigs.getBadNanComparison());
        cfg.checkActionScriptWarning(1102, this.warnigs.getBadNullAssignment());
        cfg.checkActionScriptWarning(1096, this.warnigs.getBadNullComparison());
        cfg.checkActionScriptWarning(1012, this.warnigs.getBadUndefinedComparison());
        cfg.checkActionScriptWarning(1034, this.warnigs.getBooleanConstructorWithNoArgs());
        cfg.checkActionScriptWarning(1066, this.warnigs.getChangesInResolve());
        cfg.checkActionScriptWarning(1072, this.warnigs.getClassIsSealed());
        cfg.checkActionScriptWarning(1110, this.warnigs.getConstNotInitialized());
        cfg.checkActionScriptWarning(1030, this.warnigs.getConstructorReturnsValue());
        cfg.checkActionScriptWarning(1090, this.warnigs.getDeprecatedEventHandlerError());
        cfg.checkActionScriptWarning(1060, this.warnigs.getDeprecatedFunctionError());
        cfg.checkActionScriptWarning(1058, this.warnigs.getDeprecatedPropertyError());
        cfg.checkActionScriptWarning(3583, this.warnigs.getDuplicateArgumentNames());
        cfg.checkActionScriptWarning(3596, this.warnigs.getDuplicateVariableDef());
        cfg.checkActionScriptWarning(1086, this.warnigs.getForVarInChanges());
        cfg.checkActionScriptWarning(3581, this.warnigs.getImportHidesClass());
        cfg.checkActionScriptWarning(3555, this.warnigs.getInstanceOfChanges());
        cfg.checkActionScriptWarning(1088, this.warnigs.getInternalError());
        cfg.checkActionScriptWarning(1070, this.warnigs.getLevelNotSupported());
        cfg.checkActionScriptWarning(1084, this.warnigs.getMissingNamespaceDecl());
        cfg.checkActionScriptWarning(1092, this.warnigs.getNegativeUintLiteral());
        cfg.checkActionScriptWarning(1104, this.warnigs.getNoConstructor());
        cfg.checkActionScriptWarning(1114, this.warnigs.getNoExplicitSuperCallInConstructor());
        cfg.checkActionScriptWarning(1008, this.warnigs.getNoTypeDecl());
        cfg.checkActionScriptWarning(1038, this.warnigs.getNumberFromStringChanges());
        cfg.checkActionScriptWarning(1082, this.warnigs.getScopingChangeInThis());
        cfg.checkActionScriptWarning(3551, this.warnigs.getSlowTextFieldAddition());
        cfg.checkActionScriptWarning(3553, this.warnigs.getUnlikelyFunctionValue());
        cfg.checkActionScriptWarning(3573, this.warnigs.getXmlClassHasChanged());
    }

    private void writeLinkReport(Report report) throws MojoExecutionException {
        this.writeReport(report, "link");
    }

    private void writeConfigurationReport(Report report) throws MojoExecutionException {
        this.writeReport(report, "config");
    }

    private void writeReport(Report report, String type) throws MojoExecutionException {
        File fileReport = new File(this.build.getDirectory(), this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + type + "-report.xml");
        FileWriter writer = null;
        try {
            writer = new FileWriter(fileReport);
            if ("link".equals(type)) {
                report.writeLinkReport((Writer)writer);
                this.linkReportFile = fileReport;
            } else if ("config".equals(type)) {
                report.writeConfigurationReport((Writer)writer);
            }
            this.getLog().info((CharSequence)("Written " + type + " report to " + fileReport));
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error has ocurried while recording " + type + "-report", (Exception)e);
        }
        finally {
            try {
                if (null != writer) {
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Error while closing writer", (Throwable)e);
            }
        }
        this.projectHelper.attachArtifact(this.project, "xml", type + "-report", fileReport);
    }

    protected void build(E builder) throws MojoExecutionException {
        long bytes;
        try {
            bytes = builder.build(this.incremental);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (bytes == 0L) {
            throw new MojoExecutionException("Error compiling!");
        }
    }
}

