/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.flexmojo.test;

import info.rvin.flexmojo.test.FlexUnitLauncher;
import info.rvin.mojo.flexmojo.AbstractIrvinMojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class FlexUnitMojo
extends AbstractIrvinMojo {
    private static final String END_OF_TEST_RUN = "<endOfTestRun/>";
    private static final String END_OF_TEST_SUITE = "</testsuite>";
    private static final String END_OF_TEST_ACK = "<endOfTestRunAck/>";
    private static final char NULL_BYTE = '\u0000';
    private static final String POLICY_FILE_REQUEST = "<policy-file-request/>";
    static final String DOMAIN_POLICY = "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"{0}\" /></cross-domain-policy>";
    private boolean failures = false;
    private boolean complete;
    private boolean verbose = true;
    private int testPort;
    private int socketTimeout = 60000;
    private File swf;
    private MojoExecutionException executionError;
    private boolean skipTests;
    private File reportPath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setUp();
        if (this.skipTests) {
            this.getLog().warn((CharSequence)"Skipping test phase.");
        } else if (this.swf == null || !this.swf.exists()) {
            this.getLog().warn((CharSequence)("Skipping test run. Runner not found: " + this.swf));
        } else {
            this.run();
            this.tearDown();
        }
    }

    protected void setUp() throws MojoExecutionException, MojoFailureException {
        this.swf = new File(this.build.getTestOutputDirectory(), "TestRunner.swf");
        this.reportPath = new File(this.build.getDirectory(), "surefire-reports");
        this.reportPath.mkdirs();
    }

    private void receiveFlexUnitResults() throws MojoExecutionException {
        Thread thread = new Thread(){
            private ServerSocket serverSocket = null;
            private Socket clientSocket = null;
            private InputStream in = null;
            private OutputStream out = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    this.openServerSocket();
                    this.openClientSocket();
                    StringBuffer buffer = new StringBuffer();
                    int bite = -1;
                    while ((bite = this.in.read()) != -1) {
                        char chr = (char)bite;
                        if (chr == '\u0000') {
                            String data = buffer.toString();
                            buffer = new StringBuffer();
                            if (data.equals(FlexUnitMojo.POLICY_FILE_REQUEST)) {
                                this.sendPolicyFile();
                                this.closeClientSocket();
                                this.openClientSocket();
                                continue;
                            }
                            if (data.endsWith(FlexUnitMojo.END_OF_TEST_SUITE)) {
                                this.saveTestReport(data);
                                continue;
                            }
                            if (!data.equals(FlexUnitMojo.END_OF_TEST_RUN)) continue;
                            this.sendAcknowledgement();
                            continue;
                        }
                        buffer.append(chr);
                    }
                }
                catch (MojoExecutionException be) {
                    FlexUnitMojo.this.executionError = be;
                    try {
                        this.sendAcknowledgement();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                catch (SocketTimeoutException e) {
                    FlexUnitMojo.this.executionError = new MojoExecutionException("timeout waiting for flexunit report", (Exception)e);
                }
                catch (IOException e) {
                    FlexUnitMojo.this.executionError = new MojoExecutionException("error receiving report from flexunit", (Exception)e);
                }
                finally {
                    FlexUnitMojo.this.complete = true;
                    this.closeClientSocket();
                    this.closeServerSocket();
                }
            }

            private void sendPolicyFile() throws IOException {
                this.out.write(MessageFormat.format(FlexUnitMojo.DOMAIN_POLICY, Integer.toString(FlexUnitMojo.this.testPort)).getBytes());
                this.out.write(0);
                if (FlexUnitMojo.this.verbose) {
                    FlexUnitMojo.this.log("sent policy file");
                }
            }

            private void saveTestReport(String report) throws MojoExecutionException {
                FlexUnitMojo.this.writeTestReport(report);
                if (FlexUnitMojo.this.verbose) {
                    FlexUnitMojo.this.log("end of test");
                }
            }

            private void sendAcknowledgement() throws IOException {
                this.out.write(FlexUnitMojo.END_OF_TEST_ACK.getBytes());
                this.out.write(0);
                if (FlexUnitMojo.this.verbose) {
                    FlexUnitMojo.this.log("end of test run");
                }
            }

            private void openServerSocket() throws IOException {
                this.serverSocket = new ServerSocket(FlexUnitMojo.this.testPort);
                this.serverSocket.setSoTimeout(FlexUnitMojo.this.socketTimeout);
                if (FlexUnitMojo.this.verbose) {
                    FlexUnitMojo.this.log("opened server socket");
                }
            }

            private void closeServerSocket() {
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            private void openClientSocket() throws IOException {
                this.clientSocket = this.serverSocket.accept();
                if (FlexUnitMojo.this.verbose) {
                    FlexUnitMojo.this.log("accepting data from client");
                }
                this.in = this.clientSocket.getInputStream();
                this.out = this.clientSocket.getOutputStream();
            }

            private void closeClientSocket() {
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (this.clientSocket != null) {
                    try {
                        this.clientSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        thread.start();
    }

    private void writeTestReport(String report) throws MojoExecutionException {
        try {
            Document document = DocumentHelper.parseText((String)report);
            Element root = document.getRootElement();
            String name = root.valueOf("@name");
            int numFailures = Integer.parseInt(root.valueOf("@failures"));
            int numErrors = Integer.parseInt(root.valueOf("@errors"));
            int totalProblems = numFailures + numErrors;
            if (this.verbose) {
                this.log("Running " + name);
            }
            if (this.verbose) {
                this.log(this.formatLogReport(root));
            }
            File file = new File(this.reportPath, "TEST-" + name + ".xml");
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(file), format);
            writer.write(document);
            writer.close();
            if (totalProblems > 0) {
                this.failures = true;
                if (this.verbose) {
                    this.log("flexunit test " + name + " failed.");
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("error writing report to disk", e);
        }
    }

    private String formatLogReport(Element root) {
        int numFailures = Integer.parseInt(root.valueOf("@failures"));
        int numErrors = Integer.parseInt(root.valueOf("@errors"));
        int numTests = Integer.parseInt(root.valueOf("@tests"));
        int time = Integer.parseInt(root.valueOf("@time"));
        StringBuffer msg = new StringBuffer();
        msg.append("Tests run: ");
        msg.append(numTests);
        msg.append(", Failures: ");
        msg.append(numFailures);
        msg.append(", Errors: ");
        msg.append(numErrors);
        msg.append(", Time Elapsed: ");
        msg.append(time);
        msg.append(" sec");
        return msg.toString();
    }

    private void handleFailures() throws MojoExecutionException {
        if (this.failures) {
            throw new MojoExecutionException("Some tests fail");
        }
    }

    public void log(String message) {
        System.out.println(message);
    }

    protected void run() throws MojoExecutionException, MojoFailureException {
        this.receiveFlexUnitResults();
        FlexUnitLauncher browser = new FlexUnitLauncher();
        try {
            browser.runTests(this.swf);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error launching the test runner.", e);
        }
        while (!this.complete) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    protected void tearDown() throws MojoExecutionException, MojoFailureException {
        if (this.executionError != null) {
            throw this.executionError;
        }
        this.handleFailures();
    }
}

