/*
 * Decompiled with CFR 0.152.
 */
package picocli.spring;

import java.util.Objects;
import java.util.logging.Logger;
import org.springframework.context.ApplicationContext;
import picocli.CommandLine;

public class PicocliSpringFactory
implements CommandLine.IFactory {
    private static final Logger logger = Logger.getLogger(PicocliSpringFactory.class.getName());
    private final ApplicationContext applicationContext;
    private final CommandLine.IFactory fallbackFactory;

    public PicocliSpringFactory(ApplicationContext applicationContext) {
        this(applicationContext, CommandLine.defaultFactory());
    }

    public PicocliSpringFactory(ApplicationContext applicationContext, CommandLine.IFactory fallbackFactory) {
        this.applicationContext = Objects.requireNonNull(applicationContext, "applicationContext");
        this.fallbackFactory = Objects.requireNonNull(fallbackFactory, "fallbackFactory");
    }

    public <K> K create(Class<K> clazz) throws Exception {
        try {
            return this.getBeanOrCreate(clazz);
        }
        catch (Exception e) {
            logger.info(String.format("Unable to get bean of class %s from ApplicationContext, using fallback factory %s (%s)", clazz, this.fallbackFactory.getClass().getName(), e.toString()));
            return (K)this.fallbackFactory.create(clazz);
        }
    }

    private <K> K getBeanOrCreate(Class<K> clazz) {
        try {
            return (K)this.applicationContext.getBean(clazz);
        }
        catch (Exception e) {
            return (K)this.applicationContext.getAutowireCapableBeanFactory().createBean(clazz);
        }
    }
}

