/*
 * Decompiled with CFR 0.152.
 */
package picocli.shell.jline3;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jline.builtins.Completers;
import org.jline.builtins.Options;
import org.jline.builtins.Widgets;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.utils.AttributedString;
import org.jline.utils.StyleResolver;
import picocli.CommandLine;

public class PicocliCommands {
    private final Supplier<Path> workDir;
    private final CommandLine cmd;
    private final List<String> commands;
    private final Map<String, String> aliasCommand = new HashMap<String, String>();

    public PicocliCommands(Path workDir, CommandLine cmd) {
        this(() -> workDir, cmd);
    }

    public PicocliCommands(Supplier<Path> workDir, CommandLine cmd) {
        this.workDir = workDir;
        this.cmd = cmd;
        this.commands = new ArrayList(cmd.getCommandSpec().subcommands().keySet());
        for (String c : this.commands) {
            for (String a : ((CommandLine)cmd.getSubcommands().get(c)).getCommandSpec().aliases()) {
                this.aliasCommand.put(a, c);
            }
        }
    }

    public boolean hasCommand(String command) {
        return this.commands.contains(command) || this.aliasCommand.containsKey(command);
    }

    public Completers.SystemCompleter compileCompleters() {
        Completers.SystemCompleter out = new Completers.SystemCompleter();
        out.addAliases(this.aliasCommand);
        for (String s : this.commands) {
            CommandLine.Model.CommandSpec spec = ((CommandLine)this.cmd.getSubcommands().get(s)).getCommandSpec();
            ArrayList<String> options = new ArrayList<String>();
            HashMap optionValues = new HashMap();
            for (CommandLine.Model.OptionSpec o : spec.options()) {
                ArrayList values = new ArrayList();
                if (o.completionCandidates() != null) {
                    o.completionCandidates().forEach(v -> values.add(v));
                }
                if (o.arity().max() == 0) {
                    options.addAll(Arrays.asList(o.names()));
                    continue;
                }
                for (String n : o.names()) {
                    optionValues.put(n, values);
                }
            }
            if (options.isEmpty() && optionValues.isEmpty()) {
                out.add(s, (Completer)new ArgumentCompleter(new Completer[]{new StringsCompleter(new String[]{s}), NullCompleter.INSTANCE}));
                continue;
            }
            out.add(s, (Completer)new ArgumentCompleter(new Completer[]{new StringsCompleter(new String[]{s}), new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, optionValues, options, 1)}));
        }
        return out;
    }

    public Widgets.CmdDesc commandDescription(String command) {
        CommandLine.Model.CommandSpec spec = ((CommandLine)this.cmd.getSubcommands().get(command)).getCommandSpec();
        CommandLine.Help cmdhelp = new CommandLine.Help((Object)spec);
        ArrayList<AttributedString> main = new ArrayList<AttributedString>();
        HashMap options = new HashMap();
        String synopsis = AttributedString.stripAnsi((String)((CommandLine.IHelpSectionRenderer)spec.usageMessage().sectionMap().get("synopsis")).render(cmdhelp).toString());
        main.add(Options.HelpException.highlightSyntax((String)synopsis.trim(), (StyleResolver)Options.HelpException.defaultStyle()));
        for (CommandLine.Model.OptionSpec o : spec.options()) {
            String key = Arrays.stream(o.names()).collect(Collectors.joining(" "));
            ArrayList<AttributedString> val = new ArrayList<AttributedString>();
            for (String d : o.description()) {
                val.add(new AttributedString((CharSequence)d));
            }
            if (val.isEmpty()) {
                val.add(new AttributedString((CharSequence)""));
            }
            if (o.arity().max() > 0 && key.matches(".*[a-zA-Z]{2,}$")) {
                key = key + "=" + o.paramLabel();
            }
            options.put(key, val);
        }
        return new Widgets.CmdDesc(main, Widgets.ArgDesc.doArgNames(Arrays.asList("")), options);
    }
}

