/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.aggregation;

import info.debatty.java.aggregation.AggregatorInterface;
import info.debatty.java.aggregation.InterpolationFunctions;
import info.debatty.java.aggregation.Vector;

public class WOWA
implements AggregatorInterface {
    private final Vector weights;
    private final Vector ordered_weights;

    public WOWA(double[] weights, double[] ordered_weights) {
        double threshold = 1.0E-10;
        if (weights.length != ordered_weights.length) {
            throw new IllegalArgumentException("Weights arrays have different size");
        }
        for (int i = 0; i < weights.length; ++i) {
            if (!(weights[i] < 0.0 || weights[i] > 1.0 || ordered_weights[i] < 0.0) && !(ordered_weights[i] > 1.0)) continue;
            throw new IllegalArgumentException("Weights must be between 0 and 1");
        }
        if (Math.abs(this.arraySum(weights) - 1.0) > threshold || Math.abs(this.arraySum(ordered_weights) - 1.0) > threshold) {
            throw new IllegalArgumentException("Sum of a weights vector must be equal to 1");
        }
        this.weights = new Vector(weights);
        this.ordered_weights = new Vector(ordered_weights);
    }

    @Override
    public final double aggregate(double[] values) {
        if (values.length != this.weights.size()) {
            throw new IllegalArgumentException("Data array size must be equal to weights arrays size");
        }
        for (double v : values) {
            if (!(v < 0.0) && !(v > 1.0)) continue;
            throw new IllegalArgumentException("Data values must be between 0 and 1");
        }
        int size = this.weights.size();
        Vector values_vector = new Vector(values);
        values_vector.sort(this.ordered_weights);
        Vector omega = new Vector(size);
        InterpolationFunctions interpolations = this.weights.getInterpolationFunctions();
        omega.set(0, interpolations.eval(this.ordered_weights.get(0)));
        double acc = this.ordered_weights.get(0);
        for (int i = 2; i <= size; ++i) {
            double temp = acc;
            omega.set(i - 1, interpolations.eval(acc += this.ordered_weights.get(i - 1)) - interpolations.eval(temp));
        }
        return values_vector.dotProduct(omega);
    }

    protected final double arraySum(double[] values) {
        double sum = 0.0;
        for (double el : values) {
            sum += el;
        }
        return sum;
    }
}

