/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.aggregation;

import info.debatty.java.aggregation.AggregatorInterface;
import info.debatty.java.aggregation.Vector;

public class OWA
implements AggregatorInterface {
    private final Vector weights;

    public OWA(double[] weights) {
        double threshold = 1.0E-10;
        if (Math.abs(this.arraySum(weights) - 1.0) > threshold) {
            throw new IllegalArgumentException("Sum of weights must be equal to 1");
        }
        for (double el : weights) {
            if (!(el < 0.0) && !(el > 1.0)) continue;
            throw new IllegalArgumentException("Weights must be between 0 and 1");
        }
        this.weights = new Vector(weights);
    }

    @Override
    public final double aggregate(double[] values) {
        if (values.length != this.weights.size()) {
            throw new IllegalArgumentException("Data array size must be equal to weights arrays size");
        }
        for (double v : values) {
            if (!(v < 0.0) && !(v > 1.0)) continue;
            throw new IllegalArgumentException("Data values must be between 0 and 1");
        }
        Vector values_vector = new Vector(values);
        return values_vector.sort().dotProduct(this.weights);
    }

    protected final double arraySum(double[] values) {
        double sum = 0.0;
        for (double el : values) {
            sum += el;
        }
        return sum;
    }
}

