/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.aggregation;

import info.debatty.java.aggregation.Point;

final class Line {
    double a = 0.0;
    double b = 0.0;

    Line(double a, double b) {
        this.a = a;
        this.b = b;
    }

    public static Line fromPoints(Point p0, Point p1) {
        if (p0.x == p1.x) {
            throw new ArithmeticException("Division by 0! p0.x=" + p0.x + " p1.x=" + p1.x);
        }
        double a = (p0.y - p1.y) / (p0.x - p1.x);
        double b = (p1.x * p0.y - p0.x * p1.y) / (p1.x - p0.x);
        return new Line(a, b);
    }

    public double eval(double x) {
        return this.a * x + this.b;
    }
}

