/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Extension;
import org.hl7.fhir.ImagingObjectSelectionFrame;
import org.hl7.fhir.Oid;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ImagingObjectSelection.Instance", propOrder={"sopClass", "uid", "url", "frame"})
public class ImagingObjectSelectionInstance
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Oid sopClass;
    @XmlElement(required=true)
    protected Oid uid;
    @XmlElement(required=true)
    protected Uri url;
    protected List<ImagingObjectSelectionFrame> frame;

    public Oid getSopClass() {
        return this.sopClass;
    }

    public void setSopClass(Oid value) {
        this.sopClass = value;
    }

    public Oid getUid() {
        return this.uid;
    }

    public void setUid(Oid value) {
        this.uid = value;
    }

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public List<ImagingObjectSelectionFrame> getFrame() {
        if (this.frame == null) {
            this.frame = new ArrayList<ImagingObjectSelectionFrame>();
        }
        return this.frame;
    }

    public ImagingObjectSelectionInstance withSopClass(Oid value) {
        this.setSopClass(value);
        return this;
    }

    public ImagingObjectSelectionInstance withUid(Oid value) {
        this.setUid(value);
        return this;
    }

    public ImagingObjectSelectionInstance withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public ImagingObjectSelectionInstance withFrame(ImagingObjectSelectionFrame ... values) {
        if (values != null) {
            for (ImagingObjectSelectionFrame value : values) {
                this.getFrame().add(value);
            }
        }
        return this;
    }

    public ImagingObjectSelectionInstance withFrame(Collection<ImagingObjectSelectionFrame> values) {
        if (values != null) {
            this.getFrame().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ImagingObjectSelectionInstance that = (ImagingObjectSelectionInstance)object;
        Oid lhsSopClass = this.getSopClass();
        Oid rhsSopClass = that.getSopClass();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"sopClass", (Object)lhsSopClass), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"sopClass", (Object)rhsSopClass), (Object)lhsSopClass, (Object)rhsSopClass, this.sopClass != null, that.sopClass != null)) {
            return false;
        }
        Oid lhsUid = this.getUid();
        Oid rhsUid = that.getUid();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"uid", (Object)lhsUid), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"uid", (Object)rhsUid), (Object)lhsUid, (Object)rhsUid, this.uid != null, that.uid != null)) {
            return false;
        }
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"url", (Object)lhsUrl), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"url", (Object)rhsUrl), (Object)lhsUrl, (Object)rhsUrl, this.url != null, that.url != null)) {
            return false;
        }
        List<ImagingObjectSelectionFrame> lhsFrame = this.frame != null && !this.frame.isEmpty() ? this.getFrame() : null;
        List<ImagingObjectSelectionFrame> rhsFrame = that.frame != null && !that.frame.isEmpty() ? that.getFrame() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"frame", lhsFrame), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"frame", rhsFrame), lhsFrame, rhsFrame, this.frame != null && !this.frame.isEmpty(), that.frame != null && !that.frame.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Oid theSopClass = this.getSopClass();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"sopClass", (Object)theSopClass), currentHashCode, (Object)theSopClass, this.sopClass != null);
        Oid theUid = this.getUid();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"uid", (Object)theUid), currentHashCode, (Object)theUid, this.uid != null);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"url", (Object)theUrl), currentHashCode, (Object)theUrl, this.url != null);
        List<ImagingObjectSelectionFrame> theFrame = this.frame != null && !this.frame.isEmpty() ? this.getFrame() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"frame", theFrame), currentHashCode, theFrame, this.frame != null && !this.frame.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Oid theSopClass = this.getSopClass();
        strategy.appendField(locator, (Object)this, "sopClass", buffer, (Object)theSopClass, this.sopClass != null);
        Oid theUid = this.getUid();
        strategy.appendField(locator, (Object)this, "uid", buffer, (Object)theUid, this.uid != null);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, (Object)theUrl, this.url != null);
        List<ImagingObjectSelectionFrame> theFrame = this.frame != null && !this.frame.isEmpty() ? this.getFrame() : null;
        strategy.appendField(locator, (Object)this, "frame", buffer, theFrame, this.frame != null && !this.frame.isEmpty());
        return buffer;
    }

    public void setFrame(List<ImagingObjectSelectionFrame> value) {
        this.frame = value;
    }
}

