/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.TemporalHelper;
import org.opencds.cqf.cql.engine.runtime.Time;

public class SubtractEvaluator {
    public static Object subtract(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Integer) {
            return (Integer)left - (Integer)right;
        }
        if (left instanceof Long) {
            return (Long)left - (Long)right;
        }
        if (left instanceof BigDecimal) {
            return ((BigDecimal)left).subtract((BigDecimal)right);
        }
        if (left instanceof Quantity) {
            return new Quantity().withValue(((Quantity)left).getValue().subtract(((Quantity)right).getValue())).withUnit(((Quantity)left).getUnit());
        }
        if (left instanceof BaseTemporal && right instanceof Quantity) {
            Precision valueToSubtractPrecision = Precision.fromString(((Quantity)right).getUnit());
            Precision precision = Precision.fromString(BaseTemporal.getLowestPrecision((BaseTemporal)left));
            int valueToSubtract = ((Quantity)right).getValue().intValue();
            if ((left instanceof DateTime || left instanceof Date) && valueToSubtractPrecision == Precision.WEEK) {
                valueToSubtract = TemporalHelper.weeksToDays(valueToSubtract);
                valueToSubtractPrecision = Precision.DAY;
            }
            long convertedValueToSubtract = valueToSubtract;
            if (precision.toDateTimeIndex() < valueToSubtractPrecision.toDateTimeIndex()) {
                convertedValueToSubtract = TemporalHelper.truncateValueToTargetPrecision(valueToSubtract, valueToSubtractPrecision, precision);
                valueToSubtractPrecision = precision;
            }
            if (left instanceof DateTime) {
                return new DateTime(((DateTime)left).getDateTime().minus(convertedValueToSubtract, valueToSubtractPrecision.toChronoUnit()), precision);
            }
            if (left instanceof Date) {
                return new Date(((Date)left).getDate().minus(convertedValueToSubtract, valueToSubtractPrecision.toChronoUnit())).setPrecision(precision);
            }
            return new Time(((Time)left).getTime().minus(convertedValueToSubtract, valueToSubtractPrecision.toChronoUnit()), precision);
        }
        if (left instanceof Interval && right instanceof Interval) {
            Interval leftInterval = (Interval)left;
            Interval rightInterval = (Interval)right;
            return new Interval(SubtractEvaluator.subtract(leftInterval.getStart(), rightInterval.getStart()), true, SubtractEvaluator.subtract(leftInterval.getEnd(), rightInterval.getEnd()), true);
        }
        throw new InvalidOperatorArgument("Subtract(Integer, Integer), Subtract(Long, Long) Subtract(Decimal, Decimal), Subtract(Quantity, Quantity), Subtract(Date, Quantity), Subtract(DateTime, Quantity), Subtract(Time, Quantity)", String.format("Subtract(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }
}

