/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements;

import org.cqframework.cql.elm.requirements.ElmDataRequirement;
import org.cqframework.cql.elm.requirements.ElmExpressionRequirement;
import org.cqframework.cql.elm.requirements.ElmPropertyRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirement;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.LetClause;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.VersionedIdentifier;

public class ElmQueryLetContext {
    private VersionedIdentifier libraryIdentifier;
    private LetClause letClause;
    private ElmDataRequirement requirements;

    public ElmQueryLetContext(VersionedIdentifier libraryIdentifier, LetClause letClause) {
        if (libraryIdentifier == null) {
            throw new IllegalArgumentException("libraryIdentifier is required");
        }
        if (letClause == null) {
            throw new IllegalArgumentException("letClause is required");
        }
        this.libraryIdentifier = libraryIdentifier;
        this.letClause = letClause;
    }

    public LetClause getLetClause() {
        return this.letClause;
    }

    public String getIdentifier() {
        return this.letClause.getIdentifier();
    }

    public ElmDataRequirement getRequirements() {
        return this.requirements;
    }

    public void setRequirements(ElmRequirement requirements) {
        this.requirements = requirements instanceof ElmDataRequirement ? (ElmDataRequirement)requirements : (requirements instanceof ElmExpressionRequirement ? ElmDataRequirement.inferFrom((ElmExpressionRequirement)requirements) : new ElmDataRequirement(this.libraryIdentifier, new Retrieve()));
        this.requirements.setQuerySource((Element)this.getLetClause());
    }

    public void reportProperty(ElmPropertyRequirement propertyRequirement) {
        this.requirements.reportProperty(propertyRequirement);
    }
}

