/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements;

import org.cqframework.cql.elm.requirements.ElmDataRequirement;
import org.cqframework.cql.elm.requirements.ElmExpressionRequirement;
import org.cqframework.cql.elm.requirements.ElmPropertyRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirement;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.VersionedIdentifier;

public class ElmQueryAliasContext {
    private VersionedIdentifier libraryIdentifier;
    private AliasedQuerySource querySource;
    private ElmDataRequirement requirements;

    public ElmQueryAliasContext(VersionedIdentifier libraryIdentifier, AliasedQuerySource querySource) {
        if (libraryIdentifier == null) {
            throw new IllegalArgumentException("libraryIdentifier is required");
        }
        if (querySource == null) {
            throw new IllegalArgumentException("querySource is required");
        }
        this.libraryIdentifier = libraryIdentifier;
        this.querySource = querySource;
    }

    public AliasedQuerySource getQuerySource() {
        return this.querySource;
    }

    public String getAlias() {
        return this.querySource.getAlias();
    }

    public ElmDataRequirement getRequirements() {
        return this.requirements;
    }

    public void setRequirements(ElmRequirement requirements) {
        this.requirements = requirements instanceof ElmDataRequirement ? (ElmDataRequirement)requirements : (requirements instanceof ElmExpressionRequirement ? ElmDataRequirement.inferFrom((ElmExpressionRequirement)requirements) : new ElmDataRequirement(this.libraryIdentifier, new Retrieve()));
        this.requirements.setQuerySource((Element)this.getQuerySource());
    }

    public void reportProperty(ElmPropertyRequirement propertyRequirement) {
        this.requirements.reportProperty(propertyRequirement);
    }
}

