/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.Model;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.Signature;
import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.ClassType;
import org.hl7.cql.model.ClassTypeElement;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.GenericClassSignatureParser;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.ModelContext;
import org.hl7.cql.model.ModelIdentifier;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.cql.model.ProfileType;
import org.hl7.cql.model.Relationship;
import org.hl7.cql.model.SearchType;
import org.hl7.cql.model.SimpleType;
import org.hl7.cql.model.TupleType;
import org.hl7.cql.model.TupleTypeElement;
import org.hl7.cql.model.TypeParameter;
import org.hl7.elm_modelinfo.r1.BoundParameterTypeSpecifier;
import org.hl7.elm_modelinfo.r1.ChoiceTypeInfo;
import org.hl7.elm_modelinfo.r1.ChoiceTypeSpecifier;
import org.hl7.elm_modelinfo.r1.ClassInfo;
import org.hl7.elm_modelinfo.r1.ClassInfoElement;
import org.hl7.elm_modelinfo.r1.ConversionInfo;
import org.hl7.elm_modelinfo.r1.IntervalTypeInfo;
import org.hl7.elm_modelinfo.r1.IntervalTypeSpecifier;
import org.hl7.elm_modelinfo.r1.ListTypeInfo;
import org.hl7.elm_modelinfo.r1.ListTypeSpecifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;
import org.hl7.elm_modelinfo.r1.ModelSpecifier;
import org.hl7.elm_modelinfo.r1.NamedTypeSpecifier;
import org.hl7.elm_modelinfo.r1.ParameterTypeSpecifier;
import org.hl7.elm_modelinfo.r1.ProfileInfo;
import org.hl7.elm_modelinfo.r1.RelationshipInfo;
import org.hl7.elm_modelinfo.r1.SearchInfo;
import org.hl7.elm_modelinfo.r1.SimpleTypeInfo;
import org.hl7.elm_modelinfo.r1.TupleTypeInfo;
import org.hl7.elm_modelinfo.r1.TupleTypeInfoElement;
import org.hl7.elm_modelinfo.r1.TupleTypeSpecifier;
import org.hl7.elm_modelinfo.r1.TupleTypeSpecifierElement;
import org.hl7.elm_modelinfo.r1.TypeInfo;
import org.hl7.elm_modelinfo.r1.TypeParameterInfo;
import org.hl7.elm_modelinfo.r1.TypeSpecifier;

public class ModelImporter {
    private ModelInfo modelInfo;
    private ModelManager modelManager;
    private Map<String, Model> modelIndex;
    private Map<String, TypeInfo> typeInfoIndex;
    private Map<String, DataType> resolvedTypes;
    private List<DataType> dataTypes;
    private List<Conversion> conversions;
    private List<ModelContext> contexts;
    private ModelContext defaultContext;

    public ModelImporter(ModelInfo modelInfo, ModelManager modelManager) {
        DataType contextType;
        if (modelInfo == null) {
            throw new IllegalArgumentException("modelInfo is null");
        }
        this.modelInfo = modelInfo;
        this.modelManager = modelManager;
        this.modelIndex = new HashMap<String, Model>();
        this.typeInfoIndex = new HashMap<String, TypeInfo>();
        this.resolvedTypes = new HashMap<String, DataType>();
        this.dataTypes = new ArrayList<DataType>();
        this.conversions = new ArrayList<Conversion>();
        this.contexts = new ArrayList<ModelContext>();
        if (modelManager != null) {
            Iterator systemModel;
            for (ModelSpecifier requiredModel : modelInfo.getRequiredModelInfo()) {
                Model model = modelManager.resolveModel(new ModelIdentifier().withSystem(NamespaceManager.getUriPart((String)requiredModel.getUrl())).withId(requiredModel.getName()).withVersion(requiredModel.getVersion()));
                if (model == null) continue;
                this.modelIndex.put(requiredModel.getName(), model);
            }
            if (!this.modelIndex.containsKey("System") && (systemModel = modelManager.resolveModel(new ModelIdentifier().withId("System"))) != null) {
                this.modelIndex.put("System", (Model)((Object)systemModel));
            }
        }
        for (TypeInfo t : this.modelInfo.getTypeInfo()) {
            ClassInfo classInfo;
            if (t instanceof SimpleTypeInfo) {
                this.typeInfoIndex.put(this.ensureUnqualified(((SimpleTypeInfo)t).getName()), t);
                continue;
            }
            if (!(t instanceof ClassInfo) || (classInfo = (ClassInfo)t).getName() == null) continue;
            this.typeInfoIndex.put(this.ensureUnqualified(classInfo.getName()), (TypeInfo)classInfo);
        }
        for (ConversionInfo c : this.modelInfo.getConversionInfo()) {
            DataType fromType = this.resolveTypeNameOrSpecifier(c.getFromType(), c.getFromTypeSpecifier());
            DataType toType = this.resolveTypeNameOrSpecifier(c.getToType(), c.getToTypeSpecifier());
            int qualifierIndex = c.getFunctionName().indexOf(46);
            String libraryName = qualifierIndex >= 0 ? c.getFunctionName().substring(0, qualifierIndex) : null;
            String functionName = qualifierIndex >= 0 ? c.getFunctionName().substring(qualifierIndex + 1) : null;
            Operator operator = new Operator(functionName, new Signature(fromType), toType);
            if (libraryName != null) {
                operator.setLibraryName(libraryName);
            }
            Conversion conversion = new Conversion(operator, true);
            this.conversions.add(conversion);
        }
        for (ConversionInfo c : this.modelInfo.getContextInfo()) {
            DataType contextType2 = this.resolveTypeSpecifier((TypeSpecifier)c.getContextType());
            if (!(contextType2 instanceof ClassType)) {
                throw new IllegalArgumentException(String.format("Model context %s must be a class type.", c.getName()));
            }
            ModelContext modelContext = new ModelContext(c.getName(), (ClassType)contextType2, Arrays.asList(c.getKeyElement().split(";")), c.getBirthDateElement());
            this.contexts.add(modelContext);
        }
        if (this.contexts.size() == 0 && this.modelInfo.getPatientClassName() != null && (contextType = this.resolveTypeName(this.modelInfo.getPatientClassName())) instanceof ClassType) {
            ModelContext modelContext = new ModelContext(((ClassType)contextType).getSimpleName(), (ClassType)contextType, Arrays.asList("id"), this.modelInfo.getPatientBirthDatePropertyName());
            this.contexts.add(modelContext);
            this.defaultContext = modelContext;
        }
        for (TypeInfo t : this.modelInfo.getTypeInfo()) {
            DataType type = this.resolveTypeInfo(t);
            this.dataTypes.add(type);
            if (!(t instanceof ClassInfo)) continue;
            this.importRelationships((ClassInfo)t, (ClassType)type);
        }
    }

    public Map<String, DataType> getTypes() {
        return this.resolvedTypes;
    }

    public Iterable<Conversion> getConversions() {
        return this.conversions;
    }

    public Iterable<ModelContext> getContexts() {
        return this.contexts;
    }

    public String getDefaultContextName() {
        if (this.modelInfo.getDefaultContext() != null) {
            return this.modelInfo.getDefaultContext();
        }
        if (this.defaultContext != null) {
            return this.defaultContext.getName();
        }
        return null;
    }

    private String casify(String typeName) {
        return this.casify(typeName, this.modelInfo.isCaseSensitive() != null ? this.modelInfo.isCaseSensitive() : false);
    }

    private String casify(String typeName, boolean caseSensitive) {
        return caseSensitive ? typeName.toLowerCase() : typeName;
    }

    private DataType resolveTypeInfo(TypeInfo t) {
        if (t instanceof SimpleTypeInfo) {
            return this.resolveSimpleType((SimpleTypeInfo)t);
        }
        if (t instanceof ClassInfo) {
            return this.resolveClassType((ClassInfo)t);
        }
        if (t instanceof TupleTypeInfo) {
            return this.resolveTupleType((TupleTypeInfo)t);
        }
        if (t instanceof IntervalTypeInfo) {
            return this.resolveIntervalType((IntervalTypeInfo)t);
        }
        if (t instanceof ListTypeInfo) {
            return this.resolveListType((ListTypeInfo)t);
        }
        if (t instanceof ChoiceTypeInfo) {
            return this.resolveChoiceType((ChoiceTypeInfo)t);
        }
        return null;
    }

    private DataType resolveTypeSpecifier(TypeSpecifier typeSpecifier) {
        ListTypeSpecifier listTypeSpecifier;
        DataType elementType;
        if (typeSpecifier == null) {
            return null;
        }
        if (typeSpecifier instanceof NamedTypeSpecifier) {
            NamedTypeSpecifier namedTypeSpecifier = (NamedTypeSpecifier)typeSpecifier;
            String qualifier = namedTypeSpecifier.getNamespace();
            if (qualifier == null || qualifier.isEmpty()) {
                qualifier = namedTypeSpecifier.getModelName();
            }
            if (qualifier == null || qualifier.isEmpty()) {
                qualifier = this.modelInfo.getName();
            }
            String qualifiedTypeName = String.format("%s.%s", qualifier, namedTypeSpecifier.getName());
            return this.resolveTypeName(qualifiedTypeName);
        }
        if (typeSpecifier instanceof IntervalTypeSpecifier) {
            IntervalTypeSpecifier intervalTypeSpecifier = (IntervalTypeSpecifier)typeSpecifier;
            DataType pointType = this.resolveTypeNameOrSpecifier(intervalTypeSpecifier.getPointType(), intervalTypeSpecifier.getPointTypeSpecifier());
            return new IntervalType(pointType);
        }
        if (typeSpecifier instanceof ListTypeSpecifier && (elementType = this.resolveTypeNameOrSpecifier((listTypeSpecifier = (ListTypeSpecifier)typeSpecifier).getElementType(), listTypeSpecifier.getElementTypeSpecifier())) != null) {
            return new ListType(elementType);
        }
        if (typeSpecifier instanceof TupleTypeSpecifier) {
            TupleTypeSpecifier tupleTypeSpecifier = (TupleTypeSpecifier)typeSpecifier;
            TupleType tupleType = new TupleType();
            for (TupleTypeSpecifierElement specifierElement : tupleTypeSpecifier.getElement()) {
                TupleTypeElement element = new TupleTypeElement(specifierElement.getName(), this.resolveTypeSpecifier(specifierElement.getElementType()));
                tupleType.addElement(element);
            }
        }
        if (typeSpecifier instanceof ChoiceTypeSpecifier) {
            ChoiceTypeSpecifier choiceTypeSpecifier = (ChoiceTypeSpecifier)typeSpecifier;
            ArrayList<DataType> choices = new ArrayList<DataType>();
            for (TypeSpecifier choice : choiceTypeSpecifier.getChoice()) {
                DataType choiceType = this.resolveTypeSpecifier(choice);
                choices.add(choiceType);
            }
            return new ChoiceType(choices);
        }
        return null;
    }

    private DataType resolveTypeName(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName is null");
        }
        if (typeName.toLowerCase().startsWith("interval<")) {
            DataType pointType = this.resolveTypeName(typeName.substring(typeName.indexOf(60) + 1, typeName.lastIndexOf(62)));
            return new IntervalType(pointType);
        }
        if (typeName.toLowerCase().startsWith("list<")) {
            DataType elementType = this.resolveTypeName(typeName.substring(typeName.indexOf(60) + 1, typeName.lastIndexOf(62)));
            return new ListType(elementType);
        }
        DataType result = this.lookupType(typeName);
        if (result == null) {
            TypeInfo typeInfo = this.lookupTypeInfo(this.ensureUnqualified(typeName));
            if (typeInfo == null) {
                throw new IllegalArgumentException(String.format("Could not resolve type info for type name %s.", typeName));
            }
            result = this.resolveTypeInfo(typeInfo);
        }
        return result;
    }

    private DataType resolveTypeNameOrSpecifier(String typeName, TypeSpecifier typeSpecifier) {
        if ((typeName == null || typeName.isEmpty()) && typeSpecifier == null) {
            return null;
        }
        if (typeSpecifier != null) {
            return this.resolveTypeSpecifier(typeSpecifier);
        }
        return this.resolveTypeName(typeName);
    }

    private DataType lookupType(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName is null");
        }
        DataType resolvedType = this.resolvedTypes.get(this.casify(typeName));
        if (resolvedType != null) {
            return resolvedType;
        }
        int qualifierIndex = typeName.indexOf(".");
        if (qualifierIndex < 0) {
            return null;
        }
        String qualifier = typeName.substring(0, qualifierIndex);
        if (qualifier.equals("")) {
            return null;
        }
        if (!qualifier.equals(this.modelInfo.getName())) {
            Model model = this.resolveModel(qualifier);
            if (model == null) {
                return null;
            }
            return model.resolveTypeName(typeName);
        }
        return null;
    }

    private Model resolveModel(String localIdentifier) {
        return this.modelIndex.get(localIdentifier);
    }

    private TypeInfo lookupTypeInfo(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName is null");
        }
        return this.typeInfoIndex.get(typeName);
    }

    private String ensureQualified(String name) {
        String qualifier = String.format("%s.", this.modelInfo.getName());
        if (!name.startsWith(qualifier)) {
            return String.format("%s%s", qualifier, name);
        }
        return name;
    }

    private String ensureUnqualified(String name) {
        if (name.startsWith(String.format("%s.", this.modelInfo.getName()))) {
            return name.substring(name.indexOf(46) + 1);
        }
        return name;
    }

    private SimpleType resolveSimpleType(SimpleTypeInfo t) {
        String qualifiedTypeName = this.ensureQualified(t.getName());
        DataType lookupType = this.lookupType(qualifiedTypeName);
        if (lookupType instanceof ClassType) {
            throw new IllegalArgumentException("Expected instance of SimpleType but found instance of ClassType instead.");
        }
        SimpleType result = (SimpleType)this.lookupType(qualifiedTypeName);
        if (result == null) {
            if (qualifiedTypeName.equals(DataType.ANY.getName())) {
                result = DataType.ANY;
            } else {
                result = new SimpleType(qualifiedTypeName, this.resolveTypeNameOrSpecifier(t.getBaseType(), t.getBaseTypeSpecifier()));
                result.setTarget(t.getTarget());
            }
            this.resolvedTypes.put(this.casify(result.getName()), (DataType)result);
        }
        return result;
    }

    private DataType resolveTypeNameOrSpecifier(TupleTypeInfoElement element) {
        DataType result = this.resolveTypeNameOrSpecifier(element.getElementType(), element.getElementTypeSpecifier());
        if (result == null) {
            result = this.resolveTypeNameOrSpecifier(element.getType(), element.getTypeSpecifier());
        }
        return result;
    }

    private Collection<TupleTypeElement> resolveTupleTypeElements(Collection<TupleTypeInfoElement> infoElements) {
        ArrayList<TupleTypeElement> elements = new ArrayList<TupleTypeElement>();
        for (TupleTypeInfoElement e : infoElements) {
            elements.add(new TupleTypeElement(e.getName(), this.resolveTypeNameOrSpecifier(e)));
        }
        return elements;
    }

    private TupleType resolveTupleType(TupleTypeInfo t) {
        TupleType result = new TupleType(this.resolveTupleTypeElements(t.getElement()));
        return result;
    }

    private DataType resolveTypeNameOrSpecifier(ClassInfoElement element) {
        DataType result = this.resolveTypeNameOrSpecifier(element.getElementType(), element.getElementTypeSpecifier());
        if (result == null) {
            result = this.resolveTypeNameOrSpecifier(element.getType(), element.getTypeSpecifier());
        }
        return result;
    }

    private List<TypeParameter> resolveGenericParameterDeclarations(List<TypeParameterInfo> parameterInfoList) {
        ArrayList<TypeParameter> genericParameters = new ArrayList<TypeParameter>();
        for (TypeParameterInfo parameterInfo : parameterInfoList) {
            String constraint = parameterInfo.getConstraint();
            TypeParameter.TypeParameterConstraint typeConstraint = null;
            if (constraint.equalsIgnoreCase(TypeParameter.TypeParameterConstraint.NONE.name())) {
                typeConstraint = TypeParameter.TypeParameterConstraint.NONE;
            } else if (constraint.equalsIgnoreCase(TypeParameter.TypeParameterConstraint.CLASS.name())) {
                typeConstraint = TypeParameter.TypeParameterConstraint.CLASS;
            } else if (constraint.equalsIgnoreCase(TypeParameter.TypeParameterConstraint.TUPLE.name())) {
                typeConstraint = TypeParameter.TypeParameterConstraint.TUPLE;
            } else if (constraint.equalsIgnoreCase(TypeParameter.TypeParameterConstraint.VALUE.name())) {
                typeConstraint = TypeParameter.TypeParameterConstraint.VALUE;
            } else if (constraint.equalsIgnoreCase(TypeParameter.TypeParameterConstraint.CHOICE.name())) {
                typeConstraint = TypeParameter.TypeParameterConstraint.CHOICE;
            } else if (constraint.equalsIgnoreCase(TypeParameter.TypeParameterConstraint.INTERVAL.name())) {
                typeConstraint = TypeParameter.TypeParameterConstraint.INTERVAL;
            } else if (constraint.equalsIgnoreCase(TypeParameter.TypeParameterConstraint.TYPE.name())) {
                typeConstraint = TypeParameter.TypeParameterConstraint.TYPE;
            }
            genericParameters.add(new TypeParameter(parameterInfo.getName(), typeConstraint, this.resolveTypeName(parameterInfo.getConstraintType())));
        }
        return genericParameters;
    }

    private Collection<ClassTypeElement> resolveClassTypeElements(ClassType classType, Collection<ClassInfoElement> infoElements) {
        ArrayList<ClassTypeElement> elements = new ArrayList<ClassTypeElement>();
        for (ClassInfoElement e : infoElements) {
            DataType elementType = null;
            elementType = this.isOpenType(e) ? this.resolveOpenType(classType, e) : (this.isBoundParameterType(e) ? this.resolveBoundType(classType, e) : this.resolveTypeNameOrSpecifier(e));
            if (elementType == null) {
                elementType = this.resolveTypeName("System.Any");
            }
            elements.add(new ClassTypeElement(e.getName(), elementType, e.isProhibited(), e.isOneBased(), e.getTarget()));
        }
        return elements;
    }

    private boolean isBoundParameterType(ClassInfoElement element) {
        return element.getElementTypeSpecifier() instanceof BoundParameterTypeSpecifier;
    }

    private DataType resolveBoundType(ClassType classType, ClassInfoElement e) {
        DataType boundType = null;
        BoundParameterTypeSpecifier boundParameterTypeSpecifier = (BoundParameterTypeSpecifier)e.getElementTypeSpecifier();
        String parameterName = boundParameterTypeSpecifier.getParameterName();
        TypeParameter genericParameter = classType.getGenericParameterByIdentifier(parameterName);
        if (genericParameter == null) {
            throw new RuntimeException("Unknown symbol " + parameterName);
        }
        boundType = this.resolveTypeName(boundParameterTypeSpecifier.getBoundType());
        return boundType;
    }

    private boolean isOpenType(ClassInfoElement element) {
        return element.getElementTypeSpecifier() instanceof ParameterTypeSpecifier;
    }

    private DataType resolveOpenType(ClassType classType, ClassInfoElement e) {
        ParameterTypeSpecifier parameterTypeSpecifier = (ParameterTypeSpecifier)e.getElementTypeSpecifier();
        String parameterName = parameterTypeSpecifier.getParameterName();
        if (parameterName == null || parameterName.trim().length() == 0 || classType.getGenericParameterByIdentifier(parameterName) == null) {
            throw new RuntimeException("Open types must reference a valid generic parameter and cannot be null or blank");
        }
        TypeParameter elementType = new TypeParameter(parameterTypeSpecifier.getParameterName(), TypeParameter.TypeParameterConstraint.TYPE, null);
        return elementType;
    }

    private SearchType resolveClassTypeSearch(ClassType t, SearchInfo s) {
        return new SearchType(s.getName(), s.getPath(), this.resolveTypeNameOrSpecifier(s.getType(), s.getTypeSpecifier()));
    }

    private ClassType resolveClassType(ClassInfo t) {
        if (t.getName() == null) {
            throw new IllegalArgumentException("Class definition must have a name.");
        }
        String qualifiedName = this.ensureQualified(t.getName());
        Object result = (ClassType)this.lookupType(qualifiedName);
        if (result == null) {
            result = t instanceof ProfileInfo ? new ProfileType(qualifiedName, this.resolveTypeNameOrSpecifier(t.getBaseType(), t.getBaseTypeSpecifier())) : (t.getName().contains("<") ? this.handleGenericType(t.getName(), t.getBaseType()) : (t.getBaseType() != null && t.getBaseType().contains("<") ? this.handleGenericType(t.getName(), t.getBaseType()) : new ClassType(qualifiedName, this.resolveTypeNameOrSpecifier(t.getBaseType(), t.getBaseTypeSpecifier()))));
            this.resolvedTypes.put(this.casify(result.getName()), (DataType)result);
            if (t.getParameter() != null) {
                result.addGenericParameter(this.resolveGenericParameterDeclarations(t.getParameter()));
            }
            if (t.getElement() != null) {
                result.addElements(this.resolveClassTypeElements((ClassType)result, t.getElement()));
            }
            if (t.getSearch() != null) {
                for (SearchInfo si : t.getSearch()) {
                    result.addSearch(this.resolveClassTypeSearch((ClassType)result, si));
                }
            }
            if (this.isParentGeneric((ClassType)result) && !t.getBaseType().contains("<")) {
                this.validateFreeAndBoundParameters((ClassType)result, t);
            }
            result.setIdentifier(t.getIdentifier());
            result.setLabel(t.getLabel());
            result.setTarget(t.getTarget());
            result.setRetrievable(t.isRetrievable());
            result.setPrimaryCodePath(t.getPrimaryCodePath());
        }
        return result;
    }

    private ModelContext resolveContext(String contextName) {
        for (ModelContext context : this.contexts) {
            if (!context.getName().equals(contextName)) continue;
            return context;
        }
        throw new IllegalArgumentException(String.format("Could not resolve context name %s.", contextName));
    }

    private Relationship resolveRelationship(RelationshipInfo relationshipInfo) {
        ModelContext modelContext = this.resolveContext(relationshipInfo.getContext());
        Relationship relationship = new Relationship(modelContext, Arrays.asList(relationshipInfo.getRelatedKeyElement().split(";")));
        return relationship;
    }

    private void importRelationships(ClassInfo c, ClassType t) {
        for (RelationshipInfo r : c.getContextRelationship()) {
            t.addRelationship(this.resolveRelationship(r));
        }
        for (RelationshipInfo r : c.getTargetContextRelationship()) {
            t.addTargetRelationship(this.resolveRelationship(r));
        }
    }

    private IntervalType resolveIntervalType(IntervalTypeInfo t) {
        IntervalType result = new IntervalType(this.resolveTypeNameOrSpecifier(t.getPointType(), t.getPointTypeSpecifier()));
        return result;
    }

    private ListType resolveListType(ListTypeInfo t) {
        ListType result = new ListType(this.resolveTypeNameOrSpecifier(t.getElementType(), t.getElementTypeSpecifier()));
        return result;
    }

    private ChoiceType resolveChoiceType(ChoiceTypeInfo t) {
        ArrayList<DataType> types = new ArrayList<DataType>();
        if (t.getChoice() != null && t.getChoice().size() > 0) {
            for (TypeSpecifier typeSpecifier : t.getChoice()) {
                types.add(this.resolveTypeSpecifier(typeSpecifier));
            }
        } else {
            for (TypeSpecifier typeSpecifier : t.getType()) {
                types.add(this.resolveTypeSpecifier(typeSpecifier));
            }
        }
        return new ChoiceType(types);
    }

    public void validateFreeAndBoundParameters(ClassType type, ClassInfo definition) {
        ArrayList coveredParameters = new ArrayList();
        ArrayList boundParameters = new ArrayList();
        ((ClassType)type.getBaseType()).getGenericParameters().forEach(typeParameter -> {
            String parameterName = typeParameter.getIdentifier();
            if (type.getGenericParameterByIdentifier(parameterName, true) != null) {
                coveredParameters.add(parameterName);
            } else {
                boundParameters.add(parameterName);
            }
        });
        if (boundParameters.size() > 0) {
            if (definition.getElement() != null) {
                definition.getElement().forEach(classInfoElement -> {
                    String name;
                    int paramIndex;
                    if (classInfoElement.getElementTypeSpecifier() instanceof BoundParameterTypeSpecifier && (paramIndex = boundParameters.indexOf(name = ((BoundParameterTypeSpecifier)classInfoElement.getElementTypeSpecifier()).getParameterName())) >= 0) {
                        boundParameters.remove(paramIndex);
                    }
                });
                if (boundParameters.size() > 0) {
                    throw new RuntimeException("Unknown symbols " + String.valueOf(boundParameters));
                }
            } else {
                throw new RuntimeException("Unknown symbols " + String.valueOf(boundParameters));
            }
        }
    }

    public boolean isParentGeneric(ClassType type) {
        DataType baseType = type.getBaseType();
        return baseType != null && baseType instanceof ClassType && ((ClassType)baseType).isGeneric();
    }

    private ClassType handleGenericType(String genericSignature, String baseType) {
        if (genericSignature == null) {
            throw new IllegalArgumentException("genericSignature is null");
        }
        GenericClassSignatureParser parser = new GenericClassSignatureParser(genericSignature, baseType, null, this.resolvedTypes);
        ClassType genericClassType = parser.parseGenericSignature();
        return genericClassType;
    }

    private boolean conformsTo(DataType descendant, DataType ancestor) {
        boolean conforms = false;
        conforms = descendant != null && ancestor != null && descendant.equals(ancestor) ? true : this.conformsTo(descendant.getBaseType(), ancestor);
        return conforms;
    }
}

