/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.Objects;
import java.util.StringJoiner;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.TypeSpecifier;

public class FunctionHeader {
    private final FunctionDef functionDef;
    private final TypeSpecifier resultType;
    private boolean isCompiled = false;

    public FunctionDef getFunctionDef() {
        return this.functionDef;
    }

    public TypeSpecifier getResultType() {
        return this.resultType;
    }

    public static FunctionHeader noReturnType(FunctionDef functionDef) {
        return new FunctionHeader(functionDef, null);
    }

    public static FunctionHeader withReturnType(FunctionDef functionDef, TypeSpecifier resultType) {
        return new FunctionHeader(functionDef, resultType);
    }

    private FunctionHeader(FunctionDef functionDef, TypeSpecifier resultType) {
        this.functionDef = functionDef;
        this.resultType = resultType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FunctionHeader that = (FunctionHeader)other;
        return Objects.equals(this.functionDef, that.functionDef) && Objects.equals(this.resultType, that.resultType);
    }

    public int hashCode() {
        return Objects.hash(this.functionDef, this.resultType);
    }

    public String toString() {
        return new StringJoiner(", ", FunctionHeader.class.getSimpleName() + "[", "]").add("functionDef=" + String.valueOf(this.functionDef)).add("resultType=" + String.valueOf(this.resultType)).toString();
    }

    public String getMangledName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.functionDef.getName());
        sb.append("_");
        for (OperandDef od : this.functionDef.getOperand()) {
            sb.append(od.getOperandTypeSpecifier() != null ? od.getOperandTypeSpecifier().toString() : "void");
        }
        sb.append("_");
        return sb.toString();
    }

    public boolean getIsCompiled() {
        return this.isCompiled;
    }

    public void setIsCompiled() {
        this.isCompiled = true;
    }
}

