/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.cqframework.cql.cql2elm.CompilerOptions;
import org.cqframework.cql.cql2elm.CqlCompiler;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.CqlCompilerOptions;
import org.cqframework.cql.cql2elm.CqlIncludeException;
import org.cqframework.cql.cql2elm.LibraryContentType;
import org.cqframework.cql.cql2elm.LibrarySourceLoader;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.PriorityLibrarySourceLoader;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.cqframework.cql.elm.serializing.ElmLibraryReaderFactory;
import org.fhir.ucum.UcumEssenceService;
import org.fhir.ucum.UcumException;
import org.fhir.ucum.UcumService;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.VersionedIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryManager {
    private static final Logger logger = LoggerFactory.getLogger(LibraryManager.class);
    private final ModelManager modelManager;
    private final NamespaceManager namespaceManager;
    private final CqlCompilerOptions cqlCompilerOptions;
    private final Map<VersionedIdentifier, CompiledLibrary> compiledLibraries;
    private final LibrarySourceLoader librarySourceLoader;
    private UcumService ucumService;
    private static final LibraryContentType[] supportedContentTypes = new LibraryContentType[]{LibraryContentType.JSON, LibraryContentType.XML, LibraryContentType.CQL};

    public LibraryManager(ModelManager modelManager) {
        this(modelManager, CqlCompilerOptions.defaultOptions(), null);
    }

    public LibraryManager(ModelManager modelManager, CqlCompilerOptions cqlCompilerOptions) {
        this(modelManager, cqlCompilerOptions, null);
    }

    public LibraryManager(ModelManager modelManager, CqlCompilerOptions cqlCompilerOptions, Map<VersionedIdentifier, CompiledLibrary> libraryCache) {
        if (modelManager == null) {
            throw new IllegalArgumentException("modelManager is null");
        }
        this.modelManager = modelManager;
        this.cqlCompilerOptions = cqlCompilerOptions;
        this.namespaceManager = this.modelManager.getNamespaceManager() != null ? modelManager.getNamespaceManager() : new NamespaceManager();
        this.compiledLibraries = libraryCache != null ? libraryCache : new HashMap<VersionedIdentifier, CompiledLibrary>();
        this.librarySourceLoader = new PriorityLibrarySourceLoader();
    }

    public CqlCompilerOptions getCqlCompilerOptions() {
        return this.cqlCompilerOptions;
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public Map<VersionedIdentifier, CompiledLibrary> getCompiledLibraries() {
        return this.compiledLibraries;
    }

    public UcumService getUcumService() {
        if (this.ucumService == null) {
            this.ucumService = this.getDefaultUcumService();
        }
        return this.ucumService;
    }

    protected synchronized UcumService getDefaultUcumService() {
        try {
            return new UcumEssenceService(UcumEssenceService.class.getResourceAsStream("/ucum-essence.xml"));
        }
        catch (UcumException e) {
            logger.warn("Error creating shared UcumService", (Throwable)e);
            return null;
        }
    }

    public void setUcumService(UcumService ucumService) {
        this.ucumService = ucumService;
    }

    public LibrarySourceLoader getLibrarySourceLoader() {
        return this.librarySourceLoader;
    }

    public boolean isWellKnownLibraryName(String unqualifiedIdentifier) {
        if (unqualifiedIdentifier == null) {
            return false;
        }
        switch (unqualifiedIdentifier) {
            case "FHIRHelpers": {
                return true;
            }
        }
        return false;
    }

    public CompiledLibrary resolveLibrary(VersionedIdentifier libraryIdentifier, CacheMode cacheMode) {
        return this.resolveLibrary(libraryIdentifier, new ArrayList<CqlCompilerException>(), cacheMode);
    }

    public CompiledLibrary resolveLibrary(VersionedIdentifier libraryIdentifier) {
        return this.resolveLibrary(libraryIdentifier, new ArrayList<CqlCompilerException>(), CacheMode.READ_WRITE);
    }

    public boolean canResolveLibrary(VersionedIdentifier libraryIdentifier) {
        CompiledLibrary lib = this.resolveLibrary(libraryIdentifier);
        return lib != null;
    }

    public CompiledLibrary resolveLibrary(VersionedIdentifier libraryIdentifier, List<CqlCompilerException> errors) {
        return this.resolveLibrary(libraryIdentifier, errors, CacheMode.READ_WRITE);
    }

    public CompiledLibrary resolveLibrary(VersionedIdentifier libraryIdentifier, List<CqlCompilerException> errors, CacheMode cacheMode) {
        if (libraryIdentifier == null) {
            throw new IllegalArgumentException("libraryIdentifier is null.");
        }
        if (libraryIdentifier.getId() == null || libraryIdentifier.getId().equals("")) {
            throw new IllegalArgumentException("libraryIdentifier Id is null");
        }
        CompiledLibrary library = null;
        if (cacheMode != CacheMode.NONE && (library = this.compiledLibraries.get(libraryIdentifier)) != null) {
            return library;
        }
        library = this.compileLibrary(libraryIdentifier, errors);
        if (!CqlCompilerException.hasErrors(errors) && cacheMode == CacheMode.READ_WRITE) {
            this.compiledLibraries.put(libraryIdentifier, library);
        }
        return library;
    }

    private CompiledLibrary compileLibrary(VersionedIdentifier libraryIdentifier, List<CqlCompilerException> errors) {
        CompiledLibrary result = null;
        if (!this.cqlCompilerOptions.getEnableCqlOnly() && (result = this.tryCompiledLibraryElm(libraryIdentifier, this.cqlCompilerOptions)) != null) {
            this.sortStatements(result);
            return result;
        }
        String libraryPath = NamespaceManager.getPath((String)libraryIdentifier.getSystem(), (String)libraryIdentifier.getId());
        try {
            InputStream cqlSource = this.librarySourceLoader.getLibrarySource(libraryIdentifier);
            if (cqlSource == null) {
                throw new CqlIncludeException(String.format("Could not load source for library %s, version %s.", libraryIdentifier.getId(), libraryIdentifier.getVersion()), libraryIdentifier.getSystem(), libraryIdentifier.getId(), libraryIdentifier.getVersion());
            }
            CqlCompiler compiler = new CqlCompiler(this.namespaceManager.getNamespaceInfoFromUri(libraryIdentifier.getSystem()), libraryIdentifier, this);
            compiler.run(cqlSource);
            if (errors != null) {
                errors.addAll(compiler.getExceptions());
            }
            result = compiler.getCompiledLibrary();
            if (libraryIdentifier.getVersion() != null && !libraryIdentifier.getVersion().equals(result.getIdentifier().getVersion())) {
                throw new CqlIncludeException(String.format("Library %s was included as version %s, but version %s of the library was found.", libraryPath, libraryIdentifier.getVersion(), result.getIdentifier().getVersion()), libraryIdentifier.getSystem(), libraryIdentifier.getId(), libraryIdentifier.getVersion());
            }
        }
        catch (IOException e) {
            throw new CqlIncludeException(String.format("Errors occurred translating library %s, version %s.", libraryPath, libraryIdentifier.getVersion()), libraryIdentifier.getSystem(), libraryIdentifier.getId(), libraryIdentifier.getVersion(), e);
        }
        if (result == null) {
            throw new CqlIncludeException(String.format("Could not load source for library %s, version %s.", libraryPath, libraryIdentifier.getVersion()), libraryIdentifier.getSystem(), libraryIdentifier.getId(), libraryIdentifier.getVersion());
        }
        this.sortStatements(result);
        return result;
    }

    private void sortStatements(CompiledLibrary compiledLibrary) {
        if (compiledLibrary == null || compiledLibrary.getLibrary().getStatements() == null) {
            return;
        }
        compiledLibrary.getLibrary().getStatements().getDef().sort((a, b) -> a.getName().compareTo(b.getName()));
    }

    private CompiledLibrary tryCompiledLibraryElm(VersionedIdentifier libraryIdentifier, CqlCompilerOptions options) {
        InputStream elm = null;
        for (LibraryContentType type : supportedContentTypes) {
            if (LibraryContentType.CQL == type || (elm = this.librarySourceLoader.getLibraryContent(libraryIdentifier, type)) == null) continue;
            return this.generateCompiledLibraryFromElm(libraryIdentifier, elm, type, options);
        }
        return null;
    }

    private CompiledLibrary generateCompiledLibraryFromElm(VersionedIdentifier libraryIdentifier, InputStream librarySource, LibraryContentType type, CqlCompilerOptions options) {
        Library library = null;
        CompiledLibrary compiledLibrary = null;
        try {
            library = ElmLibraryReaderFactory.getReader((String)type.mimeType()).read((Reader)new InputStreamReader(librarySource));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (library != null && this.checkBinaryCompatibility(library)) {
            compiledLibrary = this.generateCompiledLibrary(library);
        }
        return compiledLibrary;
    }

    private CompiledLibrary generateCompiledLibrary(Library library) {
        CompiledLibrary compiledLibrary;
        boolean compilationSuccess;
        block21: {
            if (library == null) {
                return null;
            }
            compilationSuccess = true;
            compiledLibrary = new CompiledLibrary();
            try {
                if (library != null) {
                    compiledLibrary.setLibrary(library);
                }
                if (library.getIdentifier() != null) {
                    compiledLibrary.setIdentifier(library.getIdentifier());
                }
                if (library.getUsings() != null && library.getUsings().getDef() != null) {
                    for (UsingDef usingDef : library.getUsings().getDef()) {
                        compiledLibrary.add(usingDef);
                    }
                }
                if (library.getIncludes() != null && library.getIncludes().getDef() != null) {
                    for (IncludeDef includeDef : library.getIncludes().getDef()) {
                        compiledLibrary.add(includeDef);
                    }
                }
                if (library.getCodeSystems() != null && library.getCodeSystems().getDef() != null) {
                    for (CodeSystemDef codeSystemDef : library.getCodeSystems().getDef()) {
                        compiledLibrary.add(codeSystemDef);
                    }
                }
                for (ValueSetDef valueSetDef : library.getValueSets().getDef()) {
                    compiledLibrary.add(valueSetDef);
                }
                if (library.getCodes() != null && library.getCodes().getDef() != null) {
                    for (CodeDef codeDef : library.getCodes().getDef()) {
                        compiledLibrary.add(codeDef);
                    }
                }
                if (library.getConcepts() != null && library.getConcepts().getDef() != null) {
                    for (ConceptDef conceptDef : library.getConcepts().getDef()) {
                        compiledLibrary.add(conceptDef);
                    }
                }
                if (library.getParameters() != null && library.getParameters().getDef() != null) {
                    for (ParameterDef parameterDef : library.getParameters().getDef()) {
                        compiledLibrary.add(parameterDef);
                    }
                }
                if (library.getStatements() == null || library.getStatements().getDef() == null) break block21;
                for (ExpressionDef expressionDef : library.getStatements().getDef()) {
                    if (expressionDef.getResultType() != null) {
                        compiledLibrary.add(expressionDef);
                        continue;
                    }
                    compilationSuccess = false;
                    break;
                }
            }
            catch (Exception e) {
                compilationSuccess = false;
            }
        }
        if (compilationSuccess) {
            return compiledLibrary;
        }
        return null;
    }

    protected Boolean compilerOptionsMatch(Library library) {
        Set<CqlCompilerOptions.Options> compilerOptions = CompilerOptions.getCompilerOptions(library);
        if (compilerOptions == null) {
            return false;
        }
        return compilerOptions.equals(this.cqlCompilerOptions.getOptions());
    }

    private boolean checkBinaryCompatibility(Library library) {
        if (library == null) {
            return false;
        }
        return this.isSignatureCompatible(library) && this.isVersionCompatible(library) && this.compilerOptionsMatch(library) != false;
    }

    private boolean isSignatureCompatible(Library library) {
        return !this.hasOverloadedFunctions(library) || this.hasSignature(library);
    }

    private boolean hasOverloadedFunctions(Library library) {
        if (library == null || library.getStatements() == null) {
            return false;
        }
        HashSet<FunctionSig> functionNames = new HashSet<FunctionSig>();
        for (ExpressionDef ed : library.getStatements().getDef()) {
            if (!(ed instanceof FunctionDef)) continue;
            FunctionDef fd = (FunctionDef)ed;
            FunctionSig sig = new FunctionSig(fd.getName(), fd.getOperand() == null ? 0 : fd.getOperand().size());
            if (functionNames.contains(sig)) {
                return true;
            }
            functionNames.add(sig);
        }
        return false;
    }

    boolean hasSignature(Library library) {
        if (library != null && library.getStatements() != null) {
            for (ExpressionDef ed : library.getStatements().getDef()) {
                FunctionRef fr;
                if (!(ed.getExpression() instanceof FunctionRef) || (fr = (FunctionRef)ed.getExpression()).getSignature() == null || fr.getSignature().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVersionCompatible(Library library) {
        String version;
        if (!StringUtils.isEmpty((CharSequence)this.cqlCompilerOptions.getCompatibilityLevel()) && library.getAnnotation() != null && (version = CompilerOptions.getCompilerVersion(library)) != null) {
            return version.equals(this.cqlCompilerOptions.getCompatibilityLevel());
        }
        return false;
    }

    public static enum CacheMode {
        NONE,
        READ_ONLY,
        READ_WRITE;

    }

    static class FunctionSig {
        private final String name;
        private final int numArguments;

        public FunctionSig(String name, int numArguments) {
            this.name = name;
            this.numArguments = numArguments;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.numArguments;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FunctionSig other = (FunctionSig)obj;
            return other.name.equals(this.name) && other.numArguments == this.numArguments;
        }
    }
}

