/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.CqlSemanticException;
import org.cqframework.cql.cql2elm.DataTypes;
import org.cqframework.cql.cql2elm.LibraryBuilder;
import org.cqframework.cql.cql2elm.ResultWithPossibleError;
import org.cqframework.cql.cql2elm.SystemMethodResolver;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.FunctionHeader;
import org.cqframework.cql.cql2elm.model.Invocation;
import org.cqframework.cql.cql2elm.model.LibraryRef;
import org.cqframework.cql.cql2elm.model.Model;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.PropertyResolution;
import org.cqframework.cql.cql2elm.model.QueryContext;
import org.cqframework.cql.cql2elm.model.TimingOperatorContext;
import org.cqframework.cql.cql2elm.model.invocation.FunctionRefInvocation;
import org.cqframework.cql.cql2elm.model.invocation.InCodeSystemInvocation;
import org.cqframework.cql.cql2elm.model.invocation.InValueSetInvocation;
import org.cqframework.cql.cql2elm.model.invocation.LastInvocation;
import org.cqframework.cql.cql2elm.model.invocation.SplitInvocation;
import org.cqframework.cql.cql2elm.preprocessor.CqlPreprocessorElmCommonVisitor;
import org.cqframework.cql.cql2elm.preprocessor.ExpressionDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.FunctionDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.LibraryInfo;
import org.cqframework.cql.cql2elm.preprocessor.ParameterDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.UsingDefinitionInfo;
import org.cqframework.cql.elm.tracking.TrackBack;
import org.cqframework.cql.elm.tracking.Trackable;
import org.cqframework.cql.gen.cqlParser;
import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.ClassType;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.ModelContext;
import org.hl7.cql.model.ModelIdentifier;
import org.hl7.cql.model.NamedType;
import org.hl7.cql.model.NamespaceInfo;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.cql.model.TupleType;
import org.hl7.cql.model.TupleTypeElement;
import org.hl7.elm.r1.AccessModifier;
import org.hl7.elm.r1.Add;
import org.hl7.elm.r1.After;
import org.hl7.elm.r1.AggregateClause;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.And;
import org.hl7.elm.r1.AnyInCodeSystem;
import org.hl7.elm.r1.AnyInValueSet;
import org.hl7.elm.r1.As;
import org.hl7.elm.r1.Before;
import org.hl7.elm.r1.BinaryExpression;
import org.hl7.elm.r1.ByDirection;
import org.hl7.elm.r1.Case;
import org.hl7.elm.r1.CaseItem;
import org.hl7.elm.r1.Code;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeRef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.CodeSystemRef;
import org.hl7.elm.r1.Collapse;
import org.hl7.elm.r1.Concatenate;
import org.hl7.elm.r1.Concept;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.Contains;
import org.hl7.elm.r1.ContextDef;
import org.hl7.elm.r1.ConvertQuantity;
import org.hl7.elm.r1.Date;
import org.hl7.elm.r1.DateFrom;
import org.hl7.elm.r1.DateTime;
import org.hl7.elm.r1.DateTimePrecision;
import org.hl7.elm.r1.DifferenceBetween;
import org.hl7.elm.r1.Distinct;
import org.hl7.elm.r1.DurationBetween;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.End;
import org.hl7.elm.r1.Ends;
import org.hl7.elm.r1.Equal;
import org.hl7.elm.r1.Equivalent;
import org.hl7.elm.r1.Exists;
import org.hl7.elm.r1.Expand;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.Flatten;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.IdentifierRef;
import org.hl7.elm.r1.If;
import org.hl7.elm.r1.Implies;
import org.hl7.elm.r1.In;
import org.hl7.elm.r1.InCodeSystem;
import org.hl7.elm.r1.InValueSet;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.IncludedIn;
import org.hl7.elm.r1.Indexer;
import org.hl7.elm.r1.Instance;
import org.hl7.elm.r1.InstanceElement;
import org.hl7.elm.r1.Interval;
import org.hl7.elm.r1.Is;
import org.hl7.elm.r1.IsNull;
import org.hl7.elm.r1.Last;
import org.hl7.elm.r1.LessOrEqual;
import org.hl7.elm.r1.LetClause;
import org.hl7.elm.r1.ListTypeSpecifier;
import org.hl7.elm.r1.Literal;
import org.hl7.elm.r1.Meets;
import org.hl7.elm.r1.Multiply;
import org.hl7.elm.r1.NamedTypeSpecifier;
import org.hl7.elm.r1.NaryExpression;
import org.hl7.elm.r1.Negate;
import org.hl7.elm.r1.Not;
import org.hl7.elm.r1.Null;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.Or;
import org.hl7.elm.r1.Overlaps;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.ParameterRef;
import org.hl7.elm.r1.PointFrom;
import org.hl7.elm.r1.Power;
import org.hl7.elm.r1.ProperIncludedIn;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Quantity;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.RelationshipClause;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.ReturnClause;
import org.hl7.elm.r1.SameAs;
import org.hl7.elm.r1.SameOrAfter;
import org.hl7.elm.r1.SameOrBefore;
import org.hl7.elm.r1.SingletonFrom;
import org.hl7.elm.r1.SortByItem;
import org.hl7.elm.r1.SortClause;
import org.hl7.elm.r1.SortDirection;
import org.hl7.elm.r1.Split;
import org.hl7.elm.r1.Start;
import org.hl7.elm.r1.Starts;
import org.hl7.elm.r1.Subtract;
import org.hl7.elm.r1.Time;
import org.hl7.elm.r1.ToConcept;
import org.hl7.elm.r1.ToList;
import org.hl7.elm.r1.Tuple;
import org.hl7.elm.r1.TupleElement;
import org.hl7.elm.r1.TupleElementDefinition;
import org.hl7.elm.r1.TypeSpecifier;
import org.hl7.elm.r1.UnaryExpression;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.ValueSetRef;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm.r1.Width;
import org.hl7.elm.r1.With;
import org.hl7.elm.r1.Without;
import org.hl7.elm.r1.Xor;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class Cql2ElmVisitor
extends CqlPreprocessorElmCommonVisitor {
    private final SystemMethodResolver systemMethodResolver;
    private final Set<String> definedExpressionDefinitions = new HashSet<String>();
    private final Stack<ExpressionDefinitionInfo> forwards = new Stack();
    private final Map<cqlParser.FunctionDefinitionContext, FunctionHeader> functionHeaders = new HashMap<cqlParser.FunctionDefinitionContext, FunctionHeader>();
    private final Map<FunctionDef, FunctionHeader> functionHeadersByDef = new HashMap<FunctionDef, FunctionHeader>();
    private final Map<FunctionHeader, cqlParser.FunctionDefinitionContext> functionDefinitions = new HashMap<FunctionHeader, cqlParser.FunctionDefinitionContext>();
    private final Stack<TimingOperatorContext> timingOperators = new Stack();
    private final List<Retrieve> retrieves = new ArrayList<Retrieve>();
    private final List<Expression> expressions = new ArrayList<Expression>();
    private final Map<String, Element> contextDefinitions = new HashMap<String, Element>();

    public Cql2ElmVisitor(LibraryBuilder libraryBuilder, TokenStream tokenStream, LibraryInfo libraryInfo) {
        super(libraryBuilder, tokenStream);
        this.libraryInfo = Objects.requireNonNull(libraryInfo, "libraryInfo required");
        this.systemMethodResolver = new SystemMethodResolver(this, libraryBuilder);
    }

    public List<Retrieve> getRetrieves() {
        return this.retrieves;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public Object visitLibrary(cqlParser.LibraryContext ctx) {
        Object lastResult = null;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            Object childResult;
            TerminalNode terminalNode;
            ParseTree tree = ctx.getChild(i);
            TerminalNode terminalNode2 = terminalNode = tree instanceof TerminalNode ? (TerminalNode)tree : null;
            if (terminalNode != null && terminalNode.getSymbol().getType() == -1 || (childResult = this.visit(tree)) == null) continue;
            lastResult = childResult;
        }
        return lastResult;
    }

    public VersionedIdentifier visitLibraryDefinition(cqlParser.LibraryDefinitionContext ctx) {
        List identifiers = (List)this.visit((ParseTree)ctx.qualifiedIdentifier());
        VersionedIdentifier vid = this.of.createVersionedIdentifier().withId((String)identifiers.remove(identifiers.size() - 1)).withVersion(this.parseString((ParseTree)ctx.versionSpecifier()));
        if (!identifiers.isEmpty()) {
            vid.setSystem(this.libraryBuilder.resolveNamespaceUri(String.join((CharSequence)".", identifiers), true));
        } else if (this.libraryBuilder.getNamespaceInfo() != null) {
            vid.setSystem(this.libraryBuilder.getNamespaceInfo().getUri());
        }
        this.libraryBuilder.setLibraryIdentifier(vid);
        return vid;
    }

    public UsingDef visitUsingDefinition(cqlParser.UsingDefinitionContext ctx) {
        String localIdentifier;
        List identifiers = (List)this.visit((ParseTree)ctx.qualifiedIdentifier());
        String unqualifiedIdentifier = (String)identifiers.remove(identifiers.size() - 1);
        String namespaceName = !identifiers.isEmpty() ? String.join((CharSequence)".", identifiers) : (this.libraryBuilder.isWellKnownModelName(unqualifiedIdentifier) ? null : (this.libraryBuilder.getNamespaceInfo() != null ? this.libraryBuilder.getNamespaceInfo().getName() : null));
        String path = null;
        NamespaceInfo modelNamespace = null;
        if (namespaceName != null) {
            String namespaceUri = this.libraryBuilder.resolveNamespaceUri(namespaceName, true);
            path = NamespaceManager.getPath((String)namespaceUri, (String)unqualifiedIdentifier);
            modelNamespace = new NamespaceInfo(namespaceName, namespaceUri);
        } else {
            path = unqualifiedIdentifier;
        }
        String string = localIdentifier = ctx.localIdentifier() == null ? unqualifiedIdentifier : this.parseString((ParseTree)ctx.localIdentifier());
        if (!localIdentifier.equals(unqualifiedIdentifier)) {
            throw new IllegalArgumentException(String.format("Local identifiers for models must be the same as the name of the model in this release of the translator (Model %s, Called %s)", unqualifiedIdentifier, localIdentifier));
        }
        UsingDef usingDef = this.libraryBuilder.resolveUsingRef(localIdentifier);
        this.libraryBuilder.pushIdentifier(localIdentifier, (Trackable)usingDef, LibraryBuilder.IdentifierScope.GLOBAL);
        return usingDef;
    }

    public Model getModel() {
        return this.getModel(null);
    }

    public Model getModel(String modelName) {
        return this.getModel(null, modelName, null, null);
    }

    @Override
    public Model getModel(NamespaceInfo modelNamespace, String modelName, String version, String localIdentifier) {
        if (modelName == null) {
            UsingDefinitionInfo defaultUsing = this.libraryInfo.getDefaultUsingDefinition();
            modelName = defaultUsing.getName();
            version = defaultUsing.getVersion();
        }
        ModelIdentifier modelIdentifier = new ModelIdentifier().withId(modelName).withVersion(version);
        if (modelNamespace != null) {
            modelIdentifier.setSystem(modelNamespace.getUri());
        }
        return this.libraryBuilder.getModel(modelIdentifier, localIdentifier);
    }

    private String getLibraryPath(String namespaceName, String unqualifiedIdentifier) {
        if (namespaceName != null) {
            String namespaceUri = this.libraryBuilder.resolveNamespaceUri(namespaceName, true);
            return NamespaceManager.getPath((String)namespaceUri, (String)unqualifiedIdentifier);
        }
        return unqualifiedIdentifier;
    }

    public Object visitIncludeDefinition(cqlParser.IncludeDefinitionContext ctx) {
        List identifiers = (List)this.visit((ParseTree)ctx.qualifiedIdentifier());
        String unqualifiedIdentifier = (String)identifiers.remove(identifiers.size() - 1);
        String namespaceName = !identifiers.isEmpty() ? String.join((CharSequence)".", identifiers) : (this.libraryBuilder.getNamespaceInfo() != null ? this.libraryBuilder.getNamespaceInfo().getName() : null);
        String path = this.getLibraryPath(namespaceName, unqualifiedIdentifier);
        IncludeDef library = this.of.createIncludeDef().withLocalIdentifier(ctx.localIdentifier() == null ? unqualifiedIdentifier : this.parseString((ParseTree)ctx.localIdentifier())).withPath(path).withVersion(this.parseString((ParseTree)ctx.versionSpecifier()));
        if (!this.libraryBuilder.canResolveLibrary(library)) {
            namespaceName = identifiers.size() > 0 ? String.join((CharSequence)".", identifiers) : (this.libraryBuilder.isWellKnownLibraryName(unqualifiedIdentifier) ? null : (this.libraryBuilder.getNamespaceInfo() != null ? this.libraryBuilder.getNamespaceInfo().getName() : null));
            path = this.getLibraryPath(namespaceName, unqualifiedIdentifier);
            library = this.of.createIncludeDef().withLocalIdentifier(ctx.localIdentifier() == null ? unqualifiedIdentifier : this.parseString((ParseTree)ctx.localIdentifier())).withPath(path).withVersion(this.parseString((ParseTree)ctx.versionSpecifier()));
        }
        this.libraryBuilder.addInclude(library);
        this.libraryBuilder.pushIdentifier(library.getLocalIdentifier(), (Trackable)library, LibraryBuilder.IdentifierScope.GLOBAL);
        return library;
    }

    public ParameterDef visitParameterDefinition(cqlParser.ParameterDefinitionContext ctx) {
        ParameterDef param = this.of.createParameterDef().withAccessLevel(this.parseAccessModifier((ParseTree)ctx.accessModifier())).withName(this.parseString((ParseTree)ctx.identifier())).withDefault(this.parseLiteralExpression((ParseTree)ctx.expression())).withParameterTypeSpecifier(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier()));
        DataType paramType = null;
        if (param.getParameterTypeSpecifier() != null) {
            paramType = param.getParameterTypeSpecifier().getResultType();
        }
        if (param.getDefault() != null) {
            if (paramType != null) {
                this.libraryBuilder.verifyType(param.getDefault().getResultType(), paramType);
            } else {
                paramType = param.getDefault().getResultType();
            }
        }
        if (paramType == null) {
            throw new IllegalArgumentException(String.format("Could not determine parameter type for parameter %s.", param.getName()));
        }
        param.setResultType(paramType);
        if (param.getDefault() != null) {
            param.setDefault(this.libraryBuilder.ensureCompatible(param.getDefault(), paramType));
        }
        this.libraryBuilder.addParameter(param);
        this.libraryBuilder.pushIdentifier(param.getName(), (Trackable)param, LibraryBuilder.IdentifierScope.GLOBAL);
        return param;
    }

    @Override
    public TupleElementDefinition visitTupleElementDefinition(cqlParser.TupleElementDefinitionContext ctx) {
        TupleElementDefinition result = this.of.createTupleElementDefinition().withName(this.parseString((ParseTree)ctx.referentialIdentifier())).withElementType(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier()));
        if (this.getIncludeDeprecatedElements()) {
            result.setType(result.getElementType());
        }
        return result;
    }

    public AccessModifier visitAccessModifier(cqlParser.AccessModifierContext ctx) {
        switch (ctx.getText().toLowerCase()) {
            case "public": {
                return AccessModifier.PUBLIC;
            }
            case "private": {
                return AccessModifier.PRIVATE;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown access modifier %s.", ctx.getText().toLowerCase()));
    }

    public CodeSystemDef visitCodesystemDefinition(cqlParser.CodesystemDefinitionContext ctx) {
        CodeSystemDef cs = this.of.createCodeSystemDef().withAccessLevel(this.parseAccessModifier((ParseTree)ctx.accessModifier())).withName(this.parseString((ParseTree)ctx.identifier())).withId(this.parseString((ParseTree)ctx.codesystemId())).withVersion(this.parseString((ParseTree)ctx.versionSpecifier()));
        if (this.libraryBuilder.isCompatibleWith("1.5")) {
            cs.setResultType(this.libraryBuilder.resolveTypeName("System", "CodeSystem"));
        } else {
            cs.setResultType((DataType)new ListType(this.libraryBuilder.resolveTypeName("System", "Code")));
        }
        this.libraryBuilder.addCodeSystem(cs);
        this.libraryBuilder.pushIdentifier(cs.getName(), (Trackable)cs, LibraryBuilder.IdentifierScope.GLOBAL);
        return cs;
    }

    public CodeSystemRef visitCodesystemIdentifier(cqlParser.CodesystemIdentifierContext ctx) {
        CodeSystemDef def;
        String libraryName = this.parseString((ParseTree)ctx.libraryIdentifier());
        String name = this.parseString((ParseTree)ctx.identifier());
        if (libraryName != null) {
            def = this.libraryBuilder.resolveLibrary(libraryName).resolveCodeSystemRef(name);
            this.libraryBuilder.checkAccessLevel(libraryName, name, def.getAccessLevel());
        } else {
            def = this.libraryBuilder.resolveCodeSystemRef(name);
        }
        if (def == null) {
            throw new IllegalArgumentException(String.format("Could not resolve reference to code system %s.", name));
        }
        return (CodeSystemRef)this.of.createCodeSystemRef().withLibraryName(libraryName).withName(name).withResultType(def.getResultType());
    }

    public CodeRef visitCodeIdentifier(cqlParser.CodeIdentifierContext ctx) {
        CodeDef def;
        String libraryName = this.parseString((ParseTree)ctx.libraryIdentifier());
        String name = this.parseString((ParseTree)ctx.identifier());
        if (libraryName != null) {
            def = this.libraryBuilder.resolveLibrary(libraryName).resolveCodeRef(name);
            this.libraryBuilder.checkAccessLevel(libraryName, name, def.getAccessLevel());
        } else {
            def = this.libraryBuilder.resolveCodeRef(name);
        }
        if (def == null) {
            throw new IllegalArgumentException(String.format("Could not resolve reference to code %s.", name));
        }
        return (CodeRef)this.of.createCodeRef().withLibraryName(libraryName).withName(name).withResultType(def.getResultType());
    }

    public ValueSetDef visitValuesetDefinition(cqlParser.ValuesetDefinitionContext ctx) {
        ValueSetDef vs = this.of.createValueSetDef().withAccessLevel(this.parseAccessModifier((ParseTree)ctx.accessModifier())).withName(this.parseString((ParseTree)ctx.identifier())).withId(this.parseString((ParseTree)ctx.valuesetId())).withVersion(this.parseString((ParseTree)ctx.versionSpecifier()));
        if (ctx.codesystems() != null) {
            for (cqlParser.CodesystemIdentifierContext codesystem : ctx.codesystems().codesystemIdentifier()) {
                CodeSystemRef cs = (CodeSystemRef)this.visit((ParseTree)codesystem);
                if (cs == null) {
                    throw new IllegalArgumentException(String.format("Could not resolve reference to code system %s.", codesystem.getText()));
                }
                vs.getCodeSystem().add(cs);
            }
        }
        if (this.libraryBuilder.isCompatibleWith("1.5")) {
            vs.setResultType(this.libraryBuilder.resolveTypeName("System", "ValueSet"));
        } else {
            vs.setResultType((DataType)new ListType(this.libraryBuilder.resolveTypeName("System", "Code")));
        }
        this.libraryBuilder.addValueSet(vs);
        this.libraryBuilder.pushIdentifier(vs.getName(), (Trackable)vs, LibraryBuilder.IdentifierScope.GLOBAL);
        return vs;
    }

    public CodeDef visitCodeDefinition(cqlParser.CodeDefinitionContext ctx) {
        CodeDef cd = this.of.createCodeDef().withAccessLevel(this.parseAccessModifier((ParseTree)ctx.accessModifier())).withName(this.parseString((ParseTree)ctx.identifier())).withId(this.parseString((ParseTree)ctx.codeId()));
        if (ctx.codesystemIdentifier() != null) {
            cd.setCodeSystem((CodeSystemRef)this.visit((ParseTree)ctx.codesystemIdentifier()));
        }
        if (ctx.displayClause() != null) {
            cd.setDisplay(this.parseString((ParseTree)ctx.displayClause().STRING()));
        }
        cd.setResultType(this.libraryBuilder.resolveTypeName("Code"));
        this.libraryBuilder.addCode(cd);
        this.libraryBuilder.pushIdentifier(cd.getName(), (Trackable)cd, LibraryBuilder.IdentifierScope.GLOBAL);
        return cd;
    }

    public ConceptDef visitConceptDefinition(cqlParser.ConceptDefinitionContext ctx) {
        ConceptDef cd = this.of.createConceptDef().withAccessLevel(this.parseAccessModifier((ParseTree)ctx.accessModifier())).withName(this.parseString((ParseTree)ctx.identifier()));
        if (ctx.codeIdentifier() != null) {
            for (cqlParser.CodeIdentifierContext ci : ctx.codeIdentifier()) {
                cd.getCode().add((CodeRef)this.visit((ParseTree)ci));
            }
        }
        if (ctx.displayClause() != null) {
            cd.setDisplay(this.parseString((ParseTree)ctx.displayClause().STRING()));
        }
        cd.setResultType(this.libraryBuilder.resolveTypeName("Concept"));
        this.libraryBuilder.addConcept(cd);
        return cd;
    }

    public NamedTypeSpecifier visitNamedTypeSpecifier(cqlParser.NamedTypeSpecifierContext ctx) {
        List<String> qualifiers = this.parseQualifiers(ctx);
        String modelIdentifier = Cql2ElmVisitor.getModelIdentifier(qualifiers);
        String identifier = Cql2ElmVisitor.getTypeIdentifier(qualifiers, this.parseString((ParseTree)ctx.referentialOrTypeNameIdentifier()));
        ResultWithPossibleError<NamedTypeSpecifier> retrievedResult = this.libraryBuilder.getNamedTypeSpecifierResult(String.format("%s:%s", modelIdentifier, identifier));
        if (retrievedResult != null) {
            if (retrievedResult.hasError()) {
                return null;
            }
            return retrievedResult.getUnderlyingResultIfExists();
        }
        DataType resultType = this.libraryBuilder.resolveTypeName(modelIdentifier, identifier);
        if (null == resultType) {
            throw new CqlCompilerException(String.format("Could not find type for model: %s and name: %s", modelIdentifier, identifier), this.getTrackBack((ParserRuleContext)ctx));
        }
        NamedTypeSpecifier result = this.of.createNamedTypeSpecifier().withName(this.libraryBuilder.dataTypeToQName(resultType));
        result.setResultType(resultType);
        return result;
    }

    private boolean isUnfilteredContext(String contextName) {
        return contextName.equals("Unfiltered") || this.libraryBuilder.isCompatibilityLevel3() && contextName.equals("Population");
    }

    public Object visitContextDefinition(cqlParser.ContextDefinitionContext ctx) {
        ModelContext modelContext;
        Element modelContextDefinition;
        String modelIdentifier = this.parseString((ParseTree)ctx.modelIdentifier());
        String unqualifiedIdentifier = this.parseString((ParseTree)ctx.identifier());
        this.setCurrentContext((String)(modelIdentifier != null ? modelIdentifier + "." + unqualifiedIdentifier : unqualifiedIdentifier));
        if (!this.isUnfilteredContext(unqualifiedIdentifier) && (modelContextDefinition = this.contextDefinitions.get((modelContext = this.libraryBuilder.resolveContextName(modelIdentifier, unqualifiedIdentifier)).getName())) == null) {
            if (this.libraryBuilder.hasUsings()) {
                ModelInfo modelInfo = modelIdentifier == null ? this.libraryBuilder.getModel(this.libraryInfo.getDefaultModelName()).getModelInfo() : this.libraryBuilder.getModel(modelIdentifier).getModelInfo();
                ClassType contextType = modelContext.getType();
                modelContextDefinition = this.libraryBuilder.resolveParameterRef(modelContext.getName());
                if (modelContextDefinition != null) {
                    this.contextDefinitions.put(modelContext.getName(), modelContextDefinition);
                } else {
                    Retrieve contextRetrieve = this.of.createRetrieve().withDataType(this.libraryBuilder.dataTypeToQName((DataType)contextType));
                    this.track((Trackable)contextRetrieve, (ParseTree)ctx);
                    contextRetrieve.setResultType((DataType)new ListType((DataType)contextType));
                    String contextClassIdentifier = contextType.getIdentifier();
                    if (contextClassIdentifier != null) {
                        contextRetrieve.setTemplateId(contextClassIdentifier);
                    }
                    modelContextDefinition = this.of.createExpressionDef().withName(unqualifiedIdentifier).withContext(this.getCurrentContext()).withExpression((Expression)this.of.createSingletonFrom().withOperand((Expression)contextRetrieve));
                    this.track((Trackable)modelContextDefinition, (ParseTree)ctx);
                    ((ExpressionDef)modelContextDefinition).getExpression().setResultType((DataType)contextType);
                    modelContextDefinition.setResultType((DataType)contextType);
                    this.libraryBuilder.addExpression((ExpressionDef)modelContextDefinition);
                    this.contextDefinitions.put(modelContext.getName(), modelContextDefinition);
                }
            } else {
                modelContextDefinition = this.of.createExpressionDef().withName(unqualifiedIdentifier).withContext(this.getCurrentContext()).withExpression((Expression)this.of.createNull());
                this.track((Trackable)modelContextDefinition, (ParseTree)ctx);
                ((ExpressionDef)modelContextDefinition).getExpression().setResultType(this.libraryBuilder.resolveTypeName("System", "Any"));
                modelContextDefinition.setResultType(((ExpressionDef)modelContextDefinition).getExpression().getResultType());
                this.libraryBuilder.addExpression((ExpressionDef)modelContextDefinition);
                this.contextDefinitions.put(modelContext.getName(), modelContextDefinition);
            }
        }
        ContextDef contextDef = this.of.createContextDef().withName(this.getCurrentContext());
        this.track((Trackable)contextDef, (ParseTree)ctx);
        if (this.libraryBuilder.isCompatibleWith("1.5")) {
            this.libraryBuilder.addContext(contextDef);
        }
        return this.getCurrentContext();
    }

    private boolean isImplicitContextExpressionDef(ExpressionDef def) {
        for (Element e : this.contextDefinitions.values()) {
            if (def != e) continue;
            return true;
        }
        return false;
    }

    private void removeImplicitContextExpressionDef(ExpressionDef def) {
        for (Map.Entry<String, Element> e : this.contextDefinitions.entrySet()) {
            if (def != e.getValue()) continue;
            this.contextDefinitions.remove(e.getKey());
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionDef internalVisitExpressionDefinition(cqlParser.ExpressionDefinitionContext ctx) {
        String identifier = this.parseString((ParseTree)ctx.identifier());
        ExpressionDef def = this.libraryBuilder.resolveExpressionRef(identifier);
        if (def == null) {
            ExpressionDef hollowExpressionDef = this.of.createExpressionDef().withName(identifier).withContext(this.getCurrentContext());
            this.libraryBuilder.pushIdentifier(identifier, (Trackable)hollowExpressionDef, LibraryBuilder.IdentifierScope.GLOBAL);
        }
        if (def == null || this.isImplicitContextExpressionDef(def)) {
            if (def != null && this.isImplicitContextExpressionDef(def)) {
                this.libraryBuilder.removeExpression(def);
                this.removeImplicitContextExpressionDef(def);
                def = null;
            }
            this.libraryBuilder.pushExpressionContext(this.getCurrentContext());
            try {
                this.libraryBuilder.pushExpressionDefinition(identifier);
                try {
                    def = this.of.createExpressionDef().withAccessLevel(this.parseAccessModifier((ParseTree)ctx.accessModifier())).withName(identifier).withContext(this.getCurrentContext()).withExpression((Expression)this.visit((ParseTree)ctx.expression()));
                    if (def.getExpression() != null) {
                        def.setResultType(def.getExpression().getResultType());
                    }
                    this.libraryBuilder.addExpression(def);
                }
                finally {
                    this.libraryBuilder.popExpressionDefinition();
                }
            }
            finally {
                this.libraryBuilder.popExpressionContext();
            }
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionDef visitExpressionDefinition(cqlParser.ExpressionDefinitionContext ctx) {
        this.libraryBuilder.pushIdentifierScope();
        try {
            ExpressionDef expressionDef = this.internalVisitExpressionDefinition(ctx);
            if (this.forwards.isEmpty() || !this.forwards.peek().getName().equals(expressionDef.getName())) {
                if (this.definedExpressionDefinitions.contains(expressionDef.getName())) {
                    throw new IllegalArgumentException(String.format("Identifier %s is already in use in this library.", expressionDef.getName()));
                }
                this.definedExpressionDefinitions.add(expressionDef.getName());
            }
            ExpressionDef expressionDef2 = expressionDef;
            return expressionDef2;
        }
        finally {
            this.libraryBuilder.popIdentifierScope();
        }
    }

    public Literal visitStringLiteral(cqlParser.StringLiteralContext ctx) {
        Literal stringLiteral = this.libraryBuilder.createLiteral(this.parseString((ParseTree)ctx.STRING()));
        this.libraryBuilder.pushIdentifier(stringLiteral.getValue(), (Trackable)stringLiteral);
        return stringLiteral;
    }

    public Literal visitSimpleStringLiteral(cqlParser.SimpleStringLiteralContext ctx) {
        return this.libraryBuilder.createLiteral(this.parseString((ParseTree)ctx.STRING()));
    }

    public Literal visitBooleanLiteral(cqlParser.BooleanLiteralContext ctx) {
        return this.libraryBuilder.createLiteral(Boolean.valueOf(ctx.getText()));
    }

    public Object visitIntervalSelector(cqlParser.IntervalSelectorContext ctx) {
        return this.libraryBuilder.createInterval(this.parseExpression((ParseTree)ctx.expression(0)), ctx.getChild(1).getText().equals("["), this.parseExpression((ParseTree)ctx.expression(1)), ctx.getChild(5).getText().equals("]"));
    }

    public Object visitTupleElementSelector(cqlParser.TupleElementSelectorContext ctx) {
        TupleElement result = this.of.createTupleElement().withName(this.parseString((ParseTree)ctx.referentialIdentifier())).withValue(this.parseExpression((ParseTree)ctx.expression()));
        result.setResultType(result.getValue().getResultType());
        return result;
    }

    public Object visitTupleSelector(cqlParser.TupleSelectorContext ctx) {
        Tuple tuple = this.of.createTuple();
        TupleType tupleType = new TupleType();
        for (cqlParser.TupleElementSelectorContext elementContext : ctx.tupleElementSelector()) {
            TupleElement element = (TupleElement)this.visit((ParseTree)elementContext);
            tupleType.addElement(new TupleTypeElement(element.getName(), element.getResultType()));
            tuple.getElement().add(element);
        }
        tuple.setResultType((DataType)tupleType);
        return tuple;
    }

    public Object visitInstanceElementSelector(cqlParser.InstanceElementSelectorContext ctx) {
        InstanceElement result = this.of.createInstanceElement().withName(this.parseString((ParseTree)ctx.referentialIdentifier())).withValue(this.parseExpression((ParseTree)ctx.expression()));
        result.setResultType(result.getValue().getResultType());
        return result;
    }

    public Object visitInstanceSelector(cqlParser.InstanceSelectorContext ctx) {
        Instance instance = this.of.createInstance();
        NamedTypeSpecifier classTypeSpecifier = this.visitNamedTypeSpecifier(ctx.namedTypeSpecifier());
        instance.setClassType(classTypeSpecifier.getName());
        instance.setResultType(classTypeSpecifier.getResultType());
        for (cqlParser.InstanceElementSelectorContext elementContext : ctx.instanceElementSelector()) {
            InstanceElement element = (InstanceElement)this.visit((ParseTree)elementContext);
            PropertyResolution resolution = this.libraryBuilder.resolveProperty(classTypeSpecifier.getResultType(), element.getName());
            element.setValue(this.libraryBuilder.ensureCompatible(element.getValue(), resolution.getType()));
            element.setName(resolution.getName());
            if (resolution.getTargetMap() != null) {
                throw new IllegalArgumentException("Target Mapping in instance selectors not yet supported");
            }
            instance.getElement().add(element);
        }
        return instance;
    }

    public Object visitCodeSelector(cqlParser.CodeSelectorContext ctx) {
        Code code = this.of.createCode();
        code.setCode(this.parseString((ParseTree)ctx.STRING()));
        code.setSystem((CodeSystemRef)this.visit((ParseTree)ctx.codesystemIdentifier()));
        if (ctx.displayClause() != null) {
            code.setDisplay(this.parseString((ParseTree)ctx.displayClause().STRING()));
        }
        code.setResultType(this.libraryBuilder.resolveTypeName("System", "Code"));
        return code;
    }

    public Object visitConceptSelector(cqlParser.ConceptSelectorContext ctx) {
        Concept concept = this.of.createConcept();
        if (ctx.displayClause() != null) {
            concept.setDisplay(this.parseString((ParseTree)ctx.displayClause().STRING()));
        }
        for (cqlParser.CodeSelectorContext codeContext : ctx.codeSelector()) {
            concept.getCode().add((Code)this.visit((ParseTree)codeContext));
        }
        concept.setResultType(this.libraryBuilder.resolveTypeName("System", "Concept"));
        return concept;
    }

    public Object visitListSelector(cqlParser.ListSelectorContext ctx) {
        TypeSpecifier elementTypeSpecifier = this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier());
        org.hl7.elm.r1.List list = this.of.createList();
        ListType listType = null;
        if (elementTypeSpecifier != null) {
            ListTypeSpecifier listTypeSpecifier = this.of.createListTypeSpecifier().withElementType(elementTypeSpecifier);
            this.track((Trackable)listTypeSpecifier, (ParseTree)ctx.typeSpecifier());
            listType = new ListType(elementTypeSpecifier.getResultType());
            listTypeSpecifier.setResultType((DataType)listType);
        }
        DataType elementType = elementTypeSpecifier != null ? elementTypeSpecifier.getResultType() : null;
        DataType inferredElementType = null;
        ArrayList<Expression> elements = new ArrayList<Expression>();
        for (cqlParser.ExpressionContext elementContext : ctx.expression()) {
            Expression element = this.parseExpression((ParseTree)elementContext);
            if (elementType != null) {
                this.libraryBuilder.verifyType(element.getResultType(), elementType);
            } else {
                DataType compatibleType;
                inferredElementType = inferredElementType == null ? element.getResultType() : ((compatibleType = this.libraryBuilder.findCompatibleType(inferredElementType, element.getResultType())) != null ? compatibleType : this.libraryBuilder.resolveTypeName("System", "Any"));
            }
            elements.add(element);
        }
        if (elementType == null) {
            elementType = inferredElementType == null ? this.libraryBuilder.resolveTypeName("System", "Any") : inferredElementType;
        }
        for (Expression element : elements) {
            if (!elementType.isSuperTypeOf(element.getResultType())) {
                Conversion conversion = this.libraryBuilder.findConversion(element.getResultType(), elementType, true, false);
                if (conversion != null) {
                    list.getElement().add(this.libraryBuilder.convertExpression(element, conversion));
                    continue;
                }
                list.getElement().add(element);
                continue;
            }
            list.getElement().add(element);
        }
        if (listType == null) {
            listType = new ListType(elementType);
        }
        list.setResultType((DataType)listType);
        return list;
    }

    public Object visitTimeLiteral(cqlParser.TimeLiteralContext ctx) {
        Pattern timePattern;
        Matcher matcher;
        String input = ctx.getText();
        if (input.startsWith("@")) {
            input = input.substring(1);
        }
        if ((matcher = (timePattern = Pattern.compile("T(\\d{2})(\\:(\\d{2})(\\:(\\d{2})(\\.(\\d+))?)?)?")).matcher(input)).matches()) {
            try {
                Time result = this.of.createTime();
                int hour = Integer.parseInt(matcher.group(1));
                int minute = -1;
                int second = -1;
                int millisecond = -1;
                if (hour < 0 || hour > 24) {
                    throw new IllegalArgumentException(String.format("Invalid hour in time literal (%s).", input));
                }
                result.setHour((Expression)this.libraryBuilder.createLiteral(hour));
                if (matcher.group(3) != null) {
                    minute = Integer.parseInt(matcher.group(3));
                    if (minute < 0 || minute >= 60 || hour == 24 && minute > 0) {
                        throw new IllegalArgumentException(String.format("Invalid minute in time literal (%s).", input));
                    }
                    result.setMinute((Expression)this.libraryBuilder.createLiteral(minute));
                }
                if (matcher.group(5) != null) {
                    second = Integer.parseInt(matcher.group(5));
                    if (second < 0 || second >= 60 || hour == 24 && second > 0) {
                        throw new IllegalArgumentException(String.format("Invalid second in time literal (%s).", input));
                    }
                    result.setSecond((Expression)this.libraryBuilder.createLiteral(second));
                }
                if (matcher.group(7) != null) {
                    millisecond = Integer.parseInt(matcher.group(7));
                    if (millisecond < 0 || hour == 24 && millisecond > 0) {
                        throw new IllegalArgumentException(String.format("Invalid millisecond in time literal (%s).", input));
                    }
                    result.setMillisecond((Expression)this.libraryBuilder.createLiteral(millisecond));
                }
                result.setResultType(this.libraryBuilder.resolveTypeName("System", "Time"));
                return result;
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(String.format("Invalid time input (%s). Use ISO 8601 time representation (hh:mm:ss.fff).", input), e);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid time input (%s). Use ISO 8601 time representation (hh:mm:ss.fff).", input));
    }

    private Expression parseDateTimeLiteral(String input) {
        Pattern dateTimePattern = Pattern.compile("(\\d{4})(((-(\\d{2}))(((-(\\d{2}))((T)((\\d{2})(\\:(\\d{2})(\\:(\\d{2})(\\.(\\d+))?)?)?)?)?)|(T))?)|(T))?((Z)|(([+-])(\\d{2})(\\:(\\d{2}))))?");
        Matcher matcher = dateTimePattern.matcher(input);
        if (matcher.matches()) {
            try {
                GregorianCalendar calendar = (GregorianCalendar)GregorianCalendar.getInstance();
                DateTime result = this.of.createDateTime();
                int year = Integer.parseInt(matcher.group(1));
                int month = -1;
                int day = -1;
                int hour = -1;
                int minute = -1;
                int second = -1;
                int millisecond = -1;
                result.setYear((Expression)this.libraryBuilder.createLiteral(year));
                if (matcher.group(5) != null) {
                    month = Integer.parseInt(matcher.group(5));
                    if (month < 0 || month > 12) {
                        throw new IllegalArgumentException(String.format("Invalid month in date/time literal (%s).", input));
                    }
                    result.setMonth((Expression)this.libraryBuilder.createLiteral(month));
                }
                if (matcher.group(9) != null) {
                    day = Integer.parseInt(matcher.group(9));
                    int maxDay = 31;
                    switch (month) {
                        case 2: {
                            maxDay = calendar.isLeapYear(year) ? 29 : 28;
                            break;
                        }
                        case 4: 
                        case 6: 
                        case 9: 
                        case 11: {
                            maxDay = 30;
                            break;
                        }
                    }
                    if (day < 0 || day > maxDay) {
                        throw new IllegalArgumentException(String.format("Invalid day in date/time literal (%s).", input));
                    }
                    result.setDay((Expression)this.libraryBuilder.createLiteral(day));
                }
                if (matcher.group(13) != null) {
                    hour = Integer.parseInt(matcher.group(13));
                    if (hour < 0 || hour > 24) {
                        throw new IllegalArgumentException(String.format("Invalid hour in date/time literal (%s).", input));
                    }
                    result.setHour((Expression)this.libraryBuilder.createLiteral(hour));
                }
                if (matcher.group(15) != null) {
                    minute = Integer.parseInt(matcher.group(15));
                    if (minute < 0 || minute >= 60 || hour == 24 && minute > 0) {
                        throw new IllegalArgumentException(String.format("Invalid minute in date/time literal (%s).", input));
                    }
                    result.setMinute((Expression)this.libraryBuilder.createLiteral(minute));
                }
                if (matcher.group(17) != null) {
                    second = Integer.parseInt(matcher.group(17));
                    if (second < 0 || second >= 60 || hour == 24 && second > 0) {
                        throw new IllegalArgumentException(String.format("Invalid second in date/time literal (%s).", input));
                    }
                    result.setSecond((Expression)this.libraryBuilder.createLiteral(second));
                }
                if (matcher.group(19) != null) {
                    millisecond = Integer.parseInt(matcher.group(19));
                    if (millisecond < 0 || hour == 24 && millisecond > 0) {
                        throw new IllegalArgumentException(String.format("Invalid millisecond in date/time literal (%s).", input));
                    }
                    result.setMillisecond((Expression)this.libraryBuilder.createLiteral(millisecond));
                }
                if (matcher.group(23) != null && matcher.group(23).equals("Z")) {
                    result.setTimezoneOffset((Expression)this.libraryBuilder.createLiteral(0.0));
                }
                if (matcher.group(25) != null) {
                    int offsetPolarity;
                    int n = offsetPolarity = matcher.group(25).equals("+") ? 1 : -1;
                    if (matcher.group(28) != null) {
                        int hourOffset = Integer.parseInt(matcher.group(26));
                        if (hourOffset < 0 || hourOffset > 14) {
                            throw new IllegalArgumentException(String.format("Timezone hour offset is out of range in date/time literal (%s).", input));
                        }
                        int minuteOffset = Integer.parseInt(matcher.group(28));
                        if (minuteOffset < 0 || minuteOffset >= 60 || hourOffset == 14 && minuteOffset > 0) {
                            throw new IllegalArgumentException(String.format("Timezone minute offset is out of range in date/time literal (%s).", input));
                        }
                        result.setTimezoneOffset((Expression)this.libraryBuilder.createLiteral(((double)hourOffset + (double)minuteOffset / 60.0) * (double)offsetPolarity));
                    } else if (matcher.group(26) != null) {
                        int hourOffset = Integer.parseInt(matcher.group(26));
                        if (hourOffset < 0 || hourOffset > 14) {
                            throw new IllegalArgumentException(String.format("Timezone hour offset is out of range in date/time literal (%s).", input));
                        }
                        result.setTimezoneOffset((Expression)this.libraryBuilder.createLiteral(Double.valueOf(hourOffset * offsetPolarity)));
                    }
                }
                if (result.getHour() == null && matcher.group(11) == null && matcher.group(20) == null && matcher.group(21) == null) {
                    Date date = this.of.createDate();
                    date.setYear(result.getYear());
                    date.setMonth(result.getMonth());
                    date.setDay(result.getDay());
                    date.setResultType(this.libraryBuilder.resolveTypeName("System", "Date"));
                    return date;
                }
                result.setResultType(this.libraryBuilder.resolveTypeName("System", "DateTime"));
                return result;
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(String.format("Invalid date-time input (%s). Use ISO 8601 date time representation (yyyy-MM-ddThh:mm:ss.fff(Z|(+/-hh:mm)).", input), e);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid date-time input (%s). Use ISO 8601 date time representation (yyyy-MM-ddThh:mm:ss.fff(Z|+/-hh:mm)).", input));
    }

    public Object visitDateLiteral(cqlParser.DateLiteralContext ctx) {
        String input = ctx.getText();
        if (input.startsWith("@")) {
            input = input.substring(1);
        }
        return this.parseDateTimeLiteral(input);
    }

    public Object visitDateTimeLiteral(cqlParser.DateTimeLiteralContext ctx) {
        String input = ctx.getText();
        if (input.startsWith("@")) {
            input = input.substring(1);
        }
        return this.parseDateTimeLiteral(input);
    }

    public Null visitNullLiteral(cqlParser.NullLiteralContext ctx) {
        Null result = this.of.createNull();
        result.setResultType(this.libraryBuilder.resolveTypeName("System", "Any"));
        return result;
    }

    public Expression visitNumberLiteral(cqlParser.NumberLiteralContext ctx) {
        return this.libraryBuilder.createNumberLiteral(ctx.NUMBER().getText());
    }

    public Expression visitSimpleNumberLiteral(cqlParser.SimpleNumberLiteralContext ctx) {
        return this.libraryBuilder.createNumberLiteral(ctx.NUMBER().getText());
    }

    public Literal visitLongNumberLiteral(cqlParser.LongNumberLiteralContext ctx) {
        String input = ctx.LONGNUMBER().getText();
        if (input.endsWith("L")) {
            input = input.substring(0, input.length() - 1);
        }
        return this.libraryBuilder.createLongNumberLiteral(input);
    }

    private BigDecimal parseDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not parse number literal: %s", value));
        }
    }

    public Expression visitQuantity(cqlParser.QuantityContext ctx) {
        if (ctx.unit() != null) {
            Quantity result = this.libraryBuilder.createQuantity(this.parseDecimal(ctx.NUMBER().getText()), this.parseString((ParseTree)ctx.unit()));
            return result;
        }
        return this.libraryBuilder.createNumberLiteral(ctx.NUMBER().getText());
    }

    private Quantity getQuantity(Expression source) {
        if (source instanceof Literal) {
            return this.libraryBuilder.createQuantity(this.parseDecimal(((Literal)source).getValue()), "1");
        }
        if (source instanceof Quantity) {
            return (Quantity)source;
        }
        throw new IllegalArgumentException("Could not create quantity from source expression.");
    }

    public Expression visitRatio(cqlParser.RatioContext ctx) {
        Quantity numerator = this.getQuantity((Expression)this.visit((ParseTree)ctx.quantity(0)));
        Quantity denominator = this.getQuantity((Expression)this.visit((ParseTree)ctx.quantity(1)));
        return this.libraryBuilder.createRatio(numerator, denominator);
    }

    public Not visitNotExpression(cqlParser.NotExpressionContext ctx) {
        Not result = this.of.createNot().withOperand(this.parseExpression((ParseTree)ctx.expression()));
        this.libraryBuilder.resolveUnaryCall("System", "Not", (UnaryExpression)result);
        return result;
    }

    public Exists visitExistenceExpression(cqlParser.ExistenceExpressionContext ctx) {
        Exists result = this.of.createExists().withOperand(this.parseExpression((ParseTree)ctx.expression()));
        this.libraryBuilder.resolveUnaryCall("System", "Exists", (UnaryExpression)result);
        return result;
    }

    public BinaryExpression visitMultiplicationExpressionTerm(cqlParser.MultiplicationExpressionTermContext ctx) {
        Multiply exp = null;
        String operatorName = null;
        switch (ctx.getChild(1).getText()) {
            case "*": {
                exp = this.of.createMultiply();
                operatorName = "Multiply";
                break;
            }
            case "/": {
                exp = this.of.createDivide();
                operatorName = "Divide";
                break;
            }
            case "div": {
                exp = this.of.createTruncatedDivide();
                operatorName = "TruncatedDivide";
                break;
            }
            case "mod": {
                exp = this.of.createModulo();
                operatorName = "Modulo";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported operator: %s.", ctx.getChild(1).getText()));
            }
        }
        exp.withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expressionTerm(0)), this.parseExpression((ParseTree)ctx.expressionTerm(1))});
        this.libraryBuilder.resolveBinaryCall("System", operatorName, (BinaryExpression)exp);
        return exp;
    }

    public Power visitPowerExpressionTerm(cqlParser.PowerExpressionTermContext ctx) {
        Power power = this.of.createPower().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expressionTerm(0)), this.parseExpression((ParseTree)ctx.expressionTerm(1))});
        this.libraryBuilder.resolveBinaryCall("System", "Power", (BinaryExpression)power);
        return power;
    }

    public Object visitPolarityExpressionTerm(cqlParser.PolarityExpressionTermContext ctx) {
        if (ctx.getChild(0).getText().equals("+")) {
            return this.visit((ParseTree)ctx.expressionTerm());
        }
        Negate result = this.of.createNegate().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
        this.libraryBuilder.resolveUnaryCall("System", "Negate", (UnaryExpression)result);
        return result;
    }

    public Expression visitAdditionExpressionTerm(cqlParser.AdditionExpressionTermContext ctx) {
        Concatenate concatenate;
        Add exp = null;
        String operatorName = null;
        switch (ctx.getChild(1).getText()) {
            case "+": {
                exp = this.of.createAdd();
                operatorName = "Add";
                break;
            }
            case "-": {
                exp = this.of.createSubtract();
                operatorName = "Subtract";
                break;
            }
            case "&": {
                exp = this.of.createConcatenate();
                operatorName = "Concatenate";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported operator: %s.", ctx.getChild(1).getText()));
            }
        }
        if (exp instanceof BinaryExpression) {
            ((BinaryExpression)exp).withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expressionTerm(0)), this.parseExpression((ParseTree)ctx.expressionTerm(1))});
            this.libraryBuilder.resolveBinaryCall("System", operatorName, (BinaryExpression)exp);
            if (exp.getResultType() == this.libraryBuilder.resolveTypeName("System", "String")) {
                concatenate = this.of.createConcatenate();
                concatenate.getOperand().addAll(((BinaryExpression)exp).getOperand());
                concatenate.setResultType(exp.getResultType());
                exp = concatenate;
            }
        } else {
            concatenate = (Concatenate)exp;
            concatenate.withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expressionTerm(0)), this.parseExpression((ParseTree)ctx.expressionTerm(1))});
            for (int i = 0; i < concatenate.getOperand().size(); ++i) {
                Expression operand = (Expression)concatenate.getOperand().get(i);
                Literal empty = this.libraryBuilder.createLiteral("");
                ArrayList<Expression> params = new ArrayList<Expression>();
                params.add(operand);
                params.add((Expression)empty);
                Expression coalesce = this.libraryBuilder.resolveFunction("System", "Coalesce", params);
                concatenate.getOperand().set(i, coalesce);
            }
            this.libraryBuilder.resolveNaryCall("System", operatorName, (NaryExpression)concatenate);
        }
        return exp;
    }

    public Object visitPredecessorExpressionTerm(cqlParser.PredecessorExpressionTermContext ctx) {
        return this.libraryBuilder.buildPredecessor(this.parseExpression((ParseTree)ctx.expressionTerm()));
    }

    public Object visitSuccessorExpressionTerm(cqlParser.SuccessorExpressionTermContext ctx) {
        return this.libraryBuilder.buildSuccessor(this.parseExpression((ParseTree)ctx.expressionTerm()));
    }

    public Object visitElementExtractorExpressionTerm(cqlParser.ElementExtractorExpressionTermContext ctx) {
        SingletonFrom result = this.of.createSingletonFrom().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
        this.libraryBuilder.resolveUnaryCall("System", "SingletonFrom", (UnaryExpression)result);
        return result;
    }

    public Object visitPointExtractorExpressionTerm(cqlParser.PointExtractorExpressionTermContext ctx) {
        PointFrom result = this.of.createPointFrom().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
        this.libraryBuilder.resolveUnaryCall("System", "PointFrom", (UnaryExpression)result);
        return result;
    }

    public Object visitTypeExtentExpressionTerm(cqlParser.TypeExtentExpressionTermContext ctx) {
        String extent = this.parseString(ctx.getChild(0));
        TypeSpecifier targetType = this.parseTypeSpecifier((ParseTree)ctx.namedTypeSpecifier());
        switch (extent) {
            case "minimum": {
                return this.libraryBuilder.buildMinimum(targetType.getResultType());
            }
            case "maximum": {
                return this.libraryBuilder.buildMaximum(targetType.getResultType());
            }
        }
        throw new IllegalArgumentException(String.format("Unknown extent: %s", extent));
    }

    public Object visitTimeBoundaryExpressionTerm(cqlParser.TimeBoundaryExpressionTermContext ctx) {
        Start result = null;
        String operatorName = null;
        if (ctx.getChild(0).getText().equals("start")) {
            result = this.of.createStart().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
            operatorName = "Start";
        } else {
            result = this.of.createEnd().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
            operatorName = "End";
        }
        this.libraryBuilder.resolveUnaryCall("System", operatorName, (UnaryExpression)result);
        return result;
    }

    private DateTimePrecision parseDateTimePrecision(String dateTimePrecision) {
        return this.parseDateTimePrecision(dateTimePrecision, true, true);
    }

    private DateTimePrecision parseComparableDateTimePrecision(String dateTimePrecision) {
        return this.parseDateTimePrecision(dateTimePrecision, true, false);
    }

    private DateTimePrecision parseComparableDateTimePrecision(String dateTimePrecision, boolean precisionRequired) {
        return this.parseDateTimePrecision(dateTimePrecision, precisionRequired, false);
    }

    private DateTimePrecision parseDateTimePrecision(String dateTimePrecision, boolean precisionRequired, boolean allowWeeks) {
        if (dateTimePrecision == null) {
            if (precisionRequired) {
                throw new IllegalArgumentException("dateTimePrecision is null");
            }
            return null;
        }
        switch (dateTimePrecision) {
            case "a": 
            case "year": 
            case "years": {
                return DateTimePrecision.YEAR;
            }
            case "mo": 
            case "month": 
            case "months": {
                return DateTimePrecision.MONTH;
            }
            case "wk": 
            case "week": 
            case "weeks": {
                if (!allowWeeks) {
                    throw new IllegalArgumentException("Week precision cannot be used for comparisons.");
                }
                return DateTimePrecision.WEEK;
            }
            case "d": 
            case "day": 
            case "days": {
                return DateTimePrecision.DAY;
            }
            case "h": 
            case "hour": 
            case "hours": {
                return DateTimePrecision.HOUR;
            }
            case "min": 
            case "minute": 
            case "minutes": {
                return DateTimePrecision.MINUTE;
            }
            case "s": 
            case "second": 
            case "seconds": {
                return DateTimePrecision.SECOND;
            }
            case "ms": 
            case "millisecond": 
            case "milliseconds": {
                return DateTimePrecision.MILLISECOND;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown precision '%s'.", dateTimePrecision));
    }

    public Object visitTimeUnitExpressionTerm(cqlParser.TimeUnitExpressionTermContext ctx) {
        String component = ctx.dateTimeComponent().getText();
        DateFrom result = null;
        String operatorName = null;
        switch (component) {
            case "date": {
                result = this.of.createDateFrom().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
                operatorName = "DateFrom";
                break;
            }
            case "time": {
                result = this.of.createTimeFrom().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
                operatorName = "TimeFrom";
                break;
            }
            case "timezone": {
                if (!this.libraryBuilder.isCompatibilityLevel3()) {
                    throw new IllegalArgumentException("Timezone keyword is only valid in 1.3 or lower");
                }
                result = this.of.createTimezoneFrom().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
                operatorName = "TimezoneFrom";
                break;
            }
            case "timezoneoffset": {
                result = this.of.createTimezoneOffsetFrom().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
                operatorName = "TimezoneOffsetFrom";
                break;
            }
            case "year": 
            case "month": 
            case "day": 
            case "hour": 
            case "minute": 
            case "second": 
            case "millisecond": {
                result = this.of.createDateTimeComponentFrom().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm())).withPrecision(this.parseDateTimePrecision(component));
                operatorName = "DateTimeComponentFrom";
                break;
            }
            case "week": {
                throw new IllegalArgumentException("Date/time values do not have a week component.");
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown precision '%s'.", component));
            }
        }
        this.libraryBuilder.resolveUnaryCall("System", operatorName, (UnaryExpression)result);
        return result;
    }

    public Object visitDurationExpressionTerm(cqlParser.DurationExpressionTermContext ctx) {
        Expression operand = this.parseExpression((ParseTree)ctx.expressionTerm());
        Start start = this.of.createStart().withOperand(operand);
        this.libraryBuilder.resolveUnaryCall("System", "Start", (UnaryExpression)start);
        End end = this.of.createEnd().withOperand(operand);
        this.libraryBuilder.resolveUnaryCall("System", "End", (UnaryExpression)end);
        DurationBetween result = this.of.createDurationBetween().withPrecision(this.parseDateTimePrecision(ctx.pluralDateTimePrecision().getText())).withOperand(new Expression[]{start, end});
        this.libraryBuilder.resolveBinaryCall("System", "DurationBetween", (BinaryExpression)result);
        return result;
    }

    public Object visitDifferenceExpressionTerm(cqlParser.DifferenceExpressionTermContext ctx) {
        Expression operand = this.parseExpression((ParseTree)ctx.expressionTerm());
        Start start = this.of.createStart().withOperand(operand);
        this.libraryBuilder.resolveUnaryCall("System", "Start", (UnaryExpression)start);
        End end = this.of.createEnd().withOperand(operand);
        this.libraryBuilder.resolveUnaryCall("System", "End", (UnaryExpression)end);
        DifferenceBetween result = this.of.createDifferenceBetween().withPrecision(this.parseDateTimePrecision(ctx.pluralDateTimePrecision().getText())).withOperand(new Expression[]{start, end});
        this.libraryBuilder.resolveBinaryCall("System", "DifferenceBetween", (BinaryExpression)result);
        return result;
    }

    public Object visitBetweenExpression(cqlParser.BetweenExpressionContext ctx) {
        Expression first = this.parseExpression((ParseTree)ctx.expression());
        Expression second = this.parseExpression((ParseTree)ctx.expressionTerm(0));
        Expression third = this.parseExpression((ParseTree)ctx.expressionTerm(1));
        boolean isProper = ctx.getChild(0).getText().equals("properly");
        if (first.getResultType() instanceof IntervalType) {
            ProperIncludedIn result = isProper ? this.of.createProperIncludedIn() : this.of.createIncludedIn().withOperand(new Expression[]{first, this.libraryBuilder.createInterval(second, true, third, true)});
            this.libraryBuilder.resolveBinaryCall("System", isProper ? "ProperIncludedIn" : "IncludedIn", (BinaryExpression)result);
            return result;
        }
        And result = this.of.createAnd().withOperand(new Expression[]{(isProper ? this.of.createGreater() : this.of.createGreaterOrEqual()).withOperand(new Expression[]{first, second}), (isProper ? this.of.createLess() : this.of.createLessOrEqual()).withOperand(new Expression[]{first, third})});
        this.libraryBuilder.resolveBinaryCall("System", isProper ? "Greater" : "GreaterOrEqual", (BinaryExpression)result.getOperand().get(0));
        this.libraryBuilder.resolveBinaryCall("System", isProper ? "Less" : "LessOrEqual", (BinaryExpression)result.getOperand().get(1));
        this.libraryBuilder.resolveBinaryCall("System", "And", (BinaryExpression)result);
        return result;
    }

    public Object visitDurationBetweenExpression(cqlParser.DurationBetweenExpressionContext ctx) {
        DurationBetween result = this.of.createDurationBetween().withPrecision(this.parseDateTimePrecision(ctx.pluralDateTimePrecision().getText())).withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expressionTerm(0)), this.parseExpression((ParseTree)ctx.expressionTerm(1))});
        this.libraryBuilder.resolveBinaryCall("System", "DurationBetween", (BinaryExpression)result);
        return result;
    }

    public Object visitDifferenceBetweenExpression(cqlParser.DifferenceBetweenExpressionContext ctx) {
        DifferenceBetween result = this.of.createDifferenceBetween().withPrecision(this.parseDateTimePrecision(ctx.pluralDateTimePrecision().getText())).withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expressionTerm(0)), this.parseExpression((ParseTree)ctx.expressionTerm(1))});
        this.libraryBuilder.resolveBinaryCall("System", "DifferenceBetween", (BinaryExpression)result);
        return result;
    }

    public Object visitWidthExpressionTerm(cqlParser.WidthExpressionTermContext ctx) {
        Width result = this.of.createWidth().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
        this.libraryBuilder.resolveUnaryCall("System", "Width", (UnaryExpression)result);
        return result;
    }

    public Expression visitParenthesizedTerm(cqlParser.ParenthesizedTermContext ctx) {
        return this.parseExpression((ParseTree)ctx.expression());
    }

    public Object visitMembershipExpression(cqlParser.MembershipExpressionContext ctx) {
        String operator;
        switch (operator = ctx.getChild(1).getText()) {
            case "in": {
                if (ctx.dateTimePrecisionSpecifier() != null) {
                    In in = this.of.createIn().withPrecision(this.parseComparableDateTimePrecision(ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText())).withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
                    this.libraryBuilder.resolveBinaryCall("System", "In", (BinaryExpression)in);
                    return in;
                }
                Expression left = this.parseExpression((ParseTree)ctx.expression(0));
                Expression right = this.parseExpression((ParseTree)ctx.expression(1));
                return this.libraryBuilder.resolveIn(left, right);
            }
            case "contains": {
                if (ctx.dateTimePrecisionSpecifier() != null) {
                    Contains contains = this.of.createContains().withPrecision(this.parseComparableDateTimePrecision(ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText())).withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
                    this.libraryBuilder.resolveBinaryCall("System", "Contains", (BinaryExpression)contains);
                    return contains;
                }
                Expression left = this.parseExpression((ParseTree)ctx.expression(0));
                Expression right = this.parseExpression((ParseTree)ctx.expression(1));
                if (left instanceof ValueSetRef) {
                    InValueSet in = this.of.createInValueSet().withCode(right).withValueset((ValueSetRef)left).withValuesetExpression(left);
                    this.libraryBuilder.resolveCall("System", "InValueSet", new InValueSetInvocation(in));
                    return in;
                }
                if (left instanceof CodeSystemRef) {
                    InCodeSystem in = this.of.createInCodeSystem().withCode(right).withCodesystem((CodeSystemRef)left).withCodesystemExpression(left);
                    this.libraryBuilder.resolveCall("System", "InCodeSystem", new InCodeSystemInvocation(in));
                    return in;
                }
                Contains contains = this.of.createContains().withOperand(new Expression[]{left, right});
                this.libraryBuilder.resolveBinaryCall("System", "Contains", (BinaryExpression)contains);
                return contains;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown operator: %s", operator));
    }

    public And visitAndExpression(cqlParser.AndExpressionContext ctx) {
        And and = this.of.createAnd().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
        this.libraryBuilder.resolveBinaryCall("System", "And", (BinaryExpression)and);
        return and;
    }

    public Expression visitOrExpression(cqlParser.OrExpressionContext ctx) {
        if (ctx.getChild(1).getText().equals("xor")) {
            Xor xor = this.of.createXor().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
            this.libraryBuilder.resolveBinaryCall("System", "Xor", (BinaryExpression)xor);
            return xor;
        }
        Or or = this.of.createOr().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
        this.libraryBuilder.resolveBinaryCall("System", "Or", (BinaryExpression)or);
        return or;
    }

    public Expression visitImpliesExpression(cqlParser.ImpliesExpressionContext ctx) {
        Implies implies = this.of.createImplies().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
        this.libraryBuilder.resolveBinaryCall("System", "Implies", (BinaryExpression)implies);
        return implies;
    }

    public Object visitInFixSetExpression(cqlParser.InFixSetExpressionContext ctx) {
        String operator = ctx.getChild(1).getText();
        Expression left = this.parseExpression((ParseTree)ctx.expression(0));
        Expression right = this.parseExpression((ParseTree)ctx.expression(1));
        switch (operator) {
            case "|": 
            case "union": {
                return this.libraryBuilder.resolveUnion(left, right);
            }
            case "intersect": {
                return this.libraryBuilder.resolveIntersect(left, right);
            }
            case "except": {
                return this.libraryBuilder.resolveExcept(left, right);
            }
        }
        return this.of.createNull();
    }

    public Expression visitEqualityExpression(cqlParser.EqualityExpressionContext ctx) {
        String operator = this.parseString(ctx.getChild(1));
        if (operator.equals("~") || operator.equals("!~")) {
            Equivalent equivalent = this.of.createEquivalent().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
            this.libraryBuilder.resolveBinaryCall("System", "Equivalent", (BinaryExpression)equivalent);
            if (!"~".equals(this.parseString(ctx.getChild(1)))) {
                this.track((Trackable)equivalent, (ParseTree)ctx);
                Not not = this.of.createNot().withOperand((Expression)equivalent);
                this.libraryBuilder.resolveUnaryCall("System", "Not", (UnaryExpression)not);
                return not;
            }
            return equivalent;
        }
        Equal equal = this.of.createEqual().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
        this.libraryBuilder.resolveBinaryCall("System", "Equal", (BinaryExpression)equal);
        if (!"=".equals(this.parseString(ctx.getChild(1)))) {
            this.track((Trackable)equal, (ParseTree)ctx);
            Not not = this.of.createNot().withOperand((Expression)equal);
            this.libraryBuilder.resolveUnaryCall("System", "Not", (UnaryExpression)not);
            return not;
        }
        return equal;
    }

    public BinaryExpression visitInequalityExpression(cqlParser.InequalityExpressionContext ctx) {
        LessOrEqual exp;
        String operatorName;
        switch (this.parseString(ctx.getChild(1))) {
            case "<=": {
                operatorName = "LessOrEqual";
                exp = this.of.createLessOrEqual();
                break;
            }
            case "<": {
                operatorName = "Less";
                exp = this.of.createLess();
                break;
            }
            case ">": {
                operatorName = "Greater";
                exp = this.of.createGreater();
                break;
            }
            case ">=": {
                operatorName = "GreaterOrEqual";
                exp = this.of.createGreaterOrEqual();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown operator: %s", ctx.getChild(1).getText()));
            }
        }
        exp.withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
        this.libraryBuilder.resolveBinaryCall("System", operatorName, (BinaryExpression)exp);
        return exp;
    }

    public List<String> visitQualifiedIdentifier(cqlParser.QualifiedIdentifierContext ctx) {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (cqlParser.QualifierContext qualifierContext : ctx.qualifier()) {
            String qualifier = this.parseString((ParseTree)qualifierContext);
            identifiers.add(qualifier);
        }
        String identifier = this.parseString((ParseTree)ctx.identifier());
        identifiers.add(identifier);
        return identifiers;
    }

    public List<String> visitQualifiedIdentifierExpression(cqlParser.QualifiedIdentifierExpressionContext ctx) {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (cqlParser.QualifierExpressionContext qualifierContext : ctx.qualifierExpression()) {
            String qualifier = this.parseString((ParseTree)qualifierContext);
            identifiers.add(qualifier);
        }
        String identifier = this.parseString((ParseTree)ctx.referentialIdentifier());
        identifiers.add(identifier);
        return identifiers;
    }

    public String visitSimplePathReferentialIdentifier(cqlParser.SimplePathReferentialIdentifierContext ctx) {
        return (String)this.visit((ParseTree)ctx.referentialIdentifier());
    }

    public String visitSimplePathQualifiedIdentifier(cqlParser.SimplePathQualifiedIdentifierContext ctx) {
        return String.valueOf(this.visit((ParseTree)ctx.simplePath())) + "." + String.valueOf(this.visit((ParseTree)ctx.referentialIdentifier()));
    }

    public String visitSimplePathIndexer(cqlParser.SimplePathIndexerContext ctx) {
        return String.valueOf(this.visit((ParseTree)ctx.simplePath())) + "[" + String.valueOf(this.visit((ParseTree)ctx.simpleLiteral())) + "]";
    }

    public Object visitTermExpression(cqlParser.TermExpressionContext ctx) {
        Object result = super.visitTermExpression(ctx);
        if (result instanceof LibraryRef) {
            throw new IllegalArgumentException(String.format("Identifier %s is a library and cannot be used as an expression.", ((LibraryRef)((Object)result)).getLibraryName()));
        }
        return result;
    }

    public Object visitTerminal(TerminalNode node) {
        String text = node.getText();
        int tokenType = node.getSymbol().getType();
        if (-1 == tokenType) {
            return null;
        }
        if (165 == tokenType || 158 == tokenType || 164 == tokenType) {
            text = text.substring(1, text.length() - 1);
        }
        return text;
    }

    public Object visitConversionExpressionTerm(cqlParser.ConversionExpressionTermContext ctx) {
        if (ctx.typeSpecifier() != null) {
            TypeSpecifier targetType = this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier());
            Expression operand = this.parseExpression((ParseTree)ctx.expression());
            if (!DataTypes.equal(operand.getResultType(), targetType.getResultType())) {
                Conversion conversion = this.libraryBuilder.findConversion(operand.getResultType(), targetType.getResultType(), false, true);
                if (conversion == null) {
                    throw new IllegalArgumentException(String.format("Could not resolve conversion from type %s to type %s.", operand.getResultType(), targetType.getResultType()));
                }
                return this.libraryBuilder.convertExpression(operand, conversion);
            }
            return operand;
        }
        String targetUnit = this.parseString((ParseTree)ctx.unit());
        targetUnit = this.libraryBuilder.ensureUcumUnit(targetUnit);
        Expression operand = this.parseExpression((ParseTree)ctx.expression());
        Literal unitOperand = this.libraryBuilder.createLiteral(targetUnit);
        this.track((Trackable)unitOperand, (ParseTree)ctx.unit());
        ConvertQuantity convertQuantity = this.of.createConvertQuantity().withOperand(new Expression[]{operand, unitOperand});
        this.track((Trackable)convertQuantity, (ParseTree)ctx);
        return this.libraryBuilder.resolveBinaryCall("System", "ConvertQuantity", (BinaryExpression)convertQuantity);
    }

    public Object visitTypeExpression(cqlParser.TypeExpressionContext ctx) {
        if (ctx.getChild(1).getText().equals("is")) {
            Is is = this.of.createIs().withOperand(this.parseExpression((ParseTree)ctx.expression())).withIsTypeSpecifier(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier()));
            is.setResultType(this.libraryBuilder.resolveTypeName("System", "Boolean"));
            return is;
        }
        As as = this.of.createAs().withOperand(this.parseExpression((ParseTree)ctx.expression())).withAsTypeSpecifier(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier())).withStrict(Boolean.valueOf(false));
        DataType targetType = as.getAsTypeSpecifier().getResultType();
        DataTypes.verifyCast(targetType, as.getOperand().getResultType());
        as.setResultType(targetType);
        return as;
    }

    public Object visitCastExpression(cqlParser.CastExpressionContext ctx) {
        As as = this.of.createAs().withOperand(this.parseExpression((ParseTree)ctx.expression())).withAsTypeSpecifier(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier())).withStrict(Boolean.valueOf(true));
        DataType targetType = as.getAsTypeSpecifier().getResultType();
        DataTypes.verifyCast(targetType, as.getOperand().getResultType());
        as.setResultType(targetType);
        return as;
    }

    public Expression visitBooleanExpression(cqlParser.BooleanExpressionContext ctx) {
        IsNull exp = null;
        Expression left = (Expression)this.visit((ParseTree)ctx.expression());
        String lastChild = ctx.getChild(ctx.getChildCount() - 1).getText();
        String nextToLast = ctx.getChild(ctx.getChildCount() - 2).getText();
        switch (lastChild) {
            case "null": {
                exp = this.of.createIsNull().withOperand(left);
                this.libraryBuilder.resolveUnaryCall("System", "IsNull", (UnaryExpression)exp);
                break;
            }
            case "true": {
                exp = this.of.createIsTrue().withOperand(left);
                this.libraryBuilder.resolveUnaryCall("System", "IsTrue", (UnaryExpression)exp);
                break;
            }
            case "false": {
                exp = this.of.createIsFalse().withOperand(left);
                this.libraryBuilder.resolveUnaryCall("System", "IsFalse", (UnaryExpression)exp);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown boolean test predicate %s.", lastChild));
            }
        }
        if ("not".equals(nextToLast)) {
            this.track((Trackable)exp, (ParseTree)ctx);
            exp = this.of.createNot().withOperand((Expression)exp);
            this.libraryBuilder.resolveUnaryCall("System", "Not", (UnaryExpression)exp);
        }
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitTimingExpression(cqlParser.TimingExpressionContext ctx) {
        Expression left = this.parseExpression((ParseTree)ctx.expression(0));
        Expression right = this.parseExpression((ParseTree)ctx.expression(1));
        TimingOperatorContext timingOperatorContext = new TimingOperatorContext(left, right);
        this.timingOperators.push(timingOperatorContext);
        try {
            Object object = this.visit((ParseTree)ctx.intervalOperatorPhrase());
            return object;
        }
        finally {
            this.timingOperators.pop();
        }
    }

    public Object visitConcurrentWithIntervalOperatorPhrase(cqlParser.ConcurrentWithIntervalOperatorPhraseContext ctx) {
        ParseTree lastChild;
        TimingOperatorContext timingOperator = this.timingOperators.peek();
        ParseTree firstChild = ctx.getChild(0);
        if ("starts".equals(firstChild.getText())) {
            Start start = this.of.createStart().withOperand(timingOperator.getLeft());
            this.track((Trackable)start, firstChild);
            this.libraryBuilder.resolveUnaryCall("System", "Start", (UnaryExpression)start);
            timingOperator.setLeft((Expression)start);
        }
        if ("ends".equals(firstChild.getText())) {
            End end = this.of.createEnd().withOperand(timingOperator.getLeft());
            this.track((Trackable)end, firstChild);
            this.libraryBuilder.resolveUnaryCall("System", "End", (UnaryExpression)end);
            timingOperator.setLeft((Expression)end);
        }
        if ("start".equals((lastChild = ctx.getChild(ctx.getChildCount() - 1)).getText())) {
            Start start = this.of.createStart().withOperand(timingOperator.getRight());
            this.track((Trackable)start, lastChild);
            this.libraryBuilder.resolveUnaryCall("System", "Start", (UnaryExpression)start);
            timingOperator.setRight((Expression)start);
        }
        if ("end".equals(lastChild.getText())) {
            End end = this.of.createEnd().withOperand(timingOperator.getRight());
            this.track((Trackable)end, lastChild);
            this.libraryBuilder.resolveUnaryCall("System", "End", (UnaryExpression)end);
            timingOperator.setRight((Expression)end);
        }
        String operatorName = null;
        SameAs operator = null;
        boolean allowPromotionAndDemotion = false;
        if (ctx.relativeQualifier() == null) {
            operator = ctx.dateTimePrecision() != null ? this.of.createSameAs().withPrecision(this.parseComparableDateTimePrecision(ctx.dateTimePrecision().getText())) : this.of.createSameAs();
            operatorName = "SameAs";
        } else {
            switch (ctx.relativeQualifier().getText()) {
                case "or after": {
                    operator = ctx.dateTimePrecision() != null ? this.of.createSameOrAfter().withPrecision(this.parseComparableDateTimePrecision(ctx.dateTimePrecision().getText())) : this.of.createSameOrAfter();
                    operatorName = "SameOrAfter";
                    allowPromotionAndDemotion = true;
                    break;
                }
                case "or before": {
                    operator = ctx.dateTimePrecision() != null ? this.of.createSameOrBefore().withPrecision(this.parseComparableDateTimePrecision(ctx.dateTimePrecision().getText())) : this.of.createSameOrBefore();
                    operatorName = "SameOrBefore";
                    allowPromotionAndDemotion = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown relative qualifier: '%s'.", ctx.relativeQualifier().getText()));
                }
            }
        }
        operator = operator.withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
        this.libraryBuilder.resolveBinaryCall("System", operatorName, (BinaryExpression)operator, true, allowPromotionAndDemotion);
        return operator;
    }

    public Object visitIncludesIntervalOperatorPhrase(cqlParser.IncludesIntervalOperatorPhraseContext ctx) {
        String dateTimePrecision;
        boolean isProper = false;
        boolean isRightPoint = false;
        TimingOperatorContext timingOperator = this.timingOperators.peek();
        for (ParseTree pt : ctx.children) {
            if ("properly".equals(pt.getText())) {
                isProper = true;
                continue;
            }
            if ("start".equals(pt.getText())) {
                Start start = this.of.createStart().withOperand(timingOperator.getRight());
                this.track((Trackable)start, pt);
                this.libraryBuilder.resolveUnaryCall("System", "Start", (UnaryExpression)start);
                timingOperator.setRight((Expression)start);
                isRightPoint = true;
                continue;
            }
            if (!"end".equals(pt.getText())) continue;
            End end = this.of.createEnd().withOperand(timingOperator.getRight());
            this.track((Trackable)end, pt);
            this.libraryBuilder.resolveUnaryCall("System", "End", (UnaryExpression)end);
            timingOperator.setRight((Expression)end);
            isRightPoint = true;
        }
        String string = dateTimePrecision = ctx.dateTimePrecisionSpecifier() != null ? ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText() : null;
        if (isRightPoint) {
            if (isProper) {
                return this.libraryBuilder.resolveProperContains(timingOperator.getLeft(), timingOperator.getRight(), this.parseComparableDateTimePrecision(dateTimePrecision, false));
            }
            return this.libraryBuilder.resolveContains(timingOperator.getLeft(), timingOperator.getRight(), this.parseComparableDateTimePrecision(dateTimePrecision, false));
        }
        if (isProper) {
            return this.libraryBuilder.resolveProperIncludes(timingOperator.getLeft(), timingOperator.getRight(), this.parseComparableDateTimePrecision(dateTimePrecision, false));
        }
        return this.libraryBuilder.resolveIncludes(timingOperator.getLeft(), timingOperator.getRight(), this.parseComparableDateTimePrecision(dateTimePrecision, false));
    }

    public Object visitIncludedInIntervalOperatorPhrase(cqlParser.IncludedInIntervalOperatorPhraseContext ctx) {
        String dateTimePrecision;
        boolean isProper = false;
        boolean isLeftPoint = false;
        TimingOperatorContext timingOperator = this.timingOperators.peek();
        for (ParseTree pt : ctx.children) {
            if ("starts".equals(pt.getText())) {
                Start start = this.of.createStart().withOperand(timingOperator.getLeft());
                this.track((Trackable)start, pt);
                this.libraryBuilder.resolveUnaryCall("System", "Start", (UnaryExpression)start);
                timingOperator.setLeft((Expression)start);
                isLeftPoint = true;
                continue;
            }
            if ("ends".equals(pt.getText())) {
                End end = this.of.createEnd().withOperand(timingOperator.getLeft());
                this.track((Trackable)end, pt);
                this.libraryBuilder.resolveUnaryCall("System", "End", (UnaryExpression)end);
                timingOperator.setLeft((Expression)end);
                isLeftPoint = true;
                continue;
            }
            if (!"properly".equals(pt.getText())) continue;
            isProper = true;
        }
        String string = dateTimePrecision = ctx.dateTimePrecisionSpecifier() != null ? ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText() : null;
        if (isLeftPoint) {
            if (isProper) {
                return this.libraryBuilder.resolveProperIn(timingOperator.getLeft(), timingOperator.getRight(), this.parseComparableDateTimePrecision(dateTimePrecision, false));
            }
            return this.libraryBuilder.resolveIn(timingOperator.getLeft(), timingOperator.getRight(), this.parseComparableDateTimePrecision(dateTimePrecision, false));
        }
        if (isProper) {
            return this.libraryBuilder.resolveProperIncludedIn(timingOperator.getLeft(), timingOperator.getRight(), this.parseComparableDateTimePrecision(dateTimePrecision, false));
        }
        return this.libraryBuilder.resolveIncludedIn(timingOperator.getLeft(), timingOperator.getRight(), this.parseComparableDateTimePrecision(dateTimePrecision, false));
    }

    public Object visitBeforeOrAfterIntervalOperatorPhrase(cqlParser.BeforeOrAfterIntervalOperatorPhraseContext ctx) {
        String qualifier;
        String dateTimePrecision;
        End end;
        Start start;
        TimingOperatorContext timingOperator = this.timingOperators.peek();
        boolean isBefore = false;
        boolean isInclusive = false;
        for (ParseTree child : ctx.children) {
            if ("starts".equals(child.getText())) {
                start = this.of.createStart().withOperand(timingOperator.getLeft());
                this.track((Trackable)start, child);
                this.libraryBuilder.resolveUnaryCall("System", "Start", (UnaryExpression)start);
                timingOperator.setLeft((Expression)start);
                continue;
            }
            if ("ends".equals(child.getText())) {
                end = this.of.createEnd().withOperand(timingOperator.getLeft());
                this.track((Trackable)end, child);
                this.libraryBuilder.resolveUnaryCall("System", "End", (UnaryExpression)end);
                timingOperator.setLeft((Expression)end);
                continue;
            }
            if ("start".equals(child.getText())) {
                start = this.of.createStart().withOperand(timingOperator.getRight());
                this.track((Trackable)start, child);
                this.libraryBuilder.resolveUnaryCall("System", "Start", (UnaryExpression)start);
                timingOperator.setRight((Expression)start);
                continue;
            }
            if (!"end".equals(child.getText())) continue;
            end = this.of.createEnd().withOperand(timingOperator.getRight());
            this.track((Trackable)end, child);
            this.libraryBuilder.resolveUnaryCall("System", "End", (UnaryExpression)end);
            timingOperator.setRight((Expression)end);
        }
        for (ParseTree child : ctx.temporalRelationship().children) {
            if ("before".equals(child.getText())) {
                isBefore = true;
                continue;
            }
            if (!"on or".equals(child.getText()) && !"or on".equals(child.getText())) continue;
            isInclusive = true;
        }
        String string = dateTimePrecision = ctx.dateTimePrecisionSpecifier() != null ? ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText() : null;
        if (ctx.quantityOffset() == null) {
            if (isInclusive) {
                if (isBefore) {
                    SameOrBefore sameOrBefore = this.of.createSameOrBefore().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                    if (dateTimePrecision != null) {
                        sameOrBefore.setPrecision(this.parseComparableDateTimePrecision(dateTimePrecision));
                    }
                    this.libraryBuilder.resolveBinaryCall("System", "SameOrBefore", (BinaryExpression)sameOrBefore, true, true);
                    return sameOrBefore;
                }
                SameOrAfter sameOrAfter = this.of.createSameOrAfter().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                if (dateTimePrecision != null) {
                    sameOrAfter.setPrecision(this.parseComparableDateTimePrecision(dateTimePrecision));
                }
                this.libraryBuilder.resolveBinaryCall("System", "SameOrAfter", (BinaryExpression)sameOrAfter, true, true);
                return sameOrAfter;
            }
            if (isBefore) {
                Before before = this.of.createBefore().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                if (dateTimePrecision != null) {
                    before.setPrecision(this.parseComparableDateTimePrecision(dateTimePrecision));
                }
                this.libraryBuilder.resolveBinaryCall("System", "Before", (BinaryExpression)before, true, true);
                return before;
            }
            After after = this.of.createAfter().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
            if (dateTimePrecision != null) {
                after.setPrecision(this.parseComparableDateTimePrecision(dateTimePrecision));
            }
            this.libraryBuilder.resolveBinaryCall("System", "After", (BinaryExpression)after, true, true);
            return after;
        }
        Quantity quantity = (Quantity)this.visit((ParseTree)ctx.quantityOffset().quantity());
        if (timingOperator.getLeft().getResultType() instanceof IntervalType) {
            if (isBefore) {
                end = this.of.createEnd().withOperand(timingOperator.getLeft());
                this.track((Trackable)end, (Element)timingOperator.getLeft());
                this.libraryBuilder.resolveUnaryCall("System", "End", (UnaryExpression)end);
                timingOperator.setLeft((Expression)end);
            } else {
                start = this.of.createStart().withOperand(timingOperator.getLeft());
                this.track((Trackable)start, (Element)timingOperator.getLeft());
                this.libraryBuilder.resolveUnaryCall("System", "Start", (UnaryExpression)start);
                timingOperator.setLeft((Expression)start);
            }
        }
        if (timingOperator.getRight().getResultType() instanceof IntervalType) {
            if (isBefore) {
                start = this.of.createStart().withOperand(timingOperator.getRight());
                this.track((Trackable)start, (Element)timingOperator.getRight());
                this.libraryBuilder.resolveUnaryCall("System", "Start", (UnaryExpression)start);
                timingOperator.setRight((Expression)start);
            } else {
                end = this.of.createEnd().withOperand(timingOperator.getRight());
                this.track((Trackable)end, (Element)timingOperator.getRight());
                this.libraryBuilder.resolveUnaryCall("System", "End", (UnaryExpression)end);
                timingOperator.setRight((Expression)end);
            }
        }
        if (ctx.quantityOffset().offsetRelativeQualifier() == null && ctx.quantityOffset().exclusiveRelativeQualifier() == null) {
            if (isBefore) {
                Subtract subtract = this.of.createSubtract().withOperand(new Expression[]{timingOperator.getRight(), quantity});
                this.track((Trackable)subtract, (Element)timingOperator.getRight());
                this.libraryBuilder.resolveBinaryCall("System", "Subtract", (BinaryExpression)subtract);
                timingOperator.setRight((Expression)subtract);
            } else {
                Add add = this.of.createAdd().withOperand(new Expression[]{timingOperator.getRight(), quantity});
                this.track((Trackable)add, (Element)timingOperator.getRight());
                this.libraryBuilder.resolveBinaryCall("System", "Add", (BinaryExpression)add);
                timingOperator.setRight((Expression)add);
            }
            SameAs sameAs = this.of.createSameAs().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
            if (dateTimePrecision != null) {
                sameAs.setPrecision(this.parseComparableDateTimePrecision(dateTimePrecision));
            }
            this.libraryBuilder.resolveBinaryCall("System", "SameAs", (BinaryExpression)sameAs);
            return sameAs;
        }
        boolean isOffsetInclusive = ctx.quantityOffset().offsetRelativeQualifier() != null;
        switch (qualifier = ctx.quantityOffset().offsetRelativeQualifier() != null ? ctx.quantityOffset().offsetRelativeQualifier().getText() : ctx.quantityOffset().exclusiveRelativeQualifier().getText()) {
            case "more than": 
            case "or more": {
                if (isBefore) {
                    Subtract subtract = this.of.createSubtract().withOperand(new Expression[]{timingOperator.getRight(), quantity});
                    this.track((Trackable)subtract, (Element)timingOperator.getRight());
                    this.libraryBuilder.resolveBinaryCall("System", "Subtract", (BinaryExpression)subtract);
                    timingOperator.setRight((Expression)subtract);
                    if (!isOffsetInclusive) {
                        Before before = this.of.createBefore().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                        if (dateTimePrecision != null) {
                            before.setPrecision(this.parseComparableDateTimePrecision(dateTimePrecision));
                        }
                        this.libraryBuilder.resolveBinaryCall("System", "Before", (BinaryExpression)before, true, true);
                        return before;
                    }
                    SameOrBefore sameOrBefore = this.of.createSameOrBefore().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                    if (dateTimePrecision != null) {
                        sameOrBefore.setPrecision(this.parseComparableDateTimePrecision(dateTimePrecision));
                    }
                    this.libraryBuilder.resolveBinaryCall("System", "SameOrBefore", (BinaryExpression)sameOrBefore, true, true);
                    return sameOrBefore;
                }
                Add add = this.of.createAdd().withOperand(new Expression[]{timingOperator.getRight(), quantity});
                this.track((Trackable)add, (Element)timingOperator.getRight());
                this.libraryBuilder.resolveBinaryCall("System", "Add", (BinaryExpression)add);
                timingOperator.setRight((Expression)add);
                if (!isOffsetInclusive) {
                    After after = this.of.createAfter().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                    if (dateTimePrecision != null) {
                        after.setPrecision(this.parseComparableDateTimePrecision(dateTimePrecision));
                    }
                    this.libraryBuilder.resolveBinaryCall("System", "After", (BinaryExpression)after, true, true);
                    return after;
                }
                SameOrAfter sameOrAfter = this.of.createSameOrAfter().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                if (dateTimePrecision != null) {
                    sameOrAfter.setPrecision(this.parseComparableDateTimePrecision(dateTimePrecision));
                }
                this.libraryBuilder.resolveBinaryCall("System", "SameOrAfter", (BinaryExpression)sameOrAfter, true, true);
                return sameOrAfter;
            }
            case "less than": 
            case "or less": {
                Expression lowerBound = null;
                Add upperBound = null;
                Expression right = timingOperator.getRight();
                if (isBefore) {
                    lowerBound = this.of.createSubtract().withOperand(new Expression[]{right, quantity});
                    this.track((Trackable)lowerBound, (Element)right);
                    this.libraryBuilder.resolveBinaryCall("System", "Subtract", (BinaryExpression)lowerBound);
                    upperBound = right;
                } else {
                    lowerBound = right;
                    upperBound = this.of.createAdd().withOperand(new Expression[]{right, quantity});
                    this.track((Trackable)upperBound, (Element)right);
                    this.libraryBuilder.resolveBinaryCall("System", "Add", (BinaryExpression)upperBound);
                }
                Interval interval = isBefore ? this.libraryBuilder.createInterval(lowerBound, isOffsetInclusive, (Expression)upperBound, isInclusive) : this.libraryBuilder.createInterval(lowerBound, isInclusive, (Expression)upperBound, isOffsetInclusive);
                this.track((Trackable)interval, (ParseTree)ctx.quantityOffset());
                In in = this.of.createIn().withOperand(new Expression[]{timingOperator.getLeft(), interval});
                if (dateTimePrecision != null) {
                    in.setPrecision(this.parseComparableDateTimePrecision(dateTimePrecision));
                }
                this.track((Trackable)in, (ParseTree)ctx.quantityOffset());
                this.libraryBuilder.resolveBinaryCall("System", "In", (BinaryExpression)in);
                if (isOffsetInclusive || isInclusive) {
                    IsNull nullTest = this.of.createIsNull().withOperand(right);
                    this.track((Trackable)nullTest, (ParseTree)ctx.quantityOffset());
                    this.libraryBuilder.resolveUnaryCall("System", "IsNull", (UnaryExpression)nullTest);
                    Not notNullTest = this.of.createNot().withOperand((Expression)nullTest);
                    this.track((Trackable)notNullTest, (ParseTree)ctx.quantityOffset());
                    this.libraryBuilder.resolveUnaryCall("System", "Not", (UnaryExpression)notNullTest);
                    And and = this.of.createAnd().withOperand(new Expression[]{in, notNullTest});
                    this.track((Trackable)and, (ParseTree)ctx.quantityOffset());
                    this.libraryBuilder.resolveBinaryCall("System", "And", (BinaryExpression)and);
                    return and;
                }
                return in;
            }
        }
        throw new IllegalArgumentException("Unable to resolve interval operator phrase.");
    }

    private BinaryExpression resolveBetweenOperator(String unit, Expression left, Expression right) {
        if (unit != null) {
            DurationBetween between = this.of.createDurationBetween().withPrecision(this.parseDateTimePrecision(unit)).withOperand(new Expression[]{left, right});
            this.libraryBuilder.resolveBinaryCall("System", "DurationBetween", (BinaryExpression)between);
            return between;
        }
        return null;
    }

    public Object visitWithinIntervalOperatorPhrase(cqlParser.WithinIntervalOperatorPhraseContext ctx) {
        TimingOperatorContext timingOperator = this.timingOperators.peek();
        boolean isProper = false;
        for (ParseTree child : ctx.children) {
            End end;
            Start start;
            if ("starts".equals(child.getText())) {
                start = this.of.createStart().withOperand(timingOperator.getLeft());
                this.track((Trackable)start, child);
                this.libraryBuilder.resolveUnaryCall("System", "Start", (UnaryExpression)start);
                timingOperator.setLeft((Expression)start);
                continue;
            }
            if ("ends".equals(child.getText())) {
                end = this.of.createEnd().withOperand(timingOperator.getLeft());
                this.track((Trackable)end, child);
                this.libraryBuilder.resolveUnaryCall("System", "End", (UnaryExpression)end);
                timingOperator.setLeft((Expression)end);
                continue;
            }
            if ("start".equals(child.getText())) {
                start = this.of.createStart().withOperand(timingOperator.getRight());
                this.track((Trackable)start, child);
                this.libraryBuilder.resolveUnaryCall("System", "Start", (UnaryExpression)start);
                timingOperator.setRight((Expression)start);
                continue;
            }
            if ("end".equals(child.getText())) {
                end = this.of.createEnd().withOperand(timingOperator.getRight());
                this.track((Trackable)end, child);
                this.libraryBuilder.resolveUnaryCall("System", "End", (UnaryExpression)end);
                timingOperator.setRight((Expression)end);
                continue;
            }
            if (!"properly".equals(child.getText())) continue;
            isProper = true;
        }
        Quantity quantity = (Quantity)this.visit((ParseTree)ctx.quantity());
        Expression lowerBound = null;
        Expression upperBound = null;
        Expression initialBound = null;
        if (timingOperator.getRight().getResultType() instanceof IntervalType) {
            lowerBound = this.of.createStart().withOperand(timingOperator.getRight());
            this.track((Trackable)lowerBound, (ParseTree)ctx.quantity());
            this.libraryBuilder.resolveUnaryCall("System", "Start", (UnaryExpression)((Start)lowerBound));
            upperBound = this.of.createEnd().withOperand(timingOperator.getRight());
            this.track((Trackable)upperBound, (ParseTree)ctx.quantity());
            this.libraryBuilder.resolveUnaryCall("System", "End", (UnaryExpression)((End)upperBound));
        } else {
            lowerBound = timingOperator.getRight();
            upperBound = timingOperator.getRight();
            initialBound = lowerBound;
        }
        lowerBound = this.of.createSubtract().withOperand(new Expression[]{lowerBound, quantity});
        this.track((Trackable)lowerBound, (ParseTree)ctx.quantity());
        this.libraryBuilder.resolveBinaryCall("System", "Subtract", (BinaryExpression)lowerBound);
        upperBound = this.of.createAdd().withOperand(new Expression[]{upperBound, quantity});
        this.track((Trackable)upperBound, (ParseTree)ctx.quantity());
        this.libraryBuilder.resolveBinaryCall("System", "Add", (BinaryExpression)upperBound);
        Interval interval = this.libraryBuilder.createInterval(lowerBound, !isProper, upperBound, !isProper);
        this.track((Trackable)interval, (ParseTree)ctx.quantity());
        In in = this.of.createIn().withOperand(new Expression[]{timingOperator.getLeft(), interval});
        this.libraryBuilder.resolveBinaryCall("System", "In", (BinaryExpression)in);
        if (!isProper && initialBound != null) {
            IsNull nullTest = this.of.createIsNull().withOperand(initialBound);
            this.track((Trackable)nullTest, (ParseTree)ctx.quantity());
            this.libraryBuilder.resolveUnaryCall("System", "IsNull", (UnaryExpression)nullTest);
            Not notNullTest = this.of.createNot().withOperand((Expression)nullTest);
            this.track((Trackable)notNullTest, (ParseTree)ctx.quantity());
            this.libraryBuilder.resolveUnaryCall("System", "Not", (UnaryExpression)notNullTest);
            And and = this.of.createAnd().withOperand(new Expression[]{in, notNullTest});
            this.track((Trackable)and, (ParseTree)ctx.quantity());
            this.libraryBuilder.resolveBinaryCall("System", "And", (BinaryExpression)and);
            return and;
        }
        return in;
    }

    public Object visitMeetsIntervalOperatorPhrase(cqlParser.MeetsIntervalOperatorPhraseContext ctx) {
        Meets operator;
        String operatorName = null;
        String dateTimePrecision = ctx.dateTimePrecisionSpecifier() != null ? ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText() : null;
        if (ctx.getChildCount() == 1 + (dateTimePrecision == null ? 0 : 1)) {
            operator = dateTimePrecision != null ? this.of.createMeets().withPrecision(this.parseComparableDateTimePrecision(dateTimePrecision)) : this.of.createMeets();
            operatorName = "Meets";
        } else if ("before".equals(ctx.getChild(1).getText())) {
            operator = dateTimePrecision != null ? this.of.createMeetsBefore().withPrecision(this.parseComparableDateTimePrecision(dateTimePrecision)) : this.of.createMeetsBefore();
            operatorName = "MeetsBefore";
        } else {
            operator = dateTimePrecision != null ? this.of.createMeetsAfter().withPrecision(this.parseComparableDateTimePrecision(dateTimePrecision)) : this.of.createMeetsAfter();
            operatorName = "MeetsAfter";
        }
        operator.withOperand(new Expression[]{this.timingOperators.peek().getLeft(), this.timingOperators.peek().getRight()});
        this.libraryBuilder.resolveBinaryCall("System", operatorName, (BinaryExpression)operator);
        return operator;
    }

    public Object visitOverlapsIntervalOperatorPhrase(cqlParser.OverlapsIntervalOperatorPhraseContext ctx) {
        Overlaps operator;
        String operatorName = null;
        String dateTimePrecision = ctx.dateTimePrecisionSpecifier() != null ? ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText() : null;
        if (ctx.getChildCount() == 1 + (dateTimePrecision == null ? 0 : 1)) {
            operator = dateTimePrecision != null ? this.of.createOverlaps().withPrecision(this.parseComparableDateTimePrecision(dateTimePrecision)) : this.of.createOverlaps();
            operatorName = "Overlaps";
        } else if ("before".equals(ctx.getChild(1).getText())) {
            operator = dateTimePrecision != null ? this.of.createOverlapsBefore().withPrecision(this.parseComparableDateTimePrecision(dateTimePrecision)) : this.of.createOverlapsBefore();
            operatorName = "OverlapsBefore";
        } else {
            operator = dateTimePrecision != null ? this.of.createOverlapsAfter().withPrecision(this.parseComparableDateTimePrecision(dateTimePrecision)) : this.of.createOverlapsAfter();
            operatorName = "OverlapsAfter";
        }
        operator.withOperand(new Expression[]{this.timingOperators.peek().getLeft(), this.timingOperators.peek().getRight()});
        this.libraryBuilder.resolveBinaryCall("System", operatorName, (BinaryExpression)operator);
        return operator;
    }

    public Object visitStartsIntervalOperatorPhrase(cqlParser.StartsIntervalOperatorPhraseContext ctx) {
        String dateTimePrecision = ctx.dateTimePrecisionSpecifier() != null ? ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText() : null;
        Starts starts = (dateTimePrecision != null ? this.of.createStarts().withPrecision(this.parseComparableDateTimePrecision(dateTimePrecision)) : this.of.createStarts()).withOperand(new Expression[]{this.timingOperators.peek().getLeft(), this.timingOperators.peek().getRight()});
        this.libraryBuilder.resolveBinaryCall("System", "Starts", (BinaryExpression)starts);
        return starts;
    }

    public Object visitEndsIntervalOperatorPhrase(cqlParser.EndsIntervalOperatorPhraseContext ctx) {
        String dateTimePrecision = ctx.dateTimePrecisionSpecifier() != null ? ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText() : null;
        Ends ends = (dateTimePrecision != null ? this.of.createEnds().withPrecision(this.parseComparableDateTimePrecision(dateTimePrecision)) : this.of.createEnds()).withOperand(new Expression[]{this.timingOperators.peek().getLeft(), this.timingOperators.peek().getRight()});
        this.libraryBuilder.resolveBinaryCall("System", "Ends", (BinaryExpression)ends);
        return ends;
    }

    public Expression resolveIfThenElse(If ifObject) {
        ifObject.setCondition(this.libraryBuilder.ensureCompatible(ifObject.getCondition(), this.libraryBuilder.resolveTypeName("System", "Boolean")));
        DataType resultType = this.libraryBuilder.ensureCompatibleTypes(ifObject.getThen().getResultType(), ifObject.getElse().getResultType());
        ifObject.setResultType(resultType);
        ifObject.setThen(this.libraryBuilder.ensureCompatible(ifObject.getThen(), resultType));
        ifObject.setElse(this.libraryBuilder.ensureCompatible(ifObject.getElse(), resultType));
        return ifObject;
    }

    public Object visitIfThenElseExpressionTerm(cqlParser.IfThenElseExpressionTermContext ctx) {
        If ifObject = this.of.createIf().withCondition(this.parseExpression((ParseTree)ctx.expression(0))).withThen(this.parseExpression((ParseTree)ctx.expression(1))).withElse(this.parseExpression((ParseTree)ctx.expression(2)));
        return this.resolveIfThenElse(ifObject);
    }

    public Object visitCaseExpressionTerm(cqlParser.CaseExpressionTermContext ctx) {
        Case result = this.of.createCase();
        Boolean hitElse = false;
        DataType resultType = null;
        for (ParseTree pt : ctx.children) {
            if ("else".equals(pt.getText())) {
                hitElse = true;
                continue;
            }
            if (pt instanceof cqlParser.ExpressionContext) {
                if (hitElse.booleanValue()) {
                    result.setElse(this.parseExpression(pt));
                    resultType = this.libraryBuilder.ensureCompatibleTypes(resultType, result.getElse().getResultType());
                } else {
                    result.setComparand(this.parseExpression(pt));
                }
            }
            if (!(pt instanceof cqlParser.CaseExpressionItemContext)) continue;
            CaseItem caseItem = (CaseItem)this.visit(pt);
            if (result.getComparand() != null) {
                this.libraryBuilder.verifyType(caseItem.getWhen().getResultType(), result.getComparand().getResultType());
            } else {
                DataTypes.verifyType(caseItem.getWhen().getResultType(), this.libraryBuilder.resolveTypeName("System", "Boolean"));
            }
            resultType = resultType == null ? caseItem.getThen().getResultType() : this.libraryBuilder.ensureCompatibleTypes(resultType, caseItem.getThen().getResultType());
            result.getCaseItem().add(caseItem);
        }
        for (CaseItem caseItem : result.getCaseItem()) {
            if (result.getComparand() != null) {
                caseItem.setWhen(this.libraryBuilder.ensureCompatible(caseItem.getWhen(), result.getComparand().getResultType()));
            }
            caseItem.setThen(this.libraryBuilder.ensureCompatible(caseItem.getThen(), resultType));
        }
        result.setElse(this.libraryBuilder.ensureCompatible(result.getElse(), resultType));
        result.setResultType(resultType);
        return result;
    }

    public Object visitCaseExpressionItem(cqlParser.CaseExpressionItemContext ctx) {
        return this.of.createCaseItem().withWhen(this.parseExpression((ParseTree)ctx.expression(0))).withThen(this.parseExpression((ParseTree)ctx.expression(1)));
    }

    public Object visitAggregateExpressionTerm(cqlParser.AggregateExpressionTermContext ctx) {
        switch (ctx.getChild(0).getText()) {
            case "distinct": {
                Distinct distinct = this.of.createDistinct().withOperand(this.parseExpression((ParseTree)ctx.expression()));
                this.libraryBuilder.resolveUnaryCall("System", "Distinct", (UnaryExpression)distinct);
                return distinct;
            }
            case "flatten": {
                Flatten flatten = this.of.createFlatten().withOperand(this.parseExpression((ParseTree)ctx.expression()));
                this.libraryBuilder.resolveUnaryCall("System", "Flatten", (UnaryExpression)flatten);
                return flatten;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown aggregate operator %s.", ctx.getChild(0).getText()));
    }

    public Object visitSetAggregateExpressionTerm(cqlParser.SetAggregateExpressionTermContext ctx) {
        Expression source = this.parseExpression((ParseTree)ctx.expression(0));
        Quantity per = null;
        if (ctx.dateTimePrecision() != null) {
            per = this.libraryBuilder.createQuantity(BigDecimal.valueOf(1.0), this.parseString((ParseTree)ctx.dateTimePrecision()));
        } else if (ctx.expression().size() > 1) {
            per = this.parseExpression((ParseTree)ctx.expression(1));
        } else if (source.getResultType() instanceof ListType) {
            ListType listType = (ListType)source.getResultType();
            if (listType.getElementType() instanceof IntervalType) {
                IntervalType intervalType = (IntervalType)listType.getElementType();
                DataType pointType = intervalType.getPointType();
                per = this.libraryBuilder.buildNull(this.libraryBuilder.resolveTypeName("System", "Quantity"));
            }
        } else {
            per = this.libraryBuilder.buildNull(this.libraryBuilder.resolveTypeName("System", "Quantity"));
        }
        switch (ctx.getChild(0).getText()) {
            case "expand": {
                Expand expand = this.of.createExpand().withOperand(new Expression[]{source, per});
                this.libraryBuilder.resolveBinaryCall("System", "Expand", (BinaryExpression)expand);
                return expand;
            }
            case "collapse": {
                Collapse collapse = this.of.createCollapse().withOperand(new Expression[]{source, per});
                this.libraryBuilder.resolveBinaryCall("System", "Collapse", (BinaryExpression)collapse);
                return collapse;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown aggregate set operator %s.", ctx.getChild(0).getText()));
    }

    public Expression visitRetrieve(cqlParser.RetrieveContext ctx) {
        boolean hasFHIRHelpers;
        this.libraryBuilder.checkLiteralContext();
        List<String> qualifiers = this.parseQualifiers(ctx.namedTypeSpecifier());
        String model = Cql2ElmVisitor.getModelIdentifier(qualifiers);
        String label = Cql2ElmVisitor.getTypeIdentifier(qualifiers, this.parseString((ParseTree)ctx.namedTypeSpecifier().referentialOrTypeNameIdentifier()));
        DataType dataType = this.libraryBuilder.resolveTypeName(model, label);
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Could not resolve type name %s.", label));
        }
        if (!(dataType instanceof ClassType) || !((ClassType)dataType).isRetrievable()) {
            throw new IllegalArgumentException(String.format("Specified data type %s does not support retrieval.", label));
        }
        ClassType classType = (ClassType)dataType;
        ClassType namedType = classType;
        ModelInfo modelInfo = this.libraryBuilder.getModel(namedType.getNamespace()).getModelInfo();
        boolean useStrictRetrieveTyping = modelInfo.isStrictRetrieveTyping() != null && modelInfo.isStrictRetrieveTyping() != false;
        String codePath = null;
        Property property = null;
        CqlSemanticException propertyException = null;
        Expression terminology = null;
        String codeComparator = null;
        if (ctx.terminology() != null) {
            Object identifiers;
            if (ctx.codePath() != null) {
                identifiers = (String)this.visit((ParseTree)ctx.codePath());
                codePath = identifiers;
            } else if (classType.getPrimaryCodePath() != null) {
                codePath = classType.getPrimaryCodePath();
            }
            if (codePath == null) {
                propertyException = new CqlSemanticException("Retrieve has a terminology target but does not specify a code path and the type of the retrieve does not have a primary code path defined.", useStrictRetrieveTyping ? CqlCompilerException.ErrorSeverity.Error : CqlCompilerException.ErrorSeverity.Warning, this.getTrackBack((ParserRuleContext)ctx));
                this.libraryBuilder.recordParsingException(propertyException);
            } else {
                try {
                    DataType codeType = this.libraryBuilder.resolvePath((DataType)namedType, codePath);
                    property = this.of.createProperty().withPath(codePath);
                    property.setResultType(codeType);
                }
                catch (Exception e) {
                    propertyException = new CqlSemanticException(String.format("Could not resolve code path %s for the type of the retrieve %s.", codePath, namedType.getName()), useStrictRetrieveTyping ? CqlCompilerException.ErrorSeverity.Error : CqlCompilerException.ErrorSeverity.Warning, this.getTrackBack((ParserRuleContext)ctx), e);
                    this.libraryBuilder.recordParsingException(propertyException);
                }
            }
            if (ctx.terminology().qualifiedIdentifierExpression() != null) {
                identifiers = (List)this.visit((ParseTree)ctx.terminology());
                terminology = this.resolveQualifiedIdentifier((List<String>)identifiers);
                this.track((Trackable)terminology, (ParseTree)ctx.terminology().qualifiedIdentifierExpression());
            } else {
                terminology = this.parseExpression((ParseTree)ctx.terminology().expression());
            }
            codeComparator = ctx.codeComparator() != null ? (String)this.visit((ParseTree)ctx.codeComparator()) : null;
        }
        Retrieve result = null;
        boolean bl = hasFHIRHelpers = this.libraryInfo.resolveLibraryName("FHIRHelpers") != null;
        if (property != null && property.getResultType() instanceof ChoiceType && codeComparator == null) {
            for (DataType propertyType : ((ChoiceType)property.getResultType()).getTypes()) {
                if (hasFHIRHelpers && propertyType instanceof NamedType && ((NamedType)propertyType).getSimpleName().equals("Reference") && namedType.getSimpleName().equals("MedicationRequest")) {
                    ClassType mClassType;
                    Retrieve mrRetrieve = this.buildRetrieve(ctx, useStrictRetrieveTyping, (NamedType)namedType, classType, null, null, null, null, null, null);
                    this.retrieves.add(mrRetrieve);
                    mrRetrieve.setResultType((DataType)new ListType((DataType)namedType));
                    DataType mDataType = this.libraryBuilder.resolveTypeName(model, "Medication");
                    ClassType mNamedType = mClassType = (ClassType)mDataType;
                    Retrieve mRetrieve = this.buildRetrieve(ctx, useStrictRetrieveTyping, (NamedType)mNamedType, mClassType, null, null, null, null, null, null);
                    this.retrieves.add(mRetrieve);
                    mRetrieve.setResultType((DataType)new ListType((DataType)namedType));
                    Query q = this.of.createQuery();
                    AliasedQuerySource aqs = this.of.createAliasedQuerySource().withExpression((Expression)mrRetrieve).withAlias("MR");
                    this.track((Trackable)aqs, (ParseTree)ctx);
                    aqs.setResultType(aqs.getExpression().getResultType());
                    q.getSource().add(aqs);
                    this.track((Trackable)q, (ParseTree)ctx);
                    q.setResultType(aqs.getResultType());
                    With w = this.of.createWith().withExpression((Expression)mRetrieve).withAlias("M");
                    this.track((Trackable)w, (ParseTree)ctx);
                    w.setResultType(w.getExpression().getResultType());
                    q.getRelationship().add(w);
                    String idPath = "id";
                    DataType idType = this.libraryBuilder.resolvePath(mDataType, idPath);
                    Property idProperty = this.libraryBuilder.buildProperty("M", idPath, false, idType);
                    String refPath = "medication.reference";
                    DataType refType = this.libraryBuilder.resolvePath(dataType, refPath);
                    Property refProperty = this.libraryBuilder.buildProperty("MR", refPath, false, refType);
                    Split split = this.of.createSplit().withStringToSplit((Expression)refProperty).withSeparator((Expression)this.libraryBuilder.createLiteral("/"));
                    this.libraryBuilder.resolveCall("System", "Split", new SplitInvocation(split));
                    Last last = this.of.createLast().withSource((Expression)split);
                    this.libraryBuilder.resolveCall("System", "Last", new LastInvocation(last));
                    Equal e = this.of.createEqual().withOperand(new Expression[]{idProperty, last});
                    this.libraryBuilder.resolveBinaryCall("System", "Equal", (BinaryExpression)e);
                    DataType mCodeType = this.libraryBuilder.resolvePath((DataType)mNamedType, "code");
                    Property mProperty = this.of.createProperty().withPath("code");
                    mProperty.setResultType(mCodeType);
                    String mCodeComparator = "~";
                    if (terminology.getResultType() instanceof ListType) {
                        mCodeComparator = "in";
                    } else if (this.libraryBuilder.isCompatibleWith("1.5")) {
                        mCodeComparator = terminology.getResultType().isSubTypeOf(this.libraryBuilder.resolveTypeName("System", "Vocabulary")) ? "in" : "~";
                    }
                    Expression terminologyComparison = null;
                    if (mCodeComparator.equals("in")) {
                        terminologyComparison = this.libraryBuilder.resolveIn((Expression)mProperty, terminology);
                    } else {
                        Equivalent equivalent = this.of.createEquivalent().withOperand(new Expression[]{mProperty, terminology});
                        this.libraryBuilder.resolveBinaryCall("System", "Equivalent", (BinaryExpression)equivalent);
                        terminologyComparison = equivalent;
                    }
                    And a = this.of.createAnd().withOperand(new Expression[]{e, terminologyComparison});
                    this.libraryBuilder.resolveBinaryCall("System", "And", (BinaryExpression)a);
                    w.withSuchThat((Expression)a);
                    if (result == null) {
                        result = q;
                        continue;
                    }
                    this.track((Trackable)q, (ParseTree)ctx);
                    result = this.libraryBuilder.resolveUnion((Expression)result, (Expression)q);
                    continue;
                }
                Retrieve retrieve = this.buildRetrieve(ctx, useStrictRetrieveTyping, (NamedType)namedType, classType, codePath, codeComparator, property, propertyType, propertyException, terminology);
                this.retrieves.add(retrieve);
                retrieve.setResultType((DataType)new ListType((DataType)namedType));
                if (result == null) {
                    result = retrieve;
                    continue;
                }
                this.track((Trackable)retrieve, (ParseTree)ctx);
                result = this.libraryBuilder.resolveUnion((Expression)result, (Expression)retrieve);
            }
        } else {
            Retrieve retrieve = this.buildRetrieve(ctx, useStrictRetrieveTyping, (NamedType)namedType, classType, codePath, codeComparator, property, property != null ? property.getResultType() : null, propertyException, terminology);
            this.retrieves.add(retrieve);
            retrieve.setResultType((DataType)new ListType((DataType)namedType));
            result = retrieve;
        }
        return result;
    }

    private Retrieve buildRetrieve(cqlParser.RetrieveContext ctx, boolean useStrictRetrieveTyping, NamedType namedType, ClassType classType, String codePath, String codeComparator, Property property, DataType propertyType, Exception propertyException, Expression terminology) {
        Retrieve retrieve = this.of.createRetrieve().withDataType(this.libraryBuilder.dataTypeToQName((DataType)namedType)).withTemplateId(classType.getIdentifier()).withCodeProperty(codePath);
        if (ctx.contextIdentifier() != null) {
            Object identifiers = (List)this.visit((ParseTree)ctx.contextIdentifier());
            Expression contextExpression = this.resolveQualifiedIdentifier((List<String>)identifiers);
            retrieve.setContext(contextExpression);
        }
        if (terminology != null) {
            try {
                if (codeComparator == null) {
                    codeComparator = "~";
                    if (terminology.getResultType() instanceof ListType) {
                        codeComparator = "in";
                    } else if (this.libraryBuilder.isCompatibleWith("1.5")) {
                        if (propertyType != null && propertyType.isSubTypeOf(this.libraryBuilder.resolveTypeName("System", "Vocabulary"))) {
                            codeComparator = terminology.getResultType().isSubTypeOf(this.libraryBuilder.resolveTypeName("System", "Vocabulary")) ? "~" : "contains";
                        } else {
                            String string = codeComparator = terminology.getResultType().isSubTypeOf(this.libraryBuilder.resolveTypeName("System", "Vocabulary")) ? "in" : "~";
                        }
                    }
                }
                if (property == null) {
                    throw propertyException;
                }
                switch (codeComparator) {
                    case "in": {
                        Expression in = this.libraryBuilder.resolveIn((Expression)property, terminology);
                        if (in instanceof In) {
                            retrieve.setCodes((Expression)((In)in).getOperand().get(1));
                            break;
                        }
                        if (in instanceof InValueSet) {
                            retrieve.setCodes((Expression)((InValueSet)in).getValueset());
                            break;
                        }
                        if (in instanceof InCodeSystem) {
                            retrieve.setCodes((Expression)((InCodeSystem)in).getCodesystem());
                            break;
                        }
                        if (in instanceof AnyInValueSet) {
                            retrieve.setCodes((Expression)((AnyInValueSet)in).getValueset());
                            break;
                        }
                        if (in instanceof AnyInCodeSystem) {
                            retrieve.setCodes((Expression)((AnyInCodeSystem)in).getCodesystem());
                            break;
                        }
                        this.libraryBuilder.recordParsingException(new CqlSemanticException(String.format("Unexpected membership operator %s in retrieve", in.getClass().getSimpleName()), useStrictRetrieveTyping ? CqlCompilerException.ErrorSeverity.Error : CqlCompilerException.ErrorSeverity.Warning, this.getTrackBack((ParserRuleContext)ctx)));
                        break;
                    }
                    case "contains": {
                        Expression contains = this.libraryBuilder.resolveContains((Expression)property, terminology);
                        if (contains instanceof Contains) {
                            retrieve.setCodes((Expression)((Contains)contains).getOperand().get(1));
                        }
                        this.libraryBuilder.recordParsingException(new CqlSemanticException("Terminology resolution using contains is not supported at this time. Use a where clause with an in operator instead.", useStrictRetrieveTyping ? CqlCompilerException.ErrorSeverity.Error : CqlCompilerException.ErrorSeverity.Warning, this.getTrackBack((ParserRuleContext)ctx)));
                        break;
                    }
                    case "~": {
                        Equivalent equivalent = this.of.createEquivalent().withOperand(new Expression[]{property, terminology});
                        this.libraryBuilder.resolveBinaryCall("System", "Equivalent", (BinaryExpression)equivalent);
                        if (!(((Expression)equivalent.getOperand().get(1)).getResultType() instanceof ListType || this.libraryBuilder.isCompatibleWith("1.5") && ((Expression)equivalent.getOperand().get(1)).getResultType().isSubTypeOf(this.libraryBuilder.resolveTypeName("System", "Vocabulary")))) {
                            retrieve.setCodes(this.libraryBuilder.resolveToList((Expression)equivalent.getOperand().get(1)));
                            break;
                        }
                        retrieve.setCodes((Expression)equivalent.getOperand().get(1));
                        break;
                    }
                    case "=": {
                        Equal equal = this.of.createEqual().withOperand(new Expression[]{property, terminology});
                        this.libraryBuilder.resolveBinaryCall("System", "Equal", (BinaryExpression)equal);
                        if (!(((Expression)equal.getOperand().get(1)).getResultType() instanceof ListType || this.libraryBuilder.isCompatibleWith("1.5") && ((Expression)equal.getOperand().get(1)).getResultType().isSubTypeOf(this.libraryBuilder.resolveTypeName("System", "Vocabulary")))) {
                            retrieve.setCodes(this.libraryBuilder.resolveToList((Expression)equal.getOperand().get(1)));
                            break;
                        }
                        retrieve.setCodes((Expression)equal.getOperand().get(1));
                        break;
                    }
                    default: {
                        this.libraryBuilder.recordParsingException(new CqlSemanticException(String.format("Unknown code comparator %s in retrieve", codeComparator), useStrictRetrieveTyping ? CqlCompilerException.ErrorSeverity.Error : CqlCompilerException.ErrorSeverity.Warning, this.getTrackBack((ParserRuleContext)ctx.codeComparator())));
                    }
                }
                retrieve.setCodeComparator(codeComparator);
                if (retrieve.getCodes() != null && retrieve.getCodes().getResultType() != null && retrieve.getCodes().getResultType() instanceof ListType && ((ListType)retrieve.getCodes().getResultType()).getElementType().equals(this.libraryBuilder.resolveTypeName("System", "Concept"))) {
                    if (retrieve.getCodes() instanceof ToList) {
                        ToList toList = (ToList)retrieve.getCodes();
                        if (toList.getOperand() instanceof ToConcept) {
                            toList.setOperand(((ToConcept)toList.getOperand()).getOperand());
                        } else {
                            Property codesAccessor = this.libraryBuilder.buildProperty(toList.getOperand(), "codes", false, toList.getOperand().getResultType());
                            retrieve.setCodes((Expression)codesAccessor);
                        }
                    } else {
                        this.libraryBuilder.recordParsingException(new CqlSemanticException("Terminology target is a list of concepts, but expects a list of codes", CqlCompilerException.ErrorSeverity.Warning, this.getTrackBack((ParserRuleContext)ctx)));
                    }
                }
            }
            catch (Exception e) {
                if (this.libraryBuilder.isCompatibleWith("1.5") && !terminology.getResultType().isSubTypeOf(this.libraryBuilder.resolveTypeName("System", "Vocabulary")) || !this.libraryBuilder.isCompatibleWith("1.5") && !(terminology.getResultType() instanceof ListType)) {
                    retrieve.setCodes(this.libraryBuilder.resolveToList(terminology));
                } else {
                    retrieve.setCodes(terminology);
                }
                retrieve.setCodeComparator(codeComparator);
                this.libraryBuilder.recordParsingException(new CqlSemanticException("Could not resolve membership operator for terminology target of the retrieve.", useStrictRetrieveTyping ? CqlCompilerException.ErrorSeverity.Error : CqlCompilerException.ErrorSeverity.Warning, this.getTrackBack((ParserRuleContext)ctx), e));
            }
        }
        return retrieve;
    }

    public Object visitSourceClause(cqlParser.SourceClauseContext ctx) {
        boolean hasFrom = "from".equals(ctx.getChild(0).getText());
        if (!hasFrom && this.isFromKeywordRequired()) {
            throw new IllegalArgumentException("The from keyword is required for queries.");
        }
        ArrayList<AliasedQuerySource> sources = new ArrayList<AliasedQuerySource>();
        for (cqlParser.AliasedQuerySourceContext source : ctx.aliasedQuerySource()) {
            if (sources.size() > 0 && !hasFrom) {
                throw new IllegalArgumentException("The from keyword is required for multi-source queries.");
            }
            sources.add((AliasedQuerySource)this.visit((ParseTree)source));
        }
        return sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitQuery(cqlParser.QueryContext ctx) {
        QueryContext queryContext = new QueryContext();
        this.libraryBuilder.pushQueryContext(queryContext);
        List sources = null;
        try {
            Query query;
            block37: {
                queryContext.enterSourceClause();
                try {
                    sources = (List)this.visit((ParseTree)ctx.sourceClause());
                }
                finally {
                    queryContext.exitSourceClause();
                }
                queryContext.addPrimaryQuerySources(sources);
                for (AliasedQuerySource source : sources) {
                    this.libraryBuilder.pushIdentifier(source.getAlias(), (Trackable)source);
                }
                boolean expressionContextPushed = false;
                List dfcx = null;
                try {
                    AggregateClause agg;
                    Expression where;
                    List list = dfcx = ctx.letClause() != null ? (List)this.visit((ParseTree)ctx.letClause()) : null;
                    if (dfcx != null) {
                        for (Object letClause : dfcx) {
                            this.libraryBuilder.pushIdentifier(letClause.getIdentifier(), (Trackable)letClause);
                        }
                    }
                    ArrayList<RelationshipClause> qicx = new ArrayList<RelationshipClause>();
                    if (ctx.queryInclusionClause() != null) {
                        for (Object queryInclusionClauseContext : ctx.queryInclusionClause()) {
                            qicx.add((RelationshipClause)this.visit((ParseTree)queryInclusionClauseContext));
                        }
                    }
                    Expression expression = where = ctx.whereClause() != null ? (Expression)this.visit((ParseTree)ctx.whereClause()) : null;
                    if (this.getDateRangeOptimization() && where != null) {
                        for (AliasedQuerySource aqs : sources) {
                            where = this.optimizeDateRangeInQuery(where, aqs);
                        }
                    }
                    ReturnClause ret = ctx.returnClause() != null ? (ReturnClause)this.visit((ParseTree)ctx.returnClause()) : null;
                    AggregateClause aggregateClause = agg = ctx.aggregateClause() != null ? (AggregateClause)this.visit((ParseTree)ctx.aggregateClause()) : null;
                    if (agg == null && ret == null && sources.size() > 1) {
                        ret = this.of.createReturnClause().withDistinct(Boolean.valueOf(true));
                        Tuple returnExpression = this.of.createTuple();
                        TupleType returnType = new TupleType();
                        for (AliasedQuerySource aqs : sources) {
                            TupleElement element = this.of.createTupleElement().withName(aqs.getAlias()).withValue((Expression)this.of.createAliasRef().withName(aqs.getAlias()));
                            DataType sourceType = aqs.getResultType() instanceof ListType ? ((ListType)aqs.getResultType()).getElementType() : aqs.getResultType();
                            element.getValue().setResultType(sourceType);
                            element.setResultType(element.getValue().getResultType());
                            returnType.addElement(new TupleTypeElement(element.getName(), element.getResultType()));
                            returnExpression.getElement().add(element);
                        }
                        returnExpression.setResultType((DataType)(queryContext.isSingular() ? returnType : new ListType((DataType)returnType)));
                        ret.setExpression((Expression)returnExpression);
                        ret.setResultType(returnExpression.getResultType());
                    }
                    queryContext.removeQuerySources(sources);
                    if (dfcx != null) {
                        queryContext.removeLetClauses(dfcx);
                    }
                    DataType queryResultType = null;
                    queryResultType = agg != null ? agg.getResultType() : (ret != null ? ret.getResultType() : ((AliasedQuerySource)sources.get(0)).getResultType());
                    SortClause sort = null;
                    if (agg == null) {
                        queryContext.setResultElementType(queryContext.isSingular() ? null : ((ListType)queryResultType).getElementType());
                        if (ctx.sortClause() != null) {
                            if (queryContext.isSingular()) {
                                throw new IllegalArgumentException("Sort clause cannot be used in a singular query.");
                            }
                            queryContext.enterSortClause();
                            try {
                                sort = (SortClause)this.visit((ParseTree)ctx.sortClause());
                                for (SortByItem sortByItem : sort.getBy()) {
                                    if (sortByItem instanceof ByDirection) {
                                        this.libraryBuilder.verifyComparable(queryContext.getResultElementType());
                                        continue;
                                    }
                                    this.libraryBuilder.verifyComparable(sortByItem.getResultType());
                                }
                            }
                            finally {
                                queryContext.exitSortClause();
                            }
                        }
                    } else if (ctx.sortClause() != null) {
                        throw new IllegalArgumentException("Sort clause cannot be used in an aggregate query.");
                    }
                    Query query2 = this.of.createQuery().withSource((Collection)sources).withLet((Collection)dfcx).withRelationship(qicx).withWhere(where).withReturn(ret).withAggregate(agg).withSort(sort);
                    query2.setResultType(queryResultType);
                    query = query2;
                    if (expressionContextPushed) {
                        this.libraryBuilder.popExpressionContext();
                    }
                    if (dfcx == null) break block37;
                }
                catch (Throwable throwable) {
                    if (expressionContextPushed) {
                        this.libraryBuilder.popExpressionContext();
                    }
                    if (dfcx != null) {
                        for (LetClause letClause : dfcx) {
                            this.libraryBuilder.popIdentifier();
                        }
                    }
                    throw throwable;
                }
                for (LetClause letClause : dfcx) {
                    this.libraryBuilder.popIdentifier();
                }
            }
            return query;
        }
        finally {
            this.libraryBuilder.popQueryContext();
            if (sources != null) {
                for (AliasedQuerySource source : sources) {
                    this.libraryBuilder.popIdentifier();
                }
            }
        }
    }

    public Expression optimizeDateRangeInQuery(Expression where, AliasedQuerySource aqs) {
        if (aqs.getExpression() instanceof Retrieve) {
            Retrieve retrieve = (Retrieve)aqs.getExpression();
            String alias = aqs.getAlias();
            if ((where instanceof IncludedIn || where instanceof In) && this.attemptDateRangeOptimization((BinaryExpression)where, retrieve, alias)) {
                where = null;
            } else if (where instanceof And && this.attemptDateRangeOptimization((And)where, retrieve, alias)) {
                where = this.consolidateAnd((And)where);
            }
        }
        return where;
    }

    private boolean attemptDateRangeOptimization(BinaryExpression during, Retrieve retrieve, String alias) {
        if (retrieve.getDateProperty() != null || retrieve.getDateRange() != null) {
            return false;
        }
        Expression left = (Expression)during.getOperand().get(0);
        Expression right = (Expression)during.getOperand().get(1);
        String propertyPath = this.getPropertyPath(left, alias);
        if (propertyPath != null && this.isRHSEligibleForDateRangeOptimization(right)) {
            retrieve.setDateProperty(propertyPath);
            retrieve.setDateRange(right);
            return true;
        }
        return false;
    }

    private String getPropertyPath(Expression reference, String alias) {
        reference = this.getConversionReference(reference);
        if ((reference = this.getChoiceSelection(reference)) instanceof Property) {
            String subPath;
            Property property = (Property)reference;
            if (alias.equals(property.getScope())) {
                return property.getPath();
            }
            if (property.getSource() != null && (subPath = this.getPropertyPath(property.getSource(), alias)) != null) {
                return String.format("%s.%s", subPath, property.getPath());
            }
        }
        return null;
    }

    private Expression getConversionReference(Expression reference) {
        Operator o;
        FunctionRef functionRef;
        if (reference instanceof FunctionRef && (functionRef = (FunctionRef)reference).getOperand().size() == 1 && functionRef.getResultType() != null && ((Expression)functionRef.getOperand().get(0)).getResultType() != null && (o = this.libraryBuilder.getConversionMap().getConversionOperator(((Expression)functionRef.getOperand().get(0)).getResultType(), functionRef.getResultType())) != null && o.getLibraryName() != null && o.getLibraryName().equals(functionRef.getLibraryName()) && o.getName() != null && o.getName().equals(functionRef.getName())) {
            return (Expression)functionRef.getOperand().get(0);
        }
        return reference;
    }

    private Expression getChoiceSelection(Expression reference) {
        As as;
        if (reference instanceof As && (as = (As)reference).getOperand() != null && as.getOperand().getResultType() instanceof ChoiceType) {
            return as.getOperand();
        }
        return reference;
    }

    private boolean attemptDateRangeOptimization(And and, Retrieve retrieve, String alias) {
        if (retrieve.getDateProperty() != null || retrieve.getDateRange() != null) {
            return false;
        }
        for (int i = 0; i < and.getOperand().size(); ++i) {
            Expression operand = (Expression)and.getOperand().get(i);
            if ((operand instanceof IncludedIn || operand instanceof In) && this.attemptDateRangeOptimization((BinaryExpression)operand, retrieve, alias)) {
                and.getOperand().set(i, this.libraryBuilder.createLiteral(true));
                return true;
            }
            if (!(operand instanceof And) || !this.attemptDateRangeOptimization((And)operand, retrieve, alias)) continue;
            return true;
        }
        return false;
    }

    private Expression consolidateAnd(And and) {
        And result = and;
        Expression lhs = (Expression)and.getOperand().get(0);
        Expression rhs = (Expression)and.getOperand().get(1);
        if (this.isBooleanLiteral(lhs, true)) {
            result = rhs;
        } else if (this.isBooleanLiteral(rhs, true)) {
            result = lhs;
        } else if (lhs instanceof And) {
            and.getOperand().set(0, this.consolidateAnd((And)lhs));
        } else if (rhs instanceof And) {
            and.getOperand().set(1, this.consolidateAnd((And)rhs));
        }
        return result;
    }

    private boolean isRHSEligibleForDateRangeOptimization(Expression rhs) {
        return rhs.getResultType().isSubTypeOf(this.libraryBuilder.resolveTypeName("System", "DateTime")) || rhs.getResultType().isSubTypeOf((DataType)new IntervalType(this.libraryBuilder.resolveTypeName("System", "DateTime")));
    }

    private boolean isDateTimeTypeSpecifier(Element e) {
        return e.getResultType().equals(this.libraryBuilder.resolveTypeName("System", "DateTime"));
    }

    public Object visitLetClause(cqlParser.LetClauseContext ctx) {
        ArrayList<LetClause> letClauseItems = new ArrayList<LetClause>();
        for (cqlParser.LetClauseItemContext letClauseItem : ctx.letClauseItem()) {
            letClauseItems.add((LetClause)this.visit((ParseTree)letClauseItem));
        }
        return letClauseItems;
    }

    public Object visitLetClauseItem(cqlParser.LetClauseItemContext ctx) {
        LetClause letClause = this.of.createLetClause().withExpression(this.parseExpression((ParseTree)ctx.expression())).withIdentifier(this.parseString((ParseTree)ctx.identifier()));
        letClause.setResultType(letClause.getExpression().getResultType());
        this.libraryBuilder.peekQueryContext().addLetClause(letClause);
        return letClause;
    }

    public Object visitAliasedQuerySource(cqlParser.AliasedQuerySourceContext ctx) {
        AliasedQuerySource source = this.of.createAliasedQuerySource().withExpression(this.parseExpression((ParseTree)ctx.querySource())).withAlias(this.parseString((ParseTree)ctx.alias()));
        source.setResultType(source.getExpression().getResultType());
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitWithClause(cqlParser.WithClauseContext ctx) {
        AliasedQuerySource aqs = (AliasedQuerySource)this.visit((ParseTree)ctx.aliasedQuerySource());
        this.libraryBuilder.peekQueryContext().addRelatedQuerySource(aqs);
        try {
            Expression expression = (Expression)this.visit((ParseTree)ctx.expression());
            DataTypes.verifyType(expression.getResultType(), this.libraryBuilder.resolveTypeName("System", "Boolean"));
            With result = this.of.createWith();
            result.withExpression(aqs.getExpression()).withAlias(aqs.getAlias()).withSuchThat(expression);
            result.setResultType(aqs.getResultType());
            With with = result;
            return with;
        }
        finally {
            this.libraryBuilder.peekQueryContext().removeQuerySource(aqs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitWithoutClause(cqlParser.WithoutClauseContext ctx) {
        AliasedQuerySource aqs = (AliasedQuerySource)this.visit((ParseTree)ctx.aliasedQuerySource());
        this.libraryBuilder.peekQueryContext().addRelatedQuerySource(aqs);
        try {
            Expression expression = (Expression)this.visit((ParseTree)ctx.expression());
            DataTypes.verifyType(expression.getResultType(), this.libraryBuilder.resolveTypeName("System", "Boolean"));
            Without result = this.of.createWithout();
            result.withExpression(aqs.getExpression()).withAlias(aqs.getAlias()).withSuchThat(expression);
            result.setResultType(aqs.getResultType());
            Without without = result;
            return without;
        }
        finally {
            this.libraryBuilder.peekQueryContext().removeQuerySource(aqs);
        }
    }

    public Object visitWhereClause(cqlParser.WhereClauseContext ctx) {
        Expression result = (Expression)this.visit((ParseTree)ctx.expression());
        DataTypes.verifyType(result.getResultType(), this.libraryBuilder.resolveTypeName("System", "Boolean"));
        return result;
    }

    public Object visitReturnClause(cqlParser.ReturnClauseContext ctx) {
        ReturnClause returnClause = this.of.createReturnClause();
        if (ctx.getChild(1) instanceof TerminalNode) {
            switch (ctx.getChild(1).getText()) {
                case "all": {
                    returnClause.setDistinct(Boolean.valueOf(false));
                    break;
                }
                case "distinct": {
                    returnClause.setDistinct(Boolean.valueOf(true));
                    break;
                }
            }
        }
        returnClause.setExpression(this.parseExpression((ParseTree)ctx.expression()));
        returnClause.setResultType((DataType)(this.libraryBuilder.peekQueryContext().isSingular() ? returnClause.getExpression().getResultType() : new ListType(returnClause.getExpression().getResultType())));
        return returnClause;
    }

    public Object visitStartingClause(cqlParser.StartingClauseContext ctx) {
        if (ctx.simpleLiteral() != null) {
            return this.visit((ParseTree)ctx.simpleLiteral());
        }
        if (ctx.quantity() != null) {
            return this.visit((ParseTree)ctx.quantity());
        }
        if (ctx.expression() != null) {
            return this.visit((ParseTree)ctx.expression());
        }
        return null;
    }

    public Object visitAggregateClause(cqlParser.AggregateClauseContext ctx) {
        this.libraryBuilder.checkCompatibilityLevel("Aggregate query clause", "1.5");
        AggregateClause aggregateClause = this.of.createAggregateClause();
        if (ctx.getChild(1) instanceof TerminalNode) {
            switch (ctx.getChild(1).getText()) {
                case "all": {
                    aggregateClause.setDistinct(Boolean.valueOf(false));
                    break;
                }
                case "distinct": {
                    aggregateClause.setDistinct(Boolean.valueOf(true));
                    break;
                }
            }
        }
        if (ctx.startingClause() != null) {
            aggregateClause.setStarting(this.parseExpression((ParseTree)ctx.startingClause()));
        }
        aggregateClause.setIdentifier(this.parseString((ParseTree)ctx.identifier()));
        Null accumulator = null;
        accumulator = aggregateClause.getStarting() != null ? this.libraryBuilder.buildNull(aggregateClause.getStarting().getResultType()) : this.libraryBuilder.buildNull(this.libraryBuilder.resolveTypeName("System", "Any"));
        LetClause letClause = this.of.createLetClause().withExpression((Expression)accumulator).withIdentifier(aggregateClause.getIdentifier());
        letClause.setResultType(letClause.getExpression().getResultType());
        this.libraryBuilder.peekQueryContext().addLetClause(letClause);
        aggregateClause.setExpression(this.parseExpression((ParseTree)ctx.expression()));
        aggregateClause.setResultType(aggregateClause.getExpression().getResultType());
        if (aggregateClause.getStarting() == null) {
            accumulator.setResultType(aggregateClause.getResultType());
            aggregateClause.setStarting((Expression)accumulator);
        }
        return aggregateClause;
    }

    public SortDirection visitSortDirection(cqlParser.SortDirectionContext ctx) {
        return SortDirection.fromValue((String)ctx.getText());
    }

    private SortDirection parseSortDirection(cqlParser.SortDirectionContext ctx) {
        if (ctx != null) {
            return this.visitSortDirection(ctx);
        }
        return SortDirection.ASC;
    }

    public SortByItem visitSortByItem(cqlParser.SortByItemContext ctx) {
        Expression sortExpression = this.parseExpression((ParseTree)ctx.expressionTerm());
        if (sortExpression instanceof IdentifierRef) {
            return (SortByItem)this.of.createByColumn().withPath(((IdentifierRef)sortExpression).getName()).withDirection(this.parseSortDirection(ctx.sortDirection())).withResultType(sortExpression.getResultType());
        }
        return (SortByItem)this.of.createByExpression().withExpression(sortExpression).withDirection(this.parseSortDirection(ctx.sortDirection())).withResultType(sortExpression.getResultType());
    }

    public Object visitSortClause(cqlParser.SortClauseContext ctx) {
        if (ctx.sortDirection() != null) {
            return this.of.createSortClause().withBy(new SortByItem[]{this.of.createByDirection().withDirection(this.parseSortDirection(ctx.sortDirection()))});
        }
        ArrayList<SortByItem> sortItems = new ArrayList<SortByItem>();
        if (ctx.sortByItem() != null) {
            for (cqlParser.SortByItemContext sortByItemContext : ctx.sortByItem()) {
                sortItems.add((SortByItem)this.visit((ParseTree)sortByItemContext));
            }
        }
        return this.of.createSortClause().withBy(sortItems);
    }

    public Object visitQuerySource(cqlParser.QuerySourceContext ctx) {
        if (ctx.expression() != null) {
            return this.visit((ParseTree)ctx.expression());
        }
        if (ctx.retrieve() != null) {
            return this.visit((ParseTree)ctx.retrieve());
        }
        List identifiers = (List)this.visit((ParseTree)ctx.qualifiedIdentifierExpression());
        return this.resolveQualifiedIdentifier(identifiers);
    }

    public Object visitIndexedExpressionTerm(cqlParser.IndexedExpressionTermContext ctx) {
        Indexer indexer = this.of.createIndexer().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expressionTerm())}).withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression())});
        this.libraryBuilder.resolveBinaryCall("System", "Indexer", (BinaryExpression)indexer);
        return indexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression visitInvocationExpressionTerm(cqlParser.InvocationExpressionTermContext ctx) {
        Expression left = this.parseExpression((ParseTree)ctx.expressionTerm());
        this.libraryBuilder.pushExpressionTarget(left);
        try {
            Expression expression = (Expression)this.visit((ParseTree)ctx.qualifiedInvocation());
            return expression;
        }
        finally {
            this.libraryBuilder.popExpressionTarget();
        }
    }

    public Expression visitExternalConstant(cqlParser.ExternalConstantContext ctx) {
        return this.libraryBuilder.resolveIdentifier(ctx.getText(), true);
    }

    public Expression visitThisInvocation(cqlParser.ThisInvocationContext ctx) {
        return this.libraryBuilder.resolveIdentifier(ctx.getText(), true);
    }

    public Expression visitMemberInvocation(cqlParser.MemberInvocationContext ctx) {
        String identifier = this.parseString((ParseTree)ctx.referentialIdentifier());
        return this.resolveMemberIdentifier(identifier);
    }

    public Expression visitQualifiedMemberInvocation(cqlParser.QualifiedMemberInvocationContext ctx) {
        String identifier = this.parseString((ParseTree)ctx.referentialIdentifier());
        return this.resolveMemberIdentifier(identifier);
    }

    public Expression resolveQualifiedIdentifier(List<String> identifiers) {
        Expression current = null;
        for (String identifier : identifiers) {
            if (current == null) {
                current = this.resolveIdentifier(identifier);
                continue;
            }
            current = this.libraryBuilder.resolveAccessor(current, identifier);
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression resolveMemberIdentifier(String identifier) {
        if (this.libraryBuilder.hasExpressionTarget()) {
            Expression target = this.libraryBuilder.popExpressionTarget();
            try {
                Expression expression = this.libraryBuilder.resolveAccessor(target, identifier);
                return expression;
            }
            finally {
                this.libraryBuilder.pushExpressionTarget(target);
            }
        }
        return this.resolveIdentifier(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression resolveIdentifier(String identifier) {
        Expression result = this.libraryBuilder.resolveIdentifier(identifier, false);
        if (result == null) {
            ParameterDefinitionInfo parameterInfo;
            ExpressionDefinitionInfo expressionInfo = this.libraryInfo.resolveExpressionReference(identifier);
            if (expressionInfo != null) {
                String saveContext = this.saveCurrentContext(expressionInfo.getContext());
                try {
                    Stack saveChunks = this.chunks;
                    this.chunks = new Stack();
                    this.forwards.push(expressionInfo);
                    try {
                        if (expressionInfo.getDefinition() == null) {
                            throw new IllegalArgumentException(String.format("Could not validate reference to expression %s because its definition contains errors.", expressionInfo.getName()));
                        }
                        this.visit((ParseTree)expressionInfo.getDefinition());
                    }
                    finally {
                        this.chunks = saveChunks;
                        this.forwards.pop();
                    }
                }
                finally {
                    this.setCurrentContext(saveContext);
                }
            }
            if ((parameterInfo = this.libraryInfo.resolveParameterReference(identifier)) != null) {
                this.visitParameterDefinition(parameterInfo.getDefinition());
            }
            result = this.libraryBuilder.resolveIdentifier(identifier, true);
        }
        return result;
    }

    private String ensureSystemFunctionName(String libraryName, String functionName) {
        if (libraryName == null || libraryName.equals("System")) {
            switch (functionName) {
                case "contains": {
                    functionName = "Contains";
                    break;
                }
                case "distinct": {
                    functionName = "Distinct";
                    break;
                }
                case "exists": {
                    functionName = "Exists";
                    break;
                }
                case "in": {
                    functionName = "In";
                    break;
                }
                case "not": {
                    functionName = "Not";
                }
            }
        }
        return functionName;
    }

    private Expression resolveFunction(String libraryName, String functionName, cqlParser.ParamListContext paramList) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        if (paramList != null && paramList.expression() != null) {
            for (cqlParser.ExpressionContext expressionContext : paramList.expression()) {
                expressions.add((Expression)this.visit((ParseTree)expressionContext));
            }
        }
        return this.resolveFunction(libraryName, functionName, expressions, true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression resolveFunction(String libraryName, String functionName, List<Expression> expressions, boolean mustResolve, boolean allowPromotionAndDemotion, boolean allowFluent) {
        Operator op;
        FunctionHeader fh;
        FunctionRefInvocation invocation;
        Invocation result;
        Iterable<FunctionDefinitionInfo> fdis;
        if (allowFluent) {
            this.libraryBuilder.checkCompatibilityLevel("Fluent functions", "1.5");
        }
        functionName = this.ensureSystemFunctionName(libraryName, functionName);
        if ((libraryName == null || libraryName.equals("") || libraryName.equals(this.libraryInfo.getLibraryName())) && (fdis = this.libraryInfo.resolveFunctionReference(functionName)) != null) {
            for (FunctionDefinitionInfo fdi : fdis) {
                String saveContext = this.saveCurrentContext(fdi.getContext());
                try {
                    this.registerFunctionDefinition(fdi.getDefinition());
                }
                finally {
                    this.setCurrentContext(saveContext);
                }
            }
        }
        if ((result = this.libraryBuilder.resolveFunction(libraryName, functionName, expressions, mustResolve, allowPromotionAndDemotion, allowFluent)) instanceof FunctionRefInvocation && (invocation = (FunctionRefInvocation)result).getResolution() != null && invocation.getResolution().getOperator() != null && (invocation.getResolution().getOperator().getLibraryName() == null || invocation.getResolution().getOperator().getLibraryName().equals(this.libraryBuilder.getCompiledLibrary().getIdentifier().getId())) && !(fh = this.getFunctionHeader(op = invocation.getResolution().getOperator())).getIsCompiled()) {
            cqlParser.FunctionDefinitionContext ctx = this.getFunctionDefinitionContext(fh);
            String saveContext = this.saveCurrentContext(fh.getFunctionDef().getContext());
            Stack saveChunks = this.chunks;
            this.chunks = new Stack();
            try {
                FunctionDef fd = this.compileFunctionDefinition(ctx);
                op.setResultType(fd.getResultType());
                invocation.setResultType(op.getResultType());
            }
            finally {
                this.setCurrentContext(saveContext);
                this.chunks = saveChunks;
            }
        }
        if (mustResolve) {
            if (result == null) {
                throw new IllegalArgumentException("Internal error: could not resolve function");
            }
            if (result.getExpression() == null) {
                throw new IllegalArgumentException("Internal error: could not resolve invocation expression");
            }
            if (result.getExpression().getResultType() == null) {
                throw new IllegalArgumentException("Internal error: could not determine result type");
            }
        }
        if (result == null) {
            return null;
        }
        return result.getExpression();
    }

    public Expression resolveFunctionOrQualifiedFunction(String identifier, cqlParser.ParamListContext paramListCtx) {
        Expression result;
        Expression result2;
        if (this.libraryBuilder.hasExpressionTarget()) {
            Expression target = this.libraryBuilder.popExpressionTarget();
            try {
                if (target instanceof LibraryRef) {
                    Expression expression = this.resolveFunction(((LibraryRef)target).getLibraryName(), identifier, paramListCtx);
                    return expression;
                }
                if (target instanceof Expression && this.isMethodInvocationEnabled()) {
                    Expression expression = this.systemMethodResolver.resolveMethod(target, identifier, paramListCtx, true);
                    return expression;
                }
                if (!this.isMethodInvocationEnabled()) {
                    throw new CqlCompilerException(String.format("The identifier %s could not be resolved as an invocation because method-style invocation is disabled.", identifier), CqlCompilerException.ErrorSeverity.Error);
                }
                throw new IllegalArgumentException(String.format("Invalid invocation target: %s", target.getClass().getName()));
            }
            finally {
                this.libraryBuilder.pushExpressionTarget(target);
            }
        }
        Expression thisRef = this.libraryBuilder.resolveIdentifier("$this", false);
        if (thisRef != null && (result2 = this.systemMethodResolver.resolveMethod(thisRef, identifier, paramListCtx, false)) != null) {
            return result2;
        }
        ParameterRef parameterRef = this.libraryBuilder.resolveImplicitContext();
        if (parameterRef != null && (result = this.systemMethodResolver.resolveMethod((Expression)parameterRef, identifier, paramListCtx, false)) != null) {
            return result;
        }
        return this.resolveFunction(null, identifier, paramListCtx);
    }

    public Expression visitFunction(cqlParser.FunctionContext ctx) {
        return this.resolveFunctionOrQualifiedFunction(this.parseString((ParseTree)ctx.referentialIdentifier()), ctx.paramList());
    }

    public Expression visitQualifiedFunction(cqlParser.QualifiedFunctionContext ctx) {
        return this.resolveFunctionOrQualifiedFunction(this.parseString((ParseTree)ctx.identifierOrFunctionIdentifier()), ctx.paramList());
    }

    public Object visitFunctionBody(cqlParser.FunctionBodyContext ctx) {
        return this.visit((ParseTree)ctx.expression());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionHeader getFunctionHeader(cqlParser.FunctionDefinitionContext ctx) {
        FunctionHeader fh = this.functionHeaders.get(ctx);
        if (fh == null) {
            Stack saveChunks = this.chunks;
            this.chunks = new Stack();
            try {
                fh = this.parseFunctionHeader(ctx);
            }
            finally {
                this.chunks = saveChunks;
            }
            this.functionHeaders.put(ctx, fh);
            this.functionDefinitions.put(fh, ctx);
            this.functionHeadersByDef.put(fh.getFunctionDef(), fh);
        }
        return fh;
    }

    private FunctionDef getFunctionDef(Operator op) {
        FunctionDef target = null;
        ArrayList<DataType> st = new ArrayList<DataType>();
        for (DataType dt : op.getSignature().getOperandTypes()) {
            st.add(dt);
        }
        Iterable<FunctionDef> fds = this.libraryBuilder.getCompiledLibrary().resolveFunctionRef(op.getName(), st);
        for (FunctionDef fd : fds) {
            if (fd.getOperand().size() != op.getSignature().getSize()) continue;
            Iterator<DataType> signatureTypes = op.getSignature().getOperandTypes().iterator();
            boolean signaturesMatch = true;
            for (int i = 0; i < fd.getOperand().size(); ++i) {
                if (DataTypes.equal(((OperandDef)fd.getOperand().get(i)).getResultType(), signatureTypes.next())) continue;
                signaturesMatch = false;
            }
            if (!signaturesMatch) continue;
            if (target == null) {
                target = fd;
                continue;
            }
            throw new IllegalArgumentException(String.format("Internal error attempting to resolve function header for %s", op.getName()));
        }
        return target;
    }

    private FunctionHeader getFunctionHeaderByDef(FunctionDef fd) {
        for (Map.Entry<FunctionDef, FunctionHeader> entry : this.functionHeadersByDef.entrySet()) {
            if (entry.getKey() != fd) continue;
            return entry.getValue();
        }
        return null;
    }

    private FunctionHeader getFunctionHeader(Operator op) {
        FunctionDef fd = this.getFunctionDef(op);
        if (fd == null) {
            throw new IllegalArgumentException(String.format("Could not resolve function header for operator %s", op.getName()));
        }
        FunctionHeader result = this.getFunctionHeaderByDef(fd);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Could not resolve function header for operator %s", op.getName()));
        }
        return result;
    }

    private cqlParser.FunctionDefinitionContext getFunctionDefinitionContext(FunctionHeader fh) {
        cqlParser.FunctionDefinitionContext ctx = this.functionDefinitions.get(fh);
        if (ctx == null) {
            throw new IllegalArgumentException(String.format("Could not resolve function definition context for function header %s", fh.getFunctionDef().getName()));
        }
        return ctx;
    }

    public void registerFunctionDefinition(cqlParser.FunctionDefinitionContext ctx) {
        FunctionHeader fh = this.getFunctionHeader(ctx);
        if (!this.libraryBuilder.getCompiledLibrary().contains(fh.getFunctionDef())) {
            this.libraryBuilder.addExpression((ExpressionDef)fh.getFunctionDef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionDef compileFunctionDefinition(cqlParser.FunctionDefinitionContext ctx) {
        FunctionHeader fh = this.getFunctionHeader(ctx);
        FunctionDef fun = fh.getFunctionDef();
        TypeSpecifier resultType = fh.getResultType();
        Operator op = this.libraryBuilder.resolveFunctionDefinition(fh.getFunctionDef());
        if (op == null) {
            throw new IllegalArgumentException(String.format("Internal error: Could not resolve operator map entry for function header %s", fh.getMangledName()));
        }
        this.libraryBuilder.pushIdentifier(fun.getName(), (Trackable)fun, LibraryBuilder.IdentifierScope.GLOBAL);
        List operand = op.getFunctionDef().getOperand();
        for (OperandDef operandDef : operand) {
            this.libraryBuilder.pushIdentifier(operandDef.getName(), (Trackable)operandDef);
        }
        try {
            if (ctx.functionBody() != null) {
                this.libraryBuilder.beginFunctionDef(fun);
                try {
                    this.libraryBuilder.pushExpressionContext(this.getCurrentContext());
                    try {
                        this.libraryBuilder.pushExpressionDefinition(fh.getMangledName());
                        try {
                            fun.setExpression(this.parseExpression((ParseTree)ctx.functionBody()));
                        }
                        finally {
                            this.libraryBuilder.popExpressionDefinition();
                        }
                    }
                    finally {
                        this.libraryBuilder.popExpressionContext();
                    }
                }
                finally {
                    this.libraryBuilder.endFunctionDef();
                }
                if (resultType != null && fun.getExpression() != null && fun.getExpression().getResultType() != null && !DataTypes.subTypeOf(fun.getExpression().getResultType(), resultType.getResultType())) {
                    throw new IllegalArgumentException(String.format("Function %s has declared return type %s but the function body returns incompatible type %s.", fun.getName(), resultType.getResultType(), fun.getExpression().getResultType()));
                }
                fun.setResultType(fun.getExpression().getResultType());
                op.setResultType(fun.getResultType());
            } else {
                fun.setExternal(Boolean.valueOf(true));
                if (resultType == null) {
                    throw new IllegalArgumentException(String.format("Function %s is marked external but does not declare a return type.", fun.getName()));
                }
                fun.setResultType(resultType.getResultType());
                op.setResultType(fun.getResultType());
            }
            fun.setContext(this.getCurrentContext());
            fh.setIsCompiled();
            FunctionDef functionDef = fun;
            return functionDef;
        }
        finally {
            for (OperandDef operandDef : operand) {
                try {
                    this.libraryBuilder.popIdentifier();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Object visitFunctionDefinition(cqlParser.FunctionDefinitionContext ctx) {
        this.libraryBuilder.pushIdentifierScope();
        try {
            this.registerFunctionDefinition(ctx);
            FunctionDef functionDef = this.compileFunctionDefinition(ctx);
            return functionDef;
        }
        finally {
            this.libraryBuilder.popIdentifierScope();
        }
    }

    private Expression parseLiteralExpression(ParseTree pt) {
        this.libraryBuilder.pushLiteralContext();
        try {
            Expression expression = this.parseExpression(pt);
            return expression;
        }
        finally {
            this.libraryBuilder.popLiteralContext();
        }
    }

    private Expression parseExpression(ParseTree pt) {
        return pt == null ? null : (Expression)this.visit(pt);
    }

    private boolean isBooleanLiteral(Expression expression, Boolean bool) {
        Literal lit;
        boolean ret = false;
        if (expression instanceof Literal && (ret = (lit = (Literal)expression).getValueType().equals(this.libraryBuilder.dataTypeToQName(this.libraryBuilder.resolveTypeName("System", "Boolean")))) && bool != null) {
            ret = bool.equals(Boolean.valueOf(lit.getValue()));
        }
        return ret;
    }

    private TrackBack getTrackBack(ParseTree tree) {
        if (tree instanceof ParserRuleContext) {
            return this.getTrackBack((ParserRuleContext)tree);
        }
        if (tree instanceof TerminalNode) {
            return this.getTrackBack((TerminalNode)tree);
        }
        return null;
    }

    private TrackBack getTrackBack(TerminalNode node) {
        TrackBack tb = new TrackBack(this.libraryBuilder.getLibraryIdentifier(), node.getSymbol().getLine(), node.getSymbol().getCharPositionInLine() + 1, node.getSymbol().getLine(), node.getSymbol().getCharPositionInLine() + node.getSymbol().getText().length());
        return tb;
    }

    private TrackBack getTrackBack(ParserRuleContext ctx) {
        TrackBack tb = new TrackBack(this.libraryBuilder.getLibraryIdentifier(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine() + 1, ctx.getStop().getLine(), ctx.getStop().getCharPositionInLine() + ctx.getStop().getText().length());
        return tb;
    }

    private void decorate(Element element, TrackBack tb) {
        if (this.locatorsEnabled() && tb != null) {
            element.setLocator(tb.toLocator());
        }
        if (this.resultTypesEnabled() && element.getResultType() != null) {
            if (element.getResultType() instanceof NamedType) {
                element.setResultTypeName(this.libraryBuilder.dataTypeToQName(element.getResultType()));
            } else {
                element.setResultTypeSpecifier(this.libraryBuilder.dataTypeToTypeSpecifier(element.getResultType()));
            }
        }
    }

    private TrackBack track(Trackable trackable, ParseTree pt) {
        TrackBack tb = this.getTrackBack(pt);
        if (tb != null) {
            trackable.getTrackbacks().add(tb);
        }
        if (trackable instanceof Element) {
            this.decorate((Element)trackable, tb);
        }
        return tb;
    }

    private TrackBack track(Trackable trackable, Element from) {
        TrackBack tb;
        TrackBack trackBack = tb = from.getTrackbacks().size() > 0 ? (TrackBack)from.getTrackbacks().get(0) : null;
        if (tb != null) {
            trackable.getTrackbacks().add(tb);
        }
        if (trackable instanceof Element) {
            this.decorate((Element)trackable, tb);
        }
        return tb;
    }
}

