/*
 * Decompiled with CFR 0.152.
 */
package in.tazj.vavr.matchers;

import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsAnything;

public class ControlMatchers {
    public static <T> Matcher<Option<T>> isDefined(final Matcher<T> matcher) {
        return new TypeSafeMatcher<Option<T>>(){

            protected boolean matchesSafely(Option<T> ts) {
                return (Boolean)ts.map(arg_0 -> ((Matcher)matcher).matches(arg_0)).getOrElse((Object)false);
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"Option that contains value matching ").appendDescriptionOf((SelfDescribing)matcher);
            }

            public void describeMismatchSafely(Option<T> option, Description mismatch) {
                if (option.isEmpty()) {
                    mismatch.appendText("No value was defined");
                } else {
                    option.forEach(value -> matcher.describeMismatch(value, mismatch));
                }
            }
        };
    }

    public static <T> Matcher<Option<T>> isDefined() {
        return ControlMatchers.isDefined(new IsAnything());
    }

    public static Matcher<Option> isEmpty() {
        return new TypeSafeMatcher<Option>(){

            protected boolean matchesSafely(Option option) {
                return option.isEmpty();
            }

            public void describeTo(Description description) {
                description.appendText("Optional value should not be defined");
            }

            public void describeMismatchSafely(Option option, Description mismatch) {
                mismatch.appendText("Expected empty Option but found ").appendValue(option.get());
            }
        };
    }

    public static <T> Matcher<Try<T>> isSuccess(final Matcher<T> matcher) {
        return new TypeSafeMatcher<Try<T>>(){

            protected boolean matchesSafely(Try<T> ts) {
                return (Boolean)ts.map(arg_0 -> ((Matcher)matcher).matches(arg_0)).getOrElse((Object)false);
            }

            public void describeTo(Description description) {
                description.appendText("Successful Try should contain value that matches: ").appendDescriptionOf((SelfDescribing)matcher);
            }

            public void describeMismatchSafely(Try<T> aTry, Description mismatch) {
                if (aTry.isFailure()) {
                    mismatch.appendText("Expected success but got ").appendValue((Object)aTry.getCause());
                } else {
                    mismatch.appendText("Expected successful Try value matching '").appendDescriptionOf((SelfDescribing)matcher).appendText("' but ");
                    matcher.describeMismatch(aTry.get(), mismatch);
                }
            }
        };
    }

    public static <T> Matcher<Try<T>> isSuccess() {
        return ControlMatchers.isSuccess(new IsAnything());
    }

    public static Matcher<Try> isFailure() {
        return new TypeSafeMatcher<Try>(){

            protected boolean matchesSafely(Try aTry) {
                return aTry.isFailure();
            }

            public void describeTo(Description description) {
                description.appendText("unsuccessful Try");
            }

            public void describeMismatchSafely(Try aTry, Description mismatch) {
                mismatch.appendText("Try should not have succeeded, but was ").appendValue((Object)aTry);
            }
        };
    }

    public static <E extends Throwable> Matcher<Try> hasFailedWith(final Class<E> clazz) {
        return new TypeSafeMatcher<Try>(){

            protected boolean matchesSafely(Try aTry) {
                if (aTry.isFailure()) {
                    return aTry.getCause().getClass().equals(clazz);
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("Try should have failed with ").appendText(clazz.getName());
            }

            public void describeMismatchSafely(Try aTry, Description mismatch) {
                aTry.onFailure(cause -> mismatch.appendText("Failure type is ").appendText(cause.getClass().getSimpleName()).appendText(" but expected ").appendText(clazz.getSimpleName()));
                aTry.onSuccess(val -> mismatch.appendText("Expected failure, but found successful Try with value: ").appendValue(val));
            }
        };
    }

    public static <L, R> Matcher<Either<L, R>> isRight(final Matcher<R> matcher) {
        return new TypeSafeMatcher<Either<L, R>>(){

            protected boolean matchesSafely(Either<L, R> either) {
                return (Boolean)either.map(arg_0 -> ((Matcher)matcher).matches(arg_0)).getOrElse((Object)false);
            }

            public void describeTo(Description description) {
                description.appendText("\u00bbEither\u00ab should contain a \u00bbRight\u00ab value matching: ").appendDescriptionOf((SelfDescribing)matcher);
            }

            public void describeMismatchSafely(Either<L, R> either, Description mismatch) {
                if (either.isRight()) {
                    mismatch.appendText("Expected matching \u00bbRight\u00ab value, but got: ");
                    matcher.describeMismatch(either.get(), mismatch);
                } else {
                    mismatch.appendText("Expected matching \u00bbRight\u00ab value, but got \u00bbLeft\u00ab: ").appendValue(either.getLeft());
                }
            }
        };
    }

    public static <L, R> Matcher<Either<L, R>> isRight() {
        return ControlMatchers.isRight(new IsAnything());
    }

    public static <L, R> Matcher<Either<L, R>> isLeft(final Matcher<L> matcher) {
        return new TypeSafeMatcher<Either<L, R>>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected boolean matchesSafely(Either<L, R> either) {
                if (!either.isLeft()) return false;
                if ((Boolean)either.mapLeft(arg_0 -> ((Matcher)matcher).matches(arg_0)).getLeft() == false) return false;
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("\u00bbEither\u00ab should contain a \u00bbLeft\u00ab value matching: ");
                matcher.describeTo(description);
            }

            public void describeMismatchSafely(Either<L, R> either, Description mismatch) {
                if (either.isLeft()) {
                    mismatch.appendText("Expected matching \u00bbLeft\u00ab value, but got: ");
                    matcher.describeMismatch(either.getLeft(), mismatch);
                } else {
                    mismatch.appendText("Expected matching \u00bbLeft\u00ab value, but got \u00bbRight\u00ab: ").appendValue(either.get());
                }
            }
        };
    }

    public static <L, R> Matcher<Either<L, R>> isLeft() {
        return ControlMatchers.isLeft(new IsAnything());
    }
}

