/*
 * Decompiled with CFR 0.152.
 */
package in.tazj.vavr.matchers;

import io.vavr.collection.Traversable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public class CollectionMatchers {
    public static <T extends Traversable> Matcher<T> isEmpty() {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T t) {
                return t.isEmpty();
            }

            public void describeTo(Description description) {
                description.appendText("Collection should be empty");
            }

            public void describeMismatchSafely(T t, Description mismatch) {
                mismatch.appendText("Collection was expected to be empty but has size ").appendValue((Object)t.size());
            }
        };
    }

    public static <T extends Traversable> Matcher<T> hasSize(final int size) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T t) {
                if (t.hasDefiniteSize()) {
                    return t.size() == size;
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("Collection should have size ").appendValue((Object)size);
            }

            public void describeMismatchSafely(T t, Description mismatch) {
                mismatch.appendText("Collection should have size ").appendValue((Object)size).appendText(" but actually has size ").appendValue((Object)t.size());
            }
        };
    }

    public static <T extends Traversable> Matcher<T> hasSize(final Matcher<Integer> matcher) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T t) {
                if (t.hasDefiniteSize()) {
                    return matcher.matches((Object)t.size());
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("Collection size should match: ").appendDescriptionOf((SelfDescribing)matcher);
            }

            public void describeMismatchSafely(T t, Description mismatch) {
                mismatch.appendText("Collection size does not match ").appendDescriptionOf((SelfDescribing)matcher).appendText(", size was ").appendValue((Object)t.size());
            }
        };
    }

    @Deprecated
    public static <E, T extends Traversable<E>> Matcher<T> containsElement(E element) {
        return CollectionMatchers.containsAny(Matchers.is(element));
    }

    public static <E, T extends Traversable<E>> Matcher<T> containsAny(final Matcher<E> matcher) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T t) {
                return t.find(arg_0 -> ((Matcher)matcher).matches(arg_0)).isDefined();
            }

            public void describeTo(Description description) {
                description.appendText("At least one element should match: ").appendDescriptionOf((SelfDescribing)matcher);
            }

            public void describeMismatchSafely(T t, Description mismatch) {
                mismatch.appendText("Collection expected to contain a value matching '").appendDescriptionOf((SelfDescribing)matcher).appendText("' but found ").appendValue(t);
            }
        };
    }

    public static <E, T extends Traversable<E>> Matcher<T> containsInAnyOrder(final Traversable<E> items) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T es) {
                return es.containsAll((Iterable)items);
            }

            public void describeTo(Description description) {
                description.appendText("Collection should contain: ").appendValueList("[", ",", "]", (Iterable)items);
            }

            public void describeMismatchSafely(T t, Description mismatch) {
                Iterable missing = (Iterable)items.partition(arg_0 -> t.contains(arg_0))._2();
                mismatch.appendText("Collection is missing elements: ").appendValueList("[", ",", "]", missing);
            }
        };
    }

    public static <E, T extends Traversable<E>> Matcher<T> allMatch(final Matcher<E> matcher) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T t) {
                return t.forAll(arg_0 -> ((Matcher)matcher).matches(arg_0));
            }

            public void describeTo(Description description) {
                description.appendText("All elements should match: ").appendDescriptionOf((SelfDescribing)matcher);
            }

            public void describeMismatchSafely(T t, Description mismatch) {
                mismatch.appendText("All elements should match '").appendDescriptionOf((SelfDescribing)matcher).appendText("' but found non-matching elements: ");
                mismatch.appendValueList("[", ",", "]", (Iterable)t.filter(e -> !matcher.matches(e)).toJavaList());
            }
        };
    }
}

