/*
 * Decompiled with CFR 0.152.
 */
package in.rmkrishna.mlog;

import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import in.rmkrishna.mlog.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J)\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u0013J\r\u0010\u0014\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lin/rmkrishna/mlog/MFileWriter;", "", "()V", "AVAILABLE_SPACE", "", "customLogFile", "Ljava/io/BufferedWriter;", "mFormatter", "Ljava/text/SimpleDateFormat;", "getFormattedMessage", "", "tag", "msg", "th", "", "isLoggable", "", "logToFile", "", "logToFile$mlog_release", "open", "open$mlog_release", "mlog_release"})
public final class MFileWriter {
    private final double AVAILABLE_SPACE = 5242880.0;
    private BufferedWriter customLogFile;
    private SimpleDateFormat mFormatter;

    public final void open$mlog_release() {
        String fileName;
        if (!this.isLoggable()) {
            return;
        }
        this.mFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        long ts = System.currentTimeMillis();
        if (ts <= (long)0) {
            ts = System.currentTimeMillis();
        }
        if (TextUtils.isEmpty((CharSequence)(fileName = Util.Companion.generateLogFilePath$mlog_release()))) {
            return;
        }
        File f = new File(fileName);
        if (!f.exists()) {
            f.createNewFile();
        }
        this.customLogFile = new BufferedWriter(new FileWriter(f, true));
        StringBuilder sb = new StringBuilder(400);
        sb.append("-------------------------\n");
        sb.append("Logging started Time : ").append(Util.Companion.convertTime$mlog_release(ts)).append("\n");
        sb.append("Process ID : ").append(Process.myPid()).append("\n");
        sb.append("Version code : ").append(Util.Companion.getAppVersionCode$mlog_release()).append("\n");
        sb.append("Version name : ").append(Util.Companion.getAppVersionName$mlog_release()).append("\n");
        sb.append("SDK Version : ").append("1.0").append("\n");
        sb.append("\n");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        MFileWriter.logToFile$mlog_release$default(this, "INIT", string, null, 4, null);
    }

    public final void logToFile$mlog_release(@NotNull String tag, @NotNull String msg, @Nullable Throwable th) {
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            if (this.customLogFile == null) {
                return;
            }
            String string = msg;
            Charset charset = null;
            boolean bl = true;
            Object var7_9 = null;
            Util.Companion companion = Util.Companion;
            if (bl & true) {
                charset = Charsets.UTF_8;
            }
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            if (!companion.doesSdcardHasEnufSpace$mlog_release(byArray2.length)) break block5;
            String logMsg = this.getFormattedMessage(tag, msg, th);
            if (this.customLogFile != null) {
                Object it;
                StringBuilder sb = new StringBuilder(1024);
                SimpleDateFormat simpleDateFormat = this.mFormatter;
                if (simpleDateFormat != null) {
                    SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
                    it = simpleDateFormat2;
                    String d = ((DateFormat)it).format(new Date(System.currentTimeMillis()));
                    sb.append(d).append(" ");
                }
                sb.append(logMsg);
                BufferedWriter bufferedWriter = this.customLogFile;
                if (bufferedWriter != null) {
                    BufferedWriter bufferedWriter2 = bufferedWriter;
                    it = bufferedWriter2;
                    ((Writer)it).write(sb.toString());
                    ((BufferedWriter)it).flush();
                }
            }
        }
    }

    public static /* bridge */ /* synthetic */ void logToFile$mlog_release$default(MFileWriter mFileWriter, String string, String string2, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        mFileWriter.logToFile$mlog_release(string, string2, throwable);
    }

    private final boolean isLoggable() {
        return Util.Companion.isSdCardPresent$mlog_release() && Util.Companion.doesSdcardHasEnufSpace$mlog_release(this.AVAILABLE_SPACE);
    }

    private final String getFormattedMessage(String tag, String msg, Throwable th) {
        String msg2 = msg;
        if (msg2 == null) {
            msg2 = "";
        }
        StringBuffer buffer = new StringBuffer(tag);
        buffer.append(":").append(msg2);
        buffer.append("\r\n").append(Log.getStackTraceString((Throwable)th));
        String string = buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
        return string;
    }
}

