/*
 * Decompiled with CFR 0.152.
 */
package com.payu.payuanalytics.analytics.utils;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import android.util.Log;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007J\u001c\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0014\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007J\u001e\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0007R\u0014\u0010\r\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000eR\"\u0010\u0017\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u001b\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0012\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/payu/payuanalytics/analytics/utils/EncryptionUtils;", "", "Landroid/content/Context;", "context", "Ljavax/crypto/SecretKey;", "createKeys", "getKeys", "", "data", "encrypt", "getSecretKey", "encryptedData", "decrypt", "PAYU_AES_GCM_NO_PADDING", "Ljava/lang/String;", "PAYU_ENCRYPTION_KEY_GCM", "", "a", "I", "getGCM_IV_LENGTH", "()I", "setGCM_IV_LENGTH", "(I)V", "GCM_IV_LENGTH", "b", "getGCM_TAG_LENGTH", "setGCM_TAG_LENGTH", "GCM_TAG_LENGTH", "mobileanalytics_release"})
public final class EncryptionUtils {
    @NotNull
    public static final EncryptionUtils INSTANCE = new EncryptionUtils();
    @NotNull
    public static final String PAYU_AES_GCM_NO_PADDING = "AES/GCM/NoPadding";
    @NotNull
    public static final String PAYU_ENCRYPTION_KEY_GCM = "payu_encryption_key_gcm";
    public static int a = 12;
    public static int b = 128;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final SecretKey createKeys(@NotNull Context context) {
        Context context2;
        KeyGenerator keyGenerator;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
        }
        catch (Exception exception) {
            Log.d((String)"TAG", (String)("createKey:Exception" + exception.getLocalizedMessage()));
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)keyGenerator, (String)"getInstance(\n           \u2026ID_KEYSTORE\n            )");
        if (Build.VERSION.SDK_INT >= 23) return keyGenerator.generateKey();
        KeyPairGeneratorSpec keyPairGeneratorSpec = new KeyPairGeneratorSpec.Builder(context2).setAlias("PayUKeyAlias").build();
        Intrinsics.checkNotNullExpressionValue((Object)keyPairGeneratorSpec, (String)"Builder(context)\n       \u2026                 .build()");
        keyGenerator.init((AlgorithmParameterSpec)keyPairGeneratorSpec);
        return keyGenerator.generateKey();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final SecretKey getKeys(@NotNull Context context) {
        KeyStore.Entry entry;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            entry = keyStore.getEntry("PayUKeyAlias", null);
            if (entry == null) throw new NullPointerException("null cannot be cast to non-null type java.security.KeyStore.SecretKeyEntry");
        }
        catch (Exception exception) {
            Context context2;
            Log.d((String)"TAG", (String)("getKeys:Exception" + exception.getLocalizedMessage()));
            return EncryptionUtils.createKeys(context2);
        }
        return ((KeyStore.SecretKeyEntry)entry).getSecretKey();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final String encrypt(@Nullable Context context, @NotNull String data) {
        Object object;
        void var1_3;
        block13: {
            Intrinsics.checkNotNullParameter((Object)var1_3, (String)"data");
            try {
                object = EncryptionUtils.getSecretKey(context);
                if (object != null) break block13;
            }
            catch (Exception exception) {
                Log.e((String)"EncryptionUtils", (String)"Encryption error", (Throwable)exception);
                return var1_3;
            }
            void v0 = var1_3;
            Log.e((String)"EncryptionUtils", (String)"Failed to get secret key");
            return v0;
        }
        Cipher cipher = Cipher.getInstance(PAYU_AES_GCM_NO_PADDING);
        cipher.init(1, (Key)object);
        object = cipher.getIV();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = var1_3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = cipher.doFinal(byArray);
        int n = ((Context)object).length + byArray2.length;
        byte[] byArray3 = new byte[n];
        Object object2 = object;
        int n2 = 0;
        int n3 = 0;
        int n4 = ((Context)object2).length;
        System.arraycopy(object2, n2, byArray3, n3, n4);
        n2 = 0;
        n3 = ((Context)object2).length;
        n4 = byArray2.length;
        System.arraycopy(byArray2, n2, byArray3, n3, n4);
        return Base64.encodeToString((byte[])byArray3, (int)2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    @Nullable
    public static final SecretKey getSecretKey(@Nullable Context context) {
        block7: {
            String[] stringArray;
            KeyGenParameterSpec.Builder builder;
            KeyGenerator keyGenerator;
            KeyGenerator keyGenerator2;
            try {
                Object object = KeyStore.getInstance("AndroidKeyStore");
                ((KeyStore)object).load(null);
                if (((KeyStore)object).containsAlias(PAYU_ENCRYPTION_KEY_GCM) && (object = ((KeyStore)object).getEntry(PAYU_ENCRYPTION_KEY_GCM, null)) instanceof KeyStore.SecretKeyEntry) {
                    return ((KeyStore.SecretKeyEntry)object).getSecretKey();
                }
                if (Build.VERSION.SDK_INT < 23) break block7;
                KeyGenerator keyGenerator3 = KeyGenerator.getInstance("AES", "AndroidKeyStore");
                keyGenerator2 = keyGenerator3;
                keyGenerator = keyGenerator3;
                Intrinsics.checkNotNullExpressionValue((Object)keyGenerator3, (String)"getInstance(\n           \u2026EYSTORE\n                )");
                builder = new KeyGenParameterSpec.Builder(PAYU_ENCRYPTION_KEY_GCM, 3);
                stringArray = new String[1];
            }
            catch (Exception exception) {
                Log.e((String)"EncryptionUtils", (String)"Error getting secret key", (Throwable)exception);
                return null;
            }
            stringArray[0] = "GCM";
            KeyGenParameterSpec.Builder builder2 = builder.setBlockModes(stringArray);
            String[] stringArray2 = new String[1];
            stringArray2[0] = "NoPadding";
            KeyGenParameterSpec.Builder builder3 = builder2.setEncryptionPaddings(stringArray2).setRandomizedEncryptionRequired(true).setKeySize(256);
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"Builder(\n               \u2026         .setKeySize(256)");
            keyGenerator.init((AlgorithmParameterSpec)builder3.build());
            return keyGenerator2.generateKey();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final String decrypt(@Nullable Context context, @Nullable String encryptedData) {
        void var1_2;
        if (encryptedData != null) {
            int n = 0;
            int n2 = var1_2.length() - 1;
            int n3 = 0;
            while (n <= n2) {
                int n4 = n3 == 0 ? n : n2;
                n4 = Intrinsics.compare((int)var1_2.charAt(n4), (int)32) <= 0 ? 1 : 0;
                if (n3 == 0) {
                    if (n4 == 0) {
                        n3 = 1;
                        continue;
                    }
                    ++n;
                    continue;
                }
                if (n4 == 0) break;
                --n2;
            }
            if (!(((Object)var1_2.subSequence(n, n2 + 1)).toString().length() == 0)) {
                GCMParameterSpec gCMParameterSpec;
                Object object;
                Object object2;
                block21: {
                    block20: {
                        Log.d((String)"EncryptionUtils", (String)"Encrypted data: ".concat((String)var1_2));
                        try {
                            object2 = EncryptionUtils.getSecretKey(object2);
                            if (object2 != null) break block20;
                        }
                        catch (Exception exception) {
                            Log.e((String)"EncryptionUtils", (String)("Decryption error: " + exception.getMessage()), (Throwable)exception);
                            return var1_2;
                        }
                        void v0 = var1_2;
                        Log.d((String)"EncryptionUtils", (String)"Failed to get secret key for decryption");
                        return v0;
                    }
                    object = Base64.decode((String)var1_2, (int)2);
                    n2 = a;
                    if (((byte[])object).length > n2 + 16) break block21;
                    void v1 = var1_2;
                    Log.d((String)"EncryptionUtils", (String)"Invalid encrypted data format: too short");
                    return v1;
                }
                byte[] byArray = object;
                byte[] byArray2 = object;
                byte[] byArray3 = object;
                object = new byte[n2];
                System.arraycopy(byArray2, 0, object, 0, n2);
                n2 = a;
                n3 = byArray3.length - n2;
                int n5 = n2;
                Object object3 = new byte[n3];
                System.arraycopy(byArray, n5, object3, 0, n3);
                Cipher cipher = Cipher.getInstance(PAYU_AES_GCM_NO_PADDING);
                Cipher cipher2 = cipher;
                byte[] byArray4 = object3;
                object3 = gCMParameterSpec;
                gCMParameterSpec = new GCMParameterSpec(b, (byte[])object);
                cipher2.init(2, (Key)object2, (AlgorithmParameterSpec)object3);
                byte[] byArray5 = cipher.doFinal(byArray4);
                object2 = byArray5;
                Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"decrypted");
                Charset charset = StandardCharsets.UTF_8;
                object = charset;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                return new String((byte[])object2, (Charset)object);
            }
        }
        Log.d((String)"EncryptionUtils", (String)"Empty encrypted data");
        return var1_2;
    }

    public final int getGCM_IV_LENGTH() {
        return a;
    }

    public final void setGCM_IV_LENGTH(int n) {
        a = n;
    }

    public final int getGCM_TAG_LENGTH() {
        return b;
    }

    public final void setGCM_TAG_LENGTH(int n) {
        b = n;
    }
}

