/*
 * Decompiled with CFR 0.152.
 */
package com.payu.payuanalytics.analytics.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import com.payu.payuanalytics.analytics.manager.AppContextProviderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003J\u001a\u0010\u0011\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/payu/payuanalytics/analytics/utils/ContextUtil;", "", "fileName", "", "(Ljava/lang/String;)V", "TAG", "sharedPreferences", "Landroid/content/SharedPreferences;", "checkNetwork", "", "deleteSharedPrefKey", "", "key", "getEncryptedSharedPreference", "context", "Landroid/content/Context;", "getStringSharedPreference", "setStringSharedPreference", "value", "mobileanalytics_release"})
public final class ContextUtil {
    @NotNull
    private final String TAG;
    @Nullable
    private final SharedPreferences sharedPreferences;

    public ContextUtil(@Nullable String fileName) {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.TAG = string;
        this.sharedPreferences = fileName != null ? this.getEncryptedSharedPreference(AppContextProviderKt.getApplication(), fileName) : (SharedPreferences)null;
    }

    @NotNull
    public final String getStringSharedPreference(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            SharedPreferences sharedPreferences = this.sharedPreferences;
            String string2 = sharedPreferences == null ? null : sharedPreferences.getString(key, "");
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            sharedPref\u2026ring(key, \"\")!!\n        }");
        }
        catch (Exception e) {
            this.deleteSharedPrefKey(key);
            string = "";
        }
        return string;
    }

    public final void setStringSharedPreference(@Nullable String key, @Nullable String value) {
        SharedPreferences.Editor sharedPreferencesEditor;
        SharedPreferences sharedPreferences = this.sharedPreferences;
        SharedPreferences.Editor editor = sharedPreferencesEditor = sharedPreferences == null ? null : sharedPreferences.edit();
        if (editor != null) {
            editor.putString(key, value);
        }
        SharedPreferences.Editor editor2 = sharedPreferencesEditor;
        if (editor2 != null) {
            editor2.apply();
        }
    }

    public final void deleteSharedPrefKey(@Nullable String key) {
        try {
            SharedPreferences.Editor sharedPreferencesEditor;
            SharedPreferences sharedPreferences = this.sharedPreferences;
            SharedPreferences.Editor editor = sharedPreferencesEditor = sharedPreferences == null ? null : sharedPreferences.edit();
            if (editor != null) {
                editor.remove(key);
            }
            SharedPreferences.Editor editor2 = sharedPreferencesEditor;
            if (editor2 != null) {
                editor2.apply();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final boolean checkNetwork() {
        ConnectivityManager cm;
        Context context = AppContextProviderKt.getApplication().getApplicationContext();
        Object object = context == null ? null : context.getSystemService("connectivity");
        ConnectivityManager connectivityManager = cm = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        if (connectivityManager != null) {
            ConnectivityManager it = connectivityManager;
            boolean bl = false;
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            return activeNetwork != null && activeNetwork.isConnectedOrConnecting();
        }
        return false;
    }

    private final SharedPreferences getEncryptedSharedPreference(Context context, String fileName) {
        try {
            MasterKey masterKey = new MasterKey.Builder(context).setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
            Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"Builder(context)\n       \u2026\n                .build()");
            MasterKey masterKeyAlias = masterKey;
            return EncryptedSharedPreferences.create((Context)context, (String)fileName, (MasterKey)masterKeyAlias, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        }
        catch (Exception e) {
            Log.d((String)this.TAG, (String)Intrinsics.stringPlus((String)"getEncryptedSharedPreference Exception =", (Object)e.getMessage()));
            return null;
        }
    }
}

