/*
 * Decompiled with CFR 0.152.
 */
package com.payu.payuanalytics.analytics.manager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import com.payu.payuanalytics.analytics.listener.OnEventsLogListener;
import com.payu.payuanalytics.analytics.manager.AppContextProviderKt;
import com.payu.payuanalytics.analytics.model.BaseAnalytics;
import com.payu.payuanalytics.analytics.network.UploadTask;
import com.payu.payuanalytics.analytics.utils.ContextUtil;
import com.payu.payuanalytics.analytics.utils.Lock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0003J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0006J*\u0010\u0019\u001a\u00020\u001a2\"\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001cj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d`\u001eJ\b\u0010\u001f\u001a\u00020\u0012H\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0006H\u0016J\u0006\u0010\"\u001a\u00020\u0012J \u0010#\u001a\u00020\u00062\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020\u0012H\u0002J\b\u0010)\u001a\u00020\u0012H\u0002J\b\u0010*\u001a\u00020\u0012H\u0002J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0006H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/payu/payuanalytics/analytics/manager/AnalyticsDataManager;", "Lcom/payu/payuanalytics/analytics/listener/OnEventsLogListener;", "baseAnalytics", "Lcom/payu/payuanalytics/analytics/model/BaseAnalytics;", "(Lcom/payu/payuanalytics/analytics/model/BaseAnalytics;)V", "TAG", "", "getBaseAnalytics", "()Lcom/payu/payuanalytics/analytics/model/BaseAnalytics;", "setBaseAnalytics", "enabled", "", "fileName", "isTimerCancelled", "mTimer", "Ljava/util/Timer;", "sharedPrefkey", "cancelTimer", "", "copyBufferToFile", "Lorg/json/JSONArray;", "fileJsonArray", "bufferJsonArray", "log", "msg", "maptojson", "Lorg/json/JSONObject;", "dataMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "onEventsLoggedFailed", "onEventsLoggedSuccessful", "response", "pushAllPendingEvents", "readFileInputStream", "mContext", "Landroid/content/Context;", "contextMode", "", "releaseFileLockAndResetTimer", "resetTimer", "sendEventsToAnalyticsPortal", "storeInBuffer", "mobileanalytics_release"})
@SuppressLint(value={"StaticFieldLeak"})
public final class AnalyticsDataManager
implements OnEventsLogListener {
    @NotNull
    private BaseAnalytics baseAnalytics;
    @Nullable
    private final String TAG;
    @NotNull
    private String fileName;
    @NotNull
    private String sharedPrefkey;
    @Nullable
    private Timer mTimer;
    private boolean isTimerCancelled;
    private boolean enabled;

    public AnalyticsDataManager(@NotNull BaseAnalytics baseAnalytics) {
        Intrinsics.checkNotNullParameter((Object)baseAnalytics, (String)"baseAnalytics");
        this.baseAnalytics = baseAnalytics;
        this.TAG = Reflection.getOrCreateKotlinClass(AnalyticsDataManager.class).getSimpleName();
        this.fileName = Intrinsics.stringPlus((String)this.baseAnalytics.getAnalyticsFileName(), (Object)this.baseAnalytics.getAnalyticsConfig().getInitiatorIdentifier());
        this.sharedPrefkey = Intrinsics.stringPlus((String)"analytics_buffer_key", (Object)this.baseAnalytics.getAnalyticsConfig().getInitiatorIdentifier());
        Thread.UncaughtExceptionHandler defaultUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler unCaughtExceptionHandler = (arg_0, arg_1) -> AnalyticsDataManager._init_$lambda-3(this, defaultUEH, arg_0, arg_1);
        Thread.setDefaultUncaughtExceptionHandler(unCaughtExceptionHandler);
    }

    @NotNull
    public final BaseAnalytics getBaseAnalytics() {
        return this.baseAnalytics;
    }

    public final void setBaseAnalytics(@NotNull BaseAnalytics baseAnalytics) {
        Intrinsics.checkNotNullParameter((Object)baseAnalytics, (String)"<set-?>");
        this.baseAnalytics = baseAnalytics;
    }

    public final void log(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (Lock.INSTANCE.getMainFileLocked()) {
            this.storeInBuffer(msg);
        } else {
            Runnable runnable = () -> AnalyticsDataManager.log$lambda-0(this, msg);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.submit(runnable);
        }
    }

    @NotNull
    public final JSONObject maptojson(@NotNull HashMap<String, Object> dataMap) {
        Intrinsics.checkNotNullParameter(dataMap, (String)"dataMap");
        JSONObject jsonobject = new JSONObject();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            String string = entry.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.key");
            String key = string;
            if (entry.getValue() == null) continue;
            jsonobject.put(key, entry.getValue());
        }
        return jsonobject;
    }

    private final void storeInBuffer(String msg) {
        try {
            String str = new ContextUtil(this.fileName).getStringSharedPreference(this.sharedPrefkey);
            JSONArray jsonArray = str != null && !StringsKt.equals((String)str, (String)"", (boolean)true) ? new JSONArray(str) : new JSONArray();
            JSONObject newAnalyticsEvent = new JSONObject(msg);
            jsonArray.put((Object)newAnalyticsEvent);
            new ContextUtil(this.fileName).setStringSharedPreference(this.sharedPrefkey, jsonArray.toString());
        }
        catch (Exception e) {
            Log.d((String)this.TAG, (String)String.valueOf(e.getMessage()));
        }
    }

    private final void resetTimer() {
        this.cancelTimer();
        this.mTimer = new Timer();
        this.isTimerCancelled = false;
        try {
            Timer timer = this.mTimer;
            Intrinsics.checkNotNull((Object)timer);
            timer.schedule(new TimerTask(this){
                final /* synthetic */ AnalyticsDataManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void run() {
                    AnalyticsDataManager.access$sendEventsToAnalyticsPortal(this.this$0);
                }
            }, this.baseAnalytics.getTimerDelay());
        }
        catch (Exception e) {
            Log.d((String)this.TAG, (String)String.valueOf(e.getMessage()));
        }
    }

    public final void cancelTimer() {
        if (this.mTimer != null && !this.isTimerCancelled) {
            Timer timer = this.mTimer;
            Intrinsics.checkNotNull((Object)timer);
            timer.cancel();
            Timer timer2 = this.mTimer;
            Intrinsics.checkNotNull((Object)timer2);
            timer2.purge();
            this.isTimerCancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendEventsToAnalyticsPortal() {
        block17: {
            block18: {
                String temp;
                block16: {
                    if (Lock.INSTANCE.getMainFileLocked()) {
                        return;
                    }
                    Lock.INSTANCE.setLock();
                    if (!new ContextUtil(null).checkNetwork()) break block18;
                    temp = "";
                    try {
                        if (!this.enabled) break block16;
                        temp = this.readFileInputStream(AppContextProviderKt.getApplication(), this.fileName, 0);
                    }
                    catch (Throwable throwable) {
                        try {
                            Ref.ObjectRef tempJsonArray = new Ref.ObjectRef();
                            tempJsonArray.element = !StringsKt.equals((String)temp, (String)"", (boolean)true) ? new JSONArray(temp) : new JSONArray();
                            if (new ContextUtil(this.fileName).getStringSharedPreference(this.sharedPrefkey).length() > 1) {
                                JSONArray analyticsBufferArray = new JSONArray(new ContextUtil(this.fileName).getStringSharedPreference(this.sharedPrefkey));
                                if (this.enabled) {
                                    tempJsonArray.element = this.copyBufferToFile((JSONArray)tempJsonArray.element, analyticsBufferArray);
                                } else {
                                    tempJsonArray.element = analyticsBufferArray;
                                    new ContextUtil(this.fileName).deleteSharedPrefKey(this.sharedPrefkey);
                                }
                            }
                            if (((JSONArray)tempJsonArray.element).length() > 0) {
                                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Ref.ObjectRef<JSONArray>)tempJsonArray, null){
                                    int label;
                                    final /* synthetic */ AnalyticsDataManager this$0;
                                    final /* synthetic */ Ref.ObjectRef<JSONArray> $tempJsonArray;
                                    {
                                        this.this$0 = $receiver;
                                        this.$tempJsonArray = $tempJsonArray;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                BaseAnalytics baseAnalytics = this.this$0.getBaseAnalytics();
                                                Intrinsics.checkNotNull((Object)baseAnalytics);
                                                String string = ((JSONArray)this.$tempJsonArray.element).toString();
                                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tempJsonArray.toString()");
                                                this.label = 1;
                                                Object object3 = new UploadTask(baseAnalytics, string, AnalyticsDataManager.access$getEnabled$p(this.this$0)).push((Continuation<? super Unit>)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                            } else {
                                this.cancelTimer();
                                Lock.INSTANCE.releaseLock();
                            }
                        }
                        catch (Exception e) {
                            Log.d((String)this.TAG, (String)String.valueOf(e.getMessage()));
                            this.releaseFileLockAndResetTimer();
                        }
                        throw throwable;
                    }
                }
                try {
                    Ref.ObjectRef tempJsonArray = new Ref.ObjectRef();
                    tempJsonArray.element = temp != null && !StringsKt.equals((String)temp, (String)"", (boolean)true) ? new JSONArray(temp) : new JSONArray();
                    if (new ContextUtil(this.fileName).getStringSharedPreference(this.sharedPrefkey).length() > 1) {
                        JSONArray analyticsBufferArray = new JSONArray(new ContextUtil(this.fileName).getStringSharedPreference(this.sharedPrefkey));
                        if (this.enabled) {
                            tempJsonArray.element = this.copyBufferToFile((JSONArray)tempJsonArray.element, analyticsBufferArray);
                        } else {
                            tempJsonArray.element = analyticsBufferArray;
                            new ContextUtil(this.fileName).deleteSharedPrefKey(this.sharedPrefkey);
                        }
                    }
                    if (((JSONArray)tempJsonArray.element).length() > 0) {
                        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)3, null);
                        break block17;
                    }
                    this.cancelTimer();
                    Lock.INSTANCE.releaseLock();
                }
                catch (Exception e) {
                    Log.d((String)this.TAG, (String)String.valueOf(e.getMessage()));
                    this.releaseFileLockAndResetTimer();
                }
                break block17;
            }
            Lock.INSTANCE.releaseLock();
        }
    }

    public final void pushAllPendingEvents() {
        Runnable runnable = () -> AnalyticsDataManager.pushAllPendingEvents$lambda-1(this);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(runnable);
    }

    private final void releaseFileLockAndResetTimer() {
        Lock.INSTANCE.releaseLock();
        if (new ContextUtil(this.fileName).getStringSharedPreference(this.sharedPrefkey).length() > 1) {
            this.resetTimer();
        }
    }

    @NotNull
    public final String readFileInputStream(@Nullable Context mContext, @NotNull String fileName, int contextMode) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        int c = 0;
        String temp = "";
        try {
            Context context = mContext;
            Intrinsics.checkNotNull((Object)context);
            File file = new File(context.getFilesDir(), fileName);
            if (!file.exists()) {
                mContext.openFileOutput(fileName, contextMode);
            }
            FileInputStream fileInputStream = mContext.openFileInput(fileName);
            while (true) {
                int n;
                int it = n = fileInputStream.read();
                boolean bl = false;
                c = it;
                if (n == -1) break;
                temp = Intrinsics.stringPlus((String)temp, (Object)Character.valueOf((char)c));
            }
            fileInputStream.close();
        }
        catch (FileNotFoundException e) {
            Log.d((String)this.TAG, (String)String.valueOf(e.getMessage()));
        }
        catch (IOException e) {
            Log.d((String)this.TAG, (String)String.valueOf(e.getMessage()));
        }
        catch (Exception e) {
            Log.d((String)this.TAG, (String)String.valueOf(e.getMessage()));
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"StaticFieldLeak"})
    private final JSONArray copyBufferToFile(JSONArray fileJsonArray, JSONArray bufferJsonArray) {
        JSONArray jSONArray;
        FileOutputStream fileOutputStream = null;
        try {
            JSONArray mergeJsonArray = new JSONArray(fileJsonArray.toString());
            int n = 0;
            int n2 = bufferJsonArray.length();
            while (n < n2) {
                int i = n++;
                JSONObject jsonObject = bufferJsonArray.getJSONObject(i);
                mergeJsonArray.put((Object)jsonObject);
            }
            fileOutputStream = AppContextProviderKt.getApplication().openFileOutput(this.fileName, 0);
            String string = mergeJsonArray.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mergeJsonArray.toString()");
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            fileOutputStream.write(byArray);
            new ContextUtil(this.fileName).deleteSharedPrefKey(this.sharedPrefkey);
            jSONArray = mergeJsonArray;
        }
        catch (Exception e) {
            Log.d((String)this.TAG, (String)String.valueOf(e.getMessage()));
            jSONArray = fileJsonArray;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    Log.d((String)this.TAG, (String)String.valueOf(e.getMessage()));
                }
            }
        }
        return jSONArray;
    }

    @Override
    public void onEventsLoggedSuccessful(@NotNull String response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        boolean isFileDeleted = AppContextProviderKt.getApplication().deleteFile(this.fileName);
        Log.d((String)"KMM LOG", (String)Intrinsics.stringPlus((String)"FILE DELETED => ", (Object)isFileDeleted));
        this.releaseFileLockAndResetTimer();
    }

    @Override
    public void onEventsLoggedFailed() {
        Lock.INSTANCE.releaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void log$lambda-0(AnalyticsDataManager this$0, String $msg) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
        if (this$0.enabled) {
            while (Lock.INSTANCE.getMainFileLocked()) {
            }
            try {
                JSONObject newObject = new JSONObject($msg);
                JSONArray jsonArray = null;
                String temp = this$0.readFileInputStream(AppContextProviderKt.getApplication(), this$0.fileName, 0);
                jsonArray = StringsKt.equals((String)temp, (String)"", (boolean)true) ? new JSONArray() : new JSONArray(temp);
                FileOutputStream fileOutputStream = AppContextProviderKt.getApplication().openFileOutput(this$0.fileName, 0);
                jsonArray.put(jsonArray.length(), (Object)newObject);
                String string = jsonArray.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonArray.toString()");
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (Exception e) {
                this$0.storeInBuffer($msg);
            }
            finally {
                this$0.resetTimer();
            }
        } else {
            this$0.storeInBuffer($msg);
            this$0.resetTimer();
        }
    }

    private static final void pushAllPendingEvents$lambda-1(AnalyticsDataManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.sendEventsToAnalyticsPortal();
    }

    private static final void _init_$lambda-3(AnalyticsDataManager this$0, Thread.UncaughtExceptionHandler $defaultUEH, Thread thread, Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        while (Lock.INSTANCE.getMainFileLocked()) {
        }
        try {
            Context context = AppContextProviderKt.getApplication();
            FileOutputStream fileOutputStream = context == null ? null : context.openFileOutput(this$0.fileName, 0);
            int c = new ContextUtil(this$0.fileName).getStringSharedPreference(this$0.sharedPrefkey).length();
            if (c > 0) {
                JSONArray jsonArray = new JSONArray();
                JSONArray bufferJsonArray = new JSONArray(new ContextUtil(this$0.fileName).getStringSharedPreference(this$0.sharedPrefkey).toString());
                int n = 0;
                int n2 = bufferJsonArray.length();
                while (n < n2) {
                    int i = n++;
                    JSONObject jsonObject = bufferJsonArray.getJSONObject(i);
                    jsonArray.put(jsonArray.length(), (Object)jsonObject);
                }
                FileOutputStream fileOutputStream2 = fileOutputStream;
                if (fileOutputStream2 != null) {
                    String string = jsonArray.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonArray.toString()");
                    byte[] byArray = string.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    fileOutputStream2.write(byArray);
                }
                new ContextUtil(this$0.fileName).deleteSharedPrefKey(this$0.sharedPrefkey);
            }
            FileOutputStream fileOutputStream3 = fileOutputStream;
            if (fileOutputStream3 != null) {
                fileOutputStream3.close();
            }
        }
        catch (IOException e) {
            Log.d((String)this$0.TAG, (String)String.valueOf(e.getMessage()));
        }
        catch (Exception e) {
            Log.d((String)this$0.TAG, (String)String.valueOf(e.getMessage()));
        }
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = $defaultUEH;
        if (uncaughtExceptionHandler != null) {
            uncaughtExceptionHandler.uncaughtException(thread, ex);
        }
    }

    public static final /* synthetic */ void access$sendEventsToAnalyticsPortal(AnalyticsDataManager $this) {
        $this.sendEventsToAnalyticsPortal();
    }

    public static final /* synthetic */ boolean access$getEnabled$p(AnalyticsDataManager $this) {
        return $this.enabled;
    }
}

