/*
 * Decompiled with CFR 0.152.
 */
package com.payu.payuanalytics.analytics.factory;

import com.payu.payuanalytics.analytics.model.AnalyticsConfig;
import com.payu.payuanalytics.analytics.model.AnalyticsType;
import com.payu.payuanalytics.analytics.model.BaseAnalytics;
import com.payu.payuanalytics.analytics.model.ClevertapAnalytics;
import com.payu.payuanalytics.analytics.model.PayUAnalytics;
import com.payu.payuanalytics.analytics.model.PayUDeviceAnalytics;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/payu/payuanalytics/analytics/factory/AnalyticsFactory;", "", "context", "analyticsConfig", "Lcom/payu/payuanalytics/analytics/model/AnalyticsConfig;", "(Ljava/lang/Object;Lcom/payu/payuanalytics/analytics/model/AnalyticsConfig;)V", "(Ljava/lang/Object;)V", "baseAnalyticsMap", "Ljava/util/HashMap;", "", "Lcom/payu/payuanalytics/analytics/model/BaseAnalytics;", "Lkotlin/collections/HashMap;", "getContext", "()Ljava/lang/Object;", "setContext", "getAnalyticsClass", "type", "Lcom/payu/payuanalytics/analytics/model/AnalyticsType;", "mobileanalytics_release"})
public final class AnalyticsFactory {
    @Nullable
    private Object context;
    @NotNull
    private AnalyticsConfig analyticsConfig;
    @NotNull
    private HashMap<String, BaseAnalytics> baseAnalyticsMap;

    public AnalyticsFactory(@Nullable Object context) {
        this.context = context;
        this.baseAnalyticsMap = new HashMap();
        this.analyticsConfig = new AnalyticsConfig();
    }

    @Nullable
    public final Object getContext() {
        return this.context;
    }

    public final void setContext(@Nullable Object object) {
        this.context = object;
    }

    public AnalyticsFactory(@Nullable Object context, @NotNull AnalyticsConfig analyticsConfig) {
        Intrinsics.checkNotNullParameter((Object)analyticsConfig, (String)"analyticsConfig");
        this(context);
        this.analyticsConfig = analyticsConfig;
    }

    @Nullable
    public final BaseAnalytics getAnalyticsClass(@NotNull AnalyticsType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String analyticsIdentifierKey = Intrinsics.stringPlus((String)this.analyticsConfig.getInitiatorIdentifier(), (Object)((Object)type));
        BaseAnalytics analytics = this.baseAnalyticsMap.get(analyticsIdentifierKey);
        if (analytics == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    CharSequence charSequence = this.analyticsConfig.getCtAccountId();
                    if (charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)this.analyticsConfig.getCtPassCode()) == null || charSequence.length() == 0) break;
                    analytics = new ClevertapAnalytics("https://in.api.clevertap.com/1/upload", this.analyticsConfig);
                    ((Map)this.baseAnalyticsMap).put(analyticsIdentifierKey, analytics);
                    return analytics;
                }
                case 2: {
                    analytics = this.analyticsConfig.isProduction() ? (BaseAnalytics)new PayUAnalytics("https://info.payu.in/merchant/MobileAnalytics", this.analyticsConfig) : (BaseAnalytics)new PayUAnalytics("https://mobiletest.payu.in/merchant/MobileAnalytics", this.analyticsConfig);
                    ((Map)this.baseAnalyticsMap).put(analyticsIdentifierKey, analytics);
                    return analytics;
                }
                case 3: {
                    analytics = this.analyticsConfig.isProduction() ? (BaseAnalytics)new PayUDeviceAnalytics("https://info.payu.in/merchant/MobileAnalytics", this.analyticsConfig) : (BaseAnalytics)new PayUDeviceAnalytics("https://info.payu.in/merchant/MobileAnalytics", this.analyticsConfig);
                    ((Map)this.baseAnalyticsMap).put(analyticsIdentifierKey, analytics);
                    return analytics;
                }
            }
        }
        return null;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnalyticsType.values().length];
            nArray[AnalyticsType.CLEVERTAP.ordinal()] = 1;
            nArray[AnalyticsType.PAYU_ANALYTICS.ordinal()] = 2;
            nArray[AnalyticsType.PAYU_DEVICE_ANALYTICS.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

