/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.FetchIFSCDetailsListener;
import com.payu.india.Model.IFSCCodeDetails;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchIFSCDetailsTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    FetchIFSCDetailsListener mIfscDetailsListener;

    public FetchIFSCDetailsTask(FetchIFSCDetailsListener ifscDetailsListener) {
        this.mIfscDetailsListener = ifscDetailsListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        InputStream responseInputStream = null;
        try {
            PayuConfig payuConfig = params[0];
            URL url = payuConfig.getEnvironment() == 2 ? new URL("https://sandbox.payu.in/") : new URL("https://api.payu.in/");
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.GET).setRequestType("application/json").setURL(url + "sdk/verifyIFSC" + "?ifscCode=" + payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader("fetch_IFSC")).build();
            HttpsURLConnection conn = PayuUtils.getHttpsConnForGetRequest(request);
            if (null != conn) {
                int i;
                int statusCode = conn.getResponseCode();
                responseInputStream = statusCode >= 200 && statusCode < 400 ? conn.getInputStream() : conn.getErrorStream();
                StringBuilder responseStringBuilder = new StringBuilder();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuilder.append(new String(byteContainer, 0, i));
                }
                JSONObject response = new JSONObject(responseStringBuilder.toString());
                payuResponse.setRawResponse(response);
                if (conn.getResponseCode() == 200 && response.optJSONObject("response") != null) {
                    JSONObject resultObject = response.getJSONObject("response").optJSONObject("result");
                    if (resultObject != null) {
                        IFSCCodeDetails ifscCodeDetails = new IFSCCodeDetails();
                        ifscCodeDetails.setBank(resultObject.optString("bank"));
                        ifscCodeDetails.setCity(resultObject.optString("city"));
                        ifscCodeDetails.setIfsc(resultObject.optString("ifsc"));
                        ifscCodeDetails.setMicr(resultObject.optString("micr"));
                        ifscCodeDetails.setState(resultObject.optString("state"));
                        ifscCodeDetails.setBranch(resultObject.optString("branch"));
                        ifscCodeDetails.setOffice(resultObject.optString("office"));
                        ifscCodeDetails.setAddress(resultObject.optString("address"));
                        ifscCodeDetails.setContact(resultObject.optString("contact"));
                        ifscCodeDetails.setDistrict(resultObject.optString("district"));
                        payuResponse.setIfscCodeDetails(ifscCodeDetails);
                        postData.setCode(0);
                        postData.setStatus("SUCCESS");
                    } else {
                        postData.setCode(5051);
                        postData.setResult("Invalid IFSC Details");
                        postData.setStatus("ERROR");
                    }
                } else if (conn.getResponseCode() == 429) {
                    postData.setCode(conn.getResponseCode());
                    postData.setResult("Oops! Too many requests. Please try after sometime");
                    postData.setStatus("ERROR");
                } else if (conn.getResponseCode() == 400) {
                    postData.setCode(conn.getResponseCode());
                    postData.setResult("IFSC not found");
                    postData.setStatus("ERROR");
                } else {
                    postData.setCode(conn.getResponseCode());
                    postData.setResult(response.optString("description"));
                    postData.setStatus("ERROR");
                }
                payuResponse.setResponseStatus(postData);
            }
        }
        catch (IOException | JSONException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Exception " + e.getMessage()));
        }
        finally {
            if (responseInputStream != null) {
                PayuUtils.safeClose(responseInputStream);
            }
        }
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.mIfscDetailsListener.onIFSCDetailsReceived(payuResponse);
    }
}

