/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model;

import com.payu.india.Payu.PayuUtils;
import com.payu.paymentparamhelper.V2ApiBase;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CalculateEmiRequest
extends V2ApiBase {
    private long txnAmount;
    private long additionalCharges;
    private JSONArray offerKeys;
    private boolean autoApplyOffer;
    private List<String> bankCodes;
    private List<String> emiCodes;
    private String skuDetails;
    private JSONObject validateSku;
    private final String percentageAdditionalCharges;
    private final String additionalCharge;
    private final String txnId;
    private final String cardBin;

    private CalculateEmiRequest(Builder builder) {
        this.txnAmount = builder.txnAmount;
        this.additionalCharges = builder.additionalCharges;
        this.offerKeys = builder.offerKeys;
        this.autoApplyOffer = builder.autoApplyOffer;
        this.bankCodes = builder.bankCodes;
        this.emiCodes = builder.emiCodes;
        this.skuDetails = builder.skuDetails;
        this.percentageAdditionalCharges = builder.percentageAdditionalCharges;
        this.additionalCharge = builder.additionalCharge;
        this.txnId = builder.txnId;
        this.cardBin = builder.cardBin;
    }

    public String getJson() {
        try {
            JSONObject jsonObject = new JSONObject();
            if (this.skuDetails != null) {
                jsonObject = this.getSkuJson(this.skuDetails);
            }
            jsonObject.put("txnAmount", this.txnAmount);
            jsonObject.put("additionalCharges", this.additionalCharges);
            if (this.offerKeys != null && this.offerKeys.length() > 0) {
                jsonObject.put("offerKeys", (Object)this.offerKeys);
            }
            jsonObject.put("autoApplyOffer", this.autoApplyOffer);
            jsonObject.put("bankCodes", this.bankCodes);
            JSONArray emiCodesArray = new JSONArray();
            for (String emiCode : this.emiCodes) {
                emiCodesArray.put((Object)emiCode);
            }
            jsonObject.put("emiCodes", (Object)emiCodesArray);
            jsonObject.put("disableOverrideNceConfig", true);
            jsonObject.put("percentageAdditionalCharges", (Object)this.percentageAdditionalCharges);
            jsonObject.put("merchantAdditionalCharges", (Object)this.additionalCharge);
            jsonObject.put("txnId", (Object)this.txnId);
            jsonObject.put("bin", (Object)this.cardBin);
            return jsonObject.toString();
        }
        catch (JSONException e) {
            return null;
        }
    }

    public JSONObject getSkuJson(String skuDetails) {
        skuDetails = PayuUtils.replaceString(skuDetails, "sku_id", "skuId");
        skuDetails = PayuUtils.replaceString(skuDetails, "amount_per_sku", "skuAmount");
        skuDetails = PayuUtils.replaceString(skuDetails, "amount_per_sku", "skuAmount");
        skuDetails = PayuUtils.replaceString(skuDetails, "offer_key", "offerKeys");
        skuDetails = PayuUtils.replaceString(skuDetails, "offer_auto_apply", "autoApply");
        skuDetails = PayuUtils.replaceString(skuDetails, "sku_details", "skus");
        try {
            return new JSONObject(skuDetails);
        }
        catch (JSONException exception) {
            return new JSONObject();
        }
    }

    public static class Builder {
        private long txnAmount;
        private long additionalCharges;
        private JSONArray offerKeys;
        private boolean autoApplyOffer;
        private List<String> bankCodes;
        private List<String> emiCodes;
        private String skuDetails;
        private String percentageAdditionalCharges;
        private String additionalCharge;
        private String txnId;
        private String cardBin;

        public long getTxnAmount() {
            return this.txnAmount;
        }

        public Builder setTxnAmount(long txnAmount) {
            this.txnAmount = txnAmount;
            return this;
        }

        public Builder setAdditionalCharges(long additionalCharges) {
            this.additionalCharges = additionalCharges;
            return this;
        }

        public Builder setOfferKeys(JSONArray offerKeys) {
            this.offerKeys = offerKeys;
            return this;
        }

        public Builder setAutoApplyOffer(boolean autoApplyOffer) {
            this.autoApplyOffer = autoApplyOffer;
            return this;
        }

        public Builder setBankCodes(List<String> bankCodes) {
            this.bankCodes = bankCodes;
            return this;
        }

        public Builder setEmiCodes(List<String> emiCodes) {
            this.emiCodes = emiCodes;
            return this;
        }

        public Builder setSkus(String skuDetails) {
            this.skuDetails = skuDetails;
            return this;
        }

        public Builder setPercentageAdditionalCharges(String percentageAdditionalCharges) {
            this.percentageAdditionalCharges = percentageAdditionalCharges;
            return this;
        }

        public Builder setAdditionalCharge(String additionalCharge) {
            this.additionalCharge = additionalCharge;
            return this;
        }

        public Builder setTxnId(String txnId) {
            this.txnId = txnId;
            return this;
        }

        public Builder setCardBin(String cardBin) {
            this.cardBin = cardBin;
            return this;
        }

        public CalculateEmiRequest build() {
            return new CalculateEmiRequest(this);
        }
    }
}

