/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.CheckoutDetailsListener;
import com.payu.india.Model.Bnpl;
import com.payu.india.Model.Emi;
import com.payu.india.Model.PayUEmiTenures;
import com.payu.india.Model.PaymentDetails;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuOffer;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetCheckoutDetailsTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private CheckoutDetailsListener mCheckoutDetailsListener;

    public GetCheckoutDetailsTask(CheckoutDetailsListener checkoutDetailsListener) {
        this.mCheckoutDetailsListener = checkoutDetailsListener;
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
    }

    /*
     * Exception decompiling
     */
    protected PayuResponse doInBackground(PayuConfig ... params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ArrayList<Emi> getEmiList(JSONObject details, String emiType) throws JSONException {
        JSONObject ccObject = details.getJSONObject("paymentOptions").getJSONObject("emi").getJSONObject("all").optJSONObject(emiType);
        if (ccObject != null && ccObject.optJSONObject("all") != null) {
            JSONObject allObject = ccObject.getJSONObject("all");
            Iterator keysIterator = allObject.keys();
            ArrayList<Emi> emiList = new ArrayList<Emi>();
            while (keysIterator.hasNext()) {
                String code = (String)keysIterator.next();
                JSONObject emiObject = allObject.getJSONObject(code);
                Emi emi = new Emi();
                emi.setBankName(code);
                emi.setBankTitle(emiObject.optString("title"));
                emi.setShortTitle(emiObject.optString("shortTitle"));
                emi.setMinAmount(emiObject.optString("minimumAmount"));
                emi.setMaxAmount(emiObject.optString("maximumAmount"));
                JSONObject tenureOptions = emiObject.getJSONObject("tenureOptions");
                JSONObject bankEligibility = emiObject.optJSONObject("eligibility");
                if (bankEligibility != null) {
                    emi.setStatus(bankEligibility.optBoolean("status"));
                    emi.setReason(bankEligibility.optString("reason"));
                }
                ArrayList<PayUEmiTenures> payUEmiTenuresList = new ArrayList<PayUEmiTenures>();
                Iterator tenureKeysIterator = tenureOptions.keys();
                while (tenureKeysIterator.hasNext()) {
                    String bankCode = (String)tenureKeysIterator.next();
                    JSONObject tenureObject = tenureOptions.getJSONObject(bankCode);
                    JSONObject eligibility = tenureObject.optJSONObject("eligibility");
                    PayUEmiTenures payUEmiTenures = new PayUEmiTenures();
                    payUEmiTenures.setBankCode(bankCode);
                    payUEmiTenures.setAdditionalCharge(tenureObject.optString("additionalCharge"));
                    payUEmiTenures.setBankDown(this.getBankDownStatus(details.optJSONObject("downInfo"), "emi", bankCode));
                    payUEmiTenures.setOfferDetailsList(this.getOffersList(details.optJSONArray("offers"), tenureObject.optJSONArray("offers")));
                    payUEmiTenures.setMinAmount(tenureObject.optString("minimumAmount"));
                    payUEmiTenures.setMaxAmount(tenureObject.optString("maximumAmount"));
                    payUEmiTenures.setTenure(tenureObject.optString("tenure"));
                    payUEmiTenures.setInterestRate(tenureObject.optString("interestRate"));
                    payUEmiTenures.setMonthlyEmi(tenureObject.optString("monthlyEmi"));
                    payUEmiTenures.setInterestCharged(tenureObject.optString("interestCharged"));
                    payUEmiTenures.setPaybackAmount(tenureObject.optString("paybackAmount"));
                    payUEmiTenures.setBankCharge(tenureObject.optString("bankCharge"));
                    if (eligibility != null) {
                        payUEmiTenures.setStatus(eligibility.optBoolean("status"));
                        payUEmiTenures.setReason(eligibility.optString("reason"));
                    }
                    payUEmiTenuresList.add(payUEmiTenures);
                }
                emi.setPayUEmiTenuresList(payUEmiTenuresList);
                emiList.add(emi);
            }
            return emiList;
        }
        return null;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.mCheckoutDetailsListener.onCheckoutDetailsResponse(payuResponse);
    }

    private PaymentDetails getPhonePeIntentFromList(ArrayList<PaymentDetails> paymentDetailsList) {
        if (paymentDetailsList == null || paymentDetailsList.size() == 0 || "PPINTENT" == null || "PPINTENT".isEmpty()) {
            return null;
        }
        for (PaymentDetails paymentDetails : paymentDetailsList) {
            if (!paymentDetails.getBankCode().equalsIgnoreCase("PPINTENT")) continue;
            return paymentDetails;
        }
        return null;
    }

    private ArrayList<PaymentDetails> prepareListWithKeyData(JSONObject details, String key) throws JSONException {
        JSONObject allObject = details.getJSONObject("paymentOptions").getJSONObject(key).getJSONObject("all");
        ArrayList<PaymentDetails> paymentDetailsList = new ArrayList<PaymentDetails>();
        Iterator keysIterator = allObject.keys();
        while (keysIterator.hasNext()) {
            String bankCode = (String)keysIterator.next();
            JSONObject ccObject = allObject.getJSONObject(bankCode);
            PaymentDetails paymentDetails = new PaymentDetails();
            paymentDetails.setBankCode(bankCode);
            paymentDetails.setBankName(ccObject.optString("title"));
            paymentDetails.setAdditionalCharge(ccObject.optString("additionalCharge"));
            paymentDetails.setIsSecureWebview(ccObject.optBoolean("secureWebview"));
            paymentDetails.setBankDown(this.getBankDownStatus(details.optJSONObject("downInfo"), key, bankCode));
            paymentDetails.setOfferDetailsList(this.getOffersList(details.optJSONArray("offers"), ccObject.optJSONArray("offers")));
            JSONArray verificationModeJsonArray = ccObject.optJSONArray("verificationMode");
            if (null != verificationModeJsonArray && verificationModeJsonArray.length() > 0) {
                paymentDetails.setVerificationModeList(this.getArrayListFromJsonArray(verificationModeJsonArray));
            }
            paymentDetailsList.add(paymentDetails);
        }
        return paymentDetailsList;
    }

    private ArrayList<Bnpl> prepareBnplListWithKeyData(JSONObject details, String key) throws JSONException {
        JSONObject allObject = details.getJSONObject("paymentOptions").getJSONObject(key).getJSONObject("all");
        ArrayList<Bnpl> paymentDetailsList = new ArrayList<Bnpl>();
        Iterator keysIterator = allObject.keys();
        while (keysIterator.hasNext()) {
            String bankCode = (String)keysIterator.next();
            JSONObject ccObject = allObject.getJSONObject(bankCode);
            Bnpl paymentDetails = new Bnpl();
            paymentDetails.setBankCode(bankCode);
            paymentDetails.setBankName(ccObject.optString("title"));
            paymentDetails.setAdditionalCharge(ccObject.optString("additionalCharge"));
            paymentDetails.setMinAmount(ccObject.optString("minimumAmount"));
            paymentDetails.setMaxAmount(ccObject.optString("minimumAmount"));
            JSONObject eligibility = ccObject.optJSONObject("eligibility");
            if (eligibility != null) {
                paymentDetails.setStatus(eligibility.optBoolean("status"));
                paymentDetails.setReason(eligibility.optString("reason"));
            }
            paymentDetailsList.add(paymentDetails);
        }
        return paymentDetailsList;
    }

    private ArrayList<String> getArrayListFromJsonArray(JSONArray jsonArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                try {
                    arrayList.add(jsonArray.get(i).toString());
                    continue;
                }
                catch (JSONException e) {
                    Log.d((String)this.getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
                }
            }
        }
        return arrayList;
    }

    private ArrayList<PayuOffer> getOffersList(JSONArray fullArray, JSONArray offerArray) {
        if (fullArray == null || fullArray.length() == 0 || offerArray == null || offerArray.length() == 0) {
            return null;
        }
        ArrayList<PayuOffer> offersList = new ArrayList<PayuOffer>();
        for (int i = 0; i < offerArray.length(); ++i) {
            String id;
            JSONObject jsonObject = offerArray.optJSONObject(i);
            if (jsonObject == null || (id = jsonObject.optString("id")) == null || id.isEmpty() || id.equalsIgnoreCase("null")) continue;
            for (int j = 0; j < fullArray.length(); ++j) {
                String idFullArray;
                JSONObject fullJsonObject = fullArray.optJSONObject(j);
                if (fullJsonObject == null || (idFullArray = fullJsonObject.optString("id")) == null || !idFullArray.equalsIgnoreCase(id)) continue;
                PayuOffer payuOffer = new PayuOffer();
                payuOffer.setId(fullJsonObject.optString("id"));
                payuOffer.setTitle(fullJsonObject.optString("title"));
                payuOffer.setDescription(fullJsonObject.optString("description"));
                payuOffer.setMinAmount(fullJsonObject.optString("min_amount"));
                payuOffer.setDiscount(fullJsonObject.optString("discount"));
                payuOffer.setDiscountUnit(fullJsonObject.optString("discount_unit"));
                payuOffer.setOfferType(fullJsonObject.optString("offer_type"));
                payuOffer.setValidOnDays(fullJsonObject.optString("valid_on_days"));
                payuOffer.setOfferKey("@" + fullJsonObject.optString("id"));
                offersList.add(payuOffer);
            }
        }
        return offersList;
    }

    private boolean getBankDownStatus(JSONObject downInfoObject, String key, String bankCode) {
        if (downInfoObject == null || downInfoObject.length() == 0 || key == null || key.equalsIgnoreCase("cc") || key.equalsIgnoreCase("dc")) {
            return false;
        }
        JSONArray banksArray = downInfoObject.optJSONArray(key);
        if (banksArray != null && banksArray.length() != 0) {
            for (int i = 0; i < banksArray.length(); ++i) {
                if (banksArray.optString(i) == null || !banksArray.optString(i).equalsIgnoreCase(bankCode)) continue;
                return true;
            }
        }
        return false;
    }

    private String getTaxFromConfigObject(JSONObject configObject, String key) throws JSONException {
        if (configObject == null || configObject.length() == 0 || configObject.optJSONObject("taxSpecification") == null) {
            return null;
        }
        JSONObject taxSpecification = configObject.getJSONObject("taxSpecification");
        if (taxSpecification.has(key)) {
            return taxSpecification.getString(key);
        }
        if (taxSpecification.has("default")) {
            return taxSpecification.getString("default");
        }
        return null;
    }

    private boolean isJSONObjectAvailableForKey(JSONObject paymentOptions, String key) {
        return paymentOptions.has(key) && paymentOptions.optJSONObject(key) != null && paymentOptions.optJSONObject(key).optJSONObject("all") != null;
    }

    static class PaymentDetailsComparator
    implements Comparator<PaymentDetails> {
        PaymentDetailsComparator() {
        }

        @Override
        public int compare(PaymentDetails p1, PaymentDetails p2) {
            return p1.getBankName().compareTo(p2.getBankName());
        }
    }
}

