/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Payu;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import android.util.Log;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SharedPreferenceUtil {
    private static String CIPHER_TRANSFORMATION = "AES/CBC/PKCS7Padding";
    private static String ENCRYPTION_ALGORITHM = "AES";
    private static String KEYSTORE_PROVIDER_ANDROID_KEYSTORE = "AndroidKeyStore";
    private static String mAlias = "PayUKeyAlias";
    private static String TAG = "SharedPreferenceUtil";

    private static SecretKey createKeys(Context context) {
        try {
            KeyGenerator kpGenerator = KeyGenerator.getInstance(ENCRYPTION_ALGORITHM, KEYSTORE_PROVIDER_ANDROID_KEYSTORE);
            if (Build.VERSION.SDK_INT < 23) {
                KeyPairGeneratorSpec spec = new KeyPairGeneratorSpec.Builder(context).setAlias(mAlias).build();
                kpGenerator.init((AlgorithmParameterSpec)spec);
            } else {
                KeyGenParameterSpec spec = new KeyGenParameterSpec.Builder(mAlias, 3).setBlockModes(new String[]{"CBC"}).setEncryptionPaddings(new String[]{"PKCS7Padding"}).build();
                kpGenerator.init((AlgorithmParameterSpec)spec);
            }
            return kpGenerator.generateKey();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("createKey:Exception" + e.getLocalizedMessage()));
            return null;
        }
    }

    private static SecretKey getKeys(Context context) {
        try {
            KeyStore ks = KeyStore.getInstance(KEYSTORE_PROVIDER_ANDROID_KEYSTORE);
            ks.load(null);
            KeyStore.SecretKeyEntry existingKey = (KeyStore.SecretKeyEntry)ks.getEntry(mAlias, null);
            if (existingKey != null) {
                return existingKey.getSecretKey();
            }
            return SharedPreferenceUtil.createKeys(context);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("getKeys:Exception" + e.getLocalizedMessage()));
            return SharedPreferenceUtil.createKeys(context);
        }
    }

    private static String encrypt(Context context, String data) {
        try {
            SecretKey key = SharedPreferenceUtil.getKeys(context);
            if (key != null) {
                Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
                cipher.init(1, key);
                byte[] cipherText = cipher.doFinal(data.getBytes());
                byte[] iv = cipher.getIV();
                byte[] encryptedDataWithIV = new byte[iv.length + cipherText.length];
                System.arraycopy(iv, 0, encryptedDataWithIV, 0, iv.length);
                System.arraycopy(cipherText, 0, encryptedDataWithIV, iv.length, cipherText.length);
                return Base64.encodeToString((byte[])encryptedDataWithIV, (int)0);
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("encrypt:Exception" + e.getLocalizedMessage()));
        }
        return null;
    }

    private static String decrypt(Context context, String encryptedData) {
        try {
            SecretKey key = SharedPreferenceUtil.getKeys(context);
            if (key != null) {
                String ex = encryptedData.replace("\n", "");
                byte[] cipherText = Base64.decode((String)ex, (int)0);
                Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
                byte[] iv = new byte[cipher.getBlockSize()];
                System.arraycopy(cipherText, 0, iv, 0, iv.length);
                cipher.init(2, (Key)key, new IvParameterSpec(iv));
                byte[] data = new byte[cipherText.length - iv.length];
                System.arraycopy(cipherText, iv.length, data, 0, data.length);
                return new String(cipher.doFinal(data));
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("decrypt:Exception" + e.getLocalizedMessage()));
        }
        return null;
    }

    public static SharedPreferences getSharedPref(Context context, String fileName) {
        SharedPreferenceUtil.getKeys(context);
        return context.getSharedPreferences(fileName, 0);
    }

    public static void addStringToSharedPreference(Context context, String spFileName, String spKey, String spValue) {
        SharedPreferences sharedPref = SharedPreferenceUtil.getSharedPref(context, spFileName);
        SharedPreferences.Editor editor = sharedPref.edit();
        if (spValue != null) {
            editor.putString(spKey, SharedPreferenceUtil.encrypt(context, spValue));
            editor.apply();
        }
    }

    public static void addIntToSharedPreference(Context context, String spFileName, String spKey, int spValue) {
        try {
            SharedPreferences sharedPref = SharedPreferenceUtil.getSharedPref(context, spFileName);
            SharedPreferences.Editor editor = sharedPref.edit();
            editor.putString(spKey, SharedPreferenceUtil.encrypt(context, String.valueOf(spValue)));
            editor.apply();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("addIntToSharedPreference:Exception" + e.getLocalizedMessage()));
        }
    }

    public static void addBooleanToSharedPreference(Context context, String spFileName, String spKey, boolean spValue) {
        SharedPreferences sharedPref = SharedPreferenceUtil.getSharedPref(context, spFileName);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(spKey, SharedPreferenceUtil.encrypt(context, String.valueOf(spValue)));
        editor.apply();
    }

    public static String getStringFromSharedPreference(Context context, String spFileName, String spKey, String defaultValue) {
        try {
            SharedPreferences sharedPref = SharedPreferenceUtil.getSharedPref(context, spFileName);
            String encryptedString = sharedPref.getString(spKey, defaultValue);
            String decodedString = SharedPreferenceUtil.decrypt(context, encryptedString);
            if (decodedString == null) {
                return defaultValue;
            }
            return decodedString;
        }
        catch (Exception e) {
            SharedPreferenceUtil.removeAllFromSharedPref(context, spFileName);
            return defaultValue;
        }
    }

    public static int getIntFromSharedPreference(Context context, String spFileName, String spKey, int defaultValue) {
        try {
            SharedPreferences sharedPref = SharedPreferenceUtil.getSharedPref(context, spFileName);
            String encryptedData = sharedPref.getString(spKey, String.valueOf(defaultValue));
            String decryptedData = SharedPreferenceUtil.decrypt(context, encryptedData);
            if (decryptedData == null) {
                return defaultValue;
            }
            return Integer.parseInt(decryptedData);
        }
        catch (Exception e) {
            SharedPreferenceUtil.removeAllFromSharedPref(context, spFileName);
            return defaultValue;
        }
    }

    public static boolean getBooleanFromSharedPreference(Context context, String spFileName, String spKey, boolean defaultValue) {
        try {
            SharedPreferences sharedPref = SharedPreferenceUtil.getSharedPref(context, spFileName);
            String encryptedData = sharedPref.getString(spKey, String.valueOf(defaultValue));
            String decryptedData = SharedPreferenceUtil.decrypt(context, encryptedData);
            if (decryptedData == null) {
                return defaultValue;
            }
            return Boolean.getBoolean(decryptedData);
        }
        catch (Exception e) {
            SharedPreferenceUtil.removeAllFromSharedPref(context, spFileName);
            return defaultValue;
        }
    }

    public static Map<String, ?> getSharedPrefMap(Context context, String prefName) {
        try {
            HashMap sharedPrefHashMap = new HashMap();
            SharedPreferences snoozeSharedPref = SharedPreferenceUtil.getSharedPref(context, prefName);
            Map allEntries = snoozeSharedPref.getAll();
            return allEntries;
        }
        catch (Exception e) {
            HashMap allEntries = new HashMap();
            SharedPreferenceUtil.removeAllFromSharedPref(context, prefName);
            return allEntries;
        }
    }

    public static void removeAllFromSharedPref(Context context, String prefName) {
        try {
            SharedPreferences settings = SharedPreferenceUtil.getSharedPref(context, prefName);
            settings.edit().clear().apply();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("removeAllFromSharedPref:Exception" + e.getLocalizedMessage()));
        }
    }
}

