/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model;

import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class UserDetailsForOffer {
    private String email;
    private String phoneNo;
    private String userToken;
    private String loggedInPhoneNumber;

    private UserDetailsForOffer(Builder builder) {
        this.email = builder.email;
        this.phoneNo = builder.phoneNo;
        this.userToken = builder.userToken;
        this.loggedInPhoneNumber = builder.loggedInPhoneNumber;
    }

    public JSONObject prepareJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("email", (Object)this.email);
            jsonObject.put("phoneNo", (Object)this.phoneNo);
            if (this.userToken != null) {
                jsonObject.put("userToken", (Object)this.userToken);
            }
            if (this.loggedInPhoneNumber != null && !this.loggedInPhoneNumber.trim().isEmpty()) {
                jsonObject.put("loggedInPhoneNumber", (Object)this.loggedInPhoneNumber);
            }
        }
        catch (JSONException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("IOException " + e.getMessage()));
        }
        return jsonObject;
    }

    public static class Builder {
        private String email;
        private String phoneNo;
        private final String userToken;
        private String loggedInPhoneNumber;

        public Builder(String userToken) {
            this.userToken = userToken;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder setPhoneNo(String phoneNo) {
            this.phoneNo = phoneNo;
            return this;
        }

        public Builder setLoggedInPhoneNumber(String loggedInPhoneNumber) {
            this.loggedInPhoneNumber = loggedInPhoneNumber;
            return this;
        }

        public UserDetailsForOffer build() {
            return new UserDetailsForOffer(this);
        }
    }
}

