/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model;

import android.util.Log;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomerDetails {
    private final String mobile;
    private final ArrayList<String> ifscCodes;

    private CustomerDetails(Builder builder) {
        this.mobile = builder.mobile;
        this.ifscCodes = builder.ifscCodes;
    }

    public JSONObject prepareCustomerDetailsObject() {
        JSONObject customerDetails = new JSONObject();
        try {
            customerDetails.put("mobile", (Object)this.mobile);
            if (this.ifscCodes != null && !this.ifscCodes.isEmpty()) {
                JSONArray ifscArray = new JSONArray();
                for (String ifscCode : this.ifscCodes) {
                    ifscArray.put((Object)ifscCode);
                }
                customerDetails.put("ifscCodes", (Object)ifscArray);
            }
        }
        catch (JSONException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
        }
        return customerDetails;
    }

    public static class Builder {
        private String mobile;
        private ArrayList<String> ifscCodes;

        public Builder setMobile(String mobile) {
            this.mobile = mobile;
            return this;
        }

        public Builder setIfscCodes(ArrayList<String> ifscCodes) {
            this.ifscCodes = ifscCodes;
            return this;
        }

        public CustomerDetails build() {
            return new CustomerDetails(this);
        }
    }
}

