/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Extras;

import android.os.Parcel;
import android.os.Parcelable;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuConstants;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PayUChecksum
implements Parcelable {
    public static final Parcelable.Creator<PayUChecksum> CREATOR = new Parcelable.Creator<PayUChecksum>(){

        public PayUChecksum createFromParcel(Parcel in) {
            return new PayUChecksum(in);
        }

        public PayUChecksum[] newArray(int size) {
            return new PayUChecksum[size];
        }
    };
    private String key;
    private String salt;
    private String txnid;
    private String amount;
    private String productinfo;
    private String firstname;
    private String email;
    private String udf1;
    private String udf2;
    private String udf3;
    private String udf4;
    private String udf5;
    private String subventionAmount;
    String var1;
    String command;
    private String[] webServiceHashParams = new String[]{"key", "command", "var1", "salt"};
    private String[] paymentHashParams = new String[]{"key", "txnid", "amount", "productinfo", "firstname", "email", "udf1", "udf2", "udf3", "udf4", "udf5", "salt", "subvention_amount"};

    public PayUChecksum() {
    }

    private PayUChecksum(Parcel in) {
        this.key = in.readString();
        this.txnid = in.readString();
        this.amount = in.readString();
        this.productinfo = in.readString();
        this.firstname = in.readString();
        this.email = in.readString();
        this.udf1 = in.readString();
        this.udf2 = in.readString();
        this.udf3 = in.readString();
        this.udf4 = in.readString();
        this.udf5 = in.readString();
        this.salt = in.readString();
        this.var1 = in.readString();
        this.command = in.readString();
        this.subventionAmount = in.readString();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTxnid() {
        return this.txnid;
    }

    public void setTxnid(String txnid) {
        this.txnid = txnid;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getProductinfo() {
        return this.productinfo;
    }

    public void setProductinfo(String productinfo) {
        this.productinfo = productinfo;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUdf1() {
        return this.udf1;
    }

    public void setUdf1(String udf1) {
        this.udf1 = udf1;
    }

    public String getUdf2() {
        return this.udf2;
    }

    public void setUdf2(String udf2) {
        this.udf2 = udf2;
    }

    public String getUdf3() {
        return this.udf3;
    }

    public void setUdf3(String udf3) {
        this.udf3 = udf3;
    }

    public String getUdf4() {
        return this.udf4;
    }

    public void setUdf4(String udf4) {
        this.udf4 = udf4;
    }

    public String getUdf5() {
        return this.udf5;
    }

    public void setUdf5(String udf5) {
        this.udf5 = udf5;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getVar1() {
        return this.var1;
    }

    public void setVar1(String var1) {
        this.var1 = var1;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getSubventionAmount() {
        return this.subventionAmount;
    }

    public void setSubventionAmount(String subventionAmount) {
        this.subventionAmount = subventionAmount;
    }

    public PostData getHash() {
        StringBuilder webServiceHash = new StringBuilder();
        if (this.command != null && this.var1 != null) {
            String[] stringArray = this.webServiceHashParams;
            int n = stringArray.length;
            block44: for (int i = 0; i < n; ++i) {
                String k;
                switch (k = stringArray[i]) {
                    case "key": {
                        if (this.key == null || this.key.length() < 1) {
                            return this.getReturnData("Mandatory param key is missing");
                        }
                        webServiceHash.append(this.key).append("|");
                        continue block44;
                    }
                    case "command": {
                        if (PayuConstants.COMMAND_SET.contains(this.command)) {
                            webServiceHash.append(this.command).append("|");
                            continue block44;
                        }
                        return this.getReturnData("Mandatory param command is missing");
                    }
                    case "var1": {
                        if (this.var1.length() >= 1) {
                            webServiceHash.append(this.var1).append("|");
                            continue block44;
                        }
                        return this.getReturnData("Mandatory param var1 is missing");
                    }
                    case "salt": {
                        if (this.salt == null || this.salt.length() < 1) {
                            return this.getReturnData("Mandatory param salt is missing");
                        }
                        webServiceHash.append(this.salt);
                    }
                }
            }
            return this.calculateHash(webServiceHash.toString());
        }
        if (this.amount != null && this.txnid != null && this.productinfo != null && this.salt != null) {
            StringBuilder paymentHash = new StringBuilder();
            String[] stringArray = this.paymentHashParams;
            int n = stringArray.length;
            block45: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "key": {
                        if (this.key == null || this.key.length() < 1) {
                            return this.getReturnData("Mandatory param key is missing");
                        }
                        paymentHash.append(this.key).append("|");
                        continue block45;
                    }
                    case "txnid": {
                        if (this.txnid.length() < 1) {
                            return this.getReturnData("should be the Transaction id (txnid)");
                        }
                        paymentHash.append(this.txnid).append("|");
                        continue block45;
                    }
                    case "amount": {
                        try {
                            if (null == this.amount || Double.parseDouble(this.amount) <= 0.0) {
                                return this.getReturnData("Amount should be a Double value example 5.00");
                            }
                            paymentHash.append(this.amount).append("|");
                            continue block45;
                        }
                        catch (NumberFormatException e) {
                            return this.getReturnData(5002, "Amount should be a Double value example 5.00");
                        }
                    }
                    case "productinfo": {
                        if (this.productinfo == null) {
                            return this.getReturnData("Product info should not be null, it can be empty or string");
                        }
                        paymentHash.append(this.productinfo).append("|");
                        continue block45;
                    }
                    case "firstname": {
                        if (this.firstname == null) {
                            return this.getReturnData("First name should not be null, it can be empty or string");
                        }
                        paymentHash.append(this.firstname).append("|");
                        continue block45;
                    }
                    case "email": {
                        if (this.email == null) {
                            return this.getReturnData("Email should not be null, it can be empty or string");
                        }
                        paymentHash.append(this.email).append("|");
                        continue block45;
                    }
                    case "udf1": {
                        if (this.udf1 == null) {
                            return this.getReturnData("UDF1 should not be null, it can be empty or string");
                        }
                        paymentHash.append(this.udf1).append("|");
                        continue block45;
                    }
                    case "udf2": {
                        if (this.udf2 == null) {
                            return this.getReturnData("UDF2 should not be null, it can be empty or string");
                        }
                        paymentHash.append(this.udf2).append("|");
                        continue block45;
                    }
                    case "udf3": {
                        if (this.udf3 == null) {
                            return this.getReturnData("UDF3 should not be null, it can be empty or string");
                        }
                        paymentHash.append(this.udf3).append("|");
                        continue block45;
                    }
                    case "udf4": {
                        if (this.udf4 == null) {
                            return this.getReturnData("UDF4 should not be null, it can be empty or string");
                        }
                        paymentHash.append(this.udf4).append("|");
                        continue block45;
                    }
                    case "udf5": {
                        if (this.udf5 == null) {
                            return this.getReturnData("UDF5 should not be null, it can be empty or string");
                        }
                        paymentHash.append(this.udf5).append("||||||");
                        continue block45;
                    }
                    case "salt": {
                        if (this.salt.length() < 1) {
                            return this.getReturnData("Salt should be a valid string");
                        }
                        paymentHash.append(this.salt);
                        continue block45;
                    }
                    case "subvention_amount": {
                        if (null == this.subventionAmount || this.subventionAmount.length() <= 0) continue block45;
                        paymentHash.append("|").append(this.subventionAmount);
                    }
                }
            }
            return this.calculateHash(paymentHash.toString());
        }
        return this.getReturnData("Mandatory param command is missing Amount should be a Double value example 5.00");
    }

    protected PostData getReturnData(String result) {
        return this.getReturnData(5001, "ERROR", result);
    }

    protected PostData getReturnData(int code, String result) {
        return this.getReturnData(code, "ERROR", result);
    }

    protected PostData getReturnData(int code, String status, String result) {
        PostData postData = new PostData();
        postData.setCode(code);
        postData.setStatus(status);
        postData.setResult(result);
        return postData;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.key);
        dest.writeString(this.txnid);
        dest.writeString(this.amount);
        dest.writeString(this.productinfo);
        dest.writeString(this.firstname);
        dest.writeString(this.email);
        dest.writeString(this.udf1);
        dest.writeString(this.udf2);
        dest.writeString(this.udf3);
        dest.writeString(this.udf4);
        dest.writeString(this.udf5);
        dest.writeString(this.salt);
        dest.writeString(this.command);
        dest.writeString(this.subventionAmount);
    }

    private PostData calculateHash(String hashString) {
        try {
            byte[] mdbytes;
            StringBuilder hash = new StringBuilder();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            messageDigest.update(hashString.getBytes());
            for (byte hashByte : mdbytes = messageDigest.digest()) {
                hash.append(Integer.toString((hashByte & 0xFF) + 256, 16).substring(1));
            }
            return this.getReturnData(0, "SUCCESS", hash.toString());
        }
        catch (NoSuchAlgorithmException e) {
            return this.getReturnData(5015, " Message digest sha 512 not found!");
        }
    }
}

