/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model.FetchOffer;

import android.util.Log;
import com.payu.india.Payu.PayuUtils;
import com.payu.paymentparamhelper.V2ApiBase;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchOfferApiRequest
extends V2ApiBase {
    private double amount;
    private String userToken;
    private String skuDetails;
    private String loggedInPhoneNumber;
    private Boolean isConsented;
    private List<String> enforcementOfferKeys;

    private FetchOfferApiRequest(Builder builder) {
        this.amount = builder.amount;
        this.userToken = builder.userToken;
        this.skuDetails = builder.skuDetails;
        this.loggedInPhoneNumber = builder.loggedInPhoneNumber;
        this.isConsented = builder.isConsented;
        this.enforcementOfferKeys = builder.enforcementOfferKeys;
    }

    public String getJson() {
        try {
            JSONObject jsonObject = new JSONObject();
            if (this.skuDetails != null) {
                jsonObject = this.getFetchOfferSkuJson(this.skuDetails);
            }
            jsonObject.put("amount", this.amount);
            if (this.userToken != null) {
                jsonObject.put("userToken", (Object)this.userToken);
            }
            if (this.loggedInPhoneNumber != null && !this.loggedInPhoneNumber.trim().isEmpty()) {
                JSONObject userDetail = new JSONObject();
                if (this.isConsented != null) {
                    userDetail.put("isConsented", (Object)this.isConsented);
                } else {
                    userDetail.put("isConsented", false);
                }
                userDetail.put("loggedInPhoneNumber", (Object)this.loggedInPhoneNumber);
                jsonObject.put("userDetail", (Object)userDetail);
            }
            if (this.enforcementOfferKeys != null && !this.enforcementOfferKeys.isEmpty()) {
                JSONArray enforceOfferKeysJsonArray = new JSONArray();
                for (int i = 0; i < this.enforcementOfferKeys.size(); ++i) {
                    String offerKey = this.enforcementOfferKeys.get(i);
                    if (offerKey == null || offerKey.trim().isEmpty()) continue;
                    enforceOfferKeysJsonArray.put((Object)offerKey);
                }
                if (enforceOfferKeysJsonArray.length() > 0) {
                    jsonObject.put("offerKeys", (Object)enforceOfferKeysJsonArray);
                }
            }
            return jsonObject.toString();
        }
        catch (JSONException e) {
            Log.d((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
            return null;
        }
    }

    private JSONObject getFetchOfferSkuJson(String skuDetails) {
        skuDetails = PayuUtils.replaceString(skuDetails, "sku_id", "skuId");
        skuDetails = PayuUtils.replaceString(skuDetails, "amount_per_sku", "skuAmount");
        skuDetails = PayuUtils.replaceString(skuDetails, "offer_key", "offerKeys");
        skuDetails = PayuUtils.replaceString(skuDetails, "sku_details", "skusDetail");
        try {
            return new JSONObject(skuDetails);
        }
        catch (JSONException jsonException) {
            return new JSONObject();
        }
    }

    public static class Builder {
        private final double amount;
        private final String userToken;
        private String skuDetails;
        private String loggedInPhoneNumber;
        private Boolean isConsented;
        private List<String> enforcementOfferKeys;

        public Builder(double amount, String userToken) {
            this.amount = amount;
            this.userToken = userToken;
        }

        public Builder setSkuDetails(String skuDetails) {
            this.skuDetails = skuDetails;
            return this;
        }

        public Builder setLoggedInPhoneNumber(String loggedInPhoneNumber) {
            this.loggedInPhoneNumber = loggedInPhoneNumber;
            return this;
        }

        public Builder setConsented(Boolean consented) {
            this.isConsented = consented;
            return this;
        }

        public Builder setEnforcementOfferKeys(List<String> enforcementOfferKeys) {
            this.enforcementOfferKeys = enforcementOfferKeys;
            return this;
        }

        public FetchOfferApiRequest build() {
            return new FetchOfferApiRequest(this);
        }
    }
}

