/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.FetchOfferDetailsListener;
import com.payu.india.Model.BankOfferInfoCards;
import com.payu.india.Model.CardsOfferInfo;
import com.payu.india.Model.DiscountDetailsofOffers;
import com.payu.india.Model.EMIOptionInOffers;
import com.payu.india.Model.EmiOfferInfo;
import com.payu.india.Model.FetchOfferInfo;
import com.payu.india.Model.FetchofferDetails;
import com.payu.india.Model.NetworkOfferInfoCards;
import com.payu.india.Model.PaymentOptionOfferinfo;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.SkuOfferInfo;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.india.Tasks.base.PayUAsyncTask;
import com.payu.paymentparamhelper.Sku;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchOfferDetailsTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private FetchOfferDetailsListener mfetchOfferDetailsListener;

    public FetchOfferDetailsTask(FetchOfferDetailsListener fetchOfferDetailsListener) {
        this.mfetchOfferDetailsListener = fetchOfferDetailsListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PayuResponse doInBackground(PayuConfig ... params) {
        PostData postData;
        PayuResponse payuResponse;
        block24: {
            payuResponse = new PayuResponse();
            postData = new PostData();
            InputStream responseInputStream = null;
            try {
                URL url = null;
                PayuConfig payuConfig = params[0];
                switch (payuConfig.getEnvironment()) {
                    case 0: {
                        url = new URL("https://api.payu.in/");
                        break;
                    }
                    case 2: {
                        url = new URL("https://sandbox.payu.in/");
                        break;
                    }
                    default: {
                        url = new URL("https://api.payu.in/");
                    }
                }
                HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).setURL(url + "offers/transactions").setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader("get_all_offer_details")).setRequestType("application/json").build();
                HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
                if (null != conn) {
                    int i;
                    responseInputStream = conn.getInputStream();
                    StringBuilder responseStringBuffer = new StringBuilder();
                    byte[] byteContainer = new byte[1024];
                    while ((i = responseInputStream.read(byteContainer)) != -1) {
                        responseStringBuffer.append(new String(byteContainer, 0, i));
                    }
                    JSONObject response = new JSONObject(responseStringBuffer.toString());
                    payuResponse.setRawResponse(response);
                    JSONObject result = response.optJSONObject("result");
                    FetchofferDetails fetchofferDetails = new FetchofferDetails();
                    if (result != null) {
                        JSONObject skusDetail;
                        JSONArray offers = result.optJSONArray("offers");
                        if (offers != null && offers.length() > 0) {
                            ArrayList<FetchOfferInfo> offerInfoArrayList = new ArrayList<FetchOfferInfo>();
                            for (int i2 = 0; i2 < offers.length(); ++i2) {
                                JSONObject offersJson = offers.getJSONObject(i2);
                                FetchOfferInfo fetchOfferInfo = new FetchOfferInfo();
                                this.preparePaymentOffersList(fetchOfferInfo, offersJson);
                                offerInfoArrayList.add(fetchOfferInfo);
                            }
                            fetchofferDetails.setPayuOfferList(offerInfoArrayList);
                        }
                        if ((skusDetail = result.optJSONObject("skusDetail")) != null) {
                            JSONArray skus = skusDetail.optJSONArray("skus");
                            ArrayList<SkuOfferInfo> skuOfferInfoArrayList = new ArrayList<SkuOfferInfo>();
                            for (int i3 = 0; skus != null && i3 < skus.length(); ++i3) {
                                SkuOfferInfo skuOfferInfo = new SkuOfferInfo();
                                JSONObject skuJson = skus.optJSONObject(i3);
                                JSONArray skuOffers = skuJson.optJSONArray("offers");
                                if (skuOffers == null || skuOffers.length() <= 0) continue;
                                String skuId = skuJson.optString("skuId");
                                String skuAmount = skuJson.optString("skuAmount");
                                int skuQuantity = skuJson.optInt("quantity");
                                ArrayList<FetchOfferInfo> offerInfoArrayList = new ArrayList<FetchOfferInfo>();
                                for (int j = 0; j < skuOffers.length(); ++j) {
                                    FetchOfferInfo fetchOfferInfo = new FetchOfferInfo();
                                    JSONObject offersJson = skuOffers.getJSONObject(j);
                                    this.preparePaymentOffersList(fetchOfferInfo, offersJson);
                                    offerInfoArrayList.add(fetchOfferInfo);
                                }
                                Sku sku = new Sku();
                                sku.setSkuId(skuId);
                                sku.setSkuAmount(skuAmount);
                                sku.setQuantity(skuQuantity);
                                skuOfferInfo.setOfferInfoArrayList(offerInfoArrayList);
                                skuOfferInfo.setSku(sku);
                                skuOfferInfoArrayList.add(skuOfferInfo);
                            }
                            fetchofferDetails.setSkuOfferInfoList(skuOfferInfoArrayList);
                        }
                        payuResponse.setFetchofferDetails(fetchofferDetails);
                    }
                    PayuUtils.safeClose(responseInputStream);
                }
                if (responseInputStream == null) break block24;
            }
            catch (ProtocolException protocolException) {
                if (responseInputStream != null) {
                    PayuUtils.safeClose(responseInputStream);
                }
                break block24;
                catch (IOException iOException) {
                    if (responseInputStream != null) {
                        PayuUtils.safeClose(responseInputStream);
                    }
                    break block24;
                    catch (JSONException jSONException) {
                        if (responseInputStream != null) {
                            PayuUtils.safeClose(responseInputStream);
                        }
                        break block24;
                        catch (Throwable throwable) {
                            if (responseInputStream != null) {
                                PayuUtils.safeClose(responseInputStream);
                            }
                            throw throwable;
                        }
                    }
                }
            }
            PayuUtils.safeClose(responseInputStream);
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.mfetchOfferDetailsListener.onFetchOfferDetailsResponse(payuResponse);
    }

    private ArrayList<PaymentOptionOfferinfo> prepareOfferDetailsInfo(String paymentOption, JSONObject offersarray) {
        ArrayList<PaymentOptionOfferinfo> paymentOptionOfferinfoArrayList = new ArrayList<PaymentOptionOfferinfo>();
        JSONArray paymentOptionJson = offersarray.optJSONArray(paymentOption);
        for (int j = 0; paymentOptionJson != null && j < paymentOptionJson.length(); ++j) {
            JSONObject paymentDetailsForOffer = null;
            try {
                paymentDetailsForOffer = paymentOptionJson.getJSONObject(j);
            }
            catch (JSONException e) {
                Log.d((String)this.getClass().getSimpleName(), (String)("Exception " + e.getMessage()));
            }
            PaymentOptionOfferinfo paymentOptionOfferinfo = new PaymentOptionOfferinfo();
            paymentOptionOfferinfo.setPaymentOptionName(paymentOption);
            paymentOptionOfferinfo.setTitle(paymentDetailsForOffer.optString("title"));
            paymentOptionOfferinfo.setPaymentCode(paymentDetailsForOffer.optString("paymentCode"));
            paymentOptionOfferinfoArrayList.add(paymentOptionOfferinfo);
        }
        return paymentOptionOfferinfoArrayList;
    }

    private void prepareOfferDetailsInfoForCards(String paymentOption, JSONObject offersarray, NetworkOfferInfoCards networkOfferInfoCards, BankOfferInfoCards bankOfferInfoCards, FetchOfferInfo fetchOfferInfo) {
        ArrayList<PaymentOptionOfferinfo> networkListForCards = new ArrayList<PaymentOptionOfferinfo>();
        ArrayList<PaymentOptionOfferinfo> bankListForCards = new ArrayList<PaymentOptionOfferinfo>();
        JSONArray paymentOptionJson = offersarray.optJSONArray(paymentOption);
        for (int j = 0; paymentOptionJson != null && j < paymentOptionJson.length(); ++j) {
            try {
                PaymentOptionOfferinfo paymentOptionOfferinfo;
                int k;
                JSONObject paymentDetailsForOffer = paymentOptionJson.getJSONObject(j);
                JSONArray networkDetailsOffer = paymentDetailsForOffer.optJSONArray("networks");
                JSONArray banksDetailsOffer = paymentDetailsForOffer.optJSONArray("banks");
                for (k = 0; networkDetailsOffer != null && k < networkDetailsOffer.length(); ++k) {
                    paymentOptionOfferinfo = this.prepareCardOfferDetails(networkDetailsOffer.getJSONObject(k), paymentOption);
                    networkListForCards.add(paymentOptionOfferinfo);
                }
                for (k = 0; banksDetailsOffer != null && k < banksDetailsOffer.length(); ++k) {
                    paymentOptionOfferinfo = this.prepareCardOfferDetails(banksDetailsOffer.getJSONObject(k), paymentOption);
                    bankListForCards.add(paymentOptionOfferinfo);
                }
                continue;
            }
            catch (JSONException e) {
                Log.d((String)this.getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
            }
        }
        if (Objects.equals(paymentOption, "creditCard")) {
            networkOfferInfoCards.setNetworkListForCCCards(networkListForCards);
            bankOfferInfoCards.setBanksListForCCCards(bankListForCards);
        } else {
            networkOfferInfoCards.setNetworkListForDCCards(networkListForCards);
            bankOfferInfoCards.setBanksListForDCCards(bankListForCards);
        }
        CardsOfferInfo cardsOfferInfo = new CardsOfferInfo();
        cardsOfferInfo.setBankOfferInfoCards(bankOfferInfoCards);
        cardsOfferInfo.setNetworkOfferInfoCards(networkOfferInfoCards);
        fetchOfferInfo.setCardsOfferInfo(cardsOfferInfo);
    }

    private PaymentOptionOfferinfo prepareCardOfferDetails(JSONObject jsonObject, String paymentOption) {
        PaymentOptionOfferinfo paymentOptionOfferinfo = new PaymentOptionOfferinfo();
        paymentOptionOfferinfo.setPaymentOptionName(paymentOption);
        paymentOptionOfferinfo.setTitle(jsonObject.optString("title"));
        paymentOptionOfferinfo.setPaymentCode(jsonObject.optString("code"));
        return paymentOptionOfferinfo;
    }

    private ArrayList<EMIOptionInOffers> prepareOffersInfoForEmi(String paymentOption, JSONObject emiObject) {
        JSONObject emiTypeJsonObject = emiObject.optJSONObject(paymentOption);
        ArrayList<EMIOptionInOffers> eMiOptionInOffersArrayList = new ArrayList<EMIOptionInOffers>();
        if (emiTypeJsonObject != null) {
            JSONArray emiBanks = emiTypeJsonObject.optJSONArray("banks");
            for (int i = 0; emiBanks != null && i < emiBanks.length(); ++i) {
                JSONObject emiBanksObject = emiBanks.optJSONObject(i);
                EMIOptionInOffers eMiOptionInOffers = new EMIOptionInOffers();
                eMiOptionInOffers.setEmiType(paymentOption);
                eMiOptionInOffers.setBankCode(emiBanksObject.optString("bankCode"));
                ArrayList<PaymentOptionOfferinfo> paymentOptionOfferInfoList = new ArrayList<PaymentOptionOfferinfo>();
                JSONArray emiTenures = emiBanksObject.optJSONArray("tenureOption");
                for (int j = 0; emiTenures != null && j < emiTenures.length(); ++j) {
                    PaymentOptionOfferinfo paymentOptionOfferinfo = new PaymentOptionOfferinfo();
                    JSONObject emiTenuresObject = emiTenures.optJSONObject(j);
                    paymentOptionOfferinfo.setPaymentCode(emiTenuresObject.optString("paymentCode"));
                    paymentOptionOfferinfo.setTitle(emiTenuresObject.optString("title"));
                    paymentOptionOfferInfoList.add(paymentOptionOfferinfo);
                }
                eMiOptionInOffers.setPaymentOptionOfferinfoArrayList(paymentOptionOfferInfoList);
                eMiOptionInOffersArrayList.add(eMiOptionInOffers);
            }
        }
        return eMiOptionInOffersArrayList;
    }

    private void preparePaymentOffersList(FetchOfferInfo fetchOfferInfo, JSONObject offersJson) {
        try {
            fetchOfferInfo.setType(offersJson.optString("type"));
            fetchOfferInfo.setOfferKey(offersJson.optString("offerKey"));
            fetchOfferInfo.setTitle(offersJson.optString("title"));
            fetchOfferInfo.setDescription(offersJson.optString("description"));
            fetchOfferInfo.setTnc(offersJson.optString("tnc"));
            fetchOfferInfo.setTncLink(offersJson.optString("tncLink"));
            fetchOfferInfo.setMinTxnAmount(Double.parseDouble(Objects.requireNonNull(offersJson.opt("minTxnAmount")).toString()));
            fetchOfferInfo.setMaxTxnAmount(Double.parseDouble(Objects.requireNonNull(offersJson.opt("maxTxnAmount")).toString()));
            fetchOfferInfo.setOfferType(offersJson.optString("offerType"));
            fetchOfferInfo.setValidFrom(offersJson.optString("validFrom"));
            fetchOfferInfo.setValidTo(offersJson.optString("validTo"));
            fetchOfferInfo.setSkuOffer(offersJson.optBoolean("isSkuOffer"));
            fetchOfferInfo.setAllPayModeOffer(offersJson.optBoolean("isAllPaymentMethodsAvailable"));
            fetchOfferInfo.setOfferCategory(PayuUtils.getStringValue(offersJson, "offerCategory"));
            fetchOfferInfo.setAmount(PayuUtils.getDoubletValue(offersJson, "amount"));
            fetchOfferInfo.setDiscount(PayuUtils.getDoubletValue(offersJson, "discount"));
            fetchOfferInfo.setDiscountedAmount(PayuUtils.getDoubletValue(offersJson, "discountedAmount"));
            DiscountDetailsofOffers discountDetailsofOffers = new DiscountDetailsofOffers();
            if (offersJson.optJSONObject("discountDetail") != null) {
                JSONObject discountJsonObject = offersJson.getJSONObject("discountDetail");
                discountDetailsofOffers.setMaxDiscount(Double.parseDouble(!discountJsonObject.get("maxDiscount").equals(null) ? discountJsonObject.get("maxDiscount").toString() : "0"));
                discountDetailsofOffers.setDiscountPercentage(discountJsonObject.optString("discountPercentage"));
                discountDetailsofOffers.setDiscount(Double.parseDouble(!discountJsonObject.get("discount").equals(null) ? discountJsonObject.get("discount").toString() : "0"));
                discountDetailsofOffers.setDiscountType(discountJsonObject.optString("discountType"));
                discountDetailsofOffers.setDiscountedAmount(Double.parseDouble(!discountJsonObject.get("discountedAmount").equals(null) ? discountJsonObject.get("discountedAmount").toString() : "0"));
                fetchOfferInfo.setDiscountDetails(discountDetailsofOffers);
            }
            fetchOfferInfo.setIsNoCostEmi(offersJson.optBoolean("isNoCostEmi"));
            BankOfferInfoCards bankOfferInfoCards = new BankOfferInfoCards();
            NetworkOfferInfoCards networkOfferInfoCards = new NetworkOfferInfoCards();
            if (offersJson.optJSONArray("creditCard") != null) {
                this.prepareOfferDetailsInfoForCards("creditCard", offersJson, networkOfferInfoCards, bankOfferInfoCards, fetchOfferInfo);
            }
            if (offersJson.optJSONArray("debitCard") != null) {
                this.prepareOfferDetailsInfoForCards("creditCard", offersJson, networkOfferInfoCards, bankOfferInfoCards, fetchOfferInfo);
            }
            if (offersJson.optJSONArray("netBanking") != null) {
                fetchOfferInfo.setNbOfferList(this.prepareOfferDetailsInfo("netBanking", offersJson));
            }
            if (offersJson.optJSONArray("wallet") != null) {
                fetchOfferInfo.setWalletOfferList(this.prepareOfferDetailsInfo("wallet", offersJson));
            }
            if (offersJson.optJSONArray("upi") != null) {
                fetchOfferInfo.setUpiOfferList(this.prepareOfferDetailsInfo("upi", offersJson));
            }
            if (offersJson.optJSONArray("BNPL".toLowerCase()) != null) {
                fetchOfferInfo.setBnplOfferList(this.prepareOfferDetailsInfo("BNPL".toLowerCase(), offersJson));
            }
            if (offersJson.optJSONArray("clw".toLowerCase()) != null) {
                fetchOfferInfo.setClwOfferInfoList(this.prepareOfferDetailsInfo("clw".toLowerCase(), offersJson));
            }
            if (offersJson.optJSONObject("EMI".toLowerCase()) != null) {
                JSONObject emiObject = offersJson.optJSONObject("EMI".toLowerCase());
                EmiOfferInfo emiOfferInfo = new EmiOfferInfo();
                emiOfferInfo.setEmiDCOffersArrayList(this.prepareOffersInfoForEmi("debitCard", emiObject));
                emiOfferInfo.setEmiCCOffersArrayList(this.prepareOffersInfoForEmi("creditCard", emiObject));
                fetchOfferInfo.setEmiOfferInfo(emiOfferInfo);
            }
        }
        catch (JSONException e) {
            Log.d((String)"PayU", (String)Objects.requireNonNull(e.getMessage()));
        }
    }
}

