/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Payu;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.security.auth.x500.X500Principal;

public class SharedPreferenceUtil {
    private static String CIPHER_TRANSFORMATION = "RSA/ECB/PKCS1Padding";
    private static String KEYSTORE_PROVIDER_ANDROID_KEYSTORE = "AndroidKeyStore";
    private static String TYPE_RSA = "RSA";
    private static String mAlias = "PayUKeyAlias";
    private static KeyPair keyPair;

    private static void createKeys(Context context) {
        try {
            GregorianCalendar start = new GregorianCalendar();
            GregorianCalendar end = new GregorianCalendar();
            ((Calendar)end).add(1, 1);
            KeyPairGenerator kpGenerator = KeyPairGenerator.getInstance(TYPE_RSA, KEYSTORE_PROVIDER_ANDROID_KEYSTORE);
            Object spec = Build.VERSION.SDK_INT < 23 ? new KeyPairGeneratorSpec.Builder(context).setAlias(mAlias).build() : new KeyGenParameterSpec.Builder(mAlias, 2).setCertificateSubject(new X500Principal("CN=$mAlias")).setDigests(new String[]{"SHA-256"}).setCertificateSerialNumber(BigInteger.valueOf(1337L)).setCertificateNotBefore(start.getTime()).setCertificateNotAfter(end.getTime()).setBlockModes(new String[]{"ECB"}).setEncryptionPaddings(new String[]{"PKCS1Padding"}).build();
            kpGenerator.initialize((AlgorithmParameterSpec)spec);
            keyPair = kpGenerator.generateKeyPair();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void getKeys(Context context) {
        if (keyPair == null) {
            try {
                KeyStore ks = KeyStore.getInstance(KEYSTORE_PROVIDER_ANDROID_KEYSTORE);
                ks.load(null);
                KeyStore.Entry entry = ks.getEntry(mAlias, null);
                if (entry instanceof KeyStore.PrivateKeyEntry) {
                    PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
                    Certificate certificate = ((KeyStore.PrivateKeyEntry)entry).getCertificate();
                    PublicKey publicKey = certificate.getPublicKey();
                    keyPair = new KeyPair(publicKey, privateKey);
                } else {
                    SharedPreferenceUtil.createKeys(context);
                }
            }
            catch (Exception e) {
                SharedPreferenceUtil.createKeys(context);
            }
        }
    }

    private static String encrypt(String data) {
        try {
            if (keyPair != null && keyPair.getPublic() != null) {
                Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
                cipher.init(1, keyPair.getPublic());
                byte[] cipherText = cipher.doFinal(data.getBytes());
                return Base64.encodeToString((byte[])cipherText, (int)0);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String decrypt(String encryptedData) {
        try {
            if (keyPair != null && keyPair.getPrivate() != null) {
                String ex = encryptedData.replace("\n", "");
                byte[] cipherText = Base64.decode((String)ex, (int)0);
                Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
                cipher.init(2, keyPair.getPrivate());
                return new String(cipher.doFinal(cipherText));
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static SharedPreferences getSharedPref(Context context, String fileName) {
        SharedPreferenceUtil.getKeys(context);
        return context.getSharedPreferences(fileName, 0);
    }

    public static void addStringToSharedPreference(Context context, String spFileName, String spKey, String spValue) {
        SharedPreferences sharedPref = SharedPreferenceUtil.getSharedPref(context, spFileName);
        SharedPreferences.Editor editor = sharedPref.edit();
        if (spValue != null) {
            editor.putString(spKey, SharedPreferenceUtil.encrypt(spValue));
            editor.apply();
        }
    }

    public static void addIntToSharedPreference(Context context, String spFileName, String spKey, int spValue) {
        try {
            SharedPreferences sharedPref = SharedPreferenceUtil.getSharedPref(context, spFileName);
            SharedPreferences.Editor editor = sharedPref.edit();
            editor.putString(spKey, SharedPreferenceUtil.encrypt(String.valueOf(spValue)));
            editor.apply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addBooleanToSharedPreference(Context context, String spFileName, String spKey, boolean spValue) {
        SharedPreferences sharedPref = SharedPreferenceUtil.getSharedPref(context, spFileName);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(spKey, SharedPreferenceUtil.encrypt(String.valueOf(spValue)));
        editor.apply();
    }

    public static String getStringFromSharedPreference(Context context, String spFileName, String spKey, String defaultValue) {
        try {
            SharedPreferences sharedPref = SharedPreferenceUtil.getSharedPref(context, spFileName);
            String encryptedString = sharedPref.getString(spKey, defaultValue);
            String decodedString = SharedPreferenceUtil.decrypt(encryptedString);
            if (decodedString == null) {
                return defaultValue;
            }
            return decodedString;
        }
        catch (Exception e) {
            SharedPreferenceUtil.removeAllFromSharedPref(context, spFileName);
            return defaultValue;
        }
    }

    public static int getIntFromSharedPreference(Context context, String spFileName, String spKey, int defaultValue) {
        try {
            SharedPreferences sharedPref = SharedPreferenceUtil.getSharedPref(context, spFileName);
            String encryptedData = sharedPref.getString(spKey, String.valueOf(defaultValue));
            String decryptedData = SharedPreferenceUtil.decrypt(encryptedData);
            if (decryptedData == null) {
                return defaultValue;
            }
            return Integer.parseInt(decryptedData);
        }
        catch (Exception e) {
            SharedPreferenceUtil.removeAllFromSharedPref(context, spFileName);
            return defaultValue;
        }
    }

    public static boolean getBooleanFromSharedPreference(Context context, String spFileName, String spKey, boolean defaultValue) {
        try {
            SharedPreferences sharedPref = SharedPreferenceUtil.getSharedPref(context, spFileName);
            String encryptedData = sharedPref.getString(spKey, String.valueOf(defaultValue));
            String decryptedData = SharedPreferenceUtil.decrypt(encryptedData);
            if (decryptedData == null) {
                return defaultValue;
            }
            return Boolean.getBoolean(decryptedData);
        }
        catch (Exception e) {
            SharedPreferenceUtil.removeAllFromSharedPref(context, spFileName);
            return defaultValue;
        }
    }

    public static Map<String, ?> getSharedPrefMap(Context context, String prefName) {
        try {
            HashMap sharedPrefHashMap = new HashMap();
            SharedPreferences snoozeSharedPref = SharedPreferenceUtil.getSharedPref(context, prefName);
            Map allEntries = snoozeSharedPref.getAll();
            return allEntries;
        }
        catch (Exception e) {
            HashMap allEntries = new HashMap();
            SharedPreferenceUtil.removeAllFromSharedPref(context, prefName);
            return allEntries;
        }
    }

    public static void removeAllFromSharedPref(Context context, String prefName) {
        try {
            SharedPreferences settings = SharedPreferenceUtil.getSharedPref(context, prefName);
            settings.edit().clear().apply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

