/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model;

import android.util.Log;
import com.payu.india.Model.CheckoutFilter;
import com.payu.india.Model.CustomerDetails;
import com.payu.india.Model.GetTransactionDetails;
import com.payu.india.Model.Usecase;
import org.json.JSONException;
import org.json.JSONObject;

public class GetCheckoutDetailsRequest {
    private final String requestId;
    private CheckoutFilter checkoutFilter;
    private CustomerDetails customerDetails;
    private Usecase usecase;
    private GetTransactionDetails transactionDetails;

    private GetCheckoutDetailsRequest(Builder builder) {
        this.requestId = builder.requestId;
        this.checkoutFilter = builder.checkoutFilter;
        this.usecase = builder.usecase;
        this.customerDetails = builder.customerDetails;
        this.transactionDetails = builder.transactionDetails;
    }

    public String prepareJSON() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("requestId", (Object)this.requestId);
            if (this.transactionDetails != null) {
                jsonObject.put("transactionDetails", (Object)this.transactionDetails.prepareTransactionDeatilsJson());
            }
            if (this.customerDetails != null) {
                jsonObject.put("customerDetails", (Object)this.customerDetails.prepareCustomerDetailsObject());
            }
            if (this.checkoutFilter != null) {
                jsonObject.put("filters", (Object)this.checkoutFilter.prepareFilterJson());
            }
            if (this.usecase != null) {
                jsonObject.put("useCase", (Object)this.usecase.prepareUseCaseJson());
            }
        }
        catch (JSONException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
        }
        return jsonObject.toString();
    }

    public static class Builder {
        private String requestId = String.valueOf(System.currentTimeMillis());
        private CheckoutFilter checkoutFilter = null;
        private CustomerDetails customerDetails = null;
        private Usecase usecase = null;
        private GetTransactionDetails transactionDetails = null;

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder setCheckoutFilter(CheckoutFilter checkoutFilter) {
            this.checkoutFilter = checkoutFilter;
            return this;
        }

        public Builder setCustomerDetails(CustomerDetails customerDetails) {
            this.customerDetails = customerDetails;
            return this;
        }

        public Builder setUsecase(Usecase usecase) {
            this.usecase = usecase;
            return this;
        }

        public Builder setTransactionDetails(GetTransactionDetails transactionDetails) {
            this.transactionDetails = transactionDetails;
            return this;
        }

        public GetCheckoutDetailsRequest build() {
            return new GetCheckoutDetailsRequest(this);
        }
    }
}

