/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import android.util.Log;
import com.payu.india.Interfaces.ValidateOfferApiListener;
import com.payu.india.Model.DiscountDetailsofOffers;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.ValidateOfferInfo;
import com.payu.india.Model.validateOffer.SKUOfferDetails;
import com.payu.india.Model.validateOffer.ValidateOfferDetails;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.paymentparamhelper.Sku;
import com.payu.paymentparamhelper.SkuDiscountDetails;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ValidateOfferTask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    private ValidateOfferApiListener mvalidateOfferApiListener;

    public ValidateOfferTask(ValidateOfferApiListener validateOfferApiListener) {
        this.mvalidateOfferApiListener = validateOfferApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://api.payu.in/");
                    break;
                }
                case 2: {
                    url = new URL("https://sandbox.payu.in/");
                    break;
                }
                default: {
                    url = new URL("https://api.payu.in/");
                }
            }
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).setURL(url + "offers/transactions/validate").setPostData(payuConfig.getData()).setHeaders(V2ApiHelper.getInstance().getAuthHeader()).setRequestType("application/json").build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                int i;
                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                JSONObject result = response.optJSONObject("result");
                if (result != null) {
                    JSONArray offerDetailJsonArray;
                    ValidateOfferDetails validateOfferDetails = new ValidateOfferDetails();
                    validateOfferDetails.setAmount(PayuUtils.getDoubletValue(result, "amount"));
                    validateOfferDetails.setValid(result.optBoolean("isValid"));
                    if (!result.isNull("totalDiscountDetail")) {
                        JSONObject totalDiscountDetail = result.getJSONObject("totalDiscountDetail");
                        validateOfferDetails.setTotalCashbackDiscount(PayuUtils.getDoubletValue(totalDiscountDetail, "totalCashbackDiscount"));
                        validateOfferDetails.setTotalInstantDiscount(PayuUtils.getDoubletValue(totalDiscountDetail, "totalInstantDiscount"));
                        validateOfferDetails.setTotalDiscountedAmount(PayuUtils.getDoubletValue(totalDiscountDetail, "totalDiscountedAmount"));
                    }
                    if (result.optJSONArray("offers") != null && (offerDetailJsonArray = result.optJSONArray("offers")) != null) {
                        validateOfferDetails.setValidateOfferInfo(this.prepareOfferInfoList(offerDetailJsonArray));
                    }
                    validateOfferDetails.setFailureReason(PayuUtils.getStringValue(result, "failureReason"));
                    if (result.optJSONObject("skusDetail") != null) {
                        JSONObject skuDetails = result.optJSONObject("skusDetail");
                        JSONObject skuDiscountDetailsJson = skuDetails.optJSONObject("skusDiscountDetail");
                        validateOfferDetails.setTotalCashbackDiscount(PayuUtils.getDoubletValue(skuDiscountDetailsJson, "totalCashbackDiscount"));
                        validateOfferDetails.setTotalInstantDiscount(PayuUtils.getDoubletValue(skuDiscountDetailsJson, "totalInstantDiscount"));
                        validateOfferDetails.setTotalDiscountedAmount(PayuUtils.getDoubletValue(skuDiscountDetailsJson, "totalDiscountedAmount"));
                        if (skuDetails.optJSONArray("skus") != null) {
                            ArrayList<SKUOfferDetails> skuOfferDetailsList = new ArrayList<SKUOfferDetails>();
                            JSONArray skus = skuDetails.optJSONArray("skus");
                            for (int i2 = 0; skus != null && i2 < skus.length(); ++i2) {
                                JSONObject skuJsonObject = skus.optJSONObject(i2);
                                Sku sku = new Sku();
                                sku.setSkuId(skuJsonObject.optString("skuId"));
                                sku.setQuantity(skuJsonObject.optInt("quantity"));
                                sku.setSkuAmount(skuJsonObject.optString("skuAmount"));
                                sku.setName(skuJsonObject.optString("name"));
                                sku.setAutoApplyOffer(skuJsonObject.optBoolean("autoApply"));
                                SKUOfferDetails skuOfferDetails = new SKUOfferDetails();
                                JSONObject totalSkuDiscountDetails = skuJsonObject.optJSONObject("skuTotalDiscountDetail");
                                SkuDiscountDetails skuDiscountDetails = new SkuDiscountDetails();
                                if (totalSkuDiscountDetails != null) {
                                    skuDiscountDetails.setInstant(PayuUtils.getDoubletValue(totalSkuDiscountDetails, "totalInstantDiscount"));
                                    skuDiscountDetails.setCashBack(PayuUtils.getDoubletValue(totalSkuDiscountDetails, "totalCashbackDiscount"));
                                    skuDiscountDetails.setDiscountedAmount(PayuUtils.getDoubletValue(totalSkuDiscountDetails, "totalDiscountedAmount"));
                                }
                                skuOfferDetails.setSkuDiscountDetails(skuDiscountDetails);
                                skuOfferDetails.setSku(sku);
                                skuOfferDetails.setValid(skuJsonObject.optBoolean("isValid"));
                                if (skuJsonObject.optJSONArray("offers") == null) continue;
                                JSONArray offerDetailJsonArray2 = skuJsonObject.optJSONArray("offers");
                                if (offerDetailJsonArray2 != null) {
                                    skuOfferDetails.setValidateOfferInfoList(this.prepareOfferInfoList(offerDetailJsonArray2));
                                }
                                skuOfferDetailsList.add(skuOfferDetails);
                            }
                            validateOfferDetails.setSkuOfferDetailsList(skuOfferDetailsList);
                        }
                    }
                    validateOfferDetails.setAutoApply(result.optBoolean("autoApply"));
                    payuResponse.setValidateOfferDetails(validateOfferDetails);
                }
                PayuUtils.safeClose(responseInputStream);
            }
        }
        catch (ProtocolException e) {
            Log.d((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("ProtocalException " + e.getMessage()));
        }
        catch (IOException e) {
            Log.d((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("IOException " + e.getMessage()));
        }
        catch (JSONException e) {
            Log.d((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    private List<ValidateOfferInfo> prepareOfferInfoList(JSONArray offerDetailJsonArray) {
        ArrayList<ValidateOfferInfo> validateOfferInfoList = new ArrayList<ValidateOfferInfo>();
        for (int i = 0; i < offerDetailJsonArray.length(); ++i) {
            JSONObject offerDetailJson = null;
            try {
                offerDetailJson = offerDetailJsonArray.getJSONObject(i);
                validateOfferInfoList.add(this.prepareValidateOfferInfo(offerDetailJson));
                continue;
            }
            catch (JSONException e) {
                Log.d((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
            }
        }
        return validateOfferInfoList;
    }

    private ValidateOfferInfo prepareValidateOfferInfo(JSONObject validateInfoJsonObject) {
        ValidateOfferInfo validateOfferInfo = new ValidateOfferInfo();
        validateOfferInfo.setOfferKey(validateInfoJsonObject.optString("offerKey"));
        String offerType = validateInfoJsonObject.optString("offerType");
        validateOfferInfo.setOfferType(offerType);
        validateOfferInfo.setTitle(validateInfoJsonObject.optString("title"));
        validateOfferInfo.setDescription(validateInfoJsonObject.optString("description"));
        validateOfferInfo.setValidFrom(validateInfoJsonObject.optString("validFrom"));
        validateOfferInfo.setValidTo(validateInfoJsonObject.optString("validTo"));
        validateOfferInfo.setTnc(validateInfoJsonObject.optString("tnc"));
        validateOfferInfo.setTncLink(validateInfoJsonObject.optString("tncLink"));
        validateOfferInfo.setDiscountType(validateInfoJsonObject.optString("discountType"));
        validateOfferInfo.setOfferPercentage(validateInfoJsonObject.optString("offerPercentage"));
        validateOfferInfo.setMaxDiscountPerTxn(validateInfoJsonObject.optDouble("maxDiscountPerTxn"));
        validateOfferInfo.setMaxTxnAmount(Double.parseDouble(Objects.requireNonNull(validateInfoJsonObject.opt("maxTxnAmount")).toString()));
        validateOfferInfo.setMinTxnAmount(Double.parseDouble(Objects.requireNonNull(validateInfoJsonObject.opt("minTxnAmount")).toString()));
        validateOfferInfo.setStatus(validateInfoJsonObject.optString("status"));
        validateOfferInfo.setIsNoCostEmi(validateInfoJsonObject.optBoolean("isNce"));
        validateOfferInfo.setValid(validateInfoJsonObject.optBoolean("isValid"));
        validateOfferInfo.setOfferCategory(validateInfoJsonObject.optString("offerCategory"));
        validateOfferInfo.setSkuOffer(validateInfoJsonObject.optBoolean("isSkuOffer"));
        validateOfferInfo.setDisallowTransactionInvalidOffer(validateInfoJsonObject.optBoolean("disallowTransactionInvalidOffer"));
        validateOfferInfo.setAmount(PayuUtils.getDoubletValue(validateInfoJsonObject, "amount"));
        validateOfferInfo.setDiscount(PayuUtils.getDoubletValue(validateInfoJsonObject, "discount"));
        validateOfferInfo.setDiscountedAmount(PayuUtils.getDoubletValue(validateInfoJsonObject, "discountedAmount"));
        DiscountDetailsofOffers discountDetailsofOffers = new DiscountDetailsofOffers();
        discountDetailsofOffers.setDiscount(PayuUtils.getDoubletValue(validateInfoJsonObject, "discount"));
        discountDetailsofOffers.setDiscountType(offerType);
        discountDetailsofOffers.setDiscountedAmount(PayuUtils.getDoubletValue(validateInfoJsonObject, "discountedAmount"));
        validateOfferInfo.setDiscountDetails(discountDetailsofOffers);
        return validateOfferInfo;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.mvalidateOfferApiListener.onValiDateOfferResponse(payuResponse);
    }
}

