/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import android.util.Log;
import com.payu.india.Interfaces.FetchIFSCDetailsListener;
import com.payu.india.Model.IFSCCodeDetails;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchIFSCDetailsTask
extends AsyncTask<String, String, PayuResponse> {
    FetchIFSCDetailsListener mIfscDetailsListener;

    public FetchIFSCDetailsTask(FetchIFSCDetailsListener ifscDetailsListener) {
        this.mIfscDetailsListener = ifscDetailsListener;
    }

    protected PayuResponse doInBackground(String ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            String ifscCode = params[0];
            URL url = new URL("https://api.payu.in/checkoutx/verifyIFSC");
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString() + "?ifscCode=" + ifscCode);
            if (null != conn) {
                int i;
                InputStream inputStream = null;
                int statusCode = conn.getResponseCode();
                inputStream = statusCode >= 200 && statusCode < 400 ? conn.getInputStream() : conn.getErrorStream();
                StringBuilder responseStringBuilder = new StringBuilder();
                byte[] byteContainer = new byte[1024];
                while ((i = inputStream.read(byteContainer)) != -1) {
                    responseStringBuilder.append(new String(byteContainer, 0, i));
                }
                JSONObject response = new JSONObject(responseStringBuilder.toString());
                payuResponse.setRawResponse(response);
                if (conn.getResponseCode() == 200 && response.optJSONObject("response") != null) {
                    JSONObject resultObject = response.getJSONObject("response").optJSONObject("result");
                    if (resultObject != null) {
                        IFSCCodeDetails ifscCodeDetails = new IFSCCodeDetails();
                        ifscCodeDetails.setBank(resultObject.optString("bank"));
                        ifscCodeDetails.setCity(resultObject.optString("city"));
                        ifscCodeDetails.setIfsc(resultObject.optString("ifsc"));
                        ifscCodeDetails.setMicr(resultObject.optString("micr"));
                        ifscCodeDetails.setState(resultObject.optString("state"));
                        ifscCodeDetails.setBranch(resultObject.optString("branch"));
                        ifscCodeDetails.setOffice(resultObject.optString("office"));
                        ifscCodeDetails.setAddress(resultObject.optString("address"));
                        ifscCodeDetails.setContact(resultObject.optString("contact"));
                        ifscCodeDetails.setDistrict(resultObject.optString("district"));
                        payuResponse.setIfscCodeDetails(ifscCodeDetails);
                        postData.setCode(0);
                        postData.setStatus("SUCCESS");
                    } else {
                        postData.setCode(5051);
                        postData.setResult("Invalid IFSC Details");
                        postData.setStatus("ERROR");
                    }
                } else if (conn.getResponseCode() == 429) {
                    postData.setCode(conn.getResponseCode());
                    postData.setResult("Oops! Too many requests. Please try after sometime");
                    postData.setStatus("ERROR");
                } else if (conn.getResponseCode() == 400) {
                    postData.setCode(conn.getResponseCode());
                    postData.setResult("IFSC not found");
                    postData.setStatus("ERROR");
                } else {
                    postData.setCode(conn.getResponseCode());
                    postData.setResult(response.optString("description"));
                    postData.setStatus("ERROR");
                }
                payuResponse.setResponseStatus(postData);
            }
        }
        catch (IOException | JSONException e) {
            Log.d((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("Exception " + e.getMessage()));
        }
        return payuResponse;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.mIfscDetailsListener.onIFSCDetailsReceived(payuResponse);
    }
}

