/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model.validateOffer;

import com.payu.india.Model.PaymentDetailsForOffer;
import com.payu.india.Model.UserDetailsForOffer;
import com.payu.india.Payu.PayuUtils;
import com.payu.paymentparamhelper.V2ApiBase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ValidateOfferRequest
extends V2ApiBase {
    private String amount;
    private JSONArray offerKeys;
    private PaymentDetailsForOffer paymentDetailsForOffer;
    private UserDetailsForOffer userDetailsForOffer;
    private boolean autoApply;
    private String skuDetails;

    private ValidateOfferRequest(Builder builder) {
        this.amount = builder.amount;
        this.offerKeys = builder.offerKeys;
        this.paymentDetailsForOffer = builder.paymentDetailsForOffer;
        this.userDetailsForOffer = builder.userDetailsForOffer;
        this.autoApply = builder.autoApply;
        this.skuDetails = builder.skuDetails;
    }

    public String getJson() {
        try {
            JSONObject jsonObject = new JSONObject();
            if (this.skuDetails != null) {
                jsonObject = this.getSKUJson(this.skuDetails);
            }
            jsonObject.put("amount", (Object)this.amount);
            if (this.offerKeys != null && this.offerKeys.length() > 0) {
                jsonObject.put("offerKeys", (Object)this.offerKeys);
            }
            jsonObject.put("paymentDetail", (Object)this.paymentDetailsForOffer.prepareJson());
            jsonObject.put("userDetail", (Object)this.userDetailsForOffer.prepareJson());
            jsonObject.put("autoApply", this.autoApply);
            return jsonObject.toString();
        }
        catch (JSONException e) {
            return null;
        }
    }

    private JSONObject getSKUJson(String skuDetails) {
        skuDetails = PayuUtils.replaceString(skuDetails, "sku_id", "skuId");
        skuDetails = PayuUtils.replaceString(skuDetails, "amount_per_sku", "skuAmount");
        skuDetails = PayuUtils.replaceString(skuDetails, "offer_key", "offerKeys");
        skuDetails = PayuUtils.replaceString(skuDetails, "offer_auto_apply", "autoApply");
        try {
            JSONObject skuJsonObject = new JSONObject(skuDetails);
            JSONArray skuJsonArray = skuJsonObject.getJSONArray("sku_details");
            JSONObject validateSku = new JSONObject();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("skus", (Object)skuJsonArray);
            validateSku.put("skusDetail", (Object)jsonObject);
            return validateSku;
        }
        catch (JSONException jsonException) {
            return new JSONObject();
        }
    }

    public static class Builder {
        private final String amount;
        private JSONArray offerKeys;
        private PaymentDetailsForOffer paymentDetailsForOffer;
        private UserDetailsForOffer userDetailsForOffer;
        private boolean autoApply;
        private String skuDetails;

        public Builder(String amount) {
            this.amount = amount;
        }

        public Builder setOfferKey(JSONArray offerKeys) {
            this.offerKeys = offerKeys;
            return this;
        }

        public Builder setPaymentDetails(PaymentDetailsForOffer paymentDetailsForOffer) {
            this.paymentDetailsForOffer = paymentDetailsForOffer;
            return this;
        }

        public Builder setAutoApply(boolean autoApply) {
            this.autoApply = autoApply;
            return this;
        }

        public Builder setuserDetails(UserDetailsForOffer userDetailsForOffer) {
            this.userDetailsForOffer = userDetailsForOffer;
            return this;
        }

        public Builder setSkuDetails(String skuDetails) {
            this.skuDetails = skuDetails;
            return this;
        }

        public ValidateOfferRequest build() {
            return new ValidateOfferRequest(this);
        }
    }
}

