/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.CheckoutDetailsListener;
import com.payu.india.Model.Bnpl;
import com.payu.india.Model.Emi;
import com.payu.india.Model.IfscMappingDetails;
import com.payu.india.Model.MerchantInfo;
import com.payu.india.Model.MerchantParamInfo;
import com.payu.india.Model.PayUEmiTenures;
import com.payu.india.Model.PaymentDetails;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuOffer;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.TaxSpecification;
import com.payu.india.Model.Upi;
import com.payu.india.Model.UpiApp;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetPaymentInstrumentTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private final CheckoutDetailsListener mCheckoutDetailsListener;

    public GetPaymentInstrumentTask(CheckoutDetailsListener checkoutDetailsListener) {
        this.mCheckoutDetailsListener = checkoutDetailsListener;
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 4: {
                    url = new URL("https://bizcheckouttest.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                StringBuilder responseStringBuffer = PayuUtils.getStringBuilder(conn, false);
                JSONObject resp = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(resp);
                if (resp.has("details") && resp.optJSONObject("details") != null) {
                    JSONObject paymentOptions;
                    JSONArray issuingBanks;
                    JSONObject downInfoObject;
                    JSONObject details = resp.getJSONObject("details");
                    JSONArray offersArray = details.optJSONArray("offers");
                    if (offersArray != null && offersArray.length() != 0) {
                        ArrayList<PayuOffer> offersList = new ArrayList<PayuOffer>();
                        for (int i = 0; i < offersArray.length(); ++i) {
                            JSONObject offerObject = offersArray.getJSONObject(i);
                            PayuOffer payuOffer = new PayuOffer();
                            payuOffer.setId(offerObject.optString("id"));
                            payuOffer.setTitle(offerObject.optString("title"));
                            payuOffer.setDescription(offerObject.optString("description"));
                            payuOffer.setMinAmount(offerObject.optString("min_amount"));
                            payuOffer.setDiscount(offerObject.optString("discount"));
                            payuOffer.setDiscountUnit(offerObject.optString("discount_unit"));
                            payuOffer.setOfferType(offerObject.optString("offer_type"));
                            payuOffer.setValidOnDays(offerObject.optString("valid_on_days"));
                            payuOffer.setOfferKey("@" + offerObject.optString("id"));
                            offersList.add(payuOffer);
                        }
                        payuResponse.setOfferDetailsList(offersList);
                    }
                    if ((downInfoObject = details.optJSONObject("downInfo")) != null && downInfoObject.length() != 0 && (issuingBanks = downInfoObject.optJSONArray("issuingBanks")) != null && issuingBanks.length() != 0) {
                        ArrayList<String> issuingBanksList = new ArrayList<String>();
                        for (int i = 0; i < issuingBanks.length(); ++i) {
                            if (issuingBanks.optString(i) == null || issuingBanks.getString(i).isEmpty()) continue;
                            issuingBanksList.add(issuingBanks.getString(i));
                        }
                        payuResponse.setDownIssuingBanks(issuingBanksList);
                    }
                    JSONObject configObject = details.optJSONObject("config");
                    ArrayList<String> threedsBankList = new ArrayList<String>();
                    MerchantInfo merchantInfo = new MerchantInfo();
                    JSONObject merchant = details.optJSONObject("merchant");
                    if (merchant != null && merchant.length() != 0) {
                        JSONArray upiApps;
                        JSONObject ifscMappingJson;
                        if (merchant.optString("logo") != null && !merchant.optString("logo").equalsIgnoreCase("null")) {
                            merchantInfo.setLogo(merchant.optString("logo"));
                        }
                        merchantInfo.setDisplayName(merchant.optString("displayName"));
                        merchantInfo.setWalletIdentifier(merchant.optString("walletIdentifier"));
                        String retryCount = merchant.optString("retryAllowed");
                        if (retryCount != null && !retryCount.isEmpty()) {
                            merchantInfo.setRetryCount(Integer.parseInt(retryCount));
                        }
                        if ((ifscMappingJson = merchant.optJSONObject("ifscBankNameMapping")) != null) {
                            Iterator keys = ifscMappingJson.keys();
                            ArrayList<IfscMappingDetails> ifscMappingDetailsList = new ArrayList<IfscMappingDetails>();
                            while (keys.hasNext()) {
                                String key = (String)keys.next();
                                JSONObject bankJson = ifscMappingJson.optJSONObject(key);
                                if (bankJson == null) continue;
                                IfscMappingDetails ifscMappingDetails = new IfscMappingDetails();
                                ifscMappingDetails.setIfscCode(key);
                                ifscMappingDetails.setBankName(bankJson.optString("name"));
                                ifscMappingDetails.setImageUrl(bankJson.optString("imageURL"));
                                ifscMappingDetails.setImageUpdateOn(bankJson.optString("imageUpdatedOn"));
                                ifscMappingDetails.setIbiboCode(bankJson.optString("ibiboCode"));
                                ifscMappingDetailsList.add(ifscMappingDetails);
                            }
                            merchantInfo.setIfscMappingDetails(ifscMappingDetailsList);
                        }
                        JSONObject merchantParamObj = merchant.optJSONObject("merchant_param");
                        MerchantParamInfo paramInfo = new MerchantParamInfo();
                        if (merchantParamObj != null && merchantParamObj.has("isAdsEnabled")) {
                            paramInfo.setAdsEnabled(merchantParamObj.optInt("isAdsEnabled") == 1);
                        }
                        if (configObject != null && configObject.has("isQuickPayEnabled")) {
                            paramInfo.setQuickPayEnabled(configObject.optBoolean("isQuickPayEnabled"));
                        }
                        if (configObject != null && configObject.has("deviceFP")) {
                            paramInfo.setDeviceIdEnabled(configObject.optBoolean("deviceFP"));
                        }
                        if (configObject != null && configObject.has("enableInternal3DSS")) {
                            paramInfo.setEnableInternal3DSS(configObject.optBoolean("enableInternal3DSS"));
                        }
                        if (configObject != null && configObject.has("internationalOn3DSS")) {
                            paramInfo.setInternationalOn3DSS(configObject.optBoolean("internationalOn3DSS"));
                        }
                        if (configObject != null && configObject.has("enable3dsSDK")) {
                            paramInfo.setEnable3dsSDK(configObject.optBoolean("enable3dsSDK"));
                        }
                        if (configObject != null && configObject.has("3DSSupportedBankList")) {
                            threedsBankList.addAll(Arrays.asList(configObject.getString("3DSSupportedBankList").split("\\|")));
                            paramInfo.setThreedsBankList(threedsBankList);
                        }
                        if (configObject != null && configObject.has("isOfferEnabled")) {
                            paramInfo.setOfferEnabled(configObject.optBoolean("isOfferEnabled"));
                        }
                        if (configObject != null && configObject.has("isQuickPayBottomSheetEnabled")) {
                            paramInfo.setQuickPayBottomSheetEnabled(configObject.optBoolean("isQuickPayBottomSheetEnabled"));
                        }
                        if (configObject != null && configObject.has("nfcEnabled")) {
                            paramInfo.setNfcEnabled(configObject.optBoolean("nfcEnabled"));
                        }
                        if (configObject != null && configObject.has("upiApps") && (upiApps = configObject.optJSONArray("upiApps")) != null && upiApps.length() != 0) {
                            ArrayList<UpiApp> upiApp = new ArrayList<UpiApp>();
                            for (int i = 0; i < upiApps.length(); ++i) {
                                JSONObject upiAppObject = null;
                                upiAppObject = upiApps.getJSONObject(i);
                                UpiApp payuOffer = new UpiApp();
                                payuOffer.setHandlers(upiAppObject.optString("handlers"));
                                payuOffer.setAppName(upiAppObject.optString("appName"));
                                payuOffer.setAndroidBundleIdentifier(upiAppObject.optString("androidBundleIdentifier"));
                                upiApp.add(payuOffer);
                            }
                            paramInfo.setUpiApps(upiApp);
                        }
                        if (configObject != null && configObject.has("upiSiApps")) {
                            ArrayList<String> upiSiAppsList = new ArrayList<String>(Arrays.asList(configObject.getString("upiSiApps").split(",")));
                            paramInfo.setUpiSIApps(upiSiAppsList);
                        }
                        if (configObject != null && configObject.has("customerRevenueEnabled")) {
                            paramInfo.setCustomerRevenueEnabled(configObject.optBoolean("customerRevenueEnabled"));
                        }
                        if (configObject != null && configObject.has("isInsuranceMerchant")) {
                            paramInfo.setInsuranceMerchant(configObject.optBoolean("isInsuranceMerchant"));
                        }
                        if (configObject != null && configObject.has("opgsp_merchant")) {
                            String opgsp = configObject.optString("opgsp_merchant");
                            paramInfo.setOpgspMerchant(opgsp != null && !opgsp.isEmpty() && !opgsp.equalsIgnoreCase("null"));
                        }
                        merchantInfo.setMerchantParamInfo(paramInfo);
                        if (merchant.optJSONArray("minkasuIbiboCodes") != null) {
                            merchantInfo.setOneClickPayBankCodes(this.getArrayListFromJsonArray(merchant.getJSONArray("minkasuIbiboCodes")));
                        }
                        payuResponse.setMerchantInfo(merchantInfo);
                    }
                    if (configObject != null) {
                        TaxSpecification taxSpecification = new TaxSpecification();
                        taxSpecification.setCcTaxValue(this.getTaxFromConfigObject(configObject, "cc"));
                        taxSpecification.setDcTaxValue(this.getTaxFromConfigObject(configObject, "dc"));
                        taxSpecification.setNbTaxValue(this.getTaxFromConfigObject(configObject, "nb"));
                        taxSpecification.setUpiTaxValue(this.getTaxFromConfigObject(configObject, "upi"));
                        taxSpecification.setEmiTaxValue(this.getTaxFromConfigObject(configObject, "emi"));
                        taxSpecification.setCashTaxValue(this.getTaxFromConfigObject(configObject, "cash"));
                        taxSpecification.setEnachTaxValue(this.getTaxFromConfigObject(configObject, "enach"));
                        taxSpecification.setLazypayTaxValue(this.getTaxFromConfigObject(configObject, "lazypay"));
                        taxSpecification.setSiTaxValue(this.getTaxFromConfigObject(configObject, "si"));
                        taxSpecification.setNeftRtgsTaxValue(this.getTaxFromConfigObject(configObject, "neftrtgs"));
                        taxSpecification.setMealCardTaxValue(this.getTaxFromConfigObject(configObject, "mc"));
                        taxSpecification.setBnplTaxValue(this.getTaxFromConfigObject(configObject, "bnpl"));
                        payuResponse.setTaxSpecification(taxSpecification);
                    }
                    if ((paymentOptions = details.optJSONObject("paymentOptions")) != null && paymentOptions.length() > 0) {
                        ArrayList<Bnpl> bnplList;
                        Upi upi;
                        JSONObject upiObject;
                        JSONArray upiArray;
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "cc")) {
                            payuResponse.setCreditCard(this.prepareListWithKeyData(details, "cc"));
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "dc")) {
                            payuResponse.setDebitCard(this.prepareListWithKeyData(details, "dc"));
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "nb")) {
                            payuResponse.setNetBanks(this.prepareListWithKeyData(details, "nb"));
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "enach")) {
                            ArrayList<PaymentDetails> nbSiList = this.prepareListWithKeyData(details, "enach");
                            payuResponse.setSiBankList(nbSiList);
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "si")) {
                            ArrayList<PaymentDetails> siList = this.prepareListWithKeyData(details, "si");
                            payuResponse.setStandingInstructions(siList);
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "neftrtgs")) {
                            ArrayList<PaymentDetails> nfetrtgsList = this.prepareListWithKeyData(details, "neftrtgs");
                            payuResponse.setNeftRtgs(nfetrtgsList);
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "cash")) {
                            ArrayList<PaymentDetails> walletList = this.prepareListWithKeyData(details, "cash");
                            PaymentDetails paymentDetails = this.getPhonePeIntentFromList(walletList);
                            if (paymentDetails != null) {
                                payuResponse.setPhonePe(paymentDetails);
                            }
                            payuResponse.setCashCard(walletList);
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "ivr")) {
                            payuResponse.setIvr(this.prepareListWithKeyData(details, "ivr"));
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "ivrdc")) {
                            payuResponse.setIvrdc(this.prepareListWithKeyData(details, "ivrdc"));
                        }
                        if (paymentOptions.has("upi") && paymentOptions.optJSONObject("upi") != null && paymentOptions.optJSONObject("upi").optJSONArray("all") != null) {
                            upiArray = paymentOptions.getJSONObject("upi").getJSONArray("all");
                            for (int i = 0; i < upiArray.length(); ++i) {
                                upiObject = upiArray.getJSONObject(i);
                                if (upiObject.optString("ibiboCode").equalsIgnoreCase("upi")) {
                                    upi = this.getUpi(offersArray, upiObject);
                                    upi.setBankDown(this.getBankDownStatus(downInfoObject, "upi", "upi"));
                                    payuResponse.setUpi(upi);
                                    continue;
                                }
                                if (upiObject.optString("ibiboCode").equalsIgnoreCase("UPITPV")) {
                                    upi = this.getUpi(offersArray, upiObject);
                                    upi.setBankDown(this.getBankDownStatus(downInfoObject, "upi", "UPITPV"));
                                    payuResponse.setUpi(upi);
                                    continue;
                                }
                                if (upiObject.optString("ibiboCode").equalsIgnoreCase("INTTPV")) {
                                    upi = this.getUpi(offersArray, upiObject);
                                    upi.setBankDown(this.getBankDownStatus(downInfoObject, "upi", "INTTPV"));
                                    payuResponse.setGenericIntent(upi);
                                    continue;
                                }
                                if (upiObject.optString("ibiboCode").equalsIgnoreCase("TEZOMNI")) {
                                    upi = this.getUpi(offersArray, upiObject);
                                    upi.setBankDown(this.getBankDownStatus(downInfoObject, "upi", "TEZOMNI"));
                                    payuResponse.setGoogleTezOmni(upi);
                                    continue;
                                }
                                if (upiObject.optString("ibiboCode").equalsIgnoreCase("TEZ")) {
                                    upi = this.getUpi(offersArray, upiObject);
                                    upi.setBankDown(this.getBankDownStatus(downInfoObject, "upi", "TEZ"));
                                    payuResponse.setGoogleTez(upi);
                                    continue;
                                }
                                if (!upiObject.optString("ibiboCode").equalsIgnoreCase("INTENT")) continue;
                                upi = this.getUpi(offersArray, upiObject);
                                upi.setBankDown(this.getBankDownStatus(downInfoObject, "upi", "INTENT"));
                                payuResponse.setGenericIntent(upi);
                            }
                            JSONObject siDetails = paymentOptions.getJSONObject("upi").optJSONObject("si");
                            if (siDetails != null) {
                                this.updateSiApps(siDetails, payuResponse);
                            }
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "upiotm")) {
                            upiArray = paymentOptions.getJSONArray("upiotm");
                            for (int i = 0; i < upiArray.length(); ++i) {
                                upiObject = upiArray.getJSONObject(i);
                                if (upiObject.optString("ibiboCode").equalsIgnoreCase("INTOTM")) {
                                    payuResponse.setIsIntentAvailableForOtm(true);
                                    upi = this.getUpi(offersArray, upiObject);
                                    upi.setBankDown(this.getBankDownStatus(downInfoObject, "upiotm", "INTOTM"));
                                    payuResponse.setGenericIntent(upi);
                                } else if (upiObject.optString("ibiboCode").equalsIgnoreCase("UPIOTM")) {
                                    payuResponse.setIsUpiAvailableForOtm(true);
                                    upi = this.getUpi(offersArray, upiObject);
                                    upi.setBankDown(this.getBankDownStatus(downInfoObject, "upiotm", "UPIOTM"));
                                    payuResponse.setUpi(upi);
                                }
                                if (upiObject.optJSONArray("apps") == null && upiObject.optJSONArray("handles") == null) continue;
                                this.updateSiApps(upiObject, payuResponse);
                            }
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "emi")) {
                            ArrayList<Emi> cardlessList;
                            ArrayList<Emi> dcemiList;
                            ArrayList<Emi> ccemiList = this.getEmiList(details, "cc");
                            if (ccemiList != null && !ccemiList.isEmpty()) {
                                payuResponse.setCcemi(ccemiList);
                            }
                            if ((dcemiList = this.getEmiList(details, "dc")) != null && !dcemiList.isEmpty()) {
                                payuResponse.setDcemi(dcemiList);
                            }
                            ArrayList<Emi> cardlessemiList = new ArrayList<Emi>();
                            ArrayList<Emi> otheremiList = this.getEmiList(details, "other");
                            if (otheremiList != null && !otheremiList.isEmpty()) {
                                cardlessemiList.addAll(otheremiList);
                            }
                            if ((cardlessList = this.getEmiList(details, "cardless")) != null && !cardlessList.isEmpty()) {
                                cardlessemiList.addAll(cardlessList);
                            }
                            if (!cardlessemiList.isEmpty()) {
                                payuResponse.setCardlessemi(cardlessemiList);
                            }
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "lazypay")) {
                            payuResponse.setLazyPay(this.prepareListWithKeyData(details, "lazypay"));
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "mc")) {
                            payuResponse.setMealCard(this.prepareListWithKeyData(details, "mc"));
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "bnpl") && (bnplList = this.prepareBnplListWithKeyData(details, "bnpl")) != null && !bnplList.isEmpty()) {
                            payuResponse.setBnpl(bnplList);
                        }
                        if (this.isJSONObjectAvailableForKey(paymentOptions, "clw")) {
                            payuResponse.setClosedLoopWallet(this.prepareListWithKeyData(details, "clw"));
                        }
                    }
                }
                if (resp.has("status") && resp.getString("status").contentEquals("0")) {
                    postData = new PostData();
                    postData.setCode(5019);
                    postData.setStatus("ERROR");
                    postData.setResult(resp.getString("msg"));
                } else {
                    postData.setCode(0);
                    postData.setResult("Data fetched successfully");
                    postData.setStatus("SUCCESS");
                }
            }
        }
        catch (ProtocolException e) {
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            postData.setCode(5004);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (JSONException e) {
            postData.setCode(5014);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        catch (IOException e) {
            postData.setCode(5016);
            postData.setStatus("ERROR");
            postData.setResult(e.getMessage());
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    private Upi getUpi(JSONArray offersArray, JSONObject upiObject) throws JSONException {
        Upi upi = new Upi();
        upi.setTitle(upiObject.optString("title"));
        upi.setAdditionalCharge(upiObject.optString("additionalCharge"));
        upi.setOfferDetailsList(this.getOffersList(offersArray, upiObject.optJSONArray("offers")));
        upi.setImageUpdatedOn(this.dateParser(upiObject.optString("imageUpdatedOn")));
        upi.setImageURL(upiObject.optString("imageURL"));
        upi.setCategory(upiObject.getString("category"));
        return upi;
    }

    private ArrayList<Emi> getEmiList(JSONObject details, String emiType) throws JSONException {
        JSONArray response = details.getJSONObject("paymentOptions").getJSONArray("emi");
        ArrayList<Emi> emiList = new ArrayList<Emi>();
        for (int i = 0; i < response.length(); ++i) {
            JSONObject emiObject = response.getJSONObject(i);
            if (emiObject == null || !emiType.equalsIgnoreCase(emiObject.getString("ibiboCode")) || emiObject.optJSONArray("all") == null) continue;
            JSONArray banksList = emiObject.getJSONArray("all");
            for (int j = 0; j < banksList.length(); ++j) {
                Emi emi = new Emi();
                JSONObject currentObject = banksList.getJSONObject(j);
                JSONObject tenureOptionsList = currentObject.getJSONObject("tenureOptions");
                JSONObject eligibility = currentObject.optJSONObject("eligibility");
                Iterator tenureKeysIterator = tenureOptionsList.keys();
                emi.setBankTitle(currentObject.optString("title"));
                emi.setShortTitle(currentObject.optString("shortTitle"));
                emi.setMinAmount(currentObject.optString("minimumAmount"));
                emi.setMaxAmount(currentObject.optString("maximumAmount"));
                emi.setBankName(currentObject.getString("ibiboCode"));
                emi.setImageUpdatedOn(this.dateParser(currentObject.optString("imageUpdatedOn")));
                emi.setImageURL(currentObject.optString("imageURL"));
                emi.setCategory(currentObject.getString("category"));
                emi.setBankCode(currentObject.getString("ibiboCode"));
                if (eligibility != null) {
                    emi.setStatus(eligibility.optBoolean("status"));
                    emi.setReason(eligibility.optString("reason"));
                }
                ArrayList<PayUEmiTenures> payUEmiTenuresList = new ArrayList<PayUEmiTenures>();
                while (tenureKeysIterator.hasNext()) {
                    String bankCode = (String)tenureKeysIterator.next();
                    JSONObject tenureObject = tenureOptionsList.getJSONObject(bankCode);
                    PayUEmiTenures payUEmiTenures = new PayUEmiTenures();
                    payUEmiTenures.setBankCode(bankCode);
                    payUEmiTenures.setAdditionalCharge(tenureObject.optString("additionalCharge"));
                    payUEmiTenures.setBankDown(this.getBankDownStatus(details.optJSONObject("downInfo"), "emi", bankCode));
                    payUEmiTenures.setOfferDetailsList(this.getOffersList(details.optJSONArray("offers"), tenureObject.optJSONArray("offers")));
                    payUEmiTenures.setMinAmount(tenureObject.optString("minimumAmount"));
                    payUEmiTenures.setMaxAmount(tenureObject.optString("maximumAmount"));
                    payUEmiTenures.setTenure(tenureObject.optString("tenure"));
                    payUEmiTenures.setInterestRate(tenureObject.optString("interestRate"));
                    payUEmiTenures.setMonthlyEmi(tenureObject.optString("monthlyEmi"));
                    payUEmiTenures.setInterestCharged(tenureObject.optString("interestCharged"));
                    payUEmiTenures.setPaybackAmount(tenureObject.optString("paybackAmount"));
                    payUEmiTenures.setBankCharge(tenureObject.optString("bankCharge"));
                    payUEmiTenures.setImageUpdatedOn(this.dateParser(currentObject.optString("imageUpdatedOn")));
                    payUEmiTenures.setImageURL(currentObject.optString("imageURL"));
                    payUEmiTenures.setCategory(currentObject.getString("category"));
                    if (eligibility != null) {
                        payUEmiTenures.setStatus(eligibility.optBoolean("status"));
                        payUEmiTenures.setReason(eligibility.optString("reason"));
                    }
                    payUEmiTenuresList.add(payUEmiTenures);
                }
                emi.setPayUEmiTenuresList(payUEmiTenuresList);
                emiList.add(emi);
            }
        }
        return emiList;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.mCheckoutDetailsListener.onCheckoutDetailsResponse(payuResponse);
    }

    private PaymentDetails getPhonePeIntentFromList(ArrayList<PaymentDetails> paymentDetailsList) {
        if (paymentDetailsList == null || paymentDetailsList.size() == 0 || "PPINTENT" == null || "PPINTENT".isEmpty()) {
            return null;
        }
        for (PaymentDetails paymentDetails : paymentDetailsList) {
            if (!paymentDetails.getBankCode().equalsIgnoreCase("PPINTENT")) continue;
            return paymentDetails;
        }
        return null;
    }

    private ArrayList<PaymentDetails> prepareListWithKeyData(JSONObject details, String key) throws JSONException {
        JSONArray response = details.getJSONObject("paymentOptions").getJSONArray(key);
        ArrayList<PaymentDetails> paymentDetailsList = new ArrayList<PaymentDetails>();
        for (int i = 0; i < response.length(); ++i) {
            PaymentDetails paymentDetails = new PaymentDetails();
            JSONObject responseObject = response.getJSONObject(i);
            paymentDetails.setImageUpdatedOn(this.dateParser(responseObject.optString("imageUpdatedOn")));
            paymentDetails.setImageURL(responseObject.optString("imageURL"));
            paymentDetails.setCategory(responseObject.getString("category"));
            paymentDetails.setBankCode(responseObject.getString("ibiboCode"));
            paymentDetails.setBankName(responseObject.optString("title"));
            paymentDetails.setAdditionalCharge(responseObject.optString("additionalCharge"));
            paymentDetails.setBankDown(this.getBankDownStatus(details.optJSONObject("downInfo"), key, responseObject.getString("ibiboCode")));
            paymentDetails.setOfferDetailsList(this.getOffersList(details.optJSONArray("offers"), responseObject.optJSONArray("offers")));
            paymentDetails.setIfscCode(responseObject.optString("ifscCode"));
            JSONArray verificationModeJsonArray = responseObject.optJSONArray("verificationMode");
            if (null != verificationModeJsonArray && verificationModeJsonArray.length() > 0) {
                paymentDetails.setVerificationModeList(this.getArrayListFromJsonArray(verificationModeJsonArray));
            }
            paymentDetails.setIsSecureWebview(responseObject.optBoolean("secureWebview"));
            paymentDetailsList.add(paymentDetails);
        }
        return paymentDetailsList;
    }

    private ArrayList<String> getArrayListFromJsonArray(JSONArray jsonArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                try {
                    arrayList.add(jsonArray.get(i).toString());
                    continue;
                }
                catch (JSONException e) {
                    Log.d((String)this.getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
                }
            }
        }
        return arrayList;
    }

    private ArrayList<PayuOffer> getOffersList(JSONArray fullArray, JSONArray offerArray) {
        if (fullArray == null || fullArray.length() == 0 || offerArray == null || offerArray.length() == 0) {
            return null;
        }
        ArrayList<PayuOffer> offersList = new ArrayList<PayuOffer>();
        for (int i = 0; i < offerArray.length(); ++i) {
            String id;
            JSONObject jsonObject = offerArray.optJSONObject(i);
            if (jsonObject == null || (id = jsonObject.optString("id")) == null || id.isEmpty() || id.equalsIgnoreCase("null")) continue;
            for (int j = 0; j < fullArray.length(); ++j) {
                String idFullArray;
                JSONObject fullJsonObject = fullArray.optJSONObject(j);
                if (fullJsonObject == null || (idFullArray = fullJsonObject.optString("id")) == null || !idFullArray.equalsIgnoreCase(id)) continue;
                PayuOffer payuOffer = new PayuOffer();
                payuOffer.setId(fullJsonObject.optString("id"));
                payuOffer.setTitle(fullJsonObject.optString("title"));
                payuOffer.setDescription(fullJsonObject.optString("description"));
                payuOffer.setMinAmount(fullJsonObject.optString("min_amount"));
                payuOffer.setDiscount(fullJsonObject.optString("discount"));
                payuOffer.setDiscountUnit(fullJsonObject.optString("discount_unit"));
                payuOffer.setOfferType(fullJsonObject.optString("offer_type"));
                payuOffer.setValidOnDays(fullJsonObject.optString("valid_on_days"));
                payuOffer.setOfferKey("@" + fullJsonObject.optString("id"));
                offersList.add(payuOffer);
            }
        }
        return offersList;
    }

    private boolean getBankDownStatus(JSONObject downInfoObject, String key, String bankCode) {
        if (downInfoObject == null || downInfoObject.length() == 0 || key == null || key.equalsIgnoreCase("cc") || key.equalsIgnoreCase("dc")) {
            return false;
        }
        JSONArray banksArray = downInfoObject.optJSONArray(key);
        if (banksArray != null && banksArray.length() != 0) {
            for (int i = 0; i < banksArray.length(); ++i) {
                if (banksArray.optString(i) == null || !banksArray.optString(i).equalsIgnoreCase(bankCode)) continue;
                return true;
            }
        }
        return false;
    }

    private String getTaxFromConfigObject(JSONObject configObject, String key) throws JSONException {
        if (configObject == null || configObject.length() == 0 || configObject.optJSONObject("taxSpecification") == null) {
            return null;
        }
        JSONObject taxSpecification = configObject.getJSONObject("taxSpecification");
        if (taxSpecification.has(key) && !taxSpecification.getString(key).equalsIgnoreCase("0")) {
            return taxSpecification.getString(key);
        }
        if (taxSpecification.has("default")) {
            return taxSpecification.getString("default");
        }
        return null;
    }

    private boolean isJSONObjectAvailableForKey(JSONObject paymentOptions, String key) {
        return paymentOptions.has(key) && paymentOptions.optJSONArray(key) != null;
    }

    private long dateParser(String value) {
        try {
            SimpleDateFormat dt = new SimpleDateFormat("yyyyy-mm-dd hh:mm:ss");
            return dt.parse(value).getTime();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private ArrayList<Bnpl> prepareBnplListWithKeyData(JSONObject details, String key) throws JSONException {
        JSONArray allObject = details.getJSONObject("paymentOptions").getJSONArray(key);
        ArrayList<Bnpl> paymentDetailsList = new ArrayList<Bnpl>();
        for (int i = 0; i < allObject.length(); ++i) {
            JSONObject bnplObject = allObject.getJSONObject(i);
            Bnpl paymentDetails = new Bnpl();
            paymentDetails.setBankCode(bnplObject.optString("ibiboCode"));
            paymentDetails.setBankName(bnplObject.optString("title"));
            paymentDetails.setAdditionalCharge(bnplObject.optString("additionalCharge"));
            paymentDetails.setMinAmount(bnplObject.optString("minimumAmount"));
            paymentDetails.setMaxAmount(bnplObject.optString("maximumAmount"));
            JSONObject eligibility = bnplObject.optJSONObject("eligibility");
            paymentDetails.setImageUpdatedOn(this.dateParser(bnplObject.optString("imageUpdatedOn")));
            paymentDetails.setImageURL(bnplObject.optString("imageURL"));
            paymentDetails.setCategory(bnplObject.getString("category"));
            if (eligibility != null) {
                paymentDetails.setStatus(eligibility.optBoolean("status"));
                paymentDetails.setReason(eligibility.optString("reason"));
            }
            paymentDetailsList.add(paymentDetails);
        }
        return paymentDetailsList;
    }

    private void updateSiApps(JSONObject siDetails, PayuResponse payuResponse) throws JSONException {
        JSONArray siSupportedHandles;
        JSONArray siSupportedApps = siDetails.optJSONArray("apps");
        if (siSupportedApps != null) {
            ArrayList<String> appsList = new ArrayList<String>();
            for (int i = 0; i < siSupportedApps.length(); ++i) {
                appsList.add(String.valueOf(siSupportedApps.get(i)));
            }
            payuResponse.setUpiSISupportedApps(appsList);
        }
        if ((siSupportedHandles = siDetails.optJSONArray("handles")) != null) {
            ArrayList<String> handleList = new ArrayList<String>();
            for (int i = 0; i < siSupportedHandles.length(); ++i) {
                handleList.add(String.valueOf(siSupportedHandles.get(i)));
            }
            payuResponse.setUpiSISupportedHandles(handleList);
        }
    }
}

