/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.util.Log;
import com.payu.india.Interfaces.FetchAdsInformationApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.adsinformation.AdsInformationResponse;
import com.payu.india.Payu.HttpRequest;
import com.payu.india.Payu.PayuUtils;
import com.payu.india.Tasks.base.PayUAsyncTask;
import java.io.IOException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchAdsInformationTask
extends PayUAsyncTask<PayuConfig, String, PayuResponse> {
    private FetchAdsInformationApiListener mFetchAdsInformationApiListener;

    public FetchAdsInformationTask(FetchAdsInformationApiListener fetchAdsInformationApiListener) {
        this.mFetchAdsInformationApiListener = fetchAdsInformationApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://api.payu.in/");
                    break;
                }
                case 2: {
                    url = new URL("https://sandbox.payu.in/");
                    break;
                }
                default: {
                    url = new URL("https://api.payu.in/");
                }
            }
            HttpRequest request = new HttpRequest.Builder().setMethod(HttpRequest.Method.POST).setURL(url + "ads/FetchAssets").setPostData(payuConfig.getData()).setRequestType("application/json; charset=utf8").build();
            HttpsURLConnection conn = PayuUtils.getHttpsConn(request);
            if (null != conn) {
                JSONArray assetsArray;
                StringBuffer responseStringBuffer = PayuUtils.getStringBuffer(conn, false);
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                payuResponse.setRawResponse(response);
                if (response.has("status") && response.has("assets") && (assetsArray = response.optJSONArray("assets")) != null && assetsArray.length() != 0) {
                    JSONObject assetsObject = assetsArray.getJSONObject(0);
                    AdsInformationResponse adsInformationResponse = new AdsInformationResponse();
                    adsInformationResponse.setImage(assetsObject.optString("path"));
                    adsInformationResponse.setRequestId(assetsObject.optString("requestId"));
                    adsInformationResponse.setAdsSource(assetsObject.optString("source"));
                    payuResponse.setAdsInformation(adsInformationResponse);
                }
                if (response.has("status") && response.getBoolean("status")) {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                } else {
                    postData.setResult(response.getString("message"));
                    postData.setStatus("ERROR");
                }
            }
            payuResponse.setResponseStatus(postData);
        }
        catch (IOException | JSONException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Exception " + e.getMessage()));
        }
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        this.mFetchAdsInformationApiListener.onGetAdsInformationResponse(payuResponse);
    }
}

