/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Model;

import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class GetTransactionDetails {
    private final double amount;
    private final String additionalCharges;
    private final String percentageAdditionalCharges;
    private final boolean preAuthorize;

    private GetTransactionDetails(Builder builder) {
        this.amount = builder.amount;
        this.additionalCharges = builder.additionalCharges;
        this.percentageAdditionalCharges = builder.percentageAdditionalCharges;
        this.preAuthorize = builder.preAuthorize;
    }

    public JSONObject prepareTransactionDetailsJson() {
        JSONObject transactionDetailsObject = new JSONObject();
        try {
            transactionDetailsObject.put("amount", this.amount);
            if (this.preAuthorize) {
                transactionDetailsObject.put("pre_authorize", 1);
            }
            if (this.additionalCharges != null && !this.additionalCharges.trim().isEmpty()) {
                transactionDetailsObject.put("additional_charges", (Object)this.additionalCharges);
            }
            if (this.percentageAdditionalCharges != null && !this.percentageAdditionalCharges.trim().isEmpty()) {
                transactionDetailsObject.put("percentage_additional_charges", (Object)this.percentageAdditionalCharges);
            }
        }
        catch (JSONException e) {
            Log.d((String)this.getClass().getSimpleName(), (String)("JSONException " + e.getMessage()));
        }
        return transactionDetailsObject;
    }

    public static class Builder {
        private double amount = 0.0;
        private String additionalCharges;
        private String percentageAdditionalCharges;
        private boolean preAuthorize;

        public Builder setAmount(double amount) {
            this.amount = amount;
            return this;
        }

        public Builder setAdditionalCharges(String additionalCharges) {
            this.additionalCharges = additionalCharges;
            return this;
        }

        public Builder setPercentageAdditionalCharges(String percentageAdditionalCharges) {
            this.percentageAdditionalCharges = percentageAdditionalCharges;
            return this;
        }

        public Builder setPreAuthorize(boolean preAuthorize) {
            this.preAuthorize = preAuthorize;
            return this;
        }

        public GetTransactionDetails build() {
            return new GetTransactionDetails(this);
        }
    }
}

