package com.payu.india.Tasks;

import com.payu.india.Interfaces.DeleteSavedOptionsListener;
import com.payu.india.Interfaces.FetchAdsInformationApiListener;
import com.payu.india.Interfaces.FetchIFSCDetailsListener;
import com.payu.india.Interfaces.FetchOfferDetailsListener;
import com.payu.india.Interfaces.GlobalVaultListener;
import com.payu.india.Interfaces.HashGenerationListener;
import com.payu.india.Interfaces.OnEmiCalculaterListener;
import com.payu.india.Interfaces.V2APITaskListener;
import com.payu.india.Interfaces.V2ApiResponseListener;
import com.payu.india.Interfaces.ValidateOfferApiListener;
import com.payu.india.Model.ApiResponse;
import com.payu.india.Model.CalculateEmiRequest;
import com.payu.india.Model.DeleteSavedOptionsRequest;
import com.payu.india.Model.DeviceIdRequest;
import com.payu.india.Model.FetchOffer.FetchOfferApiRequest;
import com.payu.india.Model.Olw.SendOtpRequest;
import com.payu.india.Model.Olw.SetMPinRequest;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.QuickPay.GlobalVaultOTPRequest;
import com.payu.india.Model.QuickPay.GlobalVaultVerifyOTPRequest;
import com.payu.india.Model.QuickPay.QuickPayRequest;
import com.payu.india.Model.adsinformation.AdsApiRequest;
import com.payu.india.Model.adsinformation.AdsImpressionApiRequest;
import com.payu.india.Model.adsinformation.AdsPayUIdApiRequest;
import com.payu.india.Model.binBaseDetails.BinBaseDetailsRequest;
import com.payu.india.Model.binBaseDetails.BinBaseDetailsResponse;
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeRequest;
import com.payu.india.Model.fetchConvenienceFee.FetchConvFeeResponse;
import com.payu.india.Model.validateOffer.ValidateOfferRequest;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.V2ApiHelper;
import com.payu.paymentparamhelper.V2ApiBase;

import org.json.JSONObject;

import java.util.HashMap;

public class V2ApiTask implements V2APITaskListener {
    private String key;
    private PayuConfig payuConfig;

    private QuickPayTask quickPayTask;

    public V2ApiTask(String key, PayuConfig payuConfig) {
        this.key = key;
        this.payuConfig = payuConfig;
    }

    @Override
    public void getOffers(final FetchOfferApiRequest fetchOfferApiRequest, HashGenerationListener hashGenerationListener, final FetchOfferDetailsListener fetchOfferDetailsListener) {
        HashMap<String, String> map = new HashMap<>();
        map.put(PayuConstants.PAYU_SIGNING_STRING, V2ApiHelper.getInstance().generateSigningString(fetchOfferApiRequest.getJson()));
        map.put(PayuConstants.CP_HASH_NAME, PayuConstants.PAYU_GET_OFFER_DETAILS);

        hashGenerationListener.generateSignature(map, map1 -> {
           //TODO need to put signature(hash) null check
            V2ApiHelper.getInstance().setAuthHeader(map1, key);
            payuConfig.setData(fetchOfferApiRequest.getJson());
            FetchOfferDetailsTask fetchOfferDetailsTask = new FetchOfferDetailsTask(fetchOfferDetailsListener);
            fetchOfferDetailsTask.execute(payuConfig);
        });

    }

    @Override
    public void getQuickPayOptions(final QuickPayRequest quickPayRequest, HashGenerationListener hashGenerationListener, GlobalVaultListener globalVaultListener) {
        HashMap<String, String> map = new HashMap<>();
        map.put(PayuConstants.PAYU_SIGNING_STRING, V2ApiHelper.getInstance().generateSigningString(quickPayRequest.getJson()));
        map.put(PayuConstants.CP_HASH_NAME, PayuConstants.PAYU_QUICKPAYEVENT);
        hashGenerationListener.generateSignature(map, map1 -> {

            V2ApiHelper.getInstance().setAuthHeader(map1, key);
            payuConfig.setData(quickPayRequest.getJson());
            quickPayTask = new QuickPayTask(globalVaultListener);
            quickPayTask.execute(payuConfig);
        });
    }

    public void cancelQuickPayTask() {
        if (quickPayTask != null) {
            quickPayTask.cancel(true);
        }
    }

    @Override
    public void validateOffers(final ValidateOfferRequest validateOfferRequest, HashGenerationListener hashGenerationListener, final ValidateOfferApiListener validateOfferApiListener) {
        HashMap<String, String> map = new HashMap<>();
        map.put(PayuConstants.PAYU_SIGNING_STRING, V2ApiHelper.getInstance().generateSigningString(validateOfferRequest.getJson()));
        map.put(PayuConstants.CP_HASH_NAME, PayuConstants.PAYU_VALIDATE_OFFER_DETAILS);
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, key);
            payuConfig.setData(validateOfferRequest.getJson());
            ValidateOfferTask validateOfferTask = new ValidateOfferTask(validateOfferApiListener);
            validateOfferTask.execute(payuConfig);
        });
    }

    @Override
    public void getAdsDetails(final AdsApiRequest adsApiRequest, FetchAdsInformationApiListener fetchAdsInformationApiListener) {
        payuConfig.setData(adsApiRequest.getJson());
        FetchAdsInformationTask fetchAdsInformationTask = new FetchAdsInformationTask(fetchAdsInformationApiListener);
        fetchAdsInformationTask.execute(payuConfig);
    }


    @Override
    public void postAdsImpressionEvent(final AdsImpressionApiRequest adsImpressionApiRequest) {
        payuConfig.setData(adsImpressionApiRequest.getJson());
        SaveEventImpressionTask saveEventImpressionTask = new SaveEventImpressionTask();
        saveEventImpressionTask.execute(payuConfig);
    }

    @Override
    public void updateAdsPayUId(final AdsPayUIdApiRequest adsPayUIdApiRequest) {
        payuConfig.setData(adsPayUIdApiRequest.getJson());
        UpdatePayUIdTask updatePayUIdTask = new UpdatePayUIdTask();
        updatePayUIdTask.execute(payuConfig);
    }

    @Override
    public void getEmiCalculator(CalculateEmiRequest calculateEmiRequest, HashGenerationListener hashGenerationListener, final OnEmiCalculaterListener onEmiCalculaterListener) {
        HashMap<String, String> map = new HashMap<>();
        map.put(PayuConstants.PAYU_SIGNING_STRING, V2ApiHelper.getInstance().generateSigningString(calculateEmiRequest.getJson()));
        map.put(PayuConstants.CP_HASH_NAME, PayuConstants.PAYU_CALCULATE_EMI);

        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, key);
            payuConfig.setData(calculateEmiRequest.getJson());
            EmiCalculatorTask emiCalculatorTask = new EmiCalculatorTask(onEmiCalculaterListener);
            emiCalculatorTask.execute(payuConfig);
        });
    }

    @Override
    public void updateDeviceId(final DeviceIdRequest deviceIdApiRequest, HashGenerationListener hashGenerationListener) {
        HashMap<String, String> map = new HashMap<>();
        map.put(PayuConstants.PAYU_SIGNING_STRING, V2ApiHelper.getInstance().generateSigningString(deviceIdApiRequest.getJson()));
        map.put(PayuConstants.CP_HASH_NAME, PayuConstants.PAYU_FETCH_DEVICE_ID);

        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, key);
            payuConfig.setData(deviceIdApiRequest.getJson());
            UpdateDeviceIdTask updateDeviceIdTask = new UpdateDeviceIdTask();
            updateDeviceIdTask.execute(payuConfig);
        });
    }


    @Override
    public void globalVaultSendOTP(final GlobalVaultOTPRequest globalVaultRequest, HashGenerationListener hashGenerationListener, GlobalVaultListener globalVaultListener) {
        HashMap<String, String> map = new HashMap<>();
        map.put(PayuConstants.PAYU_SIGNING_STRING, V2ApiHelper.getInstance().generateSigningString(globalVaultRequest.getJson()));
        map.put(PayuConstants.CP_HASH_NAME, PayuConstants.PAYU_GV_SEND_OTP);
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, key);
            payuConfig.setData(globalVaultRequest.getJson());
            GlobalVaultSendOTPTask globalVaultSendOTPTask = new GlobalVaultSendOTPTask(globalVaultListener);
            globalVaultSendOTPTask.execute(payuConfig);
        });
    }

    @Override
    public void globalVaultResendOTP(final GlobalVaultOTPRequest globalVaultRequest, HashMap<String, String> map, HashGenerationListener hashGenerationListener, GlobalVaultListener globalVaultListener) {
        HashMap<String, String> hashMap = new HashMap<>();
        map.put(PayuConstants.PAYU_SIGNING_STRING, V2ApiHelper.getInstance().generateSigningString(globalVaultRequest.getJson()));
        map.put(PayuConstants.CP_HASH_NAME, PayuConstants.PAYU_GV_RESEND_OTP);
        hashGenerationListener.generateSignature(hashMap, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, key);
            payuConfig.setData(globalVaultRequest.getJson());
            GlobalVaultReSendOTPTask globalVaultReSendOTPTask = new GlobalVaultReSendOTPTask(globalVaultListener, map);
            globalVaultReSendOTPTask.execute(payuConfig);
        });
    }

    @Override
    public void globalVaultVerifyOTP(final GlobalVaultVerifyOTPRequest globalVaultRequest, HashGenerationListener hashGenerationListener, GlobalVaultListener globalVaultListener) {
        HashMap<String, String> map = new HashMap<>();
        map.put(PayuConstants.PAYU_SIGNING_STRING, V2ApiHelper.getInstance().generateSigningString(globalVaultRequest.getJson()));
        map.put(PayuConstants.CP_HASH_NAME, PayuConstants.PAYU_GV_VERIFY_OTP);
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, key);
            payuConfig.setData(globalVaultRequest.getJson());
            GlobalVaultVerifyOTPTask globalVaultVerifyOTPTask = new GlobalVaultVerifyOTPTask(globalVaultListener);
            globalVaultVerifyOTPTask.execute(payuConfig);
        });
    }

    @Override
    public void fetchIfscDetails(String ifscCode, HashGenerationListener hashGenerationListener, FetchIFSCDetailsListener fetchIFSCDetailsListener) {
        HashMap<String, String> map = new HashMap<>();
        map.put(PayuConstants.PAYU_SIGNING_STRING, V2ApiHelper.getInstance().generateSigningString(""));
        map.put(PayuConstants.CP_HASH_NAME, PayuConstants.PAYU_FETCH_IFSC_DETAILS);
        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, key);
            payuConfig.setData(ifscCode);
            FetchIFSCDetailsTask ifscDetailsTask = new FetchIFSCDetailsTask(fetchIFSCDetailsListener);
            ifscDetailsTask.execute(payuConfig);
        });
    }

    public void deleteSavedOptions(DeleteSavedOptionsRequest deleteSavedOptionsRequest, HashGenerationListener hashGenerationListener, DeleteSavedOptionsListener deleteSavedOptionsListener){
        HashMap<String, String> map = new HashMap<>();
        map.put(PayuConstants.PAYU_SIGNING_STRING, V2ApiHelper.getInstance().generateSigningString(deleteSavedOptionsRequest.getJson()));
        map.put(PayuConstants.CP_HASH_NAME, PayuConstants.PAYU_DELETE_SAVED_OPTIONS);

        hashGenerationListener.generateSignature(map, map1 -> {
            V2ApiHelper.getInstance().setAuthHeader(map1, key);
            payuConfig.setData(deleteSavedOptionsRequest.getJson());
            DeleteSavedOptionsTask deleteSavedOptionsTask = new DeleteSavedOptionsTask(deleteSavedOptionsListener);
            deleteSavedOptionsTask.execute(payuConfig);
        });
    }

    @Override
    public void getBinBaseDetails(final BinBaseDetailsRequest binBaseDetailsRequest, HashGenerationListener hashGenerationListener, V2ApiResponseListener<ApiResponse<BinBaseDetailsResponse>> v2ApiResponseListener) {
        HashMap<String, String> map = new HashMap<>();
        map.put(PayuConstants.PAYU_SIGNING_STRING, V2ApiHelper.getInstance().generateSigningString(binBaseDetailsRequest.getJson()));
        map.put(PayuConstants.CP_HASH_NAME, PayuConstants.PAYU_BIN_BASE);
        hashGenerationListener.generateSignature(map, map1 -> {

            V2ApiHelper.getInstance().setAuthHeader(map1, key);
            payuConfig.setData(binBaseDetailsRequest.getJson());
            BinBaseDetailsTask binBaseDetailsTask = new BinBaseDetailsTask(v2ApiResponseListener);
            binBaseDetailsTask.execute(payuConfig);
        });
    }

    @Override
    public void fetchConvFeeDetails(FetchConvFeeRequest fetchConvFeeRequest, HashGenerationListener hashGenerationListener, V2ApiResponseListener<ApiResponse<FetchConvFeeResponse>> v2ApiResponseListener) {
        HashMap<String, String> map = new HashMap<>();
        map.put(PayuConstants.PAYU_SIGNING_STRING, V2ApiHelper.getInstance().generateSigningString(fetchConvFeeRequest.getJson()));
        map.put(PayuConstants.CP_HASH_NAME, PayuConstants.PAYU_FETCH_CONV_F);
        hashGenerationListener.generateSignature(map, map1 -> {

            V2ApiHelper.getInstance().setAuthHeader(map1, key);
            payuConfig.setData(fetchConvFeeRequest.getJson());
            FetchConvFeeTask fetchConvFeeTask = new FetchConvFeeTask(v2ApiResponseListener);
            fetchConvFeeTask.execute(payuConfig);
        });

    }


    public void v2ApiCall(String json, String commandName, HashMap<String, String> headerMap, HashGenerationListener hashGenerationListener, V2ApiResponseListener<ApiResponse<JSONObject>> v2ApiResponseListener) {
        HashMap<String, String> map = new HashMap<>();
        map.put(PayuConstants.PAYU_SIGNING_STRING, V2ApiHelper.getInstance().generateSigningString(json));
        map.put(PayuConstants.CP_HASH_NAME, commandName);
        hashGenerationListener.generateSignature(map, map1 -> {

            V2ApiHelper.getInstance().setAuthHeader(map1, key);
            payuConfig.setData(json);
            ApiTask apiTask = new ApiTask(v2ApiResponseListener, headerMap, commandName);
            apiTask.execute(payuConfig);
        });
    }
}
